/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.sftp;

import com.maverick.events.Event;
import com.maverick.events.EventLog;
import com.maverick.events.EventServiceImplementation;
import com.maverick.sftp.FileTransferProgress;
import com.maverick.sftp.SftpFile;
import com.maverick.sftp.SftpFileAttributes;
import com.maverick.sftp.SftpMessage;
import com.maverick.sftp.SftpStatusException;
import com.maverick.sftp.TransferCancelledException;
import com.maverick.ssh.Packet;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SubsystemChannel;
import com.maverick.ssh.message.Message;
import com.maverick.ssh.message.MessageHolder;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.UnsignedInteger32;
import com.maverick.util.UnsignedInteger64;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpSubsystemChannel
extends SubsystemChannel {
    private String p = "ISO-8859-1";
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int OPEN_TEXT = 64;
    public static int MAX_VERSION = 4;
    int i = 4;
    int l = -1;
    int j = -1;
    Vector o = new Vector();
    UnsignedInteger32 h = new UnsignedInteger32(0L);
    Hashtable k = new Hashtable();
    _b n = new _b();
    Hashtable m = new Hashtable();

    public SftpSubsystemChannel(SshSession sshSession) throws SshException {
        super(sshSession);
        this.i = MAX_VERSION;
    }

    public SftpSubsystemChannel(SshSession sshSession, int n) throws SshException {
        super(sshSession);
        this.setThisMaxSftpVersion(n);
    }

    public static void setMaxSftpVersion(int n) {
        MAX_VERSION = n;
    }

    public void setThisMaxSftpVersion(int n) {
        this.i = n;
    }

    public int getVersion() {
        return this.l;
    }

    public String getCanonicalNewline() throws SftpStatusException {
        if (this.l <= 3) {
            throw new SftpStatusException(8, "Newline setting not available for SFTP versions <= 3");
        }
        if (!this.m.containsKey("newline")) {
            return "\r\n";
        }
        return (String)this.m.get("newline");
    }

    public void initialize() throws SshException, UnsupportedEncodingException {
        try {
            this.channel.getMessageRouter().addShutdownHook(new Runnable(){

                public void run() {
                    try {
                        SftpSubsystemChannel.this.k.clear();
                        SftpSubsystemChannel.this.o.clear();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            Packet packet = this.createPacket();
            packet.write(1);
            packet.writeInt(this.i);
            this.sendMessage(packet);
            byte[] byArray = this.nextMessage();
            if (byArray[0] != 2) {
                this.close();
                throw new SshException("Unexpected response from SFTP subsystem.", 6);
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            byteArrayReader.skip(1L);
            this.j = (int)byteArrayReader.readInt();
            this.l = Math.min(this.j, MAX_VERSION);
            try {
                while (byteArrayReader.available() > 0) {
                    String string = byteArrayReader.readString();
                    String string2 = byteArrayReader.readString();
                    this.m.put(string, string2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.l <= 3) {
                this.setCharsetEncoding("ISO-8859-1");
            } else {
                this.setCharsetEncoding("UTF8");
            }
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(6, (Throwable)iOException);
        }
        catch (Throwable throwable) {
            throw new SshException(6, throwable);
        }
    }

    public void setCharsetEncoding(String string) throws SshException, UnsupportedEncodingException {
        if (this.l == -1) {
            throw new SshException("SFTP Channel must be initialized before setting character set encoding", 4);
        }
        String string2 = "123456890";
        string2.getBytes(string);
        this.p = string;
    }

    public int getServerVersion() {
        return this.j;
    }

    public String getCharsetEncoding() {
        return this.p;
    }

    public boolean supportsExtension(String string) {
        return this.m.containsKey(string);
    }

    public String getExtension(String string) {
        return (String)this.m.get(string);
    }

    public SftpMessage sendExtensionMessage(String string, byte[] byArray) throws SshException, SftpStatusException {
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(200);
            packet.writeUINT32(unsignedInteger32);
            packet.writeString(string);
            this.sendMessage(packet);
            return this.c(unsignedInteger32);
        }
        catch (IOException iOException) {
            throw new SshException(5, (Throwable)iOException);
        }
    }

    public void changePermissions(SftpFile sftpFile, int n) throws SftpStatusException, SshException {
        SftpFileAttributes sftpFileAttributes = new SftpFileAttributes(this, 5);
        sftpFileAttributes.setPermissions(new UnsignedInteger32(n));
        this.setAttributes(sftpFile, sftpFileAttributes);
    }

    public void changePermissions(String string, int n) throws SftpStatusException, SshException {
        SftpFileAttributes sftpFileAttributes = new SftpFileAttributes(this, 5);
        sftpFileAttributes.setPermissions(new UnsignedInteger32(n));
        this.setAttributes(string, sftpFileAttributes);
    }

    public void changePermissions(String string, String string2) throws SftpStatusException, SshException {
        SftpFileAttributes sftpFileAttributes = new SftpFileAttributes(this, 5);
        sftpFileAttributes.setPermissions(string2);
        this.setAttributes(string, sftpFileAttributes);
    }

    public void setAttributes(String string, SftpFileAttributes sftpFileAttributes) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(9);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            packet.write(sftpFileAttributes.toByteArray());
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public void setAttributes(SftpFile sftpFile, SftpFileAttributes sftpFileAttributes) throws SftpStatusException, SshException {
        if (!this.c(sftpFile.getHandle())) {
            throw new SftpStatusException(100, "The handle is not an open file handle!");
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(10);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeBinaryString(sftpFile.getHandle());
            packet.write(sftpFileAttributes.toByteArray());
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public UnsignedInteger32 postWriteRequest(byte[] byArray, long l, byte[] byArray2, int n, int n2) throws SftpStatusException, SshException {
        if (!this.o.contains(new String(byArray))) {
            throw new SftpStatusException(100, "The handle is not valid!");
        }
        if (byArray2.length - n < n2) {
            throw new IndexOutOfBoundsException("Incorrect data array size!");
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(6);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeBinaryString(byArray);
            packet.writeUINT64(l);
            packet.writeBinaryString(byArray2, n, n2);
            this.sendMessage(packet);
            return unsignedInteger32;
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public void writeFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n, int n2) throws SftpStatusException, SshException {
        this.getOKRequestStatus(this.postWriteRequest(byArray, unsignedInteger64.longValue(), byArray2, n, n2));
    }

    public void performOptimizedWrite(byte[] byArray, int n, int n2, InputStream inputStream, int n3, FileTransferProgress fileTransferProgress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedWrite(byArray, n, n2, inputStream, n3, fileTransferProgress, 0L);
    }

    public void performOptimizedWrite(byte[] byArray, int n, int n2, InputStream inputStream, int n3, FileTransferProgress fileTransferProgress, long l) throws SftpStatusException, SshException, TransferCancelledException {
        try {
            if (!this.o.contains(new String(byArray))) {
                throw new SftpStatusException(100, "The file handle is invalid!");
            }
            if (n < 4096) {
                throw new SshException("Block size cannot be less than 4096", 4);
            }
            if (l < 0L) {
                throw new SshException("Position value must be greater than zero!", 4);
            }
            if (l > 0L && fileTransferProgress != null) {
                fileTransferProgress.progressed(l);
            }
            if (n3 <= 0) {
                n3 = n;
            }
            byte[] byArray2 = new byte[n];
            long l2 = l;
            int n4 = 0;
            Vector<UnsignedInteger32> vector = new Vector<UnsignedInteger32>();
            inputStream = new BufferedInputStream(inputStream, n3);
            while ((n4 = inputStream.read(byArray2)) != -1) {
                vector.addElement(this.postWriteRequest(byArray, l2, byArray2, 0, n4));
                l2 += (long)n4;
                if (fileTransferProgress != null) {
                    if (fileTransferProgress.isCancelled()) {
                        throw new TransferCancelledException();
                    }
                    fileTransferProgress.progressed(l2);
                }
                if (vector.size() <= n2) continue;
                UnsignedInteger32 unsignedInteger32 = (UnsignedInteger32)vector.elementAt(0);
                vector.removeElementAt(0);
                this.getOKRequestStatus(unsignedInteger32);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.getOKRequestStatus((UnsignedInteger32)enumeration.nextElement());
            }
            vector.removeAllElements();
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (EOFException eOFException) {
            try {
                this.close();
            }
            catch (SshIOException sshIOException) {
                throw sshIOException.getRealException();
            }
            catch (IOException iOException) {
                throw new SshException(iOException.getMessage(), 6);
            }
            throw new SftpStatusException(7, "The SFTP channel terminated unexpectedly");
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SshException("Resource Shortage: try reducing the local file buffer size", 4);
        }
    }

    public void performOptimizedRead(byte[] byArray, long l, int n, OutputStream outputStream, int n2, FileTransferProgress fileTransferProgress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedRead(byArray, l, n, outputStream, n2, fileTransferProgress, 0L);
    }

    public void performOptimizedRead(byte[] byArray, long l, int n, OutputStream outputStream, int n2, FileTransferProgress fileTransferProgress, long l2) throws SftpStatusException, SshException, TransferCancelledException {
        EventLog.LogEvent(this, "Performing optimized read length=" + l + " postion=" + l2 + " blocksize=" + n + " outstandingRequests=" + n2);
        if (l <= 0L) {
            l = Long.MAX_VALUE;
        }
        try {
            if (!this.o.contains(new String(byArray))) {
                throw new SftpStatusException(100, "The file handle is invalid!");
            }
            if (n < 1 || n > 32768) {
                EventLog.LogEvent(this, "Blocksize to large for some SFTP servers, reseting to 32K");
                n = 32768;
            }
            if (l2 < 0L) {
                throw new SshException("Position value must be greater than zero!", 4);
            }
            byte[] byArray2 = new byte[n];
            int n3 = this.readFile(byArray, new UnsignedInteger64(0L), byArray2, 0, byArray2.length);
            if (n3 == -1) {
                return;
            }
            if ((long)n3 > l2) {
                outputStream.write(byArray2, (int)l2, (int)((long)n3 - l2));
                l -= (long)n3 - l2;
                l2 = n3;
            }
            if (l2 + l <= (long)n3) {
                return;
            }
            if (n3 < n && l > (long)n3) {
                n = n3;
            }
            byArray2 = null;
            long l3 = l / (long)n;
            long l4 = n2;
            if (l2 > 0L && fileTransferProgress != null) {
                fileTransferProgress.progressed(l2);
            }
            Vector<UnsignedInteger32> vector = new Vector<UnsignedInteger32>(n2);
            long l5 = l2;
            if (l3 < l4) {
                l4 = l3 + 1L;
            }
            if (l4 <= 0L) {
                EventLog.LogEvent(this, "We calculated zero outstanding requests! numBlocks=" + l3 + " outstandingRequests=" + n2 + " blocksize=" + n + " length=" + l + " position=" + l2);
                l4 = 1L;
            }
            long l6 = l3 + 2L;
            int n4 = 0;
            long l7 = l2;
            n3 = 0;
            while ((long)n3 < l4) {
                EventLog.LogEvent(this, "Posting request for file offset " + l5);
                vector.addElement(this.postReadRequest(byArray, l5, n));
                l5 += (long)n;
                if (fileTransferProgress != null && fileTransferProgress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                ++n3;
            }
            do {
                UnsignedInteger32 unsignedInteger32 = (UnsignedInteger32)vector.elementAt(0);
                vector.removeElementAt(0);
                SftpMessage sftpMessage = this.c(unsignedInteger32);
                if (sftpMessage.getType() == 103) {
                    byArray2 = sftpMessage.readBinaryString();
                    EventLog.LogEvent(this, "Get " + byArray2.length + " bytes of data");
                    outputStream.write(byArray2);
                    ++n4;
                    if (fileTransferProgress != null) {
                        fileTransferProgress.progressed(l7 += (long)byArray2.length);
                    }
                } else {
                    if (sftpMessage.getType() == 101) {
                        int n5 = (int)sftpMessage.readInt();
                        if (n5 == 1) {
                            EventLog.LogEvent(this, "Received file EOF");
                            return;
                        }
                        if (this.l >= 3) {
                            String string = sftpMessage.readString().trim();
                            EventLog.LogEvent(this, "Received status " + string);
                            throw new SftpStatusException(n5, string);
                        }
                        EventLog.LogEvent(this, "Received status " + n5);
                        throw new SftpStatusException(n5);
                    }
                    this.close();
                    throw new SshException("The server responded with an unexpected message", 6);
                }
                if (!vector.isEmpty() && (long)(n4 + vector.size()) >= l6) continue;
                EventLog.LogEvent(this, "Posting request for file offset " + l5);
                vector.addElement(this.postReadRequest(byArray, l5, n));
                l5 += (long)n;
            } while (fileTransferProgress == null || !fileTransferProgress.isCancelled());
            throw new TransferCancelledException();
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (EOFException eOFException) {
            EventLog.LogEvent(this, "Channel has reached EOF", eOFException);
            try {
                this.close();
            }
            catch (SshIOException sshIOException) {
                throw sshIOException.getRealException();
            }
            catch (IOException iOException) {
                throw new SshException(iOException.getMessage(), 6);
            }
            throw new SftpStatusException(7, "The SFTP channel terminated unexpectedly");
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public void performSynchronousRead(byte[] byArray, int n, OutputStream outputStream, FileTransferProgress fileTransferProgress, long l) throws SftpStatusException, SshException, TransferCancelledException {
        EventLog.LogEvent(this, "Performing synchronous read postion=" + l + " blocksize=" + n);
        if (!this.o.contains(new String(byArray))) {
            throw new SftpStatusException(100, "The file handle is invalid!");
        }
        if (n < 1 || n > 32768) {
            EventLog.LogEvent(this, "Blocksize to large for some SFTP servers, reseting to 32K");
            n = 32768;
        }
        if (l < 0L) {
            throw new SshException("Position value must be greater than zero!", 4);
        }
        byte[] byArray2 = new byte[n];
        UnsignedInteger64 unsignedInteger64 = new UnsignedInteger64(l);
        if (l > 0L && fileTransferProgress != null) {
            fileTransferProgress.progressed(l);
        }
        try {
            int n2;
            while ((n2 = this.readFile(byArray, unsignedInteger64, byArray2, 0, byArray2.length)) > -1) {
                if (fileTransferProgress != null && fileTransferProgress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                outputStream.write(byArray2, 0, n2);
                unsignedInteger64 = UnsignedInteger64.add(unsignedInteger64, n2);
                if (fileTransferProgress == null) continue;
                fileTransferProgress.progressed(unsignedInteger64.longValue());
            }
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public UnsignedInteger32 postReadRequest(byte[] byArray, long l, int n) throws SftpStatusException, SshException {
        try {
            if (!this.o.contains(new String(byArray))) {
                throw new SftpStatusException(100, "The file handle is invalid!");
            }
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(5);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeBinaryString(byArray);
            packet.writeUINT64(l);
            packet.writeInt(n);
            this.sendMessage(packet);
            return unsignedInteger32;
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public int readFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n, int n2) throws SftpStatusException, SshException {
        try {
            if (!this.o.contains(new String(byArray))) {
                throw new SftpStatusException(100, "The file handle is invalid!");
            }
            if (byArray2.length - n < n2) {
                throw new IndexOutOfBoundsException("Output array size is smaller than read length!");
            }
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(5);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeBinaryString(byArray);
            packet.write(unsignedInteger64.toByteArray());
            packet.writeInt(n2);
            this.sendMessage(packet);
            SftpMessage sftpMessage = this.c(unsignedInteger32);
            if (sftpMessage.getType() == 103) {
                byte[] byArray3 = sftpMessage.readBinaryString();
                System.arraycopy(byArray3, 0, byArray2, n, byArray3.length);
                return byArray3.length;
            }
            if (sftpMessage.getType() == 101) {
                int n3 = (int)sftpMessage.readInt();
                if (n3 == 1) {
                    return -1;
                }
                if (this.l >= 3) {
                    String string = sftpMessage.readString().trim();
                    throw new SftpStatusException(n3, string);
                }
                throw new SftpStatusException(n3);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public SftpFile getFile(String string) throws SftpStatusException, SshException {
        String string2 = this.getAbsolutePath(string);
        SftpFile sftpFile = new SftpFile(string2, this.getAttributes(string2));
        sftpFile.e = this;
        return sftpFile;
    }

    public String getAbsolutePath(SftpFile sftpFile) throws SftpStatusException, SshException {
        return this.getAbsolutePath(sftpFile.getFilename());
    }

    public void createSymbolicLink(String string, String string2) throws SftpStatusException, SshException {
        if (this.l < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.l));
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(20);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string2, this.p);
            packet.writeString(string, this.p);
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public String getSymbolicLinkTarget(String string) throws SftpStatusException, SshException {
        if (this.l < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.l));
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(19);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            this.sendMessage(packet);
            SftpFile[] sftpFileArray = this.b(this.c(unsignedInteger32), null);
            return sftpFileArray[0].getAbsolutePath();
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.getAbsolutePath("");
    }

    public String getAbsolutePath(String string) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(16);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            this.sendMessage(packet);
            SftpMessage sftpMessage = this.c(unsignedInteger32);
            if (sftpMessage.getType() == 104) {
                SftpFile[] sftpFileArray = this.b(sftpMessage, null);
                if (sftpFileArray.length != 1) {
                    this.close();
                    throw new SshException("Server responded to SSH_FXP_REALPATH with too many files!", 6);
                }
                return sftpFileArray[0].getAbsolutePath();
            }
            if (sftpMessage.getType() == 101) {
                int n = (int)sftpMessage.readInt();
                if (this.l >= 3) {
                    String string2 = sftpMessage.readString().trim();
                    throw new SftpStatusException(n, string2);
                }
                throw new SftpStatusException(n);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public int listChildren(SftpFile sftpFile, Vector vector) throws SftpStatusException, SshException {
        if (sftpFile.isDirectory()) {
            if (!this.c(sftpFile.getHandle()) && !this.c((sftpFile = this.openDirectory(sftpFile.getAbsolutePath())).getHandle())) {
                throw new SftpStatusException(4, "Failed to open directory");
            }
        } else {
            throw new SshException("Cannot list children for this file object", 4);
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(12);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeBinaryString(sftpFile.getHandle());
            this.sendMessage(packet);
            SftpMessage sftpMessage = this.c(unsignedInteger32);
            if (sftpMessage.getType() == 104) {
                SftpFile[] sftpFileArray = this.b(sftpMessage, sftpFile.getAbsolutePath());
                for (int k = 0; k < sftpFileArray.length; ++k) {
                    vector.addElement(sftpFileArray[k]);
                }
                return sftpFileArray.length;
            }
            if (sftpMessage.getType() == 101) {
                int n = (int)sftpMessage.readInt();
                if (n == 1) {
                    return -1;
                }
                if (this.l >= 3) {
                    String string = sftpMessage.readString().trim();
                    throw new SftpStatusException(n, string);
                }
                throw new SftpStatusException(n);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    SftpFile[] b(SftpMessage sftpMessage, String string) throws SshException {
        try {
            if (string != null && !string.endsWith("/")) {
                string = string + "/";
            }
            int n = (int)sftpMessage.readInt();
            SftpFile[] sftpFileArray = new SftpFile[n];
            String string2 = null;
            for (int k = 0; k < sftpFileArray.length; ++k) {
                String string3 = sftpMessage.readString(this.p);
                if (this.l <= 3) {
                    string2 = sftpMessage.readString(this.p);
                }
                sftpFileArray[k] = new SftpFile(string != null ? string + string3 : string3, new SftpFileAttributes(this, sftpMessage));
                sftpFileArray[k].f = string2;
                if (string2 != null && this.l <= 3) {
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2);
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        sftpFileArray[k].getAttributes().b(string4);
                        sftpFileArray[k].getAttributes().c(string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sftpFileArray[k].b(this);
            }
            return sftpFileArray;
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public void recurseMakeDirectory(String string) throws SftpStatusException, SshException {
        if (string.trim().length() > 0) {
            try {
                SftpFile sftpFile = this.openDirectory(string);
                sftpFile.close();
            }
            catch (SshException sshException) {
                int n = 0;
                do {
                    String string2 = (n = string.indexOf(47, n)) > -1 ? string.substring(0, n + 1) : string;
                    try {
                        SftpFile sftpFile = this.openDirectory(string2);
                        sftpFile.close();
                    }
                    catch (SshException sshException2) {
                        this.makeDirectory(string2);
                    }
                } while (n > -1);
            }
        }
    }

    public SftpFile openFile(String string, int n) throws SftpStatusException, SshException {
        return this.openFile(string, n, new SftpFileAttributes(this, 5));
    }

    public SftpFile openFile(String string, int n, SftpFileAttributes sftpFileAttributes) throws SftpStatusException, SshException {
        if (sftpFileAttributes == null) {
            sftpFileAttributes = new SftpFileAttributes(this, 5);
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(3);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            packet.writeInt(n);
            packet.write(sftpFileAttributes.toByteArray());
            this.sendMessage(packet);
            byte[] byArray = this.b(unsignedInteger32);
            this.o.addElement(new String(byArray));
            SftpFile sftpFile = new SftpFile(string, null);
            sftpFile.b(byArray);
            sftpFile.b(this);
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 26, true).addAttribute("FILE_NAME", sftpFile.getAbsolutePath()));
            return sftpFile;
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public SftpFile openDirectory(String string) throws SftpStatusException, SshException {
        String string2 = this.getAbsolutePath(string);
        SftpFileAttributes sftpFileAttributes = this.getAttributes(string2);
        if (!sftpFileAttributes.isDirectory()) {
            throw new SftpStatusException(4, string + " is not a directory");
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(11);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            this.sendMessage(packet);
            byte[] byArray = this.b(unsignedInteger32);
            this.o.addElement(new String(byArray));
            SftpFile sftpFile = new SftpFile(string2, sftpFileAttributes);
            sftpFile.b(byArray);
            sftpFile.b(this);
            return sftpFile;
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    void b(byte[] byArray) throws SftpStatusException, SshException {
        if (!this.c(byArray)) {
            throw new SftpStatusException(100, "The handle is invalid!");
        }
        try {
            this.o.removeElement(new String(byArray));
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(4);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeBinaryString(byArray);
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public void closeFile(SftpFile sftpFile) throws SftpStatusException, SshException {
        if (sftpFile.getHandle() != null) {
            this.b(sftpFile.getHandle());
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 25, true).addAttribute("FILE_NAME", sftpFile.getAbsolutePath()));
            sftpFile.b((byte[])null);
        }
    }

    boolean c(byte[] byArray) {
        return this.o.contains(new String(byArray));
    }

    public void removeDirectory(String string) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(15);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 29, true).addAttribute("DIRECTORY_PATH", string));
    }

    public void removeFile(String string) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(13);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 28, true).addAttribute("FILE_NAME", string));
    }

    public void renameFile(String string, String string2) throws SftpStatusException, SshException {
        if (this.l < 2) {
            throw new SftpStatusException(8, "Renaming files is not supported by the server SFTP version " + String.valueOf(this.l));
        }
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(18);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            packet.writeString(string2, this.p);
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 27, true).addAttribute("FILE_NAME", string).addAttribute("FILE_NEW_NAME", string2));
    }

    public SftpFileAttributes getAttributes(String string) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(17);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            if (this.l > 3) {
                packet.writeInt(-2147483139L);
            }
            this.sendMessage(packet);
            SftpMessage sftpMessage = this.c(unsignedInteger32);
            return this.b(sftpMessage);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    SftpFileAttributes b(SftpMessage sftpMessage) throws SftpStatusException, SshException {
        try {
            if (sftpMessage.getType() == 105) {
                return new SftpFileAttributes(this, sftpMessage);
            }
            if (sftpMessage.getType() == 101) {
                int n = (int)sftpMessage.readInt();
                if (this.l >= 3) {
                    String string = sftpMessage.readString().trim();
                    throw new SftpStatusException(n, string);
                }
                throw new SftpStatusException(n);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message.", 6);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public SftpFileAttributes getAttributes(SftpFile sftpFile) throws SftpStatusException, SshException {
        try {
            if (!this.c(sftpFile.getHandle())) {
                return this.getAttributes(sftpFile.getAbsolutePath());
            }
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(8);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeBinaryString(sftpFile.getHandle());
            if (this.l > 3) {
                packet.writeInt(-2147483139L);
            }
            this.sendMessage(packet);
            return this.b(this.c(unsignedInteger32));
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public void makeDirectory(String string) throws SftpStatusException, SshException {
        this.makeDirectory(string, new SftpFileAttributes(this, 2));
    }

    public void makeDirectory(String string, SftpFileAttributes sftpFileAttributes) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 unsignedInteger32 = this.b();
            Packet packet = this.createPacket();
            packet.write(14);
            packet.writeInt(unsignedInteger32.longValue());
            packet.writeString(string, this.p);
            packet.write(sftpFileAttributes.toByteArray());
            this.sendMessage(packet);
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    byte[] b(UnsignedInteger32 unsignedInteger32) throws SftpStatusException, SshException {
        try {
            SftpMessage sftpMessage = this.c(unsignedInteger32);
            if (sftpMessage.getType() == 102) {
                return sftpMessage.readBinaryString();
            }
            if (sftpMessage.getType() == 101) {
                int n = (int)sftpMessage.readInt();
                if (this.l >= 3) {
                    String string = sftpMessage.readString().trim();
                    throw new SftpStatusException(n, string);
                }
                throw new SftpStatusException(n);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message!", 6);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public void getOKRequestStatus(UnsignedInteger32 unsignedInteger32) throws SftpStatusException, SshException {
        try {
            SftpMessage sftpMessage = this.c(unsignedInteger32);
            if (sftpMessage.getType() == 101) {
                int n = (int)sftpMessage.readInt();
                if (n == 0) {
                    return;
                }
                if (this.l >= 3) {
                    String string = sftpMessage.readString().trim();
                    throw new SftpStatusException(n, string);
                }
                throw new SftpStatusException(n);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message!", 6);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    SftpMessage c(UnsignedInteger32 unsignedInteger32) throws SshException {
        MessageHolder messageHolder = new MessageHolder();
        while (messageHolder.msg == null) {
            try {
                if (!this.n.b(unsignedInteger32, messageHolder)) continue;
                SftpMessage sftpMessage = new SftpMessage(this.nextMessage());
                this.k.put(new UnsignedInteger32(sftpMessage.getMessageId()), sftpMessage);
            }
            catch (InterruptedException interruptedException) {
                try {
                    this.close();
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (IOException iOException) {
                    throw new SshException(iOException.getMessage(), 6);
                }
                throw new SshException("The thread was interrupted", 6);
            }
            catch (IOException iOException) {
                throw new SshException(5, (Throwable)iOException);
            }
            finally {
                this.n.b();
            }
        }
        return (SftpMessage)this.k.remove(unsignedInteger32);
    }

    UnsignedInteger32 b() {
        this.h = UnsignedInteger32.add(this.h, 1);
        return this.h;
    }

    class _b {
        boolean b = false;

        _b() {
        }

        public synchronized boolean b(UnsignedInteger32 unsignedInteger32, MessageHolder messageHolder) throws InterruptedException {
            boolean bl;
            boolean bl2 = bl = !this.b;
            if (SftpSubsystemChannel.this.k.containsKey(unsignedInteger32)) {
                messageHolder.msg = (Message)SftpSubsystemChannel.this.k.get(unsignedInteger32);
                return false;
            }
            if (bl) {
                this.b = true;
            } else {
                this.wait();
            }
            return bl;
        }

        public synchronized void b() {
            this.b = false;
            this.notifyAll();
        }
    }
}

