/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.DiffieHellmanGroups;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.ssh.components.jce.AbstractKeyExchange;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanGroup1Sha1
extends SshKeyExchangeClient
implements AbstractKeyExchange {
    public static final String DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    static final BigInteger rb = BigInteger.valueOf(1L);
    static final BigInteger xb;
    static final BigInteger vb;
    static final BigInteger tb;
    BigInteger yb = null;
    BigInteger wb = null;
    BigInteger bc = null;
    String qb;
    String ub;
    byte[] zb;
    byte[] dc;
    KeyPairGenerator cc;
    KeyAgreement ac;
    KeyFactory sb;

    public DiffieHellmanGroup1Sha1() {
        super("SHA-1");
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP1_SHA1;
    }

    public String getProvider() {
        if (this.ac != null) {
            return this.ac.getProvider().getName();
        }
        return "";
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws SshException {
        Object object;
        Object object2;
        this.qb = string;
        this.ub = string2;
        this.zb = byArray;
        this.dc = byArray2;
        try {
            this.sb = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
            this.cc = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
            this.ac = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SshException("JCE does not support Diffie Hellman key exchange", 16);
        }
        try {
            object2 = new DHParameterSpec(tb, vb);
            this.cc.initialize((AlgorithmParameterSpec)object2);
            object = this.cc.generateKeyPair();
            this.ac.init(((KeyPair)object).getPrivate());
            this.yb = ((DHPublicKey)((KeyPair)object).getPublic()).getY();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SshException("Failed to generate DH value", 16);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SshException("Failed to generate DH value", 16);
        }
        try {
            object2 = new ByteArrayWriter();
            ((ByteArrayOutputStream)object2).write(30);
            ((ByteArrayWriter)object2).writeBigInteger(this.yb);
            this.transport.sendMessage(((ByteArrayOutputStream)object2).toByteArray(), true);
        }
        catch (IOException iOException) {
            throw new SshException("Failed to write SSH_MSG_KEXDH_INIT to message buffer", 5);
        }
        object2 = this.transport.nextMessage();
        if (object2[0] != 31) {
            this.transport.disconnect(3, "Key exchange failed");
            throw new SshException("Key exchange failed [id=" + (int)object2[0] + "]", 5);
        }
        object = new ByteArrayReader((byte[])object2, 1, ((Object)object2).length - 1);
        try {
            this.hostKey = ((ByteArrayReader)object).readBinaryString();
            this.wb = ((ByteArrayReader)object).readBigInteger();
            this.signature = ((ByteArrayReader)object).readBinaryString();
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(this.wb, tb, vb);
            this.ac.doPhase(this.sb.generatePublic(dHPublicKeySpec), true);
            object2 = this.ac.generateSecret();
            if ((object2[0] & 0x80) == 128) {
                byte[] byArray3 = new byte[((Object)object2).length + 1];
                System.arraycopy(object2, 0, byArray3, 1, ((Object)object2).length);
                object2 = byArray3;
            }
            this.secret = new BigInteger((byte[])object2);
            this.calculateExchangeHash();
        }
        catch (Exception exception) {
            throw new SshException("Failed to read SSH_MSG_KEXDH_REPLY from message buffer", 5, exception);
        }
    }

    protected void calculateExchangeHash() throws SshException {
        Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("SHA-1");
        digest.putString(this.qb);
        digest.putString(this.ub);
        digest.putInt(this.zb.length);
        digest.putBytes(this.zb);
        digest.putInt(this.dc.length);
        digest.putBytes(this.dc);
        digest.putInt(this.hostKey.length);
        digest.putBytes(this.hostKey);
        digest.putBigInteger(this.yb);
        digest.putBigInteger(this.wb);
        digest.putBigInteger(this.secret);
        this.exchangeHash = digest.doFinal();
    }

    public boolean isKeyExchangeMessage(int n) {
        switch (n) {
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    static {
        vb = xb = BigInteger.valueOf(2L);
        tb = DiffieHellmanGroups.group1;
    }
}

