/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.digests.HMac;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshHmac;
import java.io.IOException;

public class AbstractHmac
implements SshHmac {
    HMac c;
    String b;

    public AbstractHmac(String string, HMac hMac) {
        this.b = string;
        this.c = hMac;
    }

    public String getAlgorithm() {
        return this.b;
    }

    public int getMacLength() {
        return this.c.getOutputSize();
    }

    public void generate(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = new byte[this.c.getMacSize()];
        byte[] byArray4 = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)(l >> 0)};
        this.c.update(byArray4, 0, byArray4.length);
        this.c.update(byArray, n, n2);
        this.c.doFinal(byArray3, 0);
        System.arraycopy(byArray3, 0, byArray2, n3, this.c.getOutputSize());
    }

    public void init(byte[] byArray) throws SshException {
        byte[] byArray2 = new byte[this.c.getMacSize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        try {
            this.c.init(byArray2);
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean verify(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray.length < n + n2) {
            throw new RuntimeException("Not enough data for message and mac!");
        }
        if (byArray2.length - n3 < this.getMacLength()) {
            throw new RuntimeException(String.valueOf(this.getMacLength()) + " bytes of MAC data required!");
        }
        byte[] byArray3 = new byte[this.c.getOutputSize()];
        this.generate(l, byArray, n, n2, byArray3, 0);
        for (int k = 0; k < byArray3.length; ++k) {
            if (byArray3[k] == byArray2[n3 + k]) continue;
            return false;
        }
        return true;
    }

    public void update(byte[] byArray) {
        this.c.update(byArray, 0, byArray.length);
    }

    public byte[] doFinal() {
        byte[] byArray = new byte[this.getMacLength()];
        this.c.doFinal(byArray, 0);
        return byArray;
    }
}

