/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.security.SecureRandom;
import com.maverick.events.EventLog;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.DiffieHellmanGroups;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshKeyExchangeClient;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;

public class DiffieHellmanGroup14Sha1
extends SshKeyExchangeClient {
    public static final String DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
    static final BigInteger d = BigInteger.valueOf(1L);
    static final BigInteger j;
    static final BigInteger h;
    static final BigInteger f;
    static final BigInteger e;
    BigInteger k = null;
    BigInteger i = null;
    BigInteger n = null;
    BigInteger m = null;
    String c;
    String g;
    byte[] l;
    byte[] o;

    public DiffieHellmanGroup14Sha1() {
        super("SHA-1");
    }

    public boolean isKeyExchangeMessage(int n) {
        switch (n) {
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP14_SHA1;
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws SshException {
        try {
            this.c = string;
            this.g = string2;
            this.l = byArray;
            this.o = byArray2;
            do {
                this.n = new BigInteger(f.bitLength(), SecureRandom.getInstance());
            } while (this.n.compareTo(d) < 0 || this.n.compareTo(e) > 0);
            this.k = h.modPow(this.n, f);
            if (this.k.compareTo(d) < 0 || this.k.compareTo(f.subtract(d)) > 0) {
                this.transport.disconnect(3, "Failed to generate key exchange value");
                throw new SshException("Key exchange failed to generate e value", 5);
            }
            EventLog.LogDebugEvent(this, "Secret will be " + this.n.toString(16));
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(30);
            byteArrayWriter.writeBigInteger(this.k);
            this.transport.sendMessage(byteArrayWriter.toByteArray(), true);
            byte[] byArray3 = this.transport.nextMessage();
            if (byArray3[0] != 31) {
                this.transport.disconnect(3, "Key exchange failed");
                throw new SshException("Key exchange failed [id=" + byArray3[0] + "]", 5);
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray3, 1, byArray3.length - 1);
            this.hostKey = byteArrayReader.readBinaryString();
            this.i = byteArrayReader.readBigInteger();
            this.signature = byteArrayReader.readBinaryString();
            this.secret = this.i.modPow(this.n, f);
            this.calculateExchangeHash();
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    protected void calculateExchangeHash() throws SshException {
        Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("SHA-1");
        digest.putString(this.c);
        digest.putString(this.g);
        digest.putInt(this.l.length);
        digest.putBytes(this.l);
        digest.putInt(this.o.length);
        digest.putBytes(this.o);
        digest.putInt(this.hostKey.length);
        digest.putBytes(this.hostKey);
        digest.putBigInteger(this.k);
        digest.putBigInteger(this.i);
        digest.putBigInteger(this.secret);
        this.exchangeHash = digest.doFinal();
    }

    static {
        h = j = BigInteger.valueOf(2L);
        f = DiffieHellmanGroups.group14;
        e = f.subtract(d).divide(j);
    }
}

