/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.ipsec.mom.EnumConfMode;
import se.ericsson.cello.iptransport.mom.IpAccessHostEt;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumIpVersion;
import se.ericsson.cello.transaction.Coordinator;

public abstract class VpnInterfaceMoGen
extends CelloMao
implements VpnInterfaceMo,
Reservable {
    protected String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"availabilityStatus", "operationalState", "subnet", "networkPrefixLength", "configurationMode", "ipVersion", "ipInterfaceFroId", "piuFroId", "autoDetectIpVersion", "vpnInterfaceMoRdn"};
    protected String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"VpnInterfaceId", "userLabel", "subnet", "networkPrefixLength", "ipAccessHostEtRef", "configurationMode", "ipVersion"};
    protected FroProxy froProxy = null;
    protected MoData data;
    Map myPmProxyFroIdMap = new HashMap(3);
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 8000;

    private void checkMandatoryAttrs(AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        this.checkMandatoryRefAttribute("ipAccessHostEtRef", attrList);
    }

    private void checkMandatoryAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0 || attrList.getValue(n) == null) {
            throw new AttrMissingAtCreateException(string, "VpnInterface");
        }
    }

    private void checkMandatoryRefAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0) {
            throw new AttrMissingAtCreateException(string, "VpnInterface");
        }
    }

    protected VpnInterfaceMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, InitialMaoContext initialMaoContext, AttrList attrList) throws MoAccessException {
        super(managedObject, "VpnInterface", string, coordinator, initialMaoContext);
        this.froProxy = froProxy;
        this.checkMandatoryAttrs(attrList);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("VpnInterface");
        setRequestContextImpl.assertAllowedAttributes(this.NON_READONLY_MOM_ATTRIBUTES, "VpnInterface");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "VpnInterface", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ipAccessHostEtRef", false));
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"VpnInterface");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"subnet", (AttrList)attrList, (Class)String.class, (String)"VpnInterface");
        if (string3 == null) {
            string3 = "";
        }
        this.validateSubnet(string3, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("subnet", string3));
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"networkPrefixLength", (AttrList)attrList, (Class)Integer.class, (String)"VpnInterface");
        int n2 = 32;
        if (n != null) {
            n2 = n;
        }
        this.validateNetworkPrefixLength(n2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("networkPrefixLength", n2));
        ManagedObject managedObject2 = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"ipAccessHostEtRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"VpnInterface");
        this.validateIpAccessHostEtRef(managedObject2, (SetRequestContext)setRequestContextImpl);
        int n3 = 0;
        if (managedObject2 != null && managedObject2 instanceof FroInfo) {
            n3 = ((FroInfo)managedObject2).getFroId(coordinator);
        }
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipAccessHostEtRef", n3));
        ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef")).setValue(managedObject2);
        Integer n4 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"configurationMode", (AttrList)attrList, (Class)Integer.class, (String)"VpnInterface");
        int n5 = 0;
        if (n4 != null) {
            n5 = n4;
        }
        this.validateConfigurationMode(n5, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("configurationMode", n5));
        Integer n6 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"ipVersion", (AttrList)attrList, (Class)Integer.class, (String)"VpnInterface");
        int n7 = 0;
        if (n6 != null) {
            n7 = n6;
        }
        this.validateIpVersion(n7, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipVersion", n7));
        this.onCreate((SetRequestContext)setRequestContextImpl);
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        FroData froData = setRequestContextImpl.sendCreateRequest(this.froProxy);
        int n8 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n8));
    }

    public VpnInterfaceMoGen(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("ipAccessHostEtRef");
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        return object;
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.onDelete(coordinator);
        ManagedObject managedObject = null;
        managedObject = this.getIpAccessHostEtRef(coordinator);
        if (managedObject != null && managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length > 0) {
            throw new MoReservedNotDeletableException("VpnInterface");
        }
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setSubnet(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("subnet", string, coordinator);
    }

    public String getSubnet(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("subnet", coordinator);
    }

    public void setNetworkPrefixLength(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("networkPrefixLength", new Integer(n), coordinator);
    }

    public int getNetworkPrefixLength(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("networkPrefixLength", coordinator);
    }

    public int getPmOutDroppedPacketsPolicyControl(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutDroppedPacketsPolicyControl", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public ManagedObject getIpAccessHostEtRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostEtRef", coordinator);
    }

    public int getConfigurationMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("configurationMode", coordinator);
    }

    public int getIpVersion(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipVersion", coordinator);
    }

    public String getType() {
        return "VpnInterface";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), this.ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
            } else if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("availabilityStatus");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: availabilityStatus", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("operationalState");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: operationalState", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("subnet")) {
                signedIntParameter = (StringParameter)getRequestContextImpl.getParameter("subnet");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: subnet", "getAttributes", -1);
                }
                objectArray[i] = signedIntParameter.getValue();
            } else if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("networkPrefixLength");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: networkPrefixLength", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("pmOutDroppedPacketsPolicyControl")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutDroppedPacketsPolicyControl", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                signedIntParameter = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)signedIntParameter, (Coordinator)coordinator);
            } else if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("configurationMode")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("configurationMode");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: configurationMode", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("ipVersion")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("ipVersion");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: ipVersion", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else {
                objectArray[i] = super.getAttribute(stringArray[i], coordinator);
            }
            objectArray[i] = this.onGetAttributes((GetRequestContext)getRequestContextImpl, stringArray[i], objectArray[i]);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("VpnInterface");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "VpnInterface");
            }
            if (string.equalsIgnoreCase("subnet")) {
                if (object instanceof String) {
                    String string3 = (String)object;
                    this.validateSubnet(string3, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("subnet", string3));
                    continue;
                }
                throw new WrongAttributeTypeException("subnet", "VpnInterface");
            }
            if (string.equalsIgnoreCase("networkPrefixLength")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateNetworkPrefixLength(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("networkPrefixLength", n));
                    continue;
                }
                throw new WrongAttributeTypeException("networkPrefixLength", "VpnInterface");
            }
            throw new NoSuchAttributeException(string, "VpnInterface");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"VpnInterface");
    }

    protected void validateSubnet(String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateNetworkPrefixLength(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"networkPrefixLength", (int)n, (int)1, (int)32, (String)"VpnInterface");
    }

    protected void validateIpAccessHostEtRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObject == null) {
            throw new ValueOutOfRangeException("ipAccessHostEtRef", "VpnInterface");
        }
        if (!(managedObject instanceof IpAccessHostEt)) {
            throw new WrongAttributeTypeException("ipAccessHostEtRef", "VpnInterface");
        }
    }

    protected void validateConfigurationMode(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"configurationMode", (int)n, (int[])EnumConfMode.VALUES_ARRAY, (String)"VpnInterface");
    }

    protected void validateIpVersion(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkEnumAttribute((String)"ipVersion", (int)n, (int[])EnumIpVersion.VALUES_ARRAY, (String)"VpnInterface");
    }
}

