/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.to;

import se.ericsson.cello.aueframework.collector.AttrListImpl;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.to.Constants;
import se.ericsson.cello.cmaaue.to.ToStateAUEUtil;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;

public class CreateESMandControlSwitchMOsAction
implements Constants,
DataCollectorAction {
    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        if (this.isNodeSMXBConfigured(collectorContext, coordinator)) {
            if (!this.esmMoExists(collectorContext, 1, coordinator)) {
                this.createESMMo(collectorContext, 1, coordinator);
            }
            if (!this.esmMoExists(collectorContext, 27, coordinator)) {
                this.createESMMo(collectorContext, 27, coordinator);
            }
            if (!this.controlSwicthMoExists(collectorContext, 1, coordinator)) {
                this.createControlSwitchMo(collectorContext, 1, coordinator);
            }
            if (!this.controlSwicthMoExists(collectorContext, 27, coordinator)) {
                this.createControlSwitchMo(collectorContext, 27, coordinator);
            }
        }
    }

    private boolean esmMoExists(CollectorContext collectorContext, int n, Coordinator coordinator) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("EthernetSwitchModule");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!managedObject.getRelativeDistinguishedName().equals("EthernetSwitchModule=1")) continue;
            ManagedObject managedObject2 = managedObject.getParent().getParent();
            try {
                int n2 = (Integer)managedObject2.getAttribute("slotNumber", coordinator);
                if (n2 != n) continue;
                return true;
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                collectorContext.getLogger().error(this.getClass(), "Failed to get slotNumber for " + managedObject.getLocalDistinguishedName());
            }
            catch (MoAccessException moAccessException) {
                collectorContext.getLogger().error(this.getClass(), "Failed to get slotNumber for " + managedObject.getLocalDistinguishedName());
            }
        }
        return false;
    }

    private boolean controlSwicthMoExists(CollectorContext collectorContext, int n, Coordinator coordinator) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("ControlSwitch");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!managedObject.getRelativeDistinguishedName().equals("ControlSwitch=1")) continue;
            ManagedObject managedObject2 = managedObject.getParent().getParent();
            try {
                int n2 = (Integer)managedObject2.getAttribute("slotNumber", coordinator);
                if (n2 != n) continue;
                return true;
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                collectorContext.getLogger().error(this.getClass(), "Failed to get slotNumber for " + managedObject.getLocalDistinguishedName());
            }
            catch (MoAccessException moAccessException) {
                collectorContext.getLogger().error(this.getClass(), "Failed to get slotNumber for " + managedObject.getLocalDistinguishedName());
            }
        }
        return false;
    }

    private void createESMMo(CollectorContext collectorContext, int n, Coordinator coordinator) throws AueException {
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("EthernetSwitchModule");
        if (moFactory == null) {
            collectorContext.getLogger().info(this.getClass(), "EthernetSwitchModule MoFactory not found");
            return;
        }
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Slot");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                int n2 = (Integer)managedObject.getAttribute("slotNumber", coordinator);
                if (n2 != n) continue;
                MoIterator moIterator2 = managedObject.getChildren();
                while (moIterator2 != null && moIterator2.hasMoreElements()) {
                    ManagedObject managedObject2 = moIterator2.nextMo();
                    AttrListImpl attrListImpl = new AttrListImpl();
                    ManagedObject managedObject3 = moFactory.createMo(managedObject2, (AttrList)attrListImpl, "1", null, coordinator);
                    collectorContext.getLogger().info(this.getClass(), managedObject3.getLocalDistinguishedName() + " MO created successfully...");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new AueException("ESM MO creation with identity 1 failed on Slot =" + n + exception.getMessage());
            }
        }
    }

    private void createControlSwitchMo(CollectorContext collectorContext, int n, Coordinator coordinator) throws AueException {
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("ControlSwitch");
        if (moFactory == null) {
            collectorContext.getLogger().info(this.getClass(), "ControlSwitch MoFactory not found");
            return;
        }
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Slot");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                int n2 = (Integer)managedObject.getAttribute("slotNumber", coordinator);
                if (n2 != n) continue;
                MoIterator moIterator2 = managedObject.getChildren();
                while (moIterator2 != null && moIterator2.hasMoreElements()) {
                    ManagedObject managedObject2 = moIterator2.nextMo();
                    AttrListImpl attrListImpl = new AttrListImpl();
                    ManagedObject managedObject3 = moFactory.createMo(managedObject2, (AttrList)attrListImpl, "1", null, coordinator);
                    collectorContext.getLogger().info(this.getClass(), managedObject3.getLocalDistinguishedName() + " MO created successfully...");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new AueException("Control Switch MO creation with identity 1  failed on Slot=" + n + exception.getMessage());
            }
        }
    }

    private boolean isNodeSMXBConfigured(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Slot");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            String string = null;
            String string2 = null;
            try {
                StructImpl structImpl = (StructImpl)managedObject.getAttribute("productData", coordinator);
                if (structImpl != null) {
                    string = (String)structImpl.getValue("productNumber");
                }
            }
            catch (MoAccessException moAccessException) {
                collectorContext.getLogger().error(this.getClass(), "Failed to get the  productNumber for SMXB, ESM and ControlSwitch MOs creation failed.");
            }
            if (string == null || !(string2 = ToStateAUEUtil.optimize(string)).startsWith("ROJ208476") && !string2.startsWith("ROJ208482")) continue;
            return true;
        }
        return false;
    }
}

