/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.to;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.to.Constants;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;

public class UpdateSwitchPortStpMoCAXDefaultValuesAction
implements DataCollectorAction,
Constants {
    public static final int CAX_TWO = 5;
    public static final String FAN_CONFIGURATION = "fanConfiguration";
    public static final String SUBRACK_PROD_TYPE_REF = "subrackProdTypeRef";
    public static final String CONFIGURED_PATH_COST = "configuredPathCost";
    public static final String MANUAL_PATH_COST = "manualPathCost";
    public static final Integer CONFIGURED_PATH_COST_CAX_DEFAULT = new Integer(200);
    public static final Boolean MANUAL_PATH_COST_CAX_DEFAULT = true;

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("SwitchPortStp");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            collectorContext.getLogger().info(this.getClass(), managedObject.getLocalDistinguishedName() + "switchPortStptMO created successfully...");
            ManagedObject managedObject2 = managedObject.getParent();
            if (managedObject2 == null) continue;
            try {
                this.updateCaxDefaultValues(managedObject2, managedObject, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("Unable to set " + UpdateSwitchPortStpMoCAXDefaultValuesAction.describe(managedObject, CONFIGURED_PATH_COST) + " to " + CONFIGURED_PATH_COST_CAX_DEFAULT, (Throwable)moAccessException);
            }
        }
    }

    private void updateCaxDefaultValues(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        boolean bl = this.isCaxSubrack(managedObject, coordinator);
        boolean bl2 = UpdateSwitchPortStpMoCAXDefaultValuesAction.isAutoCreated(managedObject);
        if (bl && bl2) {
            managedObject2.setAttribute(MANUAL_PATH_COST, (Object)MANUAL_PATH_COST_CAX_DEFAULT, coordinator);
            managedObject2.setAttribute(CONFIGURED_PATH_COST, (Object)CONFIGURED_PATH_COST_CAX_DEFAULT, coordinator);
        }
    }

    private static String describe(ManagedObject managedObject, String string) {
        return "(" + managedObject.getLocalDistinguishedName() + ")#" + string;
    }

    private static boolean isAutoCreated(ManagedObject managedObject) {
        boolean bl = false;
        if (managedObject.getRelativeDistinguishedName().equals("EthernetBridgePort=BackPlaneLinkEBP1")) {
            bl = true;
        }
        return bl;
    }

    private boolean isCaxSubrack(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        ManagedObject managedObject2 = null;
        ManagedObject managedObject3 = managedObject.getParent().getParent().getParent().getParent();
        if (managedObject3.getType().equals("Subrack")) {
            managedObject2 = (ManagedObject)managedObject3.getAttribute(SUBRACK_PROD_TYPE_REF, coordinator);
        }
        if (managedObject2 != null && (Integer)managedObject2.getAttribute(FAN_CONFIGURATION, coordinator) == 5) {
            bl = true;
        }
        return bl;
    }
}

