/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import java.lang.reflect.Array;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.ncli.mibmgr.DumpFormatter;
import se.ericsson.cello.ncli.mibmgr.MoAttribute;
import se.ericsson.cello.ncli.server.logging.Log;

public class XmlDumpFormatter
implements DumpFormatter {
    private static final String ATTR = "attribute";
    private static final String DATATYPE = "dataType";
    private static final String NEW_LINE = "\n";
    private static final String SEQUENCE = "sequence";
    private static final String STRUCTMEMBER = "structMember";
    private int indent = 1;
    private static final String INDENT = "   ";
    private StringBuffer buf;

    public String format(MoAttribute moAttribute) {
        Log.trace(this.getClass(), "Format mo " + moAttribute.getLdn());
        Log.trace(this.getClass(), "Num attrs " + moAttribute.getAttributes().length);
        Log.trace(this.getClass(), "Num values " + (moAttribute.getValues() != null ? moAttribute.getValues().length : 0));
        this.buf = new StringBuffer();
        this.appendStartTag("MO", "ldn", moAttribute.getLdn());
        ++this.indent;
        this.formatAttributeBuffer(moAttribute);
        --this.indent;
        this.addIndentation();
        this.buf.append("</MO>");
        return this.buf.toString();
    }

    private void formatAttributeBuffer(MoAttribute moAttribute) {
        if (moAttribute.getValues() == null) {
            this.buf.append("ERROR DURING COLLECTION").append(NEW_LINE);
        } else {
            int n = 0;
            for (n = 0; n < moAttribute.getAttributes().length; ++n) {
                this.appendStartTag(ATTR, "name", moAttribute.getAttributes()[n]);
                ++this.indent;
                this.appendStartTag(DATATYPE);
                ++this.indent;
                this.formatValueBuffer(moAttribute.getValues()[n]);
                --this.indent;
                this.appendEndTag(DATATYPE);
                --this.indent;
                this.appendEndTag(ATTR);
            }
        }
    }

    private void formatValueBuffer(Object object) {
        if (object instanceof Integer) {
            this.appendStartTag("integer");
            ++this.indent;
            this.appendValue(object.toString());
            --this.indent;
            this.appendEndTag("integer");
        } else if (object instanceof Long) {
            this.appendStartTag("long");
            ++this.indent;
            this.appendValue(object.toString());
            --this.indent;
            this.appendEndTag("long");
        } else if (object instanceof String) {
            this.appendStartTag("string");
            ++this.indent;
            this.appendValue(object.toString());
            --this.indent;
            this.appendEndTag("string");
        } else if (object instanceof Float) {
            this.appendStartTag("float");
            ++this.indent;
            this.appendValue(object.toString());
            --this.indent;
            this.appendEndTag("float");
        } else if (object instanceof Boolean) {
            this.appendStartTag("boolean");
            ++this.indent;
            this.appendValue(object.toString());
            --this.indent;
            this.appendEndTag("boolean");
        } else if (object instanceof ManagedObject) {
            this.appendStartTag("ManagedObject");
            ++this.indent;
            this.appendValue(object.toString());
            --this.indent;
            this.appendEndTag("ManagedObject");
        } else if (object instanceof Integer[]) {
            String string = "integer";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatSequenceBuffer((Object[])object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof Long[]) {
            String string = "long";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatSequenceBuffer((Object[])object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof Float[]) {
            String string = "float";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatSequenceBuffer((Object[])object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof String[]) {
            String string = "string";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatSequenceBuffer((Object[])object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof Boolean[]) {
            String string = "boolean";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatSequenceBuffer((Object[])object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof ManagedObject[]) {
            String string = "ManagedObject";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatSequenceBuffer((Object[])object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof int[]) {
            String string = "integer";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatPrimitiveSequenceBuffer(object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof long[]) {
            String string = "long";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatPrimitiveSequenceBuffer(object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof float[]) {
            String string = "float";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatPrimitiveSequenceBuffer(object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof boolean[]) {
            String string = "boolean";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            this.formatPrimitiveSequenceBuffer(object, string);
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else if (object instanceof Struct) {
            this.appendStartTag("struct");
            ++this.indent;
            this.formatStructBuffer((Struct)object);
            --this.indent;
            this.appendEndTag("struct");
        } else if (object instanceof Struct[]) {
            String string = "struct";
            this.appendStartTag(SEQUENCE, "type", string);
            ++this.indent;
            Struct[] structArray = (Struct[])object;
            for (int i = 0; i < structArray.length; ++i) {
                this.formatValueBuffer(structArray[i]);
            }
            --this.indent;
            this.appendEndTag(SEQUENCE);
        } else {
            this.addIndentation();
            this.buf.append("VALUE TYPE UNKNOWN!!!").append(NEW_LINE);
            Log.trace(this.getClass(), "Value type unknown");
        }
    }

    private void formatSequenceBuffer(Object[] objectArray, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.appendStartTag(string);
            ++this.indent;
            if (objectArray[i] != null) {
                this.appendValue(objectArray[i].toString());
            } else {
                this.appendValue("");
            }
            --this.indent;
            this.appendEndTag(string);
        }
    }

    private void formatPrimitiveSequenceBuffer(Object object, String string) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            this.appendStartTag(string);
            ++this.indent;
            Object object2 = Array.get(object, i);
            this.appendValue(String.valueOf(object2));
            --this.indent;
            this.appendEndTag(string);
        }
    }

    private void formatStructBuffer(Struct struct) {
        for (int i = 0; i < struct.getNames().length; ++i) {
            this.appendStartTag(STRUCTMEMBER, "name", struct.getNames()[i]);
            ++this.indent;
            this.appendStartTag(DATATYPE);
            ++this.indent;
            try {
                this.formatValueBuffer(struct.getValues()[i]);
            }
            catch (MoAccessException moAccessException) {
                this.addIndentation();
                this.buf.append("ERROR").append(NEW_LINE);
                Log.trace(this.getClass(), "Error when getting value for struct");
            }
            --this.indent;
            this.appendEndTag(DATATYPE);
            --this.indent;
            this.appendEndTag(STRUCTMEMBER);
        }
    }

    public String getMoSeparator() {
        return "";
    }

    private void addIndentation() {
        for (int i = 0; i < this.indent; ++i) {
            this.buf.append(INDENT);
        }
    }

    private void appendStartTag(String string) {
        this.addIndentation();
        this.buf.append("<");
        this.buf.append(string);
        this.buf.append(">");
        this.buf.append(NEW_LINE);
    }

    private void appendStartTag(String string, String string2, String string3) {
        this.addIndentation();
        this.buf.append("<");
        this.buf.append(string);
        this.buf.append(" ");
        this.buf.append(string2);
        this.buf.append("=\"");
        this.buf.append(string3);
        this.buf.append("\"");
        this.buf.append(">");
        this.buf.append(NEW_LINE);
    }

    private void appendEndTag(String string) {
        this.addIndentation();
        this.buf.append("</");
        this.buf.append(string);
        this.buf.append(">");
        this.buf.append(NEW_LINE);
    }

    private void appendValue(String string) {
        this.addIndentation();
        this.buf.append("<value>").append(string).append("</value>");
        this.buf.append(NEW_LINE);
    }

    public String getHeader() {
        return "<MIBDUMP>";
    }

    public String getFooter() {
        return "</MIBDUMP>";
    }
}

