/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.filter.BufferFilter;
import se.ericsson.cello.ncli.server.command.implementors.filter.BufferFilterFactory;
import se.ericsson.cello.ncli.server.command.result.Printout;

public abstract class Command {
    protected CommandResultListener resultListener;
    protected Printout printout;
    protected String filterCriteria = null;

    public Command(CommandResultListener commandResultListener) {
        this.resultListener = commandResultListener;
    }

    protected CommandResultListener getResultListener() {
        return this.resultListener;
    }

    protected void setResultListener(CommandResultListener commandResultListener) {
        this.resultListener = commandResultListener;
    }

    public abstract void execute();

    public boolean confirmCommand(Printout printout) {
        return this.resultListener.confirmCommand(printout);
    }

    public boolean checkCancellation() {
        return this.resultListener.checkCancellation();
    }

    public void sendResponse() {
        if (this.filterCriteria == null) {
            this.resultListener.sendResponse(this.printout);
            return;
        }
        BufferFilter bufferFilter = BufferFilterFactory.createBufferFilter();
        String string = bufferFilter.filterBufferLineByLine(this.printout.getPrintoutBuf().toString(), this.filterCriteria);
        this.printout.clearPrintoutBuf();
        this.printout.addFilteredBuffer(string);
        this.resultListener.sendResponse(this.printout);
    }

    public void commandCancelled() {
        this.resultListener.commandCancelled(this.printout);
    }

    public void setFilterCriteria(String string) {
        this.filterCriteria = string;
    }
}

