/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;

public class CreateCommand
extends CSCommand {
    private String type;
    private String name;

    public CreateCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void execute() {
        Log.trace(CreateCommand.class, "CreateCommand::execute()");
        this.printout = PrintoutFactory.createPrintout();
        try {
            this.getLdn();
            Mo mo = this.nodeServices.getCm().getMo(this.ldn);
            this.validateMo(mo);
            mo.createChild(this.name, this.type, this.getNameValueArray(), this.nodeServices.getTransactionHandler().getTransaction(3600000));
            if (this.checkCancellation()) {
                this.printout.addInhibitedString();
                this.commandCancelled();
                this.transactionHandler.softRollbackTransaction();
                return;
            }
            this.transactionHandler.softCommitTransaction();
            this.printout.addExecutedString();
        }
        catch (Exception exception) {
            this.transactionHandler.softRollbackTransaction();
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
        }
        this.sendResponse();
    }

    public void setNameAndType(String string) {
        this.type = string.substring(0, string.indexOf(61));
        this.name = string.substring(string.indexOf(61) + 1);
    }
}

