/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.List;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.implementors.GroupExecutor;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Transaction;

public class DeleteCommand
extends CSCommand
implements GroupExecutor {
    private String range;
    private boolean groupFlag;

    public DeleteCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setGroupFlag(boolean bl) {
        this.groupFlag = bl;
    }

    public void setRange(String string) {
        this.range = string;
    }

    public void execute() {
        try {
            Log.trace(DeleteCommand.class, "DeleteCommand::execute()");
            this.printout = PrintoutFactory.createPrintout();
            Transaction transaction = this.transactionHandler.getTransaction();
            if (this.range != null) {
                this.executeGroupRange(this.range, transaction);
            } else if (this.groupFlag) {
                this.executeEntireGroup(transaction);
            } else {
                MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
                this.getLdn();
                if (!this.noConfirmationFlag && !this.confirmCommand(this.ldn)) {
                    this.transactionHandler.softRollbackTransaction();
                    this.printout.addInhibitedString();
                    this.sendResponse();
                    return;
                }
                this.executeSingleMo(this.ldn, transaction);
                moGroup.removeGroupMember(this.ldn);
                this.transactionHandler.softCommitTransaction();
                this.printout.addExecutedString();
                this.sendResponse();
            }
        }
        catch (Exception exception) {
            this.transactionHandler.softRollbackTransaction();
            this.printout.addErrorText(new NcliException(exception));
            this.sendResponse();
        }
    }

    public void executeEntireGroup(Transaction transaction) throws NcliException {
        try {
            if (!this.confirmGroup(this.nodeServices.getMoGroupHandler().getDefaultGroup())) {
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.sendResponse();
                return;
            }
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            List list = moGroup.getGroupMembers();
            for (int i = 0; i < list.size(); ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                String string = (String)list.get(i);
                if (string != null) {
                    this.executeSingleMo(string, transaction);
                } else {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$DeleteCommand == null ? DeleteCommand.class$("se.ericsson.cello.ncli.server.command.implementors.DeleteCommand") : class$se$ericsson$cello$ncli$server$command$implementors$DeleteCommand, "Encountered null element in group, ignoring.");
                }
                if (!this.resultListener.checkCancellation()) continue;
                Log.trace(DeleteCommand.class, "Command cancelled");
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.resultListener.commandCancelled(this.printout);
                this.sendResponse();
                return;
            }
            moGroup.clearGroup();
            this.transactionHandler.softCommitTransaction();
            this.printout.addExecutedString();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public void executeSingleMo(String string, Transaction transaction) throws NcliException {
        try {
            Mo mo = this.nodeServices.getCm().getMo(string);
            this.validateMo(mo);
            boolean bl = mo.getLdn().compareTo(this.nodeServices.getWorkingMo().getLdn()) == 0;
            Mo mo2 = null;
            if (bl) {
                mo2 = this.nodeServices.getWorkingMo().getParent(transaction);
            }
            mo.delete(transaction);
            if (bl) {
                this.nodeServices.setWorkingMo(mo2);
            }
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public void executeGroupRange(String string, Transaction transaction) throws NcliException {
        try {
            if (!this.confirmGroupRange(this.nodeServices.getMoGroupHandler().getDefaultGroup(), string)) {
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.sendResponse();
                return;
            }
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            int n = moGroup.getSize();
            int[] nArray = this.nodeServices.getAddressResolver().resolveIndexFromRange(string, n);
            for (int i = 0; i < nArray.length; ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                String string2 = null;
                string2 = moGroup.getLdnAtIndex(nArray[i]);
                if (string2 == null) {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$DeleteCommand == null ? DeleteCommand.class$("se.ericsson.cello.ncli.server.command.implementors.DeleteCommand") : class$se$ericsson$cello$ncli$server$command$implementors$DeleteCommand, "Encountered null element in group, ignoring.");
                } else {
                    this.executeSingleMo(string2, transaction);
                }
                if (!this.resultListener.checkCancellation()) continue;
                Log.trace(DeleteCommand.class, "Command cancelled");
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.resultListener.commandCancelled(this.printout);
                this.sendResponse();
                return;
            }
            moGroup.removeGroupMembers(nArray);
            this.transactionHandler.softCommitTransaction();
            this.printout.addExecutedString();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }
}

