/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.exceptions.MemoryNotSufficientException;
import se.ericsson.cello.ncli.server.exceptions.MomAwarenessNotSupportedException;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.exceptions.ReadMomErrorException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.DnAttributes;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;

public class DiffCommand
extends CSCommand {
    private ArrayList ldnListToDiff = new ArrayList(0);
    private ArrayList attributes = new ArrayList(0);
    private static final String NULL = "null";

    public DiffCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void execute() {
        Log.trace(DiffCommand.class, "execute()");
        try {
            this.printout = PrintoutFactory.createPrintout();
            if (this.ldnListToDiff == null || this.ldnListToDiff.size() < 2) {
                throw new RuntimeException("At least two MO arguments required.");
            }
            Mo mo = this.nodeServices.getCm().getMo((String)this.ldnListToDiff.get(0));
            this.printout.addNumberedLDNs(this.ldnListToDiff);
            this.printout.addResultString();
            this.compare(mo, this.ldnListToDiff, this.attributes, this.transactionHandler.getCurrentTransaction());
            this.printout.addEndText();
        }
        catch (Exception exception) {
            this.printout.addNotAcceptedString();
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
        }
        this.sendResponse();
    }

    public void setListOfLdnsToDiff(ArrayList arrayList) {
        this.ldnListToDiff = arrayList;
    }

    public void setListOfAttributes(ArrayList arrayList) {
        this.attributes = arrayList;
    }

    public ArrayList getListOfLdnsToDiff() {
        return this.ldnListToDiff;
    }

    private void compare(Mo mo, ArrayList arrayList, ArrayList arrayList2, Transaction transaction) throws NcliException {
        try {
            if (arrayList2.size() == 0) {
                arrayList2 = this.fetchAttributeNamesFromMom(mo);
            }
            this.nodeServices.getCm().setCacheOn(true);
            Mo[] moArray = this.getMoAndAttributes(arrayList, arrayList2, transaction);
            boolean bl = false;
            Iterator iterator = arrayList2.iterator();
            block5: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                NameValue nameValue = mo.getAttribute(string, transaction);
                String string2 = NULL;
                if (nameValue != null) {
                    string2 = nameValue.toString();
                }
                for (int i = 1; i < moArray.length; ++i) {
                    Mo mo2 = moArray[i];
                    NameValue nameValue2 = mo2.getAttribute(string, transaction);
                    String string3 = NULL;
                    if (nameValue2 != null) {
                        string3 = nameValue2.toString();
                    }
                    if (string2.equals(string3)) continue;
                    if (bl) {
                        this.printout.addParagraphSeparator();
                    }
                    this.printout.addDiffResult(moArray, string);
                    bl = true;
                    continue block5;
                }
            }
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
        finally {
            this.nodeServices.getCm().setCacheOn(false);
        }
    }

    private ArrayList fetchAttributeNamesFromMom(Mo mo) throws MomAwarenessNotSupportedException, MemoryNotSufficientException, ReadMomErrorException {
        ArrayList<String> arrayList = new ArrayList<String>(0);
        String string = mo.getType();
        MomClass momClass = this.nodeServices.getMimModel().getClass(string);
        if (momClass == null) {
            throw new RuntimeException(" MoClass not defined in the MOM: " + mo.getType());
        }
        Iterator iterator = momClass.getAttributes();
        String string2 = mo.getType() + "Id";
        while (iterator.hasNext()) {
            String string3 = ((MomAttribute)iterator.next()).getName();
            if (string3.equalsIgnoreCase(string2)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private Mo[] getMoAndAttributes(ArrayList arrayList, ArrayList arrayList2, Transaction transaction) {
        Mo[] moArray;
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        DnAttributes[] dnAttributesArray = new DnAttributes[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            moArray = (Mo[])iterator.next();
            dnAttributesArray[n] = new DnAttributes((String)moArray, stringArray);
            ++n;
        }
        moArray = this.nodeServices.getCm().getMoAndAttributes(dnAttributesArray, transaction);
        return moArray;
    }
}

