/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredMo;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Struct;

public class NameValueHelper {
    private static final String TRUE = "true";
    NodeServices nodeServices;

    public NameValueHelper(NodeServices nodeServices) {
        this.nodeServices = nodeServices;
    }

    public NameValue createSimpleNameValue(String string, int n, String string2) {
        NameValue nameValue = null;
        NameValueFactory nameValueFactory = this.nodeServices.getCm().getNameValueFactory();
        switch (n) {
            case 9: {
                nameValue = nameValueFactory.create(string, string2);
                break;
            }
            case 6: {
                nameValue = nameValueFactory.create(string, Long.parseLong(string2));
                break;
            }
            case 7: {
                nameValue = nameValueFactory.create(string, Float.parseFloat(string2));
                break;
            }
            case 5: {
                nameValue = nameValueFactory.create(string, Integer.parseInt(string2));
                break;
            }
            case 1: {
                boolean bl = false;
                if (string2.equalsIgnoreCase(TRUE)) {
                    bl = true;
                }
                nameValue = nameValueFactory.create(string, bl);
                break;
            }
            case 12: {
                nameValue = nameValueFactory.create(string, this.getMo(string2));
                break;
            }
            default: {
                nameValue = nameValueFactory.create(string);
                nameValue.setStringValue("-=NCLI=-" + string2);
            }
        }
        return nameValue;
    }

    public NameValue createArrayNameValue(String string, int n, ArrayList arrayList) {
        NameValue nameValue = null;
        int n2 = arrayList.size();
        NameValueFactory nameValueFactory = this.nodeServices.getCm().getNameValueFactory();
        switch (n) {
            case 9: {
                nameValue = nameValueFactory.createStringArrayValue(string, arrayList.toArray(new String[0]));
                break;
            }
            case 11: {
                nameValue = nameValueFactory.createStructArrayValue(string, arrayList.toArray(new Struct[0]));
                break;
            }
            case 12: {
                Mo[] moArray = new Mo[n2];
                for (int i = 0; i < n2; ++i) {
                    moArray[i] = this.getMo((String)arrayList.get(i));
                }
                nameValue = nameValueFactory.createMoArrayValue(string, moArray);
                break;
            }
            case 6: {
                long[] lArray = new long[n2];
                for (int i = 0; i < n2; ++i) {
                    lArray[i] = Long.parseLong((String)arrayList.get(i));
                }
                nameValue = nameValueFactory.createLongArrayValue(string, lArray);
                break;
            }
            case 5: {
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = Integer.parseInt((String)arrayList.get(i));
                }
                nameValue = nameValueFactory.createIntArrayValue(string, nArray);
                break;
            }
            case 7: {
                float[] fArray = new float[n2];
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = Float.parseFloat((String)arrayList.get(i));
                }
                nameValue = nameValueFactory.createFloatArrayValue(string, fArray);
                break;
            }
            case 1: {
                boolean[] blArray = new boolean[arrayList.size()];
                for (int i = 0; i < n2; ++i) {
                    blArray[i] = ((String)arrayList.get(i)).equalsIgnoreCase(TRUE);
                }
                nameValue = nameValueFactory.createBooleanArrayValue(string, blArray);
                break;
            }
            case 0: {
                ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    arrayList2.add("-=NCLI=-" + (String)iterator.next());
                }
                return this.createArrayNameValue(string, 9, arrayList2);
            }
        }
        return nameValue;
    }

    private Mo getMo(String string) {
        Mo mo = this.nodeServices.getCm().getMo(string);
        if (mo instanceof MomFilteredMo) {
            return ((MomFilteredMo)mo).getUnfilteredMo();
        }
        return mo;
    }
}

