/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.session;

import java.io.EOFException;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.command.handlers.CommandHandlerFactory;
import se.ericsson.cello.ncli.server.command.handlers.CommandLineHandling;
import se.ericsson.cello.ncli.server.completion.CompletionHandlerFactory;
import se.ericsson.cello.ncli.server.completion.CompletionHandling;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.NodeServicesFactory;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.session.CommandLineSession;
import se.ericsson.cello.ncli.server.session.MessageHandler;
import se.ericsson.cello.ncli.server.session.SessionEventListener;

public class CommandLineSessionImpl
implements CommandLineSession {
    private boolean stopFlag;
    private NodeServices nodeService;
    private CommandLineHandling cmdHandler;
    private CompletionHandling completionHandler;
    private MessageHandler messageHandler;
    private SessionEventListener eventListener;

    public CommandLineSessionImpl(SessionEventListener sessionEventListener, MessageHandler messageHandler) {
        this.eventListener = sessionEventListener;
        this.stopFlag = false;
        this.nodeService = NodeServicesFactory.createNodeService();
        this.cmdHandler = CommandHandlerFactory.createCommandLineHandler(this, this.nodeService);
        this.completionHandler = CompletionHandlerFactory.createCompletionHandler(this, this.nodeService);
        this.messageHandler = messageHandler;
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(String string) {
        Log.trace(CommandLineSessionImpl.class, "stop(String message)");
        try {
            this.messageHandler.init(this);
        }
        catch (IOException iOException) {
            Log.trace(CommandLineSessionImpl.class, "Could not init MessageHandler");
        }
        this.closeSession(string);
    }

    private void stopSession() {
        Log.trace(CommandLineSessionImpl.class, "stopSession()");
        if (!this.stopFlag) {
            this.cmdHandler.disconnect();
            this.eventListener.onSessionStop(this);
            this.stopFlag = true;
        }
    }

    public void run() {
        try {
            try {
                this.messageHandler.init(this);
            }
            catch (IOException iOException) {
                Log.info(CommandLineSessionImpl.class, "Could not init MessageHandler");
                this.stopSession();
            }
            while (!this.stopFlag) {
                this.waitForInput();
            }
            this.messageHandler.terminate();
            Log.trace(CommandLineSessionImpl.class, "Leaving CommandLineSession::run()");
        }
        catch (Exception exception) {
            Log.error(CommandLineSessionImpl.class, "Unexpected error: " + exception.getMessage(), exception);
        }
        catch (Throwable throwable) {
            Log.error(CommandLineSessionImpl.class, "Unexpected error: " + throwable.getMessage());
        }
    }

    public void waitForInput() {
        try {
            this.messageHandler.readMessage();
            this.messageHandler.actOnInput();
        }
        catch (EOFException eOFException) {
            Log.trace(CommandLineSessionImpl.class, "Client closed socket");
            this.stopSession();
            return;
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "Communication error.", iOException);
            this.stopSession();
            return;
        }
        catch (NcliException ncliException) {
            Log.info(CommandLineSessionImpl.class, "Message error. ", ncliException);
            this.stopSession();
        }
    }

    public void onCmdReq(String string) {
        Log.trace(CommandLineSessionImpl.class, "onCmdReq(" + string + ")");
        if (string != null) {
            this.cmdHandler.executeCommand(string);
        } else {
            Log.info(CommandLineSessionImpl.class, "Empty command request");
            try {
                this.messageHandler.createCmdAckBuffer(9, null);
                this.messageHandler.writeMessage();
                this.sendPrompt();
            }
            catch (IOException iOException) {
                Log.info(CommandLineSessionImpl.class, "Could not send cmd ack message");
                this.stopSession();
            }
            catch (NcliException ncliException) {
                Log.info(CommandLineSessionImpl.class, "Could not create cmd ack message");
                this.stopSession();
            }
        }
    }

    public void onConnReq(String string) {
        Log.trace(CommandLineSessionImpl.class, "onConnReq(" + string + ")");
        if (!this.eventListener.isServiceAvailable()) {
            Log.info(CommandLineSessionImpl.class, "No more sessions are allowed. The service is unavailable.");
            this.messageHandler.createConnAckBuffer(10, null);
            try {
                this.messageHandler.writeMessage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stopSession();
            return;
        }
        if (this.eventListener.validateNumberOfSessions()) {
            Properties properties = this.parsePayload(string);
            if (properties.isEmpty()) {
                this.cmdHandler.connect(string, "", false);
            } else {
                String string2 = properties.getProperty("user", string);
                String string3 = properties.getProperty("auditid", "");
                boolean bl = properties.getProperty("restore", "0").equalsIgnoreCase("1");
                this.cmdHandler.connect(string2, string3, bl);
            }
        } else {
            Log.info(CommandLineSessionImpl.class, "Max number of sessions exceeded.");
            this.messageHandler.createConnAckBuffer(3, null);
            try {
                this.messageHandler.writeMessage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stopSession();
        }
    }

    public void onComplReq(String string) {
        Log.trace(CommandLineSessionImpl.class, "onComplReq(" + string + ")");
        this.completionHandler.executeCompletion(string, this, this.nodeService);
    }

    public void onDiscReq() {
        Log.trace(CommandLineSessionImpl.class, "onDiscReq()");
        this.cmdHandler.disconnect();
        this.messageHandler.createDiscAckBuffer();
        try {
            this.messageHandler.writeMessage();
        }
        catch (IOException iOException) {
            Log.trace(CommandLineSessionImpl.class, "Could not send disc ack.");
        }
        this.stopSession();
    }

    public void onHistoryDown() {
        Log.trace(CommandLineSessionImpl.class, "onHistoryDown()");
        this.cmdHandler.executeArrowDown();
    }

    public void onHistoryUp() {
        Log.trace(CommandLineSessionImpl.class, "onHistoryUp()");
        this.cmdHandler.executeArrowUp();
    }

    public void sendCommandResponse(String string) {
        try {
            this.messageHandler.createCmdAckBuffer(0, string);
            this.messageHandler.writeMessage();
        }
        catch (NcliException ncliException) {
            Log.info(CommandLineSessionImpl.class, "Could not create cmd_ack message. Closing session", ncliException);
            this.stop();
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "Could not send cmd_ack message. Closing session", iOException);
            this.stopSession();
        }
    }

    public String getConfirmation(String string) {
        try {
            if (string == null) {
                this.messageHandler.createConfirmReqBuffer("\u0003>");
            } else {
                this.messageHandler.createConfirmReqBuffer(string + "\u0003>");
            }
            this.messageHandler.writeMessage();
        }
        catch (NcliException ncliException) {
            Log.info(CommandLineSessionImpl.class, "getConfirmation(). Could not createConfirmReqBuffer. Closing session", ncliException);
            this.stop();
            return null;
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "getConfirmation(). Could not send ConfirmReqBuffer message. Closing session", iOException);
            this.stopSession();
            return null;
        }
        try {
            this.messageHandler.readSpecificMessage(8);
            if (this.messageHandler.getMessage().getSignal() != 5) {
                return this.messageHandler.getMessage().getData();
            }
            this.stopSession();
        }
        catch (EOFException eOFException) {
            Log.trace(CommandLineSessionImpl.class, "getConfirmation(). Client closed socket");
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "getConfirmation(). Communication error", iOException);
        }
        catch (NcliException ncliException) {
            this.messageHandler.createDiscReqBuffer(ncliException.getMessage());
            try {
                this.messageHandler.writeMessage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.stop();
        return null;
    }

    public void sendPrompt() {
        Log.trace(CommandLineSessionImpl.class, "sendPrompt()");
        if (this.stopFlag) {
            return;
        }
        String string = "[" + this.nodeService.getWorkingMo().getType() + "=" + this.nodeService.getWorkingMo().getName() + "]";
        try {
            this.messageHandler.createPromptBuffer(string);
            this.messageHandler.writeMessage();
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "Could not send prompt message. Closing session", iOException);
            this.stopSession();
        }
        catch (NcliException ncliException) {
            Log.info(CommandLineSessionImpl.class, "Could not create prompt message. Closing session", ncliException);
            this.stop();
        }
    }

    public boolean checkCancellation() {
        Log.trace(CommandLineSessionImpl.class, "checkCancellation()");
        try {
            if (this.messageHandler.anyMessageAvailable()) {
                this.messageHandler.readSpecificMessage(15);
                if (this.messageHandler.getMessage().getSignal() == 5) {
                    this.stopSession();
                }
                Log.trace(CommandLineSessionImpl.class, "true");
                return true;
            }
            Log.trace(CommandLineSessionImpl.class, "false");
            return false;
        }
        catch (EOFException eOFException) {
            Log.info(CommandLineSessionImpl.class, "checkCancellation(). Client closed socket");
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "checkCancellation(). Communication error");
        }
        catch (NcliException ncliException) {
            Log.info(CommandLineSessionImpl.class, ncliException.getMessage());
            this.messageHandler.createDiscReqBuffer(ncliException.getMessage());
            try {
                this.messageHandler.writeMessage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.stop();
        Log.trace(CommandLineSessionImpl.class, "false");
        return false;
    }

    public void closeSession() {
        this.closeSession(null);
    }

    private void closeSession(String string) {
        this.messageHandler.createDiscReqBuffer(string);
        try {
            this.messageHandler.writeMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stopSession();
    }

    public void acknowledgeConnection(boolean bl, String string) {
        if (bl) {
            this.messageHandler.createConnAckBuffer(10, string);
        } else {
            this.messageHandler.createConnAckBuffer(0, string);
        }
        try {
            this.messageHandler.writeMessage();
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "Could not acknowledge connect request");
            this.stopSession();
        }
        Log.info(CommandLineSessionImpl.class, "Connection request acknowledged");
    }

    public void sendHistoryResponse(String string) {
        Log.trace(CommandLineSessionImpl.class, "sendHistoryResponse(" + string + ")");
        try {
            this.messageHandler.createHistoryBrowseAckBuffer(string);
            this.messageHandler.writeMessage();
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "Could not send history_ack message. Closing session", iOException);
            this.stopSession();
        }
    }

    public void sendCancelAcknowledge(String string) {
    }

    public void sendCompletionResponse(String string, String string2) {
        Log.trace(CommandLineSessionImpl.class, "sendCompletionResponse()");
        if (string2 != null && string2.length() > 0) {
            Log.trace(CommandLineSessionImpl.class, "sendCompletionResponse, send completionOptionBuf");
            try {
                this.messageHandler.createComplOptionListAckBuffer(string2);
                this.messageHandler.writeMessage();
                this.sendPrompt();
            }
            catch (IOException iOException) {
                Log.info(CommandLineSessionImpl.class, "Could not send NCLI_SGN_COMPL_OPT_LIST_ACK message. Closing session", iOException);
                this.stopSession();
            }
        }
        Log.trace(CommandLineSessionImpl.class, "sendCompletionResponse, send completedCmdLine");
        try {
            this.messageHandler.createComplCmdLineAckBuffer(string);
            this.messageHandler.writeMessage();
            this.sendPrompt();
        }
        catch (IOException iOException) {
            Log.info(CommandLineSessionImpl.class, "Could not send NCLI_SGN_COMPL_CMDLINE_ACK message. Closing session", iOException);
            this.stopSession();
        }
    }

    public void sendErrorResponse(boolean bl, String string) {
    }

    Properties parsePayload(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n == -1) {
                Log.trace(class$se$ericsson$cello$ncli$server$session$CommandLineSessionImpl == null ? CommandLineSessionImpl.class$("se.ericsson.cello.ncli.server.session.CommandLineSessionImpl") : class$se$ericsson$cello$ncli$server$session$CommandLineSessionImpl, "No equal sign found. Ignoring");
                continue;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            Log.trace(class$se$ericsson$cello$ncli$server$session$CommandLineSessionImpl == null ? CommandLineSessionImpl.class$("se.ericsson.cello.ncli.server.session.CommandLineSessionImpl") : class$se$ericsson$cello$ncli$server$session$CommandLineSessionImpl, "Creating property " + string3 + "=" + string4);
            properties.setProperty(string3, string4);
        }
        return properties;
    }
}

