/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.logging;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.TraceGroup;

class CppLogger
implements AbstractLogger {
    public static final int TRUNCSIZE = 20000;
    private final List listeningLoggers = new ArrayList();
    private boolean writeToLog;

    CppLogger() {
        this(true);
    }

    CppLogger(boolean writeToLog) {
        this.writeToLog = writeToLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.infoLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.infoMessageLog(clazz, msg);
    }

    private void infoLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.info(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.info(clazz, msg);
        }
    }

    private void infoMessageLog(Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.info((Class)clazz, (String)msg1);
            }
        } else if (this.writeToLog) {
            MessageLog.info((Class)clazz, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDebug(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.debugLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.groupNumberMessageLog(TraceGroup.DEBUG.getGroupNumber(), clazz, msg);
    }

    private void debugLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceDebug(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceDebug(clazz, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDebugStackTrace(Class clazz, Throwable exc) {
        String msg = null;
        if (exc != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exc.printStackTrace(printWriter);
            stringWriter.flush();
            try {
                printWriter.close();
                stringWriter.close();
            }
            catch (IOException e) {
                msg = msg + e.getMessage();
            }
            msg = msg + stringWriter.toString();
        }
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    listeningLogger.traceDebugStackTrace(clazz, exc);
                }
            }
        }
        if (this.writeToLog) {
            MessageLog.trace((int)TraceGroup.DEBUG.getGroupNumber(), (Class)clazz, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceEnter(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.enterLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.enterMessageLog(clazz, msg);
    }

    private void enterLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceEnter(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceEnter(clazz, msg);
        }
    }

    private void enterMessageLog(Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceEnter((Class)clazz, (String)msg1);
            }
        } else if (this.writeToLog) {
            MessageLog.traceEnter((Class)clazz, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceError(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.errorLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.errorMessageLog(clazz, msg);
    }

    private void errorLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceError(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceError(clazz, msg);
        }
    }

    private void errorMessageLog(Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceError((Class)clazz, (String)msg1);
            }
        } else if (this.writeToLog) {
            MessageLog.traceError((Class)clazz, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceError(Class clazz, String msg, Throwable throwable) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.errorLogger(listeningLogger, clazz, msg, throwable);
                }
            }
        }
        this.errorMessageLog(clazz, msg, throwable);
    }

    private void errorLogger(AbstractLogger listeningLogger, Class clazz, String msg, Throwable throwable) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msgPart = (String)msgIt.next();
                if (msgIt.hasNext()) {
                    listeningLogger.traceError(clazz, msgPart);
                    continue;
                }
                listeningLogger.traceError(clazz, msgPart, throwable);
            }
        } else {
            listeningLogger.traceError(clazz, msg, throwable);
        }
    }

    private void errorMessageLog(Class clazz, String msg, Throwable throwable) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceError((Class)clazz, (String)msg1, (Throwable)throwable);
            }
        } else if (this.writeToLog) {
            MessageLog.traceError((Class)clazz, (String)msg, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceGeneral(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.generalLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.groupNumberMessageLog(TraceGroup.GENERAL.getGroupNumber(), clazz, msg);
    }

    private void generalLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceGeneral(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceGeneral(clazz, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceParam(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.paramLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.paramMessageLog(clazz, msg);
    }

    private void paramLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceParam(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceParam(clazz, msg);
        }
    }

    private void paramMessageLog(Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceParam((Class)clazz, (String)msg1);
            }
        } else if (this.writeToLog) {
            MessageLog.traceParam((Class)clazz, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceReturn(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.returnLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.returnMessageLog(clazz, msg);
    }

    private void returnLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceReturn(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceReturn(clazz, msg);
        }
    }

    private void returnMessageLog(Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceReturn((Class)clazz, (String)msg1);
            }
        } else if (this.writeToLog) {
            MessageLog.traceReturn((Class)clazz, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceAbnormal(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.abnormalLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.groupNumberMessageLog(TraceGroup.ABNORMAL.getGroupNumber(), clazz, msg);
    }

    private void abnormalLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceAbnormal(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceAbnormal(clazz, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceTimer(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.timerLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.groupNumberMessageLog(TraceGroup.TIMER.getGroupNumber(), clazz, msg);
    }

    private void timerLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceTimer(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceTimer(clazz, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceRecSig(Class clazz, String msg, InSignal inSignal) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.recSigLogger(listeningLogger, clazz, msg, inSignal);
                }
            }
        }
        this.recSigMessageLog(clazz, msg, inSignal);
    }

    private void recSigLogger(AbstractLogger listeningLogger, Class clazz, String msg, InSignal inSignal) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceRecSig(clazz, (String)msgIt.next(), inSignal);
            }
        } else {
            listeningLogger.traceRecSig(clazz, msg, inSignal);
        }
    }

    private void recSigMessageLog(Class clazz, String msg, InSignal inSignal) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceRecSig((Class)clazz, (String)msg1, (InSignal)inSignal);
            }
        } else if (this.writeToLog) {
            MessageLog.traceRecSig((Class)clazz, (String)msg, (InSignal)inSignal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceSendSig(Class clazz, String msg, OutSignal outSignal, OseProcess oseProcess) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.sendSigLogger(listeningLogger, clazz, msg, outSignal, oseProcess);
                }
            }
        }
        this.sendSigMessageLog(clazz, msg, outSignal, oseProcess);
    }

    private void sendSigLogger(AbstractLogger listeningLogger, Class clazz, String msg, OutSignal outSignal, OseProcess oseProcess) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceSendSig(clazz, (String)msgIt.next(), outSignal, oseProcess);
            }
        } else {
            listeningLogger.traceSendSig(clazz, msg, outSignal, oseProcess);
        }
    }

    private void sendSigMessageLog(Class clazz, String msg, OutSignal outSignal, OseProcess oseProcess) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceSendSig((Class)clazz, (String)msg1, (OutSignal)outSignal, (OseProcess)oseProcess);
            }
        } else if (this.writeToLog) {
            MessageLog.traceSendSig((Class)clazz, (String)msg, (OutSignal)outSignal, (OseProcess)oseProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceState(Class clazz, String msg) {
        List list = this.listeningLoggers;
        synchronized (list) {
            if (!this.listeningLoggers.isEmpty()) {
                for (int i = 0; i < this.listeningLoggers.size(); ++i) {
                    AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
                    this.stateLogger(listeningLogger, clazz, msg);
                }
            }
        }
        this.stateMessageLog(clazz, msg);
    }

    private void stateLogger(AbstractLogger listeningLogger, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                listeningLogger.traceState(clazz, (String)msgIt.next());
            }
        } else {
            listeningLogger.traceState(clazz, msg);
        }
    }

    private void stateMessageLog(Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.traceState((Class)clazz, (String)msg1);
            }
        } else if (this.writeToLog) {
            MessageLog.traceState((Class)clazz, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeningLogger(AbstractLogger logger) {
        List list = this.listeningLoggers;
        synchronized (list) {
            this.listeningLoggers.add(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeningLogger(AbstractLogger logger) {
        List list = this.listeningLoggers;
        synchronized (list) {
            this.listeningLoggers.remove(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLogger[] getListeningLoggers() {
        List list = this.listeningLoggers;
        synchronized (list) {
            AbstractLogger[] result = new AbstractLogger[this.listeningLoggers.size()];
            this.listeningLoggers.toArray(result);
            return result;
        }
    }

    private void groupNumberMessageLog(int groupNumber, Class clazz, String msg) {
        if (msg != null && msg.length() > 20000) {
            List splittedMsgs = this.splitMsg(msg, 20000);
            Iterator msgIt = splittedMsgs.iterator();
            while (msgIt.hasNext()) {
                String msg1 = (String)msgIt.next();
                if (!this.writeToLog) continue;
                MessageLog.trace((int)groupNumber, (Class)clazz, (String)msg1);
            }
        } else if (this.writeToLog) {
            MessageLog.trace((int)groupNumber, (Class)clazz, (String)msg);
        }
    }

    protected List splitMsg(String msg, int truncSize) {
        ArrayList<String> truncList = new ArrayList<String>();
        int start = 0;
        int stop = 0;
        int i = 0;
        while (stop < msg.length() - 1) {
            start = i * truncSize;
            stop = i * truncSize + truncSize;
            if (stop > msg.length() - 1) {
                truncList.add(msg.substring(start, msg.length()));
            } else {
                truncList.add(msg.substring(start, stop));
            }
            ++i;
        }
        return truncList;
    }
}

