/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class RemoveMoHelper {
    private static final Class THIS_CLASS = RemoveMoHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public void removeMoFromCppMaoDb(String moTypeName) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "removeMoFromCppMaoDb");
        DbWrapper dbWrapper = null;
        String moType = "";
        try {
            dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            dbWrapper.openConnection();
            moType = this.getMoTypeFromDataBase(dbWrapper, moTypeName);
            if (moType != "") {
                this.deleteMoFromDataBase(dbWrapper, moType);
                this.updateMosUnderDeletedMo(dbWrapper, moType);
            }
        }
        catch (Exception e) {
            throw new CrbsAueException(e.getMessage());
        }
        finally {
            try {
                dbWrapper.closeConnection(1);
            }
            catch (SQLException sqle) {
                throw new CrbsAueException(sqle.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "removeMoFromCppMaoDb");
    }

    private void updateMosUnderDeletedMo(DbWrapper dbWrapper, String moType) throws SQLException {
        String ldn = null;
        String id = null;
        ResultSet resultSet = dbWrapper.executeQuery("SELECT * FROM modata_r2 WHERE data LIKE " + AueUtil.quote("%," + moType + "=%"));
        while (resultSet.next()) {
            id = resultSet.getString(1);
            ldn = resultSet.getString(2);
            ldn = this.removeMoFromLdn(ldn, moType);
            dbWrapper.executeUpdate("UPDATE modata_r2 SET data=" + AueUtil.quote(ldn) + " WHERE id=" + id);
        }
        this.closeResultSet(resultSet);
    }

    private String removeMoFromLdn(String modata, String moType) {
        int positionOfMoType = 0;
        int positionOfSecondComma = 0;
        String updatedModata = modata;
        int index = 0;
        positionOfMoType = modata.indexOf("," + moType + "=", index);
        while (positionOfMoType != -1) {
            positionOfSecondComma = modata.indexOf(",", positionOfMoType + 1);
            updatedModata = modata.substring(0, positionOfMoType + 1) + modata.substring(positionOfSecondComma + 1, modata.length());
            index = positionOfMoType + 1;
            positionOfMoType = modata.indexOf("," + moType + "=", index);
        }
        return updatedModata;
    }

    private void deleteMoFromDataBase(DbWrapper dbWrapper, String moToDelete) throws SQLException {
        ResultSet resultSet = dbWrapper.executeQuery("SELECT id FROM modata_r2 WHERE data LIKE " + AueUtil.quote(moToDelete + "^%" + moToDelete + "%"));
        if (resultSet.next()) {
            String idOfMoToDelete = resultSet.getString(1);
            dbWrapper.executeUpdate("DELETE from modata_r2 WHERE id =" + idOfMoToDelete);
        }
        this.closeResultSet(resultSet);
    }

    private String getMoTypeFromDataBase(DbWrapper dbWrapper, String moTypeName) throws SQLException {
        String moType = "";
        ResultSet resultSet = dbWrapper.executeQuery("SELECT id FROM motype_r1 WHERE data=" + AueUtil.quote(moTypeName));
        if (resultSet.next()) {
            moType = resultSet.getString(1);
        }
        this.closeResultSet(resultSet);
        return moType;
    }

    private void closeResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            resultSet.close();
        }
    }
}

