/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyAttributeToChildMOAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CopyAttributeToChildMOAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CopyAttributeToChildMOAction = CopyAttributeToChildMOAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CopyAttributeToChildMOAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CopyAttributeToChildMOAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CopyAttributeToChildMOAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        String parentMo = this.getAndCheckParamMapString("Mo", this.paramMap, "Failed to obtain parameter \"Mo\" in class " + AueUtil.doubleQuote(this.getClass().getName()));
        String childMo = this.getAndCheckParamMapString("childMo", this.paramMap, "Failed to obtain parameter \"childMO\" in class " + AueUtil.doubleQuote(this.getClass().getName()));
        String fromAttr = this.getAndCheckParamMapString("fromAttr", this.paramMap, "Failed to obtain parameter \"fromAttr\" in class " + AueUtil.doubleQuote(this.getClass().getName()));
        String toAttr = this.getAndCheckParamMapString("toAttr", this.paramMap, "Failed to obtain parameter \"toAttr\" in class " + AueUtil.doubleQuote(this.getClass().getName()));
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        boolean gotChildTable = false;
        boolean gotParentTable = false;
        try {
            TableData childTable = tableHandler.getTableData(childMo);
            if (childTable == null || !childTable.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "Couldn't find child MO " + childMo);
            } else {
                gotChildTable = true;
            }
            TableData parentTable = tableHandler.getTableData(parentMo);
            if (parentTable == null || !parentTable.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "Couldn't find parent MO " + parentMo);
            } else {
                gotParentTable = true;
            }
            if (gotChildTable && gotParentTable) {
                this.performCopy(childTable, parentTable, tableHandler, fromAttr, toAttr);
            }
        }
        catch (TableDataException tde) {
            String errorMsg = "Could not copy attribute attribute, " + AueUtil.doubleQuote(fromAttr) + ", from parent, " + AueUtil.doubleQuote(parentMo) + ", to child, " + AueUtil.doubleQuote(childMo);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, tde));
            throw new CrbsAueException(errorMsg, tde);
        }
    }

    private void performCopy(TableData childTable, TableData parentTable, TableHandler tableHandler, String fromAttr, String toAttr) throws CrbsAueException {
        try {
            String momType = parentTable.getMomType(fromAttr);
            String defaultValue = "STRING".equals(momType) ? "" : "0";
            childTable.addAttribute(toAttr, momType, defaultValue);
            Object[] childLdnColumnDatas = childTable.getAttributeValues("ldn");
            Object[] parentFromAttrColumnDatas = parentTable.getAttributeValues(fromAttr);
            for (int childInstanceIndex = 0; childInstanceIndex < childLdnColumnDatas.length; ++childInstanceIndex) {
                String parentLdn = LdnUtil.getParentLdn(childLdnColumnDatas[childInstanceIndex].toString());
                Object[] parentLdnColumn = parentTable.getAttributeValues("ldn");
                for (int parentInstanceIndex = 0; parentInstanceIndex < parentLdnColumn.length; ++parentInstanceIndex) {
                    if (!parentLdn.equals(parentLdnColumn[parentInstanceIndex].toString())) continue;
                    Object tmpObj = parentFromAttrColumnDatas[parentInstanceIndex];
                    childTable.setAttributeValue(childInstanceIndex, toAttr, tmpObj);
                    logger.traceDebug(THIS_CLASS, "Attribute " + fromAttr + " extracted from parent " + parentTable.getFroTypeName());
                }
            }
            tableHandler.checkAndDropIfNotUpdated(childTable);
        }
        catch (TableDataException e) {
            throw new CrbsAueException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

