/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.AbstractList;
import java.util.ArrayList;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.AttributeData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class CreateChildInstanceAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CreateChildInstanceAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CreateChildInstanceAction = CreateChildInstanceAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CreateChildInstanceAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CreateChildInstanceAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CreateChildInstanceAction;

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        boolean parentFro = false;
        boolean parentCPP = false;
        try {
            MoAccessor accessor;
            String childTypeName = this.getAndCheckParamMapString("childType", this.paramMap, "The child type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
            String childRdnValue = this.getAndCheckParamMapString("childRdnValue", this.paramMap, "The child RDN is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
            String parentFroTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type, copy to, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
            String childAttributes = (String)this.paramMap.get("childAttributes");
            if (childAttributes != null && !childAttributes.equals("")) {
                this.parseChildAttributes(childAttributes);
            }
            if ((accessor = ((CollectorContext)aueContext).getMoAccessor()) == null) {
                throw new CrbsAueException("MoAccessor accessor is null. No parent instance of type " + parentFroTypeName + "exist. Can't create child instance of type " + childTypeName);
            }
            TableData parentTableData = null;
            try {
                parentTableData = this.tableHandler.getTableData(parentFroTypeName);
            }
            catch (TableDataException e) {
                logger.traceGeneral(THIS_CLASS, "MO " + childTypeName + " has no parent in Fro.");
            }
            Object[] ldnObjects = null;
            if (parentTableData != null && !parentTableData.getTableName().equals("")) {
                try {
                    ldnObjects = TableDataUtil.getLdns(parentTableData);
                    parentFro = true;
                }
                catch (TableDataException tde) {
                    // empty catch block
                }
            }
            if (ldnObjects == null || ldnObjects.length == 0) {
                boolean parentIsRemoved;
                boolean bl = parentIsRemoved = !parentTableData.getFroTypeId().equals(new Integer(-1));
                if (parentIsRemoved) {
                    logger.traceGeneral(THIS_CLASS, "The parent MO " + parentFroTypeName + " has been removed. Not creating child instance " + childTypeName + "!");
                    return;
                }
                MoIterator moIterator = accessor.lookupType(parentFroTypeName);
                if (moIterator == null) {
                    logger.traceGeneral(THIS_CLASS, "MO " + childTypeName + " has no parent in CPP.");
                } else {
                    parentCPP = true;
                    while (moIterator.hasMoreElements()) {
                        ManagedObject parentMo = moIterator.nextMo();
                        String parentLdn = parentMo.getLocalDistinguishedName();
                        String childLdn = parentLdn + "," + childTypeName + "=" + childRdnValue;
                        this.addInstanceToTable(childTypeName, childLdn, parentFroTypeName, parentLdn, parentFro);
                    }
                }
            } else {
                for (int i = 0; i < ldnObjects.length; ++i) {
                    String parentLdn = ldnObjects[i].toString();
                    String childLdn = parentLdn + "," + childTypeName + "=" + childRdnValue;
                    this.addInstanceToTable(childTypeName, childLdn, parentFroTypeName, parentLdn, parentFro);
                }
            }
            if (!parentCPP && !parentFro) {
                logger.traceGeneral(THIS_CLASS, "MO " + childTypeName + " has no parent in CPP or MO. Child not created.");
            }
            logger.traceReturn(THIS_CLASS, "createInstance()");
        }
        catch (CrbsAueException cae) {
            throw cae;
        }
        catch (Exception e) {
            CrbsAueException cae = new CrbsAueException("Failed create child instance. Reason: " + e.getMessage());
            cae.setStackTrace(e.getStackTrace());
            throw cae;
        }
    }

    private void setupTableForNewMoType(String childTypeName, TableData childTableData, TableHandler tableHandler) throws CrbsAueException, TableDataException {
        String childFroTypeString = this.getAndCheckParamMapString("childFroType", this.paramMap, "The child FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        Integer childFroType = this.getIntegerFroTypeId(childFroTypeString);
        childTableData.setFroTypeId(childFroType);
        String auePrefix = tableHandler.getRbsAueMetaData().getAuePrefix();
        String tablePrefix = tableHandler.getRbsAueMetaData().getFroDataPrefix();
        String tableName = auePrefix + tablePrefix + childTypeName + "_INITIAL";
        childTableData.setNewTableName(tableName);
        if (this.moTypeIsNew(childTypeName)) {
            this.insertIntoFroVersions(childFroType, childTypeName);
        }
    }

    private void addInstanceToTable(String childTypeName, String childMoLdn, String parentFroType, String parentLdn, boolean froParent) throws CrbsAueException {
        try {
            TableData childTable = this.tableHandler.getTableData(childTypeName);
            String tableName = childTable.getTableName();
            if (tableName.equalsIgnoreCase("")) {
                this.setupTableForNewMoType(childTypeName, childTable, this.tableHandler);
            }
            if (childTable.hasColumns()) {
                logger.traceGeneral(THIS_CLASS, "The attribute columns exist for " + childTypeName + ", no need to add them to TableData.");
            } else {
                childTable.addAttribute("froid", "S32", "0");
                childTable.setAsTheOnlyPrimaryKey("froid");
                childTable.addAttribute("ldn", "STRING", "");
                childTable.addAttribute("parentRef", "moref", "");
                if (this.attributeDataList != null) {
                    this.addChildAttributesColumns(this.attributeDataList, childTable);
                }
                logger.traceGeneral(THIS_CLASS, "No attributes in the database for " + childTypeName + ", attribute columns added to TableData.");
            }
            Object[] froIdColumnDatas = childTable.getAttributeValues("froid");
            Object[] ldnColumnDatas = childTable.getAttributeValues("ldn");
            boolean childExists = false;
            for (int i = 0; i < ldnColumnDatas.length; ++i) {
                if (!childMoLdn.equalsIgnoreCase(ldnColumnDatas[i].toString())) continue;
                childExists = true;
                break;
            }
            if (!childExists) {
                int froId = this.getNextAvailableFroId(froIdColumnDatas);
                ArrayList<String> attributeNamesList = new ArrayList<String>();
                attributeNamesList.add("froid");
                attributeNamesList.add("ldn");
                attributeNamesList.add("parentRef");
                ArrayList<Object> attributeValuesList = new ArrayList<Object>();
                attributeValuesList.add(new Integer(froId));
                attributeValuesList.add(childMoLdn);
                attributeValuesList.add(this.createParentMoRef(parentLdn, parentFroType, froParent));
                if (this.attributeDataList != null && this.attributeDataList.size() > 0) {
                    for (int i = 0; i < this.attributeDataList.size(); ++i) {
                        AttributeData attribute = (AttributeData)this.attributeDataList.get(i);
                        attributeNamesList.add(attribute.name);
                        attributeValuesList.add(attribute.value);
                    }
                }
                String[] attributeNames = new String[attributeNamesList.size()];
                attributeNamesList.toArray(attributeNames);
                Object[] attributeValues = new Object[attributeValuesList.size()];
                attributeValuesList.toArray(attributeValues);
                childTable.addAttributeValues(attributeNames, attributeValues);
                this.tableHandler.checkAndDropIfNotUpdated(childTable);
                this.tableHandler.storeInAuePersistency(childMoLdn, "froId", Integer.toString(froId));
            }
        }
        catch (TableDataException tde) {
            CrbsAueException cae = new CrbsAueException("Failed create child instance. Reason: " + tde.getMessage());
            cae.setStackTrace(tde.getStackTrace());
            throw cae;
        }
    }

    private void addChildAttributesColumns(AbstractList localAttributeDataList, TableData childTableData) throws TableDataException {
        for (int i = 0; i < localAttributeDataList.size(); ++i) {
            AttributeData attribute = (AttributeData)localAttributeDataList.get(i);
            String columnToAdd = attribute.name;
            boolean columnExist = false;
            String[] attributeNames = childTableData.getAttributeNames();
            for (int column = 0; column < attributeNames.length; ++column) {
                if (!attributeNames[i].equalsIgnoreCase(columnToAdd)) continue;
                logger.traceGeneral(THIS_CLASS, "The column " + columnToAdd + "already exist in the table " + childTableData.getTableName() + ". No need to add column.");
                columnExist = true;
                break;
            }
            if (columnExist) continue;
            childTableData.addAttribute(columnToAdd, attribute.type, attribute.defaultValue);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

