/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.ArrayList;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.AttributeData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

public class CreateOneInstanceAction
extends AbstractCreateInstanceAction {
    private static final int PARENT_REF_COLUMN = 2;
    private static final int LDN_COLUMN = 1;
    private static final int FRO_ID_COLUMN = 0;
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CreateOneInstanceAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CreateOneInstanceAction = CreateOneInstanceAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CreateOneInstanceAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private String createdMoLdn;
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CreateOneInstanceAction;

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        String froTypeName = this.getAndCheckParamMapString("name", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String froTypeIdString = this.getAndCheckParamMapString("frotype", this.paramMap, "The FRO type id is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String parentLdn = this.getAndCheckParamMapString("parentldn", this.paramMap, "The parent LDN is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        if (!AueUtil.isLdn(parentLdn)) {
            throw new CrbsAueException("Specified parent LDN is not a real LDN, " + AueUtil.doubleQuote(parentLdn));
        }
        Integer froTypeId = this.getIntegerFroTypeId(froTypeIdString);
        int froId = -1;
        try {
            String froIdValue = this.getAndCheckParamMapString("froid", this.paramMap, "The froId value is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
            froId = Integer.parseInt(froIdValue);
        }
        catch (CrbsAueException auee) {
            logger.traceGeneral(THIS_CLASS, "No froId specified for new MO " + froTypeName);
        }
        String rdnValue = "";
        try {
            rdnValue = this.getAndCheckParamMapString("rdnValue", this.paramMap, "The RDN value is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        }
        catch (CrbsAueException auee) {
            logger.traceGeneral(THIS_CLASS, "No RDN specified for new MO " + froTypeName);
        }
        boolean parentRefExists = true;
        try {
            String parentRefExistsString = this.getAndCheckParamMapString("parentRefExists", this.paramMap, "The parentRefExists value is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
            parentRefExists = Boolean.valueOf(parentRefExistsString);
        }
        catch (CrbsAueException auee) {
            logger.traceGeneral(THIS_CLASS, "No parentRefExists specified for new MO " + froTypeName);
        }
        String childAttributes = (String)this.paramMap.get("childAttributes");
        if (childAttributes != null && !childAttributes.equals("")) {
            this.parseChildAttributes(childAttributes);
        }
        this.createInstance(rdnValue, parentRefExists, froTypeName, froTypeId, froId, parentLdn);
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    protected void createInstance(String rdnValue, boolean parentRefExists, String froTypeName, Integer froTypeId, int froIdIn, String parentLdn) throws CrbsAueException {
        try {
            TableData tableData = null;
            tableData = this.tableHandler.isExisting(froTypeId) ? this.tableHandler.getTableData(froTypeName) : this.tableHandler.createNewEmptyTableData(froTypeId, froTypeName);
            if (tableData.hasColumns()) {
                logger.traceGeneral(THIS_CLASS, "The attribute columns exist for " + froTypeName + ", no need to add them to TableData.");
            } else {
                this.addColumnsToFroDataTable(tableData, froTypeName, parentRefExists);
            }
            this.checkCorrectColumnsExist(tableData, parentRefExists);
            Integer froId = null;
            if (froIdIn == -1) {
                froId = this.getNewFroId(tableData);
            } else {
                this.verifyFroId(froIdIn, tableData);
                froId = new Integer(froIdIn);
            }
            String ldn = this.getLdn(rdnValue, parentLdn, froTypeName, froId, tableData);
            this.addColumnData(froId, parentLdn, ldn, tableData, parentRefExists);
            if (this.moTypeIsNew(froTypeName)) {
                this.insertIntoFroVersions(froTypeId, froTypeName);
            }
            this.tableHandler.storeInAuePersistency(ldn, "froId", froId.toString());
        }
        catch (TableDataException tde) {
            throw new CrbsAueException(tde.getMessage(), tde);
        }
    }

    private void addColumnData(Integer froId, String parentLdn, String ldn, TableData tableData, boolean parentRefExists) throws CrbsAueException, TableDataException {
        String froTypeName = this.getFroTypeNameFromLdn(parentLdn);
        ArrayList<String> attributeNamesList = new ArrayList<String>();
        ArrayList<Object> attributeValuesList = new ArrayList<Object>();
        attributeNamesList.add("froid");
        attributeNamesList.add("ldn");
        attributeValuesList.add(froId);
        attributeValuesList.add(ldn);
        if (parentRefExists) {
            String parentRef = this.createParentMoRef(parentLdn, froTypeName, true);
            attributeNamesList.add("parentRef");
            attributeValuesList.add(parentRef);
        }
        if (this.attributeDataList != null && this.attributeDataList.size() > 0) {
            for (int i = 0; i < this.attributeDataList.size(); ++i) {
                AttributeData attribute = (AttributeData)this.attributeDataList.get(i);
                attributeNamesList.add(attribute.name);
                attributeValuesList.add(attribute.value);
            }
        }
        String[] attributeNames = new String[attributeNamesList.size()];
        attributeNamesList.toArray(attributeNames);
        Object[] attributeValues = new Object[attributeValuesList.size()];
        attributeValuesList.toArray(attributeValues);
        tableData.addAttributeValues(attributeNames, attributeValues);
        this.createdMoLdn = ldn;
    }

    private String getLdn(String rdnValue, String parentLdn, String froTypeName, Integer froId, TableData tableData) throws TableDataException {
        String ldn = "";
        ldn = rdnValue.equalsIgnoreCase("") ? this.getAvailableLdn(parentLdn, froTypeName, froId, tableData) : parentLdn + "," + froTypeName + "=" + rdnValue;
        return ldn;
    }

    private String getAvailableLdn(String parentLdn, String froTypeName, Integer froId, TableData tableData) throws TableDataException {
        Integer rdnValue = new Integer(froId + 1);
        String firstLdnPart = parentLdn + "," + froTypeName + "=";
        Object[] ldnColumnDatas = tableData.getAttributeValues("ldn");
        return this.getNextAvailibleLdn(firstLdnPart, rdnValue, ldnColumnDatas);
    }

    private String getNextAvailibleLdn(String firstLdnPart, Integer rdnValue, Object[] ldnColumnDatas) {
        String ldn = firstLdnPart + rdnValue.toString();
        for (int i = 0; i < ldnColumnDatas.length; ++i) {
            if (!ldn.equalsIgnoreCase((String)ldnColumnDatas[i])) continue;
            ldn = this.getNextAvailibleLdn(firstLdnPart, new Integer(rdnValue + 1), ldnColumnDatas);
            break;
        }
        return ldn;
    }

    private void checkCorrectColumnsExist(TableData tableData, boolean parentRefExists) throws CrbsAueException {
        boolean columnsOk;
        String[] attributeNames = tableData.getAttributeNames();
        boolean bl = columnsOk = attributeNames != null && this.verifyColumn(attributeNames, 0, "froid") && this.verifyColumn(attributeNames, 1, "ldn");
        if (columnsOk) {
            if (parentRefExists) {
                columnsOk = this.verifyColumn(attributeNames, 2, "parentRef");
            } else {
                boolean bl2 = columnsOk = attributeNames.length <= 2 || !attributeNames[2].equalsIgnoreCase("parentRef");
            }
        }
        if (!columnsOk) {
            throw new CrbsAueException(CreateOneInstanceAction.attributeNameNotAsExepectedErrorMsg(tableData.getTableName(), attributeNames, parentRefExists));
        }
    }

    private boolean verifyColumn(String[] attributeNames, int columnIndex, String expectedColumnName) {
        return attributeNames.length > columnIndex && attributeNames[columnIndex].equalsIgnoreCase(expectedColumnName);
    }

    private static String attributeNameNotAsExepectedErrorMsg(String tableName, String[] attributeNames, boolean parentRefExists) {
        StringBuffer result = new StringBuffer("Expected the first columns in table \"" + tableName + "\" to be: 'froid', 'ldn'" + (parentRefExists ? ", 'parentRef'" : "") + ". Actual columns: ");
        if (attributeNames == null) {
            result.append("NULL");
        } else if (attributeNames.length == 0) {
            result.append("NONE");
        } else {
            for (int i = 0; i < attributeNames.length; ++i) {
                result.append((i > 0 ? ", " : "") + "'" + attributeNames[i] + "'");
            }
        }
        return result.toString();
    }

    private void addColumnsToFroDataTable(TableData tableData, String froTypeName, boolean parentRefExists) throws CrbsAueException {
        try {
            tableData.addAttribute("froid", "S32", "0");
            tableData.setPrimaryKey("froid", true);
            tableData.addAttribute("ldn", "STRING", "");
            if (parentRefExists) {
                tableData.addAttribute("parentRef", "moref", "");
            }
            logger.traceGeneral(THIS_CLASS, "No attributes in the database for " + froTypeName + ", attribute columns added to TableData.");
        }
        catch (TableDataException tde) {
            throw new CrbsAueException("Exception from TableData: " + tde.getMessage());
        }
    }

    private Integer getNewFroId(TableData tableData) throws TableDataException {
        Object[] froIdColumnDatas = tableData.getAttributeValues("froid");
        Integer tmpFroId = new Integer(0);
        if (froIdColumnDatas.length > 0) {
            for (int i = 0; i < froIdColumnDatas.length; ++i) {
                Integer intData = (Integer)froIdColumnDatas[i];
                if (intData == null || intData <= tmpFroId) continue;
                tmpFroId = intData;
            }
            tmpFroId = new Integer(tmpFroId + 1);
        }
        return tmpFroId;
    }

    private void verifyFroId(int froId, TableData tableData) throws CrbsAueException, TableDataException {
        Object[] froIdColumnDatas = tableData.getAttributeValues("froid");
        if (froIdColumnDatas.length > 0) {
            for (int i = 0; i < froIdColumnDatas.length; ++i) {
                Integer intData = (Integer)froIdColumnDatas[i];
                if (intData == null || intData != froId) continue;
                throw new CrbsAueException("Specified froId already exists in " + tableData.getTableName());
            }
        }
    }

    public String getCreatedMoLdn() {
        return this.createdMoLdn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

