/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class TruncateAttributeRangeAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$TruncateAttributeRangeAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$TruncateAttributeRangeAction = TruncateAttributeRangeAction.class$("se.ericsson.crbs.omf.aue.step1.actions.TruncateAttributeRangeAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$TruncateAttributeRangeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$TruncateAttributeRangeAction;
    static /* synthetic */ Class class$java$lang$Integer;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String attrToBeTruncated = this.getAndCheckParamMapString("name", this.paramMap, "The attribute to be truncated is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String minAttrValueStr = this.getAndCheckParamMapString("min", this.paramMap, "The minimum attribute value is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        Integer minAttrValue = this.checkAndGetInteger(minAttrValueStr, "min");
        String maxAttrValueStr = this.getAndCheckParamMapString("max", this.paramMap, "The maximum attribute value is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        Integer maxAttrValue = this.checkAndGetInteger(maxAttrValueStr, "max");
        Object offsetObj = this.paramMap.get("offset");
        int offsetValue = offsetObj == null ? 0 : Integer.parseInt(offsetObj.toString());
        if (minAttrValue >= maxAttrValue) {
            String errorMsg = "Max and min values for, " + AueUtil.doubleQuote(attrToBeTruncated) + ", are incorrect: min = " + minAttrValue + ", max = " + maxAttrValue;
            logger.traceDebug(THIS_CLASS, errorMsg);
            throw new CrbsAueException(errorMsg);
        }
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData.isNotEmpty()) {
                Class javaType = tableData.getJavaType(attrToBeTruncated);
                if (!javaType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = TruncateAttributeRangeAction.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    String errorMsg = "Could not truncate values for attribute, " + AueUtil.doubleQuote(attrToBeTruncated) + ". The attribute does NOT hold integer values!";
                    logger.traceDebug(THIS_CLASS, errorMsg);
                    throw new CrbsAueException(errorMsg);
                }
                this.checkAndTruncateValues(froTypeName, attrToBeTruncated, minAttrValue, maxAttrValue, offsetValue, tableData);
                tableHandler.checkAndDropIfNotUpdated(tableData);
            }
        }
        catch (TableDataException tde) {
            String errorMsg = "Could not truncate attribute, " + AueUtil.doubleQuote(attrToBeTruncated) + ", in " + AueUtil.doubleQuote(froTypeName);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, tde));
            throw new CrbsAueException(errorMsg, tde);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    protected Integer checkAndGetInteger(String integerStr, String attributeValueName) throws CrbsAueException {
        Integer intValue;
        try {
            intValue = Integer.valueOf(integerStr);
        }
        catch (NumberFormatException nfe) {
            throw new CrbsAueException(attributeValueName + " is not an integer, " + AueUtil.doubleQuote(integerStr));
        }
        logger.traceGeneral(THIS_CLASS, "checkAndGetInteger(" + integerStr + ", " + attributeValueName + ") - is OK");
        return intValue;
    }

    private void checkAndTruncateValues(String froTypeName, String attrToBeTruncated, Integer minAttrValue, Integer maxAttrValue, int offsetValue, TableData tableData) throws TableDataException {
        Object[] tableColumnDataValues = tableData.getAttributeValues(attrToBeTruncated);
        for (int j = 0; j < tableColumnDataValues.length; ++j) {
            Object orgValue;
            Integer attrValue = (Integer)tableColumnDataValues[j];
            Integer correctedValue = new Integer(attrValue + offsetValue);
            if (correctedValue < minAttrValue) {
                orgValue = tableColumnDataValues[j];
                tableData.setAttributeValue(j, attrToBeTruncated, minAttrValue);
                logger.traceGeneral(THIS_CLASS, "Value, " + AueUtil.doubleQuote(orgValue.toString()) + ", for attribute, " + AueUtil.doubleQuote(attrToBeTruncated) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", increased to, " + AueUtil.doubleQuote(minAttrValue.toString()));
                continue;
            }
            if (correctedValue > maxAttrValue) {
                orgValue = tableColumnDataValues[j];
                tableData.setAttributeValue(j, attrToBeTruncated, maxAttrValue);
                logger.traceGeneral(THIS_CLASS, "Value, " + AueUtil.doubleQuote(orgValue.toString()) + ", for attribute, " + AueUtil.doubleQuote(attrToBeTruncated) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", decreased to, " + AueUtil.doubleQuote(maxAttrValue.toString()));
                continue;
            }
            if (attrValue.equals(correctedValue)) continue;
            orgValue = tableColumnDataValues[j];
            tableData.setAttributeValue(j, attrToBeTruncated, correctedValue);
            logger.traceGeneral(THIS_CLASS, "Value, " + AueUtil.doubleQuote(orgValue.toString()) + ", for attribute, " + AueUtil.doubleQuote(attrToBeTruncated) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", changed to, " + AueUtil.doubleQuote(correctedValue.toString()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

