/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.AbstractFroXmlHelperImpl;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRefHelper;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;

public class FroMoRefHelperImpl
extends AbstractFroXmlHelperImpl
implements FroMoRefHelper {
    protected static final FroMoRef EMPTY = new FroMoRef(null);
    private FroMoRef subMoRef = FroMoRef.EMPTY;
    private FroStruct subStruct = FroStruct.EMPTY;
    private FroArray subArray = FroArray.EMPTY;
    private boolean initiated = false;
    private final TableHandler tableHandler;

    public FroMoRefHelperImpl(TableHandler tableHandler) {
        super(FroMoRef.class);
        this.tableHandler = tableHandler;
    }

    public String getName() {
        return this.name;
    }

    public int getTagType() {
        return 3;
    }

    public String convertManagedObjectToXml(String attributeName, ManagedObject managedObjectToBeConverted) {
        this.name = attributeName;
        String ldn = managedObjectToBeConverted.getLocalDistinguishedName();
        NameTypeValue nameTypeValue = new NameTypeValue("ldn", "STRING", ldn);
        this.xmlTagsList.add(nameTypeValue);
        int froType = this.getFroType(ldn);
        nameTypeValue = new NameTypeValue("frotype", "S32", Integer.toString(froType));
        this.xmlTagsList.add(nameTypeValue);
        int froId = this.getFroId(ldn);
        nameTypeValue = new NameTypeValue("froid", "S32", Integer.toString(froId));
        this.xmlTagsList.add(nameTypeValue);
        return this.toXmlString();
    }

    private int getFroType(String ldn) {
        Integer froType = new Integer(-1);
        try {
            String froTypeName = AueUtil.getLastLdnElement(ldn);
            TableData tableData = this.tableHandler.getTableData(froTypeName);
            froType = tableData.getFroTypeId();
        }
        catch (TableDataException tde) {
            froType = new Integer(-1);
        }
        return froType;
    }

    private int getFroId(String ldn) {
        Integer froId = new Integer(-1);
        try {
            String froTypeName = AueUtil.getLastLdnElement(ldn);
            TableData tableData = this.tableHandler.getTableData(froTypeName);
            Object[] ldnColumnDatas = tableData.getAttributeValues("ldn");
            int ldnIndex = -1;
            for (int i = 0; i < ldnColumnDatas.length; ++i) {
                if (!ldnColumnDatas[i].toString().equalsIgnoreCase(ldn)) continue;
                ldnIndex = i;
                break;
            }
            Object[] froIdColumnDatas = tableData.getAttributeValues("froid");
            froId = (Integer)froIdColumnDatas[ldnIndex];
        }
        catch (TableDataException tde) {
            froId = new Integer(-1);
        }
        return froId;
    }

    public void parse(String xmlTagToBeParsed) throws ParseException {
        InputStream inputStream = null;
        try {
            this.initiated = false;
            this.subMoRef = FroMoRef.EMPTY;
            this.subStruct = FroStruct.EMPTY;
            this.subArray = FroArray.EMPTY;
            this.name = "";
            this.xmlTagsList.clear();
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setContentHandler(this);
            inputStream = new ByteArrayInputStream(xmlTagToBeParsed.getBytes());
            parser.parse(new InputSource(inputStream));
        }
        catch (Exception e) {
            String errorMsg = AueUtil.appendReason("Could not parse the MO ref information.", e);
            this.logger.traceError(this.thisClass, errorMsg, e);
            throw new ParseException(errorMsg, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception ignore) {}
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean insideSubArrayTag;
        boolean insideSubMoRefTag = !FroMoRef.EMPTY.equals(this.subMoRef);
        boolean insideSubStructTag = !FroStruct.EMPTY.equals(this.subStruct);
        boolean bl = insideSubArrayTag = !FroArray.EMPTY.equals(this.subArray);
        if (insideSubStructTag) {
            this.subStruct.startElement(uri, localName, qName, attributes);
        } else if (insideSubArrayTag) {
            this.subArray.startElement(uri, localName, qName, attributes);
        } else if (insideSubMoRefTag) {
            this.subMoRef.startElement(uri, localName, qName, attributes);
        } else if ("array".equals(localName)) {
            this.subArray = new FroArray(this.tableHandler);
            this.subArray.startElement(uri, localName, qName, attributes);
        } else if ("struct".equals(localName)) {
            this.subStruct = new FroStruct(this.tableHandler);
            this.subStruct.startElement(uri, localName, qName, attributes);
        } else if ("moref".equals(localName)) {
            if (this.initiated) {
                this.subMoRef = new FroMoRef(this.tableHandler);
                this.subMoRef.startElement(uri, localName, qName, attributes);
            } else {
                this.name = attributes.getValue("name");
                this.initiated = true;
            }
        } else if ("attr".equals(localName)) {
            String tmpName = attributes.getValue("name");
            String tmpType = attributes.getValue("type");
            String tmpValue = attributes.getValue("value");
            this.xmlTagsList.add(new NameTypeValue(tmpName, tmpType, tmpValue));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean insideSubArrayTag;
        boolean insidSubMoRefTag = !FroMoRef.EMPTY.equals(this.subMoRef);
        boolean insideSubStructTag = !FroStruct.EMPTY.equals(this.subStruct);
        boolean bl = insideSubArrayTag = !FroArray.EMPTY.equals(this.subArray);
        if (insideSubStructTag) {
            if ("struct".equals(localName)) {
                this.xmlTagsList.add(this.subStruct);
                this.subStruct = FroStruct.EMPTY;
            } else {
                this.subStruct.endElement(uri, localName, qName);
            }
        } else if (insideSubArrayTag) {
            if ("array".equals(localName)) {
                this.xmlTagsList.add(this.subArray);
                this.subArray = FroArray.EMPTY;
            } else {
                this.subArray.endElement(uri, localName, qName);
            }
        } else if (insidSubMoRefTag) {
            if ("moref".equals(localName)) {
                this.xmlTagsList.add(this.subMoRef);
                this.subMoRef = FroMoRef.EMPTY;
            } else {
                this.subMoRef.endElement(uri, localName, qName);
            }
        } else if ("moref".equals(localName)) {
            this.initiated = false;
        }
    }

    public String getXmlTagName() {
        return "moref";
    }
}

