/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.cert;

import com.prismtech.corba.security.KeyStorePlugin;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import se.ericsson.security.corba.cert.CertificateUtil;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class KeyStorePluginImpl
implements KeyStorePlugin {
    private static final long GRACE_PERIOD_MILLIS = 3599000L;
    private static TraceErrorLogger logger = new TraceErrorLogger();

    public KeyStore getKeyStore(byte[] byArray, char[] cArray) {
        logger.trace(1, this.getClass(), "getKeyStore");
        KeyStore keyStore = null;
        try {
            keyStore = CertificateUtil.getPKCS12KeyStore();
            keyStore.load(new ByteArrayInputStream(byArray), cArray);
            logger.trace(1, this.getClass(), "Returning keystore with size " + keyStore.size());
        }
        catch (Throwable throwable) {
            logger.trace(1, this.getClass(), "getKeyStore failed: " + throwable.getMessage());
        }
        return keyStore;
    }

    public KeyStore getKeyStore(byte[] byArray, char[] cArray, String string, String string2) {
        KeyStore keyStore = null;
        logger.trace(1, this.getClass(), "getKeyStore " + string + " " + string2);
        try {
            if (string2 == null) {
                logger.trace(1, this.getClass(), "No provider given using default");
                keyStore = KeyStore.getInstance(string);
            } else {
                keyStore = KeyStore.getInstance(string, string2);
            }
            keyStore.load(new ByteArrayInputStream(byArray), cArray);
            logger.trace(1, this.getClass(), "Returning keystore with size " + keyStore.size());
        }
        catch (Throwable throwable) {
            logger.trace(1, this.getClass(), "getKeyStore failed: " + throwable.getMessage());
        }
        return keyStore;
    }

    public void validate(X509Certificate x509Certificate) {
        if (System.currentTimeMillis() > 3599000L) {
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
        }
    }
}

