/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main.handler;

import se.ericsson.cello.configurationversion.main.event.rollbacklist.InsertedInRollbackListEvent;
import se.ericsson.cello.configurationversion.main.event.rollbacklist.RemovedFromRollbackListEvent;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_FRO_AttributeHandler;
import se.ericsson.cello.configurationversion.rollbacklist.RollbackListContentsController;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class CV_AttributeRollbackListHandler
extends CV_FRO_AttributeHandler
implements PropertyChangeListener {
    public CV_AttributeRollbackListHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_AttributeRollbackListHandler( )");
        }
    }

    public CV_AttributeRollbackListHandler(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_AttributeRollbackListHandler(boolean anAddAsPropertyChangeListener)", "anAddAsPropertyChangeListener: " + bl);
        }
        if (bl) {
            try {
                CV_ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingConfigurationVersionPropertyName.RollbackList, this);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "CV_AttributeRollbackListHandler(boolean anAddAsPropertyChangeListener)", "Throwable caught when trying to add this instance as a listener on property change for RollbackList.", throwable);
            }
        }
    }

    public String[] get() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "get( )");
        }
        RollbackListContentsController rollbackListContentsController = new RollbackListContentsController();
        return rollbackListContentsController.getRollbackList();
    }

    public boolean isConfiguredInRollbackList(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isConfiguredInRollbackList(String aCV_Name)", "aCV_Name: " + string);
        }
        String[] stringArray = this.get();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent evt)", "evt: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof InsertedInRollbackListEvent) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent evt)", "A CV has been inserted as the first entry in the rollbacklist,\n\tname of inserted CV: " + ((InsertedInRollbackListEvent)propertyChangeEvent.getNewValue()).cvName);
                }
                this.notify(((InsertedInRollbackListEvent)propertyChangeEvent.getNewValue()).rollbackList);
            } else if (propertyChangeEvent.getNewValue() instanceof RemovedFromRollbackListEvent) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent evt)", "A CV has been removed from the rollbacklist,\n\tname of removed CV: " + ((RemovedFromRollbackListEvent)propertyChangeEvent.getNewValue()).cvName);
                }
                this.notify(((RemovedFromRollbackListEvent)propertyChangeEvent.getNewValue()).rollbackList);
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Unknown type of property change value received (ignored).evt: " + propertyChangeEvent);
            }
        }
        catch (ConfigurationVersionException configurationVersionException) {
            // empty catch block
        }
    }

    private void notify(String[] stringArray) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notify(String[ ] aRollbackList)", "aRollbackList: " + SuLib.toString(stringArray));
        }
        String[] stringArray2 = new String[]{"rollbackList"};
        Object[] objectArray = new Object[]{stringArray};
        super.notify(stringArray2, objectArray);
    }
}

