/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.mohandler.iproutingtable;

import se.ericsson.cello.configurationversion.file.ipnetworkdata.proxy.IP_NetworkDataProxy;
import se.ericsson.cello.configurationversion.file.ipnetworkdata.proxy.IP_NetworkDataProxyLookup;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.mohandler.ethernetlink.EthernetLinkMO_handlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.iproutingtable.IP_RoutingTableMO_handlerInterface;
import se.ericsson.cello.ipoam.suaccess.IpRoutingTableMoSU_Access;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class IP_RoutingTableMO_Handler
implements IP_RoutingTableMO_handlerInterface {
    private IpRoutingTableMoSU_Access myIpRoutingTableMoSU_Access = null;

    public IP_RoutingTableMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "IP_RoutingTableMO_Handler(MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public String getNodeNextHopIP_Address() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeNextHopIP_Address()");
        }
        try {
            Struct struct = this.getNodeRoutingTableEntry();
            if (struct != null) {
                return this.myIpRoutingTableMoSU_Access.getValueForNextHopIpAddr(struct);
            }
            Trace.info(this.getClass(), "getNodeNextHopIP_Address()", "No static route found containing default gateway address (attribute ipAddress that starts with '0.0').");
            return null;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeNextHopIP_Address()", "Throwable caught when attempting to retreive the NextHopIP_Address of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetNodeNextHopIP_Address()" + "\n\tThrowable caught when attempting to retreive the NextHopIP_Address of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public boolean setNodeNextHopIP_Address(String string, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setNodeNextHopIP_Address(String aPathToIP_AddressDir)", "aPathToIP_AddressDir: " + string + "\n\taCompareToFirstVersion: " + bl);
        }
        IP_NetworkDataProxy iP_NetworkDataProxy = IP_NetworkDataProxyLookup.getIP_NetworkDataProxy(string, bl);
        String string2 = iP_NetworkDataProxy.getIP_Address();
        String string3 = iP_NetworkDataProxy.getNextHopIP_Address();
        String string4 = iP_NetworkDataProxy.getSubnetMask();
        EthernetLinkMO_handlerInterface ethernetLinkMO_handlerInterface = ServiceFinder.getEthernetLinkMO_handlerInterface();
        String string5 = ethernetLinkMO_handlerInterface.getNodeIP_Address();
        String string6 = ethernetLinkMO_handlerInterface.getNodeSubnetMask();
        String string7 = this.getNodeNextHopIP_Address();
        int n = this.getNodeRouteMetric();
        boolean bl2 = this.getNodeRedistribute();
        String string8 = string5;
        String string9 = string6;
        String string10 = string7;
        boolean bl3 = false;
        if (this.checkIfIP_DataNeedToBeSet(string2, string5, "a.b.c.d")) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setNodeNextHopIP_Address(String aPathToIP_AddressDir)", "ipAddress is different. Setting of IPData required.");
            }
            string8 = string2;
            bl3 = true;
        }
        if (this.checkIfIP_DataNeedToBeSet(string3, string7, "a.b.c.d")) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setNodeNextHopIP_Address(String aPathToIP_AddressDir)", "nextHopIpAddress is different. Setting of IPData required.");
            }
            string10 = string3;
            bl3 = true;
        }
        if (this.checkIfIP_DataNeedToBeSet(string4, string6, "a.b.c.d")) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setNodeNextHopIP_Address(String aPathToIP_AddressDir)", "subnetMask is different. Setting of IPData required.");
            }
            string9 = string4;
            bl3 = true;
        }
        if (bl3) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setNodeNextHopIP_Address(String aPathToIP_AddressDir)", "Setting IPData.");
            }
            this.setIPData(string8, string3, string9, string5, string10, string6, n, bl2);
        } else if (Trace.valid(this.getClass(), 20)) {
            Trace.debug("setNodeNextHopIP_Address(String aPathToIP_AddressDir)", "Not setting ipData ");
        }
        return bl3;
    }

    private IpRoutingTableMoSU_Access getIP_RoutingTableMO() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIP_RoutingTableMo( )");
        }
        try {
            if (this.myIpRoutingTableMoSU_Access == null) {
                MoIterator moIterator = MoRepository.instance().lookupType("IpRoutingTable");
                if (moIterator != null) {
                    this.myIpRoutingTableMoSU_Access = (IpRoutingTableMoSU_Access)moIterator.nextElement();
                } else {
                    Trace.log1(this.getClass(), "getIP_RoutingTableMo( )", "No IpRoutingTable MO instance was found in the node.RETURNS - null");
                }
            }
            return this.myIpRoutingTableMoSU_Access;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getIP_RoutingTableMo( )", "Throwable caught when attempting to look up the IpRoutingTableMo.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetIP_RoutingTableMo( )" + "\n\tThrowable caught when attempting to look up the IpRoutingTableMo." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private Struct getNodeRoutingTableEntry() throws ConfigurationVersionException {
        String string = "getNodeRoutingTableEntry( )";
        try {
            IpRoutingTableMoSU_Access ipRoutingTableMoSU_Access = this.getIP_RoutingTableMO();
            if (ipRoutingTableMoSU_Access != null && SU_AccessVersionHandler.getInstance().isSupported("SU_2", ipRoutingTableMoSU_Access.getSupportedVersions())) {
                return this.getNodeRoutingTableStaticEntry();
            }
            this.logRoutingTableRoutes();
            if (ipRoutingTableMoSU_Access != null) {
                long l = ipRoutingTableMoSU_Access.actionNumberOfRoutes(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "theNoOfRoutes: " + l);
                }
                Struct struct = null;
                String string2 = null;
                boolean bl = false;
                Struct struct2 = null;
                int n = -1;
                int n2 = 0;
                while ((long)n2 < l) {
                    struct = ipRoutingTableMoSU_Access.actionGetRoutingTableEntry(n2, null);
                    this.logRoutingTableEntry(string, n2, struct);
                    string2 = this.myIpRoutingTableMoSU_Access.getValueForDestinationIpAddr(struct);
                    if (string2 != null && string2.startsWith("0.0.")) {
                        bl = this.myIpRoutingTableMoSU_Access.getValueForActive(struct);
                        if (bl) {
                            this.logRoutingTableEntryReturned(string, n2, struct);
                            return struct;
                        }
                        if (struct2 == null) {
                            struct2 = struct;
                            n = n2;
                        }
                    }
                    ++n2;
                }
                if (struct2 != null) {
                    this.logRoutingTableEntryReturned(string, n, struct2);
                    return struct2;
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "No IpRoutingTableMo found.");
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught when attempting to retreive the RoutingTableEntry of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught when attempting to retreive the RoutingTableEntry of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private Struct getNodeRoutingTableStaticEntry() throws ConfigurationVersionException {
        String string = "getNodeRoutingTableStaticEntry( )";
        try {
            this.logRoutingTableRoutes();
            IpRoutingTableMoSU_Access ipRoutingTableMoSU_Access = this.getIP_RoutingTableMO();
            if (ipRoutingTableMoSU_Access != null) {
                long l = ipRoutingTableMoSU_Access.actionNumberOfRoutes(null);
                Struct[] structArray = ipRoutingTableMoSU_Access.getStaticRoutes(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "theStaticRoutes: " + structArray.length + "\n\ttheNoOfRoutes: " + l);
                }
                Struct struct = null;
                Struct struct2 = null;
                String string2 = null;
                String string3 = null;
                boolean bl = false;
                Struct struct3 = null;
                int n = -1;
                for (int i = 0; i < structArray.length; ++i) {
                    struct = structArray[i];
                    this.logRoutingTableEntry(string, i, struct);
                    string3 = (String)struct.getValue("ipAddress");
                    String string4 = (String)struct.getValue("nextHopIpAddr");
                    if (string3 == null || !string3.startsWith("0.0.")) continue;
                    int n2 = 0;
                    while ((long)n2 < l) {
                        struct2 = ipRoutingTableMoSU_Access.actionGetRoutingTableEntry(n2, null);
                        this.logRoutingTableEntry(string, n2, struct2);
                        string2 = this.myIpRoutingTableMoSU_Access.getValueForDestinationIpAddr(struct2);
                        String string5 = this.myIpRoutingTableMoSU_Access.getValueForNextHopIpAddr(struct2);
                        if (string2 != null && string2.startsWith("0.0.") && string5 != null && string5.equals(string4)) {
                            bl = this.myIpRoutingTableMoSU_Access.getValueForActive(struct2);
                            if (bl) {
                                this.logRoutingTableEntryReturned(string, n2, struct2);
                                return struct2;
                            }
                            if (struct3 == null) {
                                struct3 = struct2;
                                n = n2;
                            }
                        }
                        ++n2;
                    }
                }
                if (struct3 != null) {
                    this.logRoutingTableEntryReturned(string, n, struct3);
                    return struct3;
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "No IpRoutingTableMo found.");
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught when attempting to retreive the RoutingTableStaticEntry of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught when attempting to retreive the RoutingTableStaticEntry of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void logRoutingTableEntry(String string, int n, Struct struct) {
        try {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "index i: " + n + SuLib.toString(struct));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void logRoutingTableEntryReturned(String string, int n, Struct struct) {
        try {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "Returning Routing Table Entry:\n\tindex i: " + n + SuLib.toString(struct));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void logRoutingTableRoutes() throws ConfigurationVersionException {
        block9: {
            try {
                IpRoutingTableMoSU_Access ipRoutingTableMoSU_Access = this.getIP_RoutingTableMO();
                Struct struct = null;
                if (ipRoutingTableMoSU_Access != null) {
                    long l = ipRoutingTableMoSU_Access.actionNumberOfRoutes(null);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getNodeRoutingTableEntry()", "theNoOfRoutes: " + l);
                    }
                    int n = 0;
                    while ((long)n < l) {
                        struct = ipRoutingTableMoSU_Access.actionGetRoutingTableEntry(n, null);
                        try {
                            if (Trace.valid(this.getClass(), 22)) {
                                Trace.debug(this.getClass(), 22, "logRoutingTableRoutes()", "index i: " + n + SuLib.toString(struct));
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++n;
                    }
                    break block9;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "logRoutingTableRoutes()", "No IpRoutingTableMo found.");
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "logRoutingTableRoutes()", "Throwable caught when attempting to retreive the RoutingTableEntry of the node.", throwable);
                throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tlogRoutingTableRoutes()" + "\n\tThrowable caught when attempting to retreive the RoutingTableEntry of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
        }
    }

    private boolean checkIfIP_DataNeedToBeSet(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkIfIP_DataNeedToBeSet(String aIPDataFromFile, String aIPDataFromNode, String aDefaultValue)", "aIPDataFromFile: " + string + "\n\taIPDataFromNode: " + string2 + "\n\taDefaultValue: " + string3);
        }
        if (string != null && string2 != null) {
            if (string.equals(string2)) {
                return false;
            }
            return !string.equals(string3);
        }
        if (string == string2) {
            return false;
        }
        return string != null;
    }

    private void setIPData(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIPData(String aIpAddressFromFile, String aNextHopIpAddressFromFile, String aSubnetMaskFromFile, String aIpAddressFromNode, String aNextHopIpAddressFromNode, String aSubnetMaskFromNode, int aRouteMetricFromNode, boolean aRedistributeFromNode)", "anIP_Address: " + string + "\n\taNextHopIpAddressFromFile: " + string2 + "\n\taSubnetMaskFromFile : " + string3 + "\n\taIpAddressFromNode : " + string4 + "\n\taNextHopIpAddressFromNode : " + string5 + "\n\taSubnetMaskFromNode : " + string6 + "\n\taRouteMetricFromNode : " + n + "\n\taRedistributeFromNode : " + bl);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            IpRoutingTableMoSU_Access ipRoutingTableMoSU_Access = this.getIP_RoutingTableMO();
            Struct struct = this.getNodeRoutingTableEntry();
            if (struct != null) {
                control = Transaction.create();
                coordinator = Transaction.getCoordinator(control);
                ipRoutingTableMoSU_Access.actionDeleteStaticRoute(struct, coordinator);
                String string7 = this.myIpRoutingTableMoSU_Access.getValueForDestinationIpAddr(struct);
                String string8 = this.myIpRoutingTableMoSU_Access.getValueForDestinationNetworkMask(struct);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIPData(String aIpAddressFromNodeaIpAddressFromFile, String aNextHopIpAddressFromFile, String aSubnetMaskFromFile, String aIpAddressFromNode, String aNextHopIpAddressFromNode, String aSubnetMaskFromNode, int aRouteMetricFromNode, boolean aRedistributeFromNode)", "actionDeleteStaticRoute executed.\n\tChecking new static route with dest IP address from node itself to add or not. theDestinationIpAddr: " + string7 + "\n\ttheDestinationNetworkMask: " + string8 + "\n\taNextHopIpAddressFromFile: " + string2 + "\n\taRouteMetricFromNode: " + n + "\n\taRedistributeFromNode: " + bl);
                }
                boolean bl2 = false;
                if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", ipRoutingTableMoSU_Access.getSupportedVersions())) {
                    Struct[] structArray = this.myIpRoutingTableMoSU_Access.getStaticRoutes(coordinator);
                    for (int i = 0; i < structArray.length; ++i) {
                        Struct struct2 = structArray[i];
                        String string9 = (String)struct2.getValue("ipAddress");
                        if (string9 == null || !string9.startsWith("0.0.") || string2 == null || !string2.equals((String)struct2.getValue("nextHopIpAddr"))) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "setIPData(String aIpAddressFromNodeaIpAddressFromFile, String aNextHopIpAddressFromFile, String aSubnetMaskFromFile, String aIpAddressFromNode, String aNextHopIpAddressFromNode, String aSubnetMaskFromNode, int aRouteMetricFromNode, boolean aRedistributeFromNode)", "actionDeleteStaticRoute executed.\n\tAdding new static route with dest IP address from node itself. theDestinationIpAddr: " + string7 + "\n\ttheDestinationNetworkMask: " + string8 + "\n\taNextHopIpAddressFromFile: " + string2 + "\n\taRouteMetricFromNode: " + n + "\n\taRedistributeFromNode: " + bl);
                    }
                    ipRoutingTableMoSU_Access.actionAddStaticRoute(string7, string8, string2, n, bl, coordinator);
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIPData(String aIpAddressFromNodeaIpAddressFromFile, String aNextHopIpAddressFromFile, String aSubnetMaskFromFile, String aIpAddressFromNode, String aNextHopIpAddressFromNode, String aSubnetMaskFromNode, int aRouteMetricFromNode, boolean aRedistributeFromNode)", "\n\tAdding new static route with dest IP address from node itself is not required since it already exits. theDestinationIpAddr: " + string7 + "\n\ttheDestinationNetworkMask: " + string8 + "\n\taNextHopIpAddressFromFile: " + string2 + "\n\taRouteMetricFromNode: " + n + "\n\taRedistributeFromNode: " + bl);
                }
                Transaction.commit(control);
                this.logRoutingTableRoutes();
            } else {
                Trace.info(this.getClass(), "setIPData(String aIpAddressFromFile, String aNextHopIpAddressFromFile, String aSubnetMaskFromFile, String aIpAddressFromNode, String aNextHopIpAddressFromNode, String aSubnetMaskFromNode, int aRouteMetricFromNode, boolean aRedistributeFromNode)", "Not possible to set IP data for the node due to no IpRoutingTableMo exists.\n\tIP data that should have been set: \n\tanIP_Address: " + string + "\n\taNextHopIpAddressFromFile: " + string2 + "\n\taSubnetMask: " + string3 + "\n\taRouteMetricFromNode: " + n + "\n\taRedistributeFromNode: " + bl);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setIPData(String aIpAddressFromFile, String aNextHopIpAddressFromFile, String aSubnetMaskFromFile, String aIpAddressFromNode, String aNextHopIpAddressFromNode, String aSubnetMaskFromNode, int aRouteMetricFromNode, boolean aRedistributeFromNode)", "Throwable caught when attempting to set the IP data of the node.\n\tanIP_Address: " + string + "\n\taNextHopIpAddressFromFile: " + string2 + "\n\taSubnetMask: " + string3 + "\n\taRouteMetricFromNode: " + n + "\n\taRedistributeFromNode: " + bl + throwable);
            Transaction.rollback(control);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsetIPData(String aIpAddressFromFile, String aNextHopIpAddressFromFile, String aSubnetMaskFromFile, String aIpAddressFromNode, String aNextHopIpAddressFromNode, String aSubnetMaskFromNode, int aRouteMetricFromNode, boolean aRedistributeFromNode)" + "\n\tanIP_Address: " + string + "\n\taNextHopIpAddressFromFile: " + string2 + "\n\taSubnetMask: " + string3 + "\n\taRouteMetricFromNode: " + n + "\n\taRedistributeFromNode: " + bl + "\n\tThrowable caught when attempting to set the IP data of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private int getNodeRouteMetric() throws ConfigurationVersionException {
        try {
            Struct struct = this.getNodeRoutingTableEntry();
            if (struct != null) {
                return this.myIpRoutingTableMoSU_Access.getValueForRouteMetric(struct);
            }
            Trace.info(this.getClass(), "getNodeRouteMetric()", "RoutingTable entry for the node is empty.");
            return 0;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeRouteMetric()", "Throwable caught when attempting to retreive the 'routeMetric' value of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetNodeRouteMetric()" + "\n\tThrowable caught when attempting to retreive the 'routeMetric' value of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private boolean getNodeRedistribute() throws ConfigurationVersionException {
        try {
            Struct struct = this.getNodeRoutingTableEntry();
            if (struct != null) {
                return this.myIpRoutingTableMoSU_Access.getValueForRedistribute(struct);
            }
            Trace.info(this.getClass(), "getNodeRedistribute()", "RoutingTable entry for the node is empty.");
            return true;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeRedistribute()", "Throwable caught when attempting to retreive the 'redistribute' value of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetNodeRedistribute()" + "\n\tThrowable caught when attempting to retreive the 'redistribute' value of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

