/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.froproxy.cv.interfaces;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.su.froproxy.cv.interfaces.CelloCvArmaInfo;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class CV_ArmamentInformation {
    public int result = -1;
    public int mainSubrackNumber = -1;
    public Collection celloCvArmaInfo = null;
    private HashSet mySrNumbers = new HashSet();
    private int myCoreMP_SlotA = -1;
    private int myCoreMP_SlotB = -1;

    public CV_ArmamentInformation(int n, int n2, int n3, Collection collection) {
        this.result = 0;
        this.myCoreMP_SlotA = n2;
        this.myCoreMP_SlotB = n3;
        this.celloCvArmaInfo = collection;
        this.setSrNumbers();
    }

    public CV_ArmamentInformation(int n, int n2, Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_ArmamentInformation(int aResult, int aMainSubrackNumber, Collection aCelloCvArmaInfo )", "aResult: " + n + "\n\taMainSubrackNumber: " + n2 + "\n\taCelloCvArmaInfo: " + collection);
        }
        this.result = n;
        this.mainSubrackNumber = n2;
        this.celloCvArmaInfo = collection;
        this.setSrNumbers();
        this.setCoreMP_Info();
    }

    public int getCoreMP_SlotA() {
        return this.myCoreMP_SlotA;
    }

    public int getCoreMP_SlotB() {
        return this.myCoreMP_SlotB;
    }

    public Collection getSrNumbers() {
        return this.mySrNumbers;
    }

    public Collection getCelloCvArmaInfo(Integer n) {
        CelloCvArmaInfo celloCvArmaInfo = null;
        HashSet<CelloCvArmaInfo> hashSet = new HashSet<CelloCvArmaInfo>();
        Iterator iterator = this.celloCvArmaInfo.iterator();
        while (iterator.hasNext()) {
            celloCvArmaInfo = (CelloCvArmaInfo)iterator.next();
            if (!celloCvArmaInfo.getSrNumberIntegerValue().equals(n)) continue;
            hashSet.add(celloCvArmaInfo);
        }
        return hashSet;
    }

    public boolean containsSrNumber(Integer n) {
        return this.mySrNumbers.contains(n);
    }

    public int getResult() {
        return this.result;
    }

    public int getMainSubrackNumber() {
        return this.mainSubrackNumber;
    }

    public Collection getCelloCvArmaInfo() {
        return this.celloCvArmaInfo;
    }

    public String toString() {
        return "\n\tresult: " + this.result + "\n\tmainSubrackNumber: " + this.mainSubrackNumber + "\n\tCoreMP_SlotA: " + this.myCoreMP_SlotA + "\n\tCoreMP_SlotB: " + this.myCoreMP_SlotB + "\n\tcelloCvArmaInfo: " + this.celloCvArmaInfo;
    }

    private void setSrNumbers() {
        CelloCvArmaInfo celloCvArmaInfo = null;
        Iterator iterator = this.celloCvArmaInfo.iterator();
        while (iterator.hasNext()) {
            celloCvArmaInfo = (CelloCvArmaInfo)iterator.next();
            this.mySrNumbers.add(celloCvArmaInfo.getSrNumberIntegerValue());
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setSrNumbers()", "mySrNumbers: " + this.mySrNumbers);
        }
    }

    private void setCoreMP_Info() {
        CelloCvArmaInfo celloCvArmaInfo = null;
        Iterator iterator = this.celloCvArmaInfo.iterator();
        while (iterator.hasNext()) {
            celloCvArmaInfo = (CelloCvArmaInfo)iterator.next();
            if (!celloCvArmaInfo.isCoreMP()) continue;
            if (this.myCoreMP_SlotA == -1) {
                this.myCoreMP_SlotA = celloCvArmaInfo.getSlotNumber();
                continue;
            }
            this.myCoreMP_SlotB = celloCvArmaInfo.getSlotNumber();
            break;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCoreMP_Info()", "myCoreMP_SlotA: " + this.myCoreMP_SlotA + "\n\tmyCoreMP_SlotB: " + this.myCoreMP_SlotB);
        }
    }
}

