/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.timerforverification;

import java.util.Collection;
import java.util.LinkedList;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.su.timerforverification.VerificationTimerController;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class VerificationTimer
implements TimerListener {
    private Collection myLoadModulesThatHaveBeenChecksumed = null;
    private Timer myTimer = null;
    private boolean myVerifyUpgrade = false;
    private boolean myStartedTimer = false;

    public VerificationTimer(int n, boolean bl) {
        this.myTimer = new Timer(n);
        this.myLoadModulesThatHaveBeenChecksumed = new LinkedList();
        this.myVerifyUpgrade = bl;
    }

    public VerificationTimer(int n, Collection collection, boolean bl) {
        this.myTimer = new Timer(n);
        this.myLoadModulesThatHaveBeenChecksumed = collection;
        this.myVerifyUpgrade = bl;
    }

    public Collection getLoadModulesThatHaveBeenChecksumed() {
        return this.myLoadModulesThatHaveBeenChecksumed;
    }

    public void setLoadModulesThatHaveBeenChecksumed(Collection collection) {
        this.myLoadModulesThatHaveBeenChecksumed.addAll(collection);
    }

    public boolean isVerifyUpgrade() {
        return this.myVerifyUpgrade;
    }

    public void setVerifyUpgrade(boolean bl) {
        this.myVerifyUpgrade = bl;
    }

    public void startTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startTimer()");
        }
        this.myTimer.addListener(this);
        this.myTimer.startTimer();
        this.myStartedTimer = true;
    }

    public void stopTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopTimer()");
        }
        if (this.myTimer != null) {
            this.myTimer.stopTimer();
            this.myTimer.removeListener(this);
            this.myTimer = null;
            this.myLoadModulesThatHaveBeenChecksumed = null;
            this.myStartedTimer = false;
        }
    }

    public boolean isStartedTimer() {
        return this.myStartedTimer;
    }

    public void updateTimerDuration(int n, boolean bl) {
        this.myTimer.updateDurationTime(n);
        this.myVerifyUpgrade = bl;
        if (this.myVerifyUpgrade) {
            this.myLoadModulesThatHaveBeenChecksumed = new LinkedList();
        }
    }

    public void timerAction(TimerEvent timerEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "timerAction(TimerEvent e)\n\tTimerEvent: " + timerEvent);
        }
        VerificationTimerController.instance().removeTimer(this);
    }
}

