/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.uci.control;

import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.uci.control.ExecutionOfSequenceFinishedInformationEvent;
import se.ericsson.cello.su.uci.control.SequenceToBeExecutedInformationEvent;
import se.ericsson.cello.su.uci.control.TriggerExecutionResult;
import se.ericsson.cello.su.uci.control.UCI_Control;
import se.ericsson.cello.su.uci.suinterface.SuUpgradeMaster;
import se.ericsson.cello.su.uci.verify.DiskSpaceVerifier;
import se.ericsson.cello.su.uci.verify.NodeTypeVerifier;
import se.ericsson.cello.su.uci.verify.PiuTypeConfigurationVerifier;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.su.uci.verify.configurationmismatchforlmpath.ConfigurationMismatchForLMPathController;
import se.ericsson.cello.su.uci.verify.diskhealthcheck.DiskHealthCheckController;
import se.ericsson.cello.su.uci.verify.javaheap.JavaHeapController;
import se.ericsson.cello.su.uci.verify.jdbc.JDBC_ConnectionController;
import se.ericsson.cello.su.uci.verify.repertoirereplacementcheck.RepertoireReplacementCheckController;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.install.UP_LoadModulesRelationInformation;
import se.ericsson.cello.upgradepackage.install.event.UP_InstallRequestEvent;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMasterExtended;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipatorExtended;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.main.util.ActionResultInformationEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.trigger.TriggerCentralHandlerInterface;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingDiskHealthCheck;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingJDBC_ConnectionCheck;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingJavaHeapSizeConsistencyCheck;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingMismatchPathForLMCheck;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingRepertoireReplacementCheck;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingRpuAddtionCheck;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.verify.RpuConsistencyVerifier;
import se.ericsson.cello.upgradepackage.verify.VerifyUpgradeException;

public class UCI_Controller
implements UCI_Control,
PropertyChangeListener,
UpgradeParticipatorExtended {
    private static final String UCI_CONTROLLER_PARTICIPATOR_NAME = "SU Pre Checker";
    private boolean myIsActive = false;
    private SequenceToBeExecutedInformationEvent mySequenceToBeExecutedInformationEvent = null;

    public UCI_Controller() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UCI_Controller( )");
        }
        TriggerCentralHandlerInterface triggerCentralHandlerInterface = (TriggerCentralHandlerInterface)ServiceLocatorFacade.getRepository().getService(TriggerCentralHandlerInterface.class);
        triggerCentralHandlerInterface.addUpgradeParticipator(this);
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.SequenceStatus, this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", false);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof SequenceToBeExecutedInformationEvent) {
                this.mySequenceToBeExecutedInformationEvent = (SequenceToBeExecutedInformationEvent)propertyChangeEvent.getNewValue();
                if (this.mySequenceToBeExecutedInformationEvent.isContentsValid()) {
                    this.myIsActive = true;
                } else {
                    Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Contents of received SequenceToBeExecutedInformationEvent is not valid, UCI_Controller will not be activated,\n\t(i.e. all received Triggers will be confirmed without executing any checks).\n\treceived SequenceToBeExecutedInformationEvent: " + this.mySequenceToBeExecutedInformationEvent, false);
                }
            } else if (propertyChangeEvent.getNewValue() instanceof ExecutionOfSequenceFinishedInformationEvent) {
                this.mySequenceToBeExecutedInformationEvent = null;
                this.myIsActive = false;
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent, false);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught, message: " + throwable.toString(), throwable);
        }
    }

    public String participatorName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "participatorName( )");
        }
        return UCI_CONTROLLER_PARTICIPATOR_NAME;
    }

    public void triggerIndicated(UpgradeMaster upgradeMaster, String string) {
        Trace.error(this.getClass(), "triggerIndicated(UpgradeMaster master, String triggerName)", "Unexpected (old) interface UpgradeMaster used instead of correct interface UpgradeMasterExtended.");
        upgradeMaster.triggerConfirmed(this, string, false);
    }

    public void triggerIndicated(UpgradeMasterExtended upgradeMasterExtended, String string, int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerIndicated(UpgradeMasterExtended anUpgradeMasterExtended, String aTriggerName, int anUpgradePackageState)", "anUpgradeMasterExtended: " + upgradeMasterExtended + "\n\taTriggerName: " + string + "\n\tanUpgradePackageState: " + SuLib.translateStateValueToString(n));
        }
        TriggerExecutionResult triggerExecutionResult = null;
        boolean bl = this.isPreCheckTrigger(string);
        if (this.myIsActive && bl) {
            Trace.suTestLog(this.getClass(), "triggerIndicated(UpgradeMasterExtended anUpgradeMasterExtended, String aTriggerName, int anUpgradePackageState)", "Trigger " + string + " received in UCI_Controller," + "\n\tstate of UP at start of sequence: " + SuLib.translateStateValueToString(n) + "\n\tUCI Controller is active: " + this.myIsActive + "\n\treceived Trigger is of type predefined PreCheckTrigger: " + bl);
            if (string.equals("VERIFY_INSTALL")) {
                triggerExecutionResult = this.handleTriggerVerifyInstall();
            } else if (string.equals("VERIFY_UPGRADE")) {
                triggerExecutionResult = this.handleTriggerVerifyUpgrade(n);
            } else if (string.equals("VERIFY_SOFT_UPGRADE")) {
                triggerExecutionResult = this.handleTriggerVerifySoftUpgrade(n);
            } else if (string.equals("VERIFY_HARD_UPGRADE")) {
                triggerExecutionResult = this.handleTriggerVerifyHardUpgrade(n);
            } else if (string.equals("VERIFY_UPDATE")) {
                triggerExecutionResult = this.handleTriggerVerifyUpdate(n);
            }
        } else {
            Trace.suTestLog(this.getClass(), "triggerIndicated(UpgradeMasterExtended anUpgradeMasterExtended, String aTriggerName, int anUpgradePackageState)", "Trigger " + string + " received in UCI_Controller," + "\n\tanUpgradePackageState: " + SuLib.translateStateValueToString(n) + "\n\tUCI Controller is active: " + this.myIsActive + "\n\treceived Trigger is of type predefined PreCheckTrigger: " + bl);
        }
        if (triggerExecutionResult == null || triggerExecutionResult.confirmStatus == 1) {
            ((SuUpgradeMaster)upgradeMasterExtended).triggerConfirmed(this, string, true);
        } else {
            ActionResultData[] actionResultDataArray = new ActionResultData[triggerExecutionResult.actionResultDatas.size()];
            actionResultDataArray = triggerExecutionResult.actionResultDatas.toArray(actionResultDataArray);
            ((SuUpgradeMaster)upgradeMasterExtended).triggerConfirmed((UpgradeParticipator)this, string, triggerExecutionResult.confirmStatus, actionResultDataArray);
        }
    }

    private TriggerExecutionResult addVerificationResult(TriggerExecutionResult triggerExecutionResult, VerificationResult verificationResult) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addVerificationResult(TriggerExecutionResult aTriggerExecutionResult, VerificationResult aVerificationResult)", "aTriggerExecutionResult: " + triggerExecutionResult + "\n\taVerificationResult: " + verificationResult);
        }
        if (triggerExecutionResult != null) {
            triggerExecutionResult.addVerificationResult(verificationResult);
        } else {
            triggerExecutionResult = this.createTriggerExecutionResult(verificationResult);
        }
        return triggerExecutionResult;
    }

    private TriggerExecutionResult addVerificationResult(TriggerExecutionResult triggerExecutionResult, VerificationResult[] verificationResultArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addVerificationResult(TriggerExecutionResult aTriggerExecutionResult, VerificationResult[] aVerificationResults)", "aTriggerExecutionResult: " + triggerExecutionResult + "\n\taVerificationResult[]: " + SuLib.toString(verificationResultArray));
        }
        VerificationResult verificationResult = null;
        for (int i = 0; i < verificationResultArray.length; ++i) {
            verificationResult = verificationResultArray[i];
            if (verificationResult == null) continue;
            this.addVerificationResult(triggerExecutionResult, verificationResult);
        }
        return triggerExecutionResult;
    }

    private TriggerExecutionResult createTriggerExecutionResult(VerificationResult verificationResult) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createTriggerExecutionResult(VerificationResult aVerificationResult)", "aVerificationResult: " + verificationResult);
        }
        if (verificationResult != null) {
            return new TriggerExecutionResult(verificationResult);
        }
        return null;
    }

    private TriggerExecutionResult handleTriggerVerifyInstall() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTriggerVerifyInstall( )");
        }
        VerificationResult verificationResult = this.verifyPIUsSupportedByA_SpecificNodeType();
        TriggerExecutionResult triggerExecutionResult = this.createTriggerExecutionResult(verificationResult);
        verificationResult = this.verifyDiskSpaceSufficientForInstall();
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyConfigurationMismatchForLMs(true);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        VerificationResult[] verificationResultArray = this.verifyConfigurationMismatchForPiuType();
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResultArray);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 21, "handleTriggerVerifyInstall()", "RETURNS - theTriggerExecutionResult: " + triggerExecutionResult);
        }
        return triggerExecutionResult;
    }

    private TriggerExecutionResult handleTriggerVerifyUpgrade(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTriggerVerifyUpgrade(int anUpgradePackageState)", "anUpgradePackageState: " + SuLib.translateStateValueToString(n));
        }
        VerificationResult verificationResult = this.verifyPIUsSupportedByA_SpecificNodeType();
        TriggerExecutionResult triggerExecutionResult = this.createTriggerExecutionResult(verificationResult);
        verificationResult = this.verifyDiskSpaceSufficientForInstall(n);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyDiskHealthCheck(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyConfigurationMismatchForLMs(false);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyRepertoireReplacement(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyJDBC_Connection(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyJavaHeapSizeConsistency(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyInconsistenciesInRpuAddition(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        return triggerExecutionResult;
    }

    private TriggerExecutionResult handleTriggerVerifySoftUpgrade(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTriggerVerifySoftUpgrade(int anUpgradePackageState)", "anUpgradePackageState: " + SuLib.translateStateValueToString(n));
        }
        VerificationResult verificationResult = this.verifyConfigurationMismatchForLMs(false);
        TriggerExecutionResult triggerExecutionResult = this.createTriggerExecutionResult(verificationResult);
        verificationResult = this.verifyRepertoireReplacement(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyJDBC_Connection(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyJavaHeapSizeConsistency(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyInconsistenciesInRpuAddition(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        return triggerExecutionResult;
    }

    private TriggerExecutionResult handleTriggerVerifyHardUpgrade(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTriggerVerifyHardUpgrade(int anUpgradePackageState)", "anUpgradePackageState: " + SuLib.translateStateValueToString(n));
        }
        VerificationResult verificationResult = this.verifyConfigurationMismatchForLMs(false);
        TriggerExecutionResult triggerExecutionResult = this.createTriggerExecutionResult(verificationResult);
        verificationResult = this.verifyRepertoireReplacement(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyJDBC_Connection(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyJavaHeapSizeConsistency(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyInconsistenciesInRpuAddition(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        return triggerExecutionResult;
    }

    private TriggerExecutionResult handleTriggerVerifyUpdate(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTriggerVerifyUpdate(int anUpgradePackageState)", "anUpgradePackageState: " + SuLib.translateStateValueToString(n));
        }
        VerificationResult verificationResult = this.verifyConfigurationMismatchForLMs(false);
        TriggerExecutionResult triggerExecutionResult = this.createTriggerExecutionResult(verificationResult);
        verificationResult = this.verifyRepertoireReplacement(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyJavaHeapSizeConsistency(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        verificationResult = this.verifyInconsistenciesInRpuAddition(this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, this.mySequenceToBeExecutedInformationEvent);
        triggerExecutionResult = this.addVerificationResult(triggerExecutionResult, verificationResult);
        return triggerExecutionResult;
    }

    private boolean isPreCheckTrigger(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isPreCheckTrigger(String aTriggerName)", "aTriggerName: " + string);
        }
        return string.equals("VERIFY_INSTALL") || string.equals("VERIFY_UPGRADE") || string.equals("VERIFY_HARD_UPGRADE") || string.equals("VERIFY_SOFT_UPGRADE") || string.equals("VERIFY_UPDATE");
    }

    private VerificationResult verifyPIUsSupportedByA_SpecificNodeType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyPIUsSupportedByA_SpecificNodeType( )");
        }
        VerificationResult verificationResult = null;
        if (this.mySequenceToBeExecutedInformationEvent != null) {
            UP_InstallRequestEvent uP_InstallRequestEvent = this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent();
            if (uP_InstallRequestEvent.getRequestedTypeOfUP().isHW_Sensitive() && uP_InstallRequestEvent.getHSI_Variant().isNSI()) {
                NodeTypeVerifier nodeTypeVerifier = new NodeTypeVerifier();
                UP_LoadModulesRelationInformation uP_LoadModulesRelationInformation = this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_AndLM_Information().transformedUP;
                verificationResult = nodeTypeVerifier.verifyPIUsSupportedByA_SpecificNodeType(uP_LoadModulesRelationInformation);
            }
        } else {
            ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.LACK_OF_DISK_SPACE, "Install verification: Not possible to determine if verification of that the used PIUs in the node are supported by a specific node type according to the Upgrade Control File shall be executed,reason: variable mySequenceToBeExecutedInformationEvent = null.");
            verificationResult = new VerificationResult(false, actionResultData);
        }
        return verificationResult;
    }

    private VerificationResult verifyDiskSpaceSufficientForInstall() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyDiskSpaceSufficientForInstall( )");
        }
        VerificationResult verificationResult = null;
        if (this.mySequenceToBeExecutedInformationEvent != null) {
            DiskSpaceVerifier diskSpaceVerifier = new DiskSpaceVerifier(this.mySequenceToBeExecutedInformationEvent.initUP_Information);
            boolean bl = false;
            if (this.mySequenceToBeExecutedInformationEvent.isInstallSequence) {
                bl = this.mySequenceToBeExecutedInformationEvent.isForcedInstallRequested;
            }
            verificationResult = diskSpaceVerifier.verifyDiskSpaceSufficientForInstall(bl);
        } else {
            ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.LACK_OF_DISK_SPACE, "Install verification: Verification of that disk space is sufficient for install was not possible to execute,reason: variable mySequenceToBeExecutedInformationEvent = null.");
            verificationResult = new VerificationResult(false, actionResultData);
        }
        return verificationResult;
    }

    private VerificationResult verifyDiskSpaceSufficientForInstall(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyDiskSpaceSufficientForInstall(int anUpgradePackageState)", "anUpgradePackageState: " + n);
        }
        if (n == 0 || n == 6) {
            return this.verifyDiskSpaceSufficientForInstall();
        }
        return null;
    }

    private VerificationResult verifyDiskHealthCheck(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyDiskHealthCheck(String anUP_DocumentNumber, String anUP_DocumentRevision)", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingDiskHealthCheck(this));
        VerificationResult verificationResult = new DiskHealthCheckController().requestDiskHealthCheck(string, string2);
        return verificationResult;
    }

    private VerificationResult verifyConfigurationMismatchForLMs(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyConfigurationMismatchForLMs(boolean isVerifyInstall)", "\n\tanUP_DocumentNumber: \n\tanUP_DocumentRevision: ");
        }
        VerificationResult verificationResult = null;
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingMismatchPathForLMCheck(this));
            verificationResult = new ConfigurationMismatchForLMPathController(this.mySequenceToBeExecutedInformationEvent).verifyConfigurationMismatchForLMPathController(bl);
        }
        catch (VerifyUpgradeException verifyUpgradeException) {
            Trace.info(this.getClass(), "verifyConfigurationMismatchForLMs(boolean isVerifyInstall)", "VerifyUpgradeException caught, message: " + verifyUpgradeException.toString());
        }
        return verificationResult;
    }

    private VerificationResult[] verifyConfigurationMismatchForPiuType() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyConfigurationMismatchForPiuType( )");
        }
        VerificationResult[] verificationResultArray = new VerificationResult[2];
        if (this.mySequenceToBeExecutedInformationEvent != null) {
            UP_InstallRequestEvent uP_InstallRequestEvent = this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent();
            if (uP_InstallRequestEvent.getRequestedTypeOfUP().isHW_Sensitive()) {
                PiuTypeConfigurationVerifier piuTypeConfigurationVerifier = new PiuTypeConfigurationVerifier();
                verificationResultArray = piuTypeConfigurationVerifier.verifyConfigurationMismatchForPiuType(uP_InstallRequestEvent);
            }
        } else {
            ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.PIUTYPE_LOADLIST_INCONSISTENT, "Install verification: Not possible to do the verification of that the PiuTypes for slots having multiple SoftwareAllocations, reason: variable mySequenceToBeExecutedInformationEvent = null.");
            verificationResultArray[0] = new VerificationResult(false, actionResultData);
        }
        return verificationResultArray;
    }

    private VerificationResult verifyRepertoireReplacement(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyRepertoireReplacement(String anUP_DocumentNumber, String anUP_DocumentRevision)", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingRepertoireReplacementCheck(this));
        VerificationResult verificationResult = null;
        try {
            verificationResult = new RepertoireReplacementCheckController(this.mySequenceToBeExecutedInformationEvent).verifyRepertoireReplacementCheckController();
        }
        catch (VerifyUpgradeException verifyUpgradeException) {
            Trace.log1(this.getClass(), "verifyRepertoireReplacement(String anUP_DocumentNumber, String anUP_DocumentRevision)", "VerifyUpgradeException caught (ignored): " + (Object)((Object)verifyUpgradeException));
        }
        return verificationResult;
    }

    private VerificationResult verifyJDBC_Connection(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyJDBC_Connection(String anUP_DocumentNumber, String anUP_DocumentRevision)", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingJDBC_ConnectionCheck(this));
        try {
            return new JDBC_ConnectionController().execute();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "verifyJDBC_Connection(String anUP_DocumentNumber, String anUP_DocumentRevision)", "Do not report problems sine the Polyhedra functionallity not even is part of the node configuration\n\tNoClassDefFoundError: " + noClassDefFoundError);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "verifyJDBC_Connection(String anUP_DocumentNumber, String anUP_DocumentRevision)", "Do not report problems sine the Polyhedra functionallity not even is part of the node configuration\n\tClassNotFoundException: " + throwable);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
    }

    private VerificationResult verifyJavaHeapSizeConsistency(String string, String string2, String string3, SequenceToBeExecutedInformationEvent sequenceToBeExecutedInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyJavaHeapSizeConsistency(String anUP_DocumentNumber, String anUP_DocumentRevision, String anUP_UCF_Path, SequenceToBeExecutedInformationEvent )", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2 + "\n\tanUP_UCF_Path: " + string3 + "\n\taSequenceToBeExecutedInformationEvent: " + sequenceToBeExecutedInformationEvent);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingJavaHeapSizeConsistencyCheck(this));
        try {
            return new JavaHeapController(string, string2, string3, sequenceToBeExecutedInformationEvent).execute();
        }
        catch (Throwable throwable) {
            Trace.log1(this.getClass(), "verifyJavaHeapSizeConsistency(String anUP_DocumentNumber, String anUP_DocumentRevision, String anUP_UCF_Path, SequenceToBeExecutedInformationEvent )", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2 + "\n\tanUP_UCF_Path: " + string3 + "\n\taSequenceToBeExecutedInformationEvent: " + sequenceToBeExecutedInformationEvent + "\n\tThrowable: " + throwable);
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
    }

    private VerificationResult verifyInconsistenciesInRpuAddition(String string, String string2, String string3, SequenceToBeExecutedInformationEvent sequenceToBeExecutedInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyInconsistenciesInRpuAddition(String anUP_DocumentNumber, String anUP_DocumentRevision, String anUP_UCF_Path, SequenceToBeExecutedInformationEvent aSequenceToBeExecutedInformationEvent)", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2 + "\n\tanUP_UCF_Path: " + string3 + "\n\taSequenceToBeExecutedInformationEvent: " + sequenceToBeExecutedInformationEvent);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingRpuAddtionCheck(this));
        try {
            return new RpuConsistencyVerifier(string, string2, string3, sequenceToBeExecutedInformationEvent).execute();
        }
        catch (Throwable throwable) {
            Trace.log1(this.getClass(), "verifyInconsistenciesInRpuAddition(String anUP_DocumentNumber, String anUP_DocumentRevision, String anUP_UCF_Path, SequenceToBeExecutedInformationEvent aSequenceToBeExecutedInformationEvent)", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2 + "\n\tanUP_UCF_Path: " + string3 + "\n\taSequenceToBeExecutedInformationEvent: " + sequenceToBeExecutedInformationEvent + "\n\tThrowable: " + throwable);
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
    }
}

