/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.uci.verify;

import java.util.Collection;
import java.util.LinkedList;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SupportedSequenceInformation;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.upgradepackage.install.event.UP_InstallRequestEvent;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.main.util.ActionResultInformationEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingPiuTypeConfigOverlappInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingPiuTypeLoadListsInformation;
import se.ericsson.cello.upgradepackage.verify.UcfDataContainer;
import se.ericsson.cello.upgradepackage.verify.VerifyHelper;
import se.ericsson.cello.upgradepackage.verify.event.BlockingVerifyRequestEvent;

public class PiuTypeConfigurationVerifier {
    public PiuTypeConfigurationVerifier() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PiuTypeConfigurationVerifier( )");
        }
    }

    public VerificationResult[] verifyConfigurationMismatchForPiuType(UP_InstallRequestEvent uP_InstallRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyConfigurationMismatchForLMs()");
        }
        VerificationResult[] verificationResultArray = new VerificationResult[2];
        try {
            UcfDataContainer ucfDataContainer;
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseAllMainElements(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, uP_InstallRequestEvent.upgradePackageUCF_Path, false);
            BlockingVerifyRequestEvent blockingVerifyRequestEvent = this.createBlockingVerifyRequestEvent(uP_InstallRequestEvent);
            SupportedSequenceInformation supportedSequenceInformation = VerifyHelper.verifyUpgradeWindow(documentObjectProxyInterface, blockingVerifyRequestEvent);
            Collection collection = new LinkedList();
            Collection collection2 = new LinkedList();
            if (supportedSequenceInformation.isSupported() && (ucfDataContainer = VerifyHelper.initMultipleSwaConfigValidation(documentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase)) != null) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingPiuTypeLoadListsInformation(this));
                collection = VerifyHelper.verifyPiuTypeLoadLists(ucfDataContainer);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingPiuTypeConfigOverlappInformation(this));
                collection2 = VerifyHelper.verifyPiuTypeOverlapp(ucfDataContainer);
            }
            if (collection.isEmpty() && collection2.isEmpty()) {
                verificationResultArray[0] = this.createVerificationResultOK();
            } else {
                if (!collection.isEmpty()) {
                    verificationResultArray[0] = this.createVerificationResult(ActionResultInformationEnum.PIUTYPE_LOADLIST_INCONSISTENT, "Install verification: Faulty Repertoire configuration having inconsitent PiuTypes " + ((Object)collection).toString());
                }
                if (!collection2.isEmpty()) {
                    verificationResultArray[1] = this.createVerificationResult(ActionResultInformationEnum.PIUTYPE_NOT_UNIQUE, "Install verification: Faulty SWA configuration having duplicate PiuTypes " + ((Object)collection2).toString());
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyConfigurationMismatchForPiuType()", "Throwable caught, message: " + throwable.toString(), throwable);
            verificationResultArray[0] = this.createVerificationResult(throwable);
        }
        return verificationResultArray;
    }

    private VerificationResult createVerificationResult(ActionResultInformationEnum actionResultInformationEnum, String string) {
        ActionResultData actionResultData = new ActionResultData(actionResultInformationEnum, string);
        return new VerificationResult(true, false, actionResultData);
    }

    private VerificationResult createVerificationResultOK() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createVerificationResultOK( )");
        }
        return new VerificationResult(true);
    }

    private VerificationResult createVerificationResult(Throwable throwable) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createVerificationResult(hrowable aThrowable)", "aThrowable: " + throwable);
        }
        ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.PIUTYPE_LOADLIST_INCONSISTENT, "Install verification: Verification of that all SWA are having Repertoire with consitent PiuTypes and does not have having duplicate PiuTypes was not possible to execute.Reason: Throwable caught,\n\taThrowable: " + throwable);
        return new VerificationResult(false, actionResultData);
    }

    private BlockingVerifyRequestEvent createBlockingVerifyRequestEvent(UP_InstallRequestEvent uP_InstallRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createBlockingVerifyRequestEvent(UP_InstallRequestEvent anInstallRequestEvent)", "UP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        return new BlockingVerifyRequestEvent(uP_InstallRequestEvent.getSource(), uP_InstallRequestEvent.baseUP_UCF_Path, uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, uP_InstallRequestEvent.upgradePackageOriginalUCF_Path, uP_InstallRequestEvent.upgradePackageProductionDate, uP_InstallRequestEvent.upgradePackageProductName, uP_InstallRequestEvent.upgradePackageType, uP_InstallRequestEvent.upgradePackageUCF_Path, TypeOfUpgrade.Upgrade, uP_InstallRequestEvent.getUP_CompatibilityIndex(), uP_InstallRequestEvent.getInstalledTypeOfUP(), new int[0], uP_InstallRequestEvent.getSU_LogicCompatibilityIndex(), 0, "", uP_InstallRequestEvent.getCurrentSequenceLabel(), uP_InstallRequestEvent.getPreUpgradeState(), uP_InstallRequestEvent.getRequestedTypeOfUP(), uP_InstallRequestEvent.getHSI_Variant(), uP_InstallRequestEvent.ftpServerInformation, uP_InstallRequestEvent.activatedTypeOfUP, uP_InstallRequestEvent.hasPreUpgradeBeenExecuted());
    }
}

