/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.transform.Value;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.OldUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.PreUpgradeCase;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.PreUpgradeCaseAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.UpgradeCase;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.UpgradeCaseAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.UpgradeWindow;

public class UpgradeWindowTransformer {
    public static final String UpgradeCasePath = "UpgradePackage/UpgradeWindow/OldUpgradePackage/UpgradeCase";
    public static final String PreUpgradeCasePath = "UpgradePackage/UpgradeWindow/OldUpgradePackage/PreUpgradeCase";

    public void execute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (value.getElementPath().equals(UpgradeCasePath)) {
            this.transformUpgradeCaseAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(PreUpgradeCasePath)) {
            this.transformPreUpgradeCaseAttribute(value, documentObjectUpgradePackage);
        } else {
            UpgradeTrace.info(this.getClass(), (String)"transformValue(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo()));
        }
    }

    private void transformUpgradeCaseAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformUpgradeCaseAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getUpgradeCases(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        UpgradeCase upgradeCase = null;
        while (iterator.hasNext()) {
            upgradeCase = (UpgradeCase)iterator.next();
            if (value.getAttributeName().equals(UpgradeCaseAttributeName.Type.getValue())) {
                if (upgradeCase.getType() == null || !upgradeCase.getType().equals(value.getFrom())) continue;
                upgradeCase.setType(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformUpgradeCaseAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformPreUpgradeCaseAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformPreUpgradeCaseAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getPreUpgradeCases(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        PreUpgradeCase preUpgradeCase = null;
        while (iterator.hasNext()) {
            preUpgradeCase = (PreUpgradeCase)iterator.next();
            if (value.getAttributeName().equals(PreUpgradeCaseAttributeName.Type.getValue())) {
                if (preUpgradeCase.getType() == null || !preUpgradeCase.getType().equals(value.getFrom())) continue;
                preUpgradeCase.setType(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformPreUpgradeCaseAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getUpgradeCases(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getUpgradeCases(DocumentObjectUpgradePackage aDOUP)", (String)("aDOUP: " + documentObjectUpgradePackage));
        }
        LinkedList linkedList = new LinkedList();
        UpgradeWindow upgradeWindow = documentObjectUpgradePackage.getUpgradeWindow();
        if (upgradeWindow != null) {
            Vector vector = upgradeWindow.getOldUpgradePackages();
            Iterator iterator = vector.iterator();
            OldUpgradePackage oldUpgradePackage = null;
            while (iterator.hasNext()) {
                oldUpgradePackage = (OldUpgradePackage)iterator.next();
                linkedList.addAll(oldUpgradePackage.getUpgradeCases());
            }
        }
        return linkedList;
    }

    private Collection getPreUpgradeCases(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPreUpgradeCases(DocumentObjectUpgradePackage aDOUP)", (String)("aDOUP: " + documentObjectUpgradePackage));
        }
        LinkedList linkedList = new LinkedList();
        UpgradeWindow upgradeWindow = documentObjectUpgradePackage.getUpgradeWindow();
        if (upgradeWindow != null) {
            Vector vector = upgradeWindow.getOldUpgradePackages();
            Iterator iterator = vector.iterator();
            OldUpgradePackage oldUpgradePackage = null;
            while (iterator.hasNext()) {
                oldUpgradePackage = (OldUpgradePackage)iterator.next();
                linkedList.addAll(oldUpgradePackage.getPreUpgradeCases());
            }
        }
        return linkedList;
    }
}

