/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.Enumer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringUtils;
import se.ericsson.cello.sudom.parser.AttributeMissingException;
import se.ericsson.cello.sudom.parser.AttributeValueOutOfRangeException;
import se.ericsson.cello.sudom.parser.IllegalAttributeValueException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeFormatException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.MandatoryInformationHandler;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionConstraints;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionValue;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public abstract class AttributeProperty
extends Enumer {
    protected boolean isMandatory = false;
    protected boolean isAttributeOfInterest = false;
    private UpgradePackageSyntaxVersionConstraints myUpgradePackageSyntaxVersionConstraints = null;
    private MandatoryInformationHandler myMandatoryInformationHandler = null;

    public AttributeProperty(String string) {
        super(string);
    }

    public AttributeProperty(String string, boolean bl) {
        super(string);
        this.isMandatory = bl;
    }

    public AttributeProperty(String string, MandatoryInformationHandler mandatoryInformationHandler) {
        super(string);
        this.myMandatoryInformationHandler = mandatoryInformationHandler;
    }

    public AttributeProperty(String string, UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints) {
        super(string);
        this.myUpgradePackageSyntaxVersionConstraints = upgradePackageSyntaxVersionConstraints;
    }

    public AttributeProperty(String string, boolean bl, UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints) {
        super(string);
        this.isMandatory = bl;
        this.myUpgradePackageSyntaxVersionConstraints = upgradePackageSyntaxVersionConstraints;
    }

    public boolean getIsAttributeOfInterest() {
        return this.isAttributeOfInterest;
    }

    public boolean isAttributeOfInterest() {
        return this.isAttributeOfInterest;
    }

    public void setIsAttributeOfInterest(boolean bl) {
        this.isAttributeOfInterest = bl;
    }

    public static String[] verifyNoNames(AttributeList attributeList) {
        if (UpgradeTrace.valid((Class)AttributeProperty.class, (int)25)) {
            UpgradeTrace.debug((Class)AttributeProperty.class, (int)25, (String)"verifyNoNames ( AttributeList anAttributeList )", (String)("anAttributeList: " + attributeList));
        }
        if (attributeList == null) {
            UpgradeTrace.error((Class)AttributeProperty.class, (String)"verifyNoNames ( AttributeList anAttributeList )", (String)"Invalid input data, anAttributeList is set to null\n\tanAttributeList: null ");
            return null;
        }
        int n = attributeList.getLength();
        String[] stringArray = new String[n];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringArray[i] = attributeList.getName(i);
            }
        }
        return stringArray;
    }

    public boolean isMandatory() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isMandatory()", (String)("myMandatoryInformationHandler: " + this.myMandatoryInformationHandler + "\n\tisMandatory: " + this.isMandatory));
        }
        if (this.myMandatoryInformationHandler != null) {
            return this.myMandatoryInformationHandler.isMandatory();
        }
        return this.isMandatory;
    }

    protected void errorAttributeMissing(Class clazz, String string, String string2, String string3, Locator locator) throws AttributeMissingException {
        String string4 = "Upgrade control file error,\n\tmandatory attribute missing: attribute " + string3 + " not found in element of type " + string2 + ".";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string4 + LocatorProxy.getLocatorInfo(locator)));
        throw new AttributeMissingException(string4, locator);
    }

    protected void errorAttributeValueOutOfRange(Class clazz, String string, String string2, String string3, String string4, String string5, Locator locator) throws AttributeValueOutOfRangeException {
        String string6 = "Upgrade control file error,\n\tattribute value out of range: " + string3 + " = \"" + string4 + "\"" + " found in element of type " + string2 + "." + "\n\tAllowed range for this attribute value is " + string5 + ".";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string6 + LocatorProxy.getLocatorInfo(locator)));
        throw new AttributeValueOutOfRangeException(string6, locator);
    }

    protected void errorIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws IllegalAttributeValueException {
        String string5 = "Upgrade control file error,\n\tillegal attribute value: " + string3 + " = \"" + string4 + "\"" + " found in element of type " + string2 + ".";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string5 + LocatorProxy.getLocatorInfo(locator)));
        throw new IllegalAttributeValueException(string5, locator);
    }

    protected void errorIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, Locator locator, boolean bl) throws IllegalAttributeValueException {
        String string5 = "Upgrade control file error,\n\tillegal attribute value: " + string3 + " = \"" + string4 + "\"" + " found in element of type " + string2 + ".";
        if (!bl) {
            UpgradeTrace.info((Class)clazz, (String)string, (String)(string5 + LocatorProxy.getLocatorInfo(locator)));
        }
        throw new IllegalAttributeValueException(string5, locator);
    }

    protected void errorIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, String string5, Locator locator) throws IllegalAttributeValueException {
        String string6 = "Upgrade control file error,\n\tillegal attribute value: " + string3 + " = \"" + string4 + "\"" + " found in element of type " + string2 + ".";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string6 + string5 + LocatorProxy.getLocatorInfo(locator)));
        throw new IllegalAttributeValueException(string6, string5, locator);
    }

    protected void errorIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, String string5, Locator locator, boolean bl) throws IllegalAttributeValueException {
        String string6 = "Upgrade control file error,\n\tillegal attribute value: " + string3 + " = \"" + string4 + "\"" + " found in element of type " + string2 + ".";
        String string7 = LocatorProxy.getLocatorInfo(locator);
        if (!bl) {
            UpgradeTrace.info((Class)clazz, (String)string, (String)(string6 + string5 + string7));
        }
        throw new IllegalAttributeValueException(string6, string5, string7);
    }

    protected void errorUnexpectedAttributeFormat(Class clazz, String string, String string2, String string3, String string4, String string5, Locator locator) throws UnexpectedAttributeFormatException {
        String string6 = "Upgrade control file error,\n\tunexpected attribute value format: " + string3 + " = \"" + string4 + "\"" + " found in element of type " + string2 + "." + "\n\tAttribute value of type " + string5 + " was expected.";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string6 + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedAttributeFormatException(string6, locator);
    }

    protected void validate(String string, String string2, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate(String anElementName, String aValue, Locator aLocator)", (String)("Attribute name: " + this.getValue() + "\n\tAttribute aValue: " + string2 + "\n\tanElementName: " + string + "\n\tmyUpgradePackageSyntaxVersionConstraints: " + this.myUpgradePackageSyntaxVersionConstraints));
        }
        if (string2 != null) {
            if (!this.isAllowed()) {
                this.handleUnexpectedAttribute("validate(String anElementName, String aValue, Locator aLocator)", string, this.getValue(), locator);
            }
        } else if (this.isMandatory) {
            this.errorAttributeMissing(this.getClass(), "validate(String anElementName, String aValue, Locator aLocator)", string, this.getValue(), locator);
        }
    }

    protected static String[] verifyNames(AttributeList attributeList, String[] stringArray) {
        if (UpgradeTrace.valid((Class)AttributeProperty.class, (int)25)) {
            UpgradeTrace.debug((Class)AttributeProperty.class, (int)25, (String)"verifyNames ( AttributeList anAttributeList, String[] anAttributeNameList )", (String)("anAttributeList: " + attributeList + "\n\tanAttributeNameList: " + StringUtils.toString(stringArray)));
        }
        if (stringArray == null || attributeList == null) {
            UpgradeTrace.error((Class)AttributeProperty.class, (String)"verifyNames(AttributeList anAttributeList, String[] anAttributeNameList)", (String)("Invalid input data, anAttributeNameList or/ and anAttributeList is set to null\n\tanAttributeList: " + attributeList + "\n\tanAttributeNameList: " + StringUtils.toString(stringArray)));
            return null;
        }
        Vector<String> vector = new Vector<String>(0);
        for (int i = 0; i < attributeList.getLength(); ++i) {
            if (AttributeProperty.isAttributeNameKnown(attributeList.getName(i), stringArray)) continue;
            vector.addElement(attributeList.getName(i));
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    private void debugUnexpectedAttribute(String string, String string2, String string3, Locator locator) {
        if (UpgradeTrace.valid((Class)AttributeProperty.class, (int)25)) {
            UpgradeTrace.debug((Class)AttributeProperty.class, (int)25, (String)"debugUnexpectedAttribute(String anElementName, String anAttributeName, String aSyntaxVersionInfo, Locator aDocumentLocator)", (String)("Attribute in Upgrade Control File is not allowed for declared (or default) value of attribute 'syntaxVersion'.\n\tElement of type " + string + " contains unexpected attribute " + string2 + "." + string3 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator) + "\n\tThis mismatch is ignored since attribute 'ignoreUnknownAttributes' is set to 'yes'."));
        }
    }

    private void errorUnexpectedAttribute(String string, String string2, String string3, String string4, Locator locator) throws UnexpectedAttributeException {
        String string5 = "Upgrade control file error,\n\telement of type " + string2 + " contains unexpected attribute " + string3 + "." + string4;
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string5 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedAttributeException(string5, locator.getLineNumber(), locator.getColumnNumber());
    }

    private void handleUnexpectedAttribute(String string, String string2, String string3, Locator locator) throws UnexpectedAttributeException {
        String string4 = "";
        String string5 = CommonDocumentObjectInformation.getInstance().getSyntaxVersion();
        if (!string5.equals("L")) {
            string4 = "\n\tValue of attribute 'syntaxVersion': " + string5 + ".";
        }
        if (CommonDocumentObjectInformation.getInstance().getIgnoreUnknownAttributes()) {
            this.debugUnexpectedAttribute(string2, string3, string4, locator);
        } else {
            this.errorUnexpectedAttribute(string, string2, string3, string4, locator);
        }
    }

    private boolean isAllowed() throws ValidateException {
        if (this.myUpgradePackageSyntaxVersionConstraints == null) {
            return true;
        }
        return UpgradePackageSyntaxVersionValue.isAllowed(CommonDocumentObjectInformation.getInstance().getSyntaxVersion(), this.myUpgradePackageSyntaxVersionConstraints);
    }

    private static boolean isAttributeNameKnown(String string, String[] stringArray) {
        if (UpgradeTrace.valid((Class)AttributeProperty.class, (int)25)) {
            UpgradeTrace.debug((Class)AttributeProperty.class, (int)25, (String)"isAttributeNameKnown ( String anAttributeName, String[] anAttributeNameList )", (String)("anAttributeName: " + string + "\n\tanAttributeNameList: " + StringUtils.toString(stringArray)));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (UpgradeTrace.valid((Class)(class$se$ericsson$cello$sudom$parser$dom$AttributeProperty == null ? AttributeProperty.class$("se.ericsson.cello.sudom.parser.dom.AttributeProperty") : class$se$ericsson$cello$sudom$parser$dom$AttributeProperty), (int)27)) {
                UpgradeTrace.debug((Class)(class$se$ericsson$cello$sudom$parser$dom$AttributeProperty == null ? AttributeProperty.class$("se.ericsson.cello.sudom.parser.dom.AttributeProperty") : class$se$ericsson$cello$sudom$parser$dom$AttributeProperty), (int)27, (String)"isAttributeNameKnown ( String anAttributeName, String[] anAttributeNameList )", (String)("anAttributeNameList[" + i + "]: " + stringArray[i]));
            }
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

