/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import java.util.StringTokenizer;

public class FromStateInformation {
    public static final String DELIMITER = "\u00a3\u00a3\u00a3";
    private String myCompabilityIndex = null;
    private String myProductNumer = null;
    private String myProductRevision = null;

    public FromStateInformation(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        if (stringTokenizer.countTokens() == 1) {
            this.myCompabilityIndex = stringTokenizer.nextToken();
        } else if (stringTokenizer.countTokens() == 2) {
            this.myProductNumer = stringTokenizer.nextToken();
            this.myProductRevision = stringTokenizer.nextToken();
        }
    }

    public boolean hasProductData() {
        return this.myProductNumer != null && this.myProductRevision != null;
    }

    public boolean hasCompabilityIndex() {
        return this.myCompabilityIndex != null;
    }

    public String getProductNumber() {
        return this.myProductNumer;
    }

    public String getProductRevision() {
        return this.myProductRevision;
    }

    public String getUpCompabilityIndex() {
        return this.myCompabilityIndex;
    }

    public String getFromStateInformation() {
        if (this.myProductNumer != null && this.myProductRevision != null) {
            return "ProductData number=" + this.myProductNumer + " revision=" + this.myProductRevision;
        }
        if (this.myCompabilityIndex != null) {
            return "UpCompatibilityIndex index=" + this.myCompabilityIndex;
        }
        return "Unknown";
    }

    public String toString() {
        return "\n\tmyCompabilityIndex: " + this.myCompabilityIndex + "\n\tmyProductNumer: " + this.myProductNumer + "\n\tmyProductRevision: " + this.myProductRevision;
    }
}

