/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.productdata;

import org.xml.sax.Locator;
import se.ericsson.cello.sudom.parser.dom.AttributeValue;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataAttributeName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class ProductDataDateValue
extends AttributeValue {
    private static final int allowedLength = 8;
    private static final int maxDayValue = 31;
    private static final int maxMonthValue = 12;
    private static final int minMonthAndDayValue = 1;
    private static final int minYearValue = 0;

    public static void validate(String string, Locator locator) throws ValidateException {
        if (string.length() != 8) {
            ProductDataDateValue.errorIllegalAttributeValue(ProductDataDateValue.class, "validate(String aValue, Locator aLocator)", "ProductData", ProductDataAttributeName.Date.getValue(), string, "Must contain exactly 8 characters.", locator);
        }
        String string2 = null;
        int n = 0;
        try {
            string2 = string.substring(0, 4);
            n = Integer.parseInt(string2);
            if (n < 0) {
                ProductDataDateValue.errorIllegalAttributeValue(ProductDataDateValue.class, "validate(String aValue, Locator aLocator)", "ProductData", ProductDataAttributeName.Date.getValue(), string, "The value for year (YYYY = " + string2 + ") must be a positive number.", locator);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ProductDataDateValue.errorIllegalAttributeValue(ProductDataDateValue.class, "validate(String aValue, Locator aLocator)", "ProductData", ProductDataAttributeName.Date.getValue(), string, "The value for year (YYYY = " + string2 + ") may only contain numbers.", locator);
        }
        try {
            string2 = string.substring(4, 6);
            n = Integer.parseInt(string2);
            if (n < 1 || n > 12) {
                ProductDataDateValue.errorIllegalAttributeValue(ProductDataDateValue.class, "validate(String aValue, Locator aLocator)", "ProductData", ProductDataAttributeName.Date.getValue(), string, "The value for month (MM = " + string2 + ") must be within the allowed range: " + 1 + " - " + 12 + ".", locator);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ProductDataDateValue.errorIllegalAttributeValue(ProductDataDateValue.class, "validate(String aValue, Locator aLocator)", "ProductData", ProductDataAttributeName.Date.getValue(), string, "The value for month (MM = " + string2 + ") may only contain numbers.", locator);
        }
        try {
            string2 = string.substring(6);
            n = Integer.parseInt(string2);
            if (n < 1 || n > 31) {
                ProductDataDateValue.errorIllegalAttributeValue(ProductDataDateValue.class, "validate(String aValue, Locator aLocator)", "ProductData", ProductDataAttributeName.Date.getValue(), string, "The value for day (DD = " + string2 + ") must be within the allowed range: " + 1 + " - " + 31 + ".", locator);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ProductDataDateValue.errorIllegalAttributeValue(ProductDataDateValue.class, "validate(String aValue, Locator aLocator)", "ProductData", ProductDataAttributeName.Date.getValue(), string, "The value for day (DD = " + string2 + ") may only contain numbers.", locator);
        }
    }
}

