/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.loadmodule;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.LoaderName;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.extsuif.util.enumer.OseProgramLoadClassName;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM_ChecksumValue;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM_DirectoryValue;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallSM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallSM_ChecksumValue;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModule;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_LoaderNameValue;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.proxy.exceptions.DocumentObjectProxyException;
import se.ericsson.cello.sudom.proxy.exceptions.FindAndReplaceException;
import se.ericsson.cello.sudom.proxy.exceptions.LoadModulesProxyException;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileDataException;
import se.ericsson.cello.sudom.proxy.loadmodule.LM_AndSM_DestFilePathInformation;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleInformationExtended;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxy;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesWithLoaderNamesInformation;
import se.ericsson.cello.sudom.proxy.loadmodule.UpLmDataRemove;
import se.ericsson.cello.sudom.util.datacontainer.LoadModuleInfo;
import se.ericsson.cello.sudom.util.datacontainer.LoadModuleReplacementContainer;

public class LoadModulesProxy
implements LoadModulesProxyInterface {
    private Vector myLoadModulesVector = null;
    private HashMap myLoadModulesMap = new HashMap();
    protected static final String UNDERSCORE = "_";

    public LoadModulesProxy() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"LoadModulesProxy()");
        }
    }

    public LoadModulesProxy(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"LoadModulesProxy(Vector aLoadModules)", (String)("aLoadModules: " + vector));
        }
        this.myLoadModulesVector = vector == null ? new Vector(10, 2) : vector;
        this.buildSetOfprodNoAndRevs();
    }

    public void addLoadModule(LoadModuleInfo loadModuleInfo) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addLoadModule(LoadModuleInfo aLoadModuleInfo)", (String)("aLoadModuleInfo: " + loadModuleInfo.getProductNumber() + " " + loadModuleInfo.getRevision()));
        }
        LoadModule loadModule = new LoadModule(loadModuleInfo);
        this.myLoadModulesMap.put(loadModule.getProductData().getNumber() + UNDERSCORE + loadModule.getProductData().getRevision(), new LoadModuleProxy(loadModule));
    }

    public void addLoadModule(LoadModuleInformationExtended loadModuleInformationExtended) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addLoadModule(LoadModuleInformationExtended aLoadModuleInformationExtended)", (String)("aLoadModuleInformationExtended: " + loadModuleInformationExtended.getProductNumber() + " " + loadModuleInformationExtended.getProductRevision()));
        }
        if (this.myLoadModulesVector == null) {
            this.myLoadModulesVector = new Vector(10, 2);
        }
        LoadModule loadModule = new LoadModule(loadModuleInformationExtended);
        this.myLoadModulesVector.add(loadModule);
        this.myLoadModulesMap.put(loadModule.getProductData().getNumber() + UNDERSCORE + loadModule.getProductData().getRevision(), new LoadModuleProxy(loadModule));
    }

    public Collection getLoadModulesWithOseProgramLoadClassName(OseProgramLoadClassName oseProgramLoadClassName) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesWithOseProgramLoadClassName(OseProgramLoadClassName aOseProgramLoadClassName)", (String)("aOseProgramLoadClassName: " + oseProgramLoadClassName));
        }
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            if (!loadModuleProxyInterface.getOseProgramLoadClass().equals(oseProgramLoadClassName.getValue())) continue;
            linkedList.add(new ProductNumberAndRevision(loadModuleProxyInterface.getProductNumber(), loadModuleProxyInterface.getProductRevision()));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getLoadModulesWithOseProgramLoadClassName(OseProgramLoadClassName aOseProgramLoadClassName)", (String)("RETURNS - theRequestedLoadModules: " + linkedList));
        }
        return linkedList;
    }

    public void addOrReplaceLoadModules(Vector vector) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addOrReplaceLoadModules(Vector aLoadModules)", (String)("aLoadModules: " + vector));
        }
        Enumeration enumeration = vector.elements();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        while (enumeration.hasMoreElements()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)enumeration.nextElement();
            this.myLoadModulesMap.put(loadModuleProxyInterface.getProductNumber() + UNDERSCORE + loadModuleProxyInterface.getProductRevision(), loadModuleProxyInterface);
        }
        this.synchronizeLoadModulesVectorWithMap();
    }

    public Vector getAllReliableProgramLabelValues() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getAllReliableProgramLabelValues( )");
        }
        Vector<String> vector = new Vector<String>(1);
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxy loadModuleProxy = null;
        String string = null;
        while (iterator.hasNext()) {
            loadModuleProxy = (LoadModuleProxy)iterator.next();
            string = loadModuleProxy.getReliableProgramLabel();
            if (string == null) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public Collection getAllUpLmDataRemoveData() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getAllReliableProgramLabelValues( )");
        }
        LinkedList<UpLmDataRemove> linkedList = new LinkedList<UpLmDataRemove>();
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        UpLmDataRemove upLmDataRemove = null;
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            upLmDataRemove = this.createUpLmDataRemove(loadModuleProxyInterface.getLoadModule());
            if (upLmDataRemove == null) continue;
            linkedList.add(upLmDataRemove);
        }
        return linkedList;
    }

    private UpLmDataRemove createUpLmDataRemove(LoadModule loadModule) {
        ProductData productData;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createUpLmDataRemove(LoadModule aLoadModule)", (String)("aLoadModule: " + loadModule));
        }
        if ((productData = loadModule.getProductData()) == null) {
            return null;
        }
        if (productData.getNumber() == null || productData.getRevision() == null) {
            return null;
        }
        Vector vector = loadModule.getInstallLM();
        if (vector.isEmpty()) {
            return null;
        }
        Iterator iterator = vector.iterator();
        InstallLM installLM = null;
        String string = null;
        Vector<String> vector2 = new Vector<String>(1);
        while (iterator.hasNext()) {
            installLM = (InstallLM)iterator.next();
            string = installLM.getDestFilePathName();
            if (string == null) continue;
            vector2.add(string);
        }
        Collection collection = loadModule.getInstallSM();
        if (collection.isEmpty()) {
            return new UpLmDataRemove(productData.getNumber(), productData.getRevision(), productData.getNumberRaw(), productData.getRevisionRaw(), vector2);
        }
        Iterator iterator2 = collection.iterator();
        InstallSM installSM = null;
        String string2 = null;
        String string3 = null;
        Vector<String> vector3 = new Vector<String>(1);
        while (iterator2.hasNext()) {
            installSM = (InstallSM)iterator2.next();
            string2 = installSM.getExtension();
            string3 = installSM.getDestFilePathNameRef();
            if (string3 == null) continue;
            vector3.add(string3 + "." + string2);
        }
        return new UpLmDataRemove(productData.getNumber(), productData.getRevision(), productData.getNumberRaw(), productData.getRevisionRaw(), vector2, true, vector3, string2);
    }

    public boolean allLoadModulesContainsIndicatedLoaderName(ProductNumbersAndRevisions productNumbersAndRevisions, LoaderName loaderName) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"allLoadModulesContainsIndicatedLoaderName(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions, LoaderName aLoaderName)", (String)("aLoadModulesProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\taLoaderName: " + loaderName));
        }
        Iterator iterator = productNumbersAndRevisions.getElements().iterator();
        ProductNumberAndRevision productNumberAndRevision = null;
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        while (iterator.hasNext()) {
            productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
            loadModuleProxyInterface = this.getLoadModuleProxyInterface(productNumberAndRevision);
            if (loadModuleProxyInterface == null) {
                UpgradeTrace.info(this.getClass(), (String)"allLoadModulesContainsIndicatedLoaderName(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions, LoaderName aLoaderName)", (String)("Illegal reference in the Upgrade Control File,\n\ta LoadModuleRef element (in a Repertoire element) contains a reference to a non-existing LoadModule element.\n\tproductNumber: " + productNumberAndRevision.productNumber + "\n\trevision: " + productNumberAndRevision.revision));
                return false;
            }
            if (loadModuleProxyInterface.getMoDataLM_LoaderName().equalsIgnoreCase(loaderName.getValue())) continue;
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"allLoadModulesContainsIndicatedLoaderType(ProductNumbersAndRevisions aLoadModulesProductNumbersAndRevisions, String aLoaderName)", (String)("The ModataLM element (in a LoadModule element) does not contain the requested loaderName value,\n\tLoadModule ProductData number: " + productNumberAndRevision.productNumber + "\n\tLoadModule ProductData revision: " + productNumberAndRevision.revision + "\n\tModataLM loaderName: " + loadModuleProxyInterface.getMoDataLM_LoaderName() + "\n\tthe requested loaderName: " + loaderName));
            }
            return false;
        }
        return true;
    }

    public Collection getLoadModuleProxyInterfaces(ProductNumbersAndRevisions productNumbersAndRevisions) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleProxyInterfaces(Collection aProductNumbersAndRevisions)", (String)("aProductNumbersAndRevisions: " + productNumbersAndRevisions));
        }
        Vector<LoadModuleProxyInterface> vector = new Vector<LoadModuleProxyInterface>(1);
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        Iterator iterator = productNumbersAndRevisions.getElements().iterator();
        while (iterator.hasNext()) {
            loadModuleProxyInterface = this.getLoadModuleProxyInterface((ProductNumberAndRevision)iterator.next());
            if (loadModuleProxyInterface == null) continue;
            vector.add(loadModuleProxyInterface);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getLoadModuleProxyInterfaces(Collection aProductNumberAndRevisions)", (String)("Returns - theLoadModuleProxyInterfaces: " + vector));
        }
        return vector;
    }

    public LoadModuleProxyInterface getLoadModuleProxyInterface(ProductNumberAndRevision productNumberAndRevision) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleProxyInterface(ProductNumberAndRevision aProductNumberAndRevision)", (String)("aProductNumberAndRevision: " + productNumberAndRevision.getProductNumberAndRevision()));
        }
        return (LoadModuleProxyInterface)this.myLoadModulesMap.get(productNumberAndRevision.getProductNumberAndRevision());
    }

    public LoadModuleProxyInterface getLoadModuleProxyInterface(String string, String string2) {
        return (LoadModuleProxyInterface)this.myLoadModulesMap.get(string + UNDERSCORE + string2);
    }

    public Collection getLoadModuleProxyInterfaces() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleProxyInterfaces()");
        }
        UpgradeTrace.debug(this.getClass(), (int)25, (String)("getLoadModuleProxyInterfaces() " + this.myLoadModulesMap));
        return this.myLoadModulesMap.values();
    }

    private void synchronizeLoadModulesVectorWithMap() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"synchronizeLoadModulesVectorWithMap( )");
        }
        this.myLoadModulesVector.clear();
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxy loadModuleProxy = null;
        while (iterator.hasNext()) {
            loadModuleProxy = (LoadModuleProxy)iterator.next();
            this.myLoadModulesVector.add(loadModuleProxy.getLoadModule());
        }
    }

    public Collection getLoadModulesWithLoaderNames(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesWithLoaderNames(Collection aLoaderNames)", (String)("aLoaderNames: " + collection));
        }
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxy loadModuleProxy = null;
        Iterator iterator2 = collection.iterator();
        String string = null;
        LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
        while (iterator.hasNext()) {
            loadModuleProxy = (LoadModuleProxy)iterator.next();
            string = loadModuleProxy.getLoaderName();
            iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                if (!((LoaderName)iterator2.next()).getValue().equalsIgnoreCase(string)) continue;
                linkedList.add(new ProductNumberAndRevision(loadModuleProxy.getProductNumber(), loadModuleProxy.getProductRevision()));
            }
        }
        return linkedList;
    }

    public LoadModulesWithLoaderNamesInformation getLoadModulesWithLoaderNamesInformation(Collection collection, boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesWithLoaderNamesInformation(Collection aLoaderNames, boolean anIsViewFilesOfInterest)", (String)("aLoaderNames: " + collection + "\n\tanIsViewFilesOfInterest: " + bl));
        }
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxy loadModuleProxy = null;
        String string = null;
        Iterator iterator2 = null;
        LoaderName loaderName = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        String string2 = null;
        LoadModulesWithLoaderNamesInformation loadModulesWithLoaderNamesInformation = new LoadModulesWithLoaderNamesInformation();
        while (iterator.hasNext()) {
            loadModuleProxy = (LoadModuleProxy)iterator.next();
            string = loadModuleProxy.getLoaderName();
            iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                loaderName = (LoaderName)iterator2.next();
                if (!loaderName.getValue().equalsIgnoreCase(string)) continue;
                productNumberAndRevision = new ProductNumberAndRevision(loadModuleProxy.getProductNumber(), loadModuleProxy.getProductRevision());
                if (loaderName.equals(LoaderName.Other) && bl) {
                    string2 = loadModuleProxy.getOtherLoaderName();
                    if (string2 != null && string2.equals("ViewFile")) {
                        loadModulesWithLoaderNamesInformation.addViewFileLoadModule(productNumberAndRevision);
                        continue;
                    }
                    loadModulesWithLoaderNamesInformation.addLoadModule(loaderName, productNumberAndRevision);
                    continue;
                }
                loadModulesWithLoaderNamesInformation.addLoadModule(loaderName, productNumberAndRevision);
            }
        }
        return loadModulesWithLoaderNamesInformation;
    }

    public Vector getNotReferencedLoadModules(ProductNumbersAndRevisions productNumbersAndRevisions) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)", (String)("aProductNumberAndRevisionOfReferencedLoadModules: " + productNumbersAndRevisions));
        }
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        Vector<LoadModuleProxyInterface> vector = new Vector<LoadModuleProxyInterface>(1);
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            if (productNumbersAndRevisions.contains(loadModuleProxyInterface.getProductNumber(), loadModuleProxyInterface.getProductRevision())) continue;
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"getNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)", (String)("Add of not referenced load module: " + loadModuleProxyInterface.getProductNumber() + " " + loadModuleProxyInterface.getProductRevision()));
            }
            vector.addElement(loadModuleProxyInterface);
        }
        return vector;
    }

    public Collection getNotReferencedLoadModulesAsNumberAndRevision(ProductNumbersAndRevisions productNumbersAndRevisions) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)", (String)("aProductNumberAndRevisionOfReferencedLoadModules: " + productNumbersAndRevisions));
        }
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxy loadModuleProxy = null;
        Vector<ProductNumberAndRevision> vector = new Vector<ProductNumberAndRevision>(1);
        while (iterator.hasNext()) {
            loadModuleProxy = (LoadModuleProxy)iterator.next();
            if (productNumbersAndRevisions.contains(loadModuleProxy.getProductNumber(), loadModuleProxy.getProductRevision())) continue;
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"getNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)", (String)("Add of not referenced load module: " + loadModuleProxy.getProductNumber() + " " + loadModuleProxy.getProductRevision()));
            }
            vector.addElement(new ProductNumberAndRevision(loadModuleProxy.getProductNumber(), loadModuleProxy.getProductRevision()));
        }
        return vector;
    }

    public ProductNumbersAndRevisions getProductNumberAndRevisionOfLoadModules() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionOfLoadModules( )");
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            productNumbersAndRevisions.addRawElement(loadModuleProxyInterface.getProductNumber(), loadModuleProxyInterface.getProductRevision(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw(), loadModuleProxyInterface.getProductLocatorString());
        }
        return productNumbersAndRevisions;
    }

    public ProductNumbersAndRevisions getProductNumberAndRevisionWithSignedInfoOfLoadModules() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionOfLoadModules( )");
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        Iterator iterator = this.myLoadModulesMap.values().iterator();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            bl = loadModuleProxyInterface.getInstallSMs().size() > 0;
            productNumbersAndRevisions.addRawElement(loadModuleProxyInterface.getProductNumber(), loadModuleProxyInterface.getProductRevision(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw(), loadModuleProxyInterface.getProductLocatorString(), bl);
        }
        return productNumbersAndRevisions;
    }

    public int getTotalNumberOfFiles(Collection collection) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTotalNumberOfFiles(Collection aProductNumberAndRevisionOfLoadModules)", (String)("aProductNumberAndRevisionOfLoadModules: " + collection));
        }
        try {
            Iterator iterator = collection.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            int n = 0;
            while (iterator.hasNext()) {
                if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                    UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTotalNumberOfFiles(Collection aProductNumberAndRevisionOfLoadModules)", (String)"1 ");
                }
                if ((loadModuleProxyInterface = this.getLoadModuleProxyInterface(productNumberAndRevision = (ProductNumberAndRevision)iterator.next())) != null) {
                    n += loadModuleProxyInterface.getNumberOfFiles();
                    continue;
                }
                UpgradeTrace.error(this.getClass(), (String)"getTotalNumberOfFiles(Collection aProductNumberAndRevisionOfLoadModules)", (String)("aProductNumberAndRevisionOfLoadModules: " + collection + "\n\tUpgrade control file error," + "\n\tarequested product number and revision is not matching a LoadModule element in the used UCF," + "\n\tProductNumberAndRevisionOfLoadModule: " + productNumberAndRevision));
                throw new UpgradeControlFileDataException("getTotalNumberOfFiles(Collection aProductNumberAndRevisionOfLoadModules)\n\taProductNumberAndRevisionOfLoadModules: " + collection + "\n\tUpgrade control file error," + "\n\tarequested product number and revision is not matching a LoadModule element in the used UCF," + "\n\tProductNumberAndRevisionOfLoadModule: " + productNumberAndRevision);
            }
            return n;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"getTotalNumberOfFiles(Collection aProductNumberAndRevisionOfLoadModules)", (String)"Throwable caught.", (Throwable)throwable);
            return 9;
        }
    }

    public void removeNotReferencedLoadModules(ProductNumbersAndRevisions productNumbersAndRevisions, boolean bl, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws LoadModulesProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules, anIsActiveOtherLMsConnectedInToState,DocumentObjectUpgradePackage aDocumentObjectUpgradePackage)", (String)("aProductNumberAndRevisionOfReferencedLoadModules: " + productNumbersAndRevisions + "\n\tanIsActiveOtherLMsConnectedInToState: " + bl + "\n\taDocumentObjectUpgradePackage: " + documentObjectUpgradePackage));
        }
        try {
            Iterator iterator = this.myLoadModulesMap.values().iterator();
            LoadModuleProxy loadModuleProxy = null;
            while (iterator.hasNext()) {
                loadModuleProxy = (LoadModuleProxy)iterator.next();
                if (productNumbersAndRevisions.contains(loadModuleProxy.getProductNumber(), loadModuleProxy.getProductRevision())) continue;
                if (!loadModuleProxy.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.Other)) {
                    iterator.remove();
                    continue;
                }
                if (!bl) continue;
                iterator.remove();
            }
        }
        catch (Exception exception) {
            throw new LoadModulesProxyException("removeNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)\n\tUpgrade control file creation error,\n\tException caught when removing not referenced LoadModules.\n\tException info : " + exception);
        }
        if (this.myLoadModulesMap.isEmpty()) {
            UpgradeTrace.error(this.getClass(), (String)"removeNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)", (String)("Upgrade control file creation error,\n\tall LoadModule elements have been removed from original control file.\n\taProductNumberAndRevisionOfReferencedLoadModules: " + productNumbersAndRevisions));
            throw new LoadModulesProxyException("removeNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)\n\tUpgrade control file creation error,\n\tall LoadModule elements have been removed from original control file.\n\taProductNumberAndRevisionOfReferencedLoadModules: " + productNumbersAndRevisions);
        }
        documentObjectUpgradePackage.adaptLoadModules(this.getLoadModuleProxyInterfaces());
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeNotReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules, anIsActiveOtherLMsConnectedInToState)", (String)("RETURN - myLoadModules : " + this.myLoadModulesMap + "\n\t myLoadModulesVector: " + this.myLoadModulesVector));
        }
    }

    public void addLoadModulesReferencedInAddJavaLM(ProductNumbersAndRevisions productNumbersAndRevisions) throws LoadModulesProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addReferencedLoadModules(ProductNumbersAndRevisions aProductNumberAndRevisionOfReferencedLoadModules)", (String)("aProductNumberAndRevisionOfReferencedLoadModules: " + productNumbersAndRevisions));
        }
    }

    public void replaceLoadModules(Vector vector, Vector vector2) throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"replaceLoadModules(Vector aLoadModuleReplacementsContainer, Vector aNewLoadModules)", (String)("aLoadModuleReplacementsContainer: " + vector + "\n\taNewLoadModules: " + vector2));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object object;
            LoadModuleReplacementContainer loadModuleReplacementContainer = (LoadModuleReplacementContainer)iterator.next();
            ProductNumberAndRevision productNumberAndRevision = loadModuleReplacementContainer.getNewLM();
            LoadModuleProxyInterface loadModuleProxyInterface = this.getLoadModule(productNumberAndRevision.productNumber, productNumberAndRevision.revision, vector2);
            if (loadModuleProxyInterface == null) {
                UpgradeTrace.error(this.getClass(), (String)"replaceLoadModules(Vector aLoadModuleReplacementsContainer, Vector aNewLoadModules)", (String)("aLoadModuleReplacementsContainer: " + vector + "\n\taNewLoadModules: " + vector2 + "\n\tUpgrade control file error," + "\n\ta NewLM element in a delta control file must contain the same product number " + "and revision as one of the LoadModule elements," + "\n\tat least one doesn't."));
                throw new UpgradeControlFileDataException("replaceLoadModules(Vector aLoadModuleReplacementsContainer, Vector aNewLoadModules)\n\taLoadModuleReplacementsContainer: " + vector + "\n\taNewLoadModules: " + vector2 + "\n\tUpgrade control file error," + "\n\ta NewLM element in a delta control file must contain the same product number " + "and revision as one of the LoadModule elements," + "\n\tat least one doesn't.");
            }
            Iterator iterator2 = loadModuleReplacementContainer.getOldLMs().iterator();
            ProductNumberAndRevision productNumberAndRevision2 = null;
            boolean bl = false;
            block1: while (iterator2.hasNext()) {
                productNumberAndRevision2 = (ProductNumberAndRevision)iterator2.next();
                if (productNumberAndRevision2.revision.equals("*")) {
                    Iterator iterator3 = this.getLoadModuleKeys().iterator();
                    object = null;
                    while (iterator3.hasNext()) {
                        object = (String)iterator3.next();
                        if (((String)object).indexOf(productNumberAndRevision2.productNumber) < 0) continue;
                        if (this.myLoadModulesMap.remove(object) == null) continue block1;
                        bl = true;
                        continue block1;
                    }
                    continue;
                }
                if (this.myLoadModulesMap.remove(productNumberAndRevision2.productNumber + UNDERSCORE + productNumberAndRevision2.revision) == null) continue;
                bl = true;
            }
            boolean bl2 = false;
            if (productNumberAndRevision.revision.equals("*")) {
                object = this.getLoadModuleKeys().iterator();
                String string = null;
                while (object.hasNext()) {
                    string = (String)object.next();
                    if (string.indexOf(productNumberAndRevision.productNumber) < 0) continue;
                    if (this.myLoadModulesMap.remove(string) != null) {
                        bl2 = true;
                    }
                    break;
                }
            } else if (this.myLoadModulesMap.remove(productNumberAndRevision.productNumber + UNDERSCORE + productNumberAndRevision.revision) != null) {
                bl2 = true;
            }
            if (!bl && !bl2) {
                UpgradeTrace.log1(this.getClass(), (String)"replaceLoadModules(Vector aLoadModuleReplacementsContainer, Vector aNewLoadModules)", (String)("the control file where LoadModule elements shall be replaced does not contain a LoadModule\n\telement matching the LoadModuleReplacement element containing any of the OldLM's or the NewLM element where \n\tNewLM has productNumber = " + productNumberAndRevision.productNumber + " and revision = " + productNumberAndRevision.revision + "."));
                throw new FindAndReplaceException("replaceLoadModules(Vector aLoadModuleReplacementsContainer, Vector aNewLoadModules)\n\tthe control file where LoadModule elements shall be replaced does not contain a LoadModule\n\telement matching the LoadModuleReplacement element containing any of theOldLM's or the NewLM element where \n\tNewLM has productNumber = " + productNumberAndRevision.productNumber + " and revision = " + productNumberAndRevision.revision + ".");
            }
            this.myLoadModulesMap.put(loadModuleProxyInterface.getProductNumber() + UNDERSCORE + loadModuleProxyInterface.getProductRevision(), loadModuleProxyInterface);
        }
    }

    public Set getLoadModuleKeys() {
        return this.myLoadModulesMap.keySet();
    }

    private LoadModuleProxyInterface getLoadModule(String string, String string2, Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModule(String aProductNumber, String aRevision, Vector aLoadModules) ", (String)("aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\taLoadModules: " + vector));
        }
        Iterator iterator = vector.iterator();
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            if (!loadModuleProxyInterface.getProductNumber().equals(string) || !loadModuleProxyInterface.getProductRevision().equals(string2)) continue;
            return loadModuleProxyInterface;
        }
        return null;
    }

    public void buildSetOfprodNoAndRevs() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"buildSetOfprodNoAndRevs( )");
        }
        if (!this.myLoadModulesMap.isEmpty()) {
            this.myLoadModulesMap.clear();
        }
        Iterator iterator = this.myLoadModulesVector.iterator();
        LoadModule loadModule = null;
        while (iterator.hasNext()) {
            loadModule = (LoadModule)iterator.next();
            if (loadModule.getProductData() == null) continue;
            this.myLoadModulesMap.put(loadModule.getProductData().getNumber() + UNDERSCORE + loadModule.getProductData().getRevision(), new LoadModuleProxy(loadModule));
        }
    }

    public Collection getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(Collection collection) throws LoadModulesProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(Collection aProductNumbersAndRevisions) ", (String)("aProductNumbersAndRevisions: " + collection));
        }
        try {
            LinkedList<LM_AndSM_DestFilePathInformation> linkedList = new LinkedList<LM_AndSM_DestFilePathInformation>();
            Iterator iterator = collection.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            LM_AndSM_DestFilePathInformation lM_AndSM_DestFilePathInformation = null;
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                lM_AndSM_DestFilePathInformation = this.getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(productNumberAndRevision);
                if (lM_AndSM_DestFilePathInformation == null) continue;
                linkedList.add(lM_AndSM_DestFilePathInformation);
            }
            return linkedList;
        }
        catch (LoadModulesProxyException loadModulesProxyException) {
            throw loadModulesProxyException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(Collection aProductNumbersAndRevisions)", (String)("aProductNumbersAndRevisions: " + collection + "\n\tThrowable caught."), (Throwable)throwable);
            throw new LoadModulesProxyException("Class name: " + this.getClass().getName() + "\n\tgetDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(Collection aProductNumbersAndRevisions)" + "\n\taProductNumbersAndRevisions: " + collection + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }

    public LM_AndSM_DestFilePathInformation getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(ProductNumberAndRevision productNumberAndRevision) throws LoadModulesProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(ProductNumberAndRevision aProductNumberAndRevision) ", (String)("aProductNumberAndRevision: " + productNumberAndRevision));
        }
        try {
            LM_AndSM_DestFilePathInformation lM_AndSM_DestFilePathInformation = null;
            LoadModuleProxyInterface loadModuleProxyInterface = this.getLoadModuleProxyInterface(productNumberAndRevision);
            Iterator iterator = loadModuleProxyInterface.getInstallLMs().iterator();
            InstallLM installLM = null;
            while (iterator.hasNext()) {
                installLM = (InstallLM)iterator.next();
                if (!installLM.getChecksum().equals(InstallLM_ChecksumValue.getDefaultValue()) || !installLM.getDirectory().equalsIgnoreCase(InstallLM_DirectoryValue.getDefaultValue())) continue;
                if (lM_AndSM_DestFilePathInformation == null) {
                    lM_AndSM_DestFilePathInformation = new LM_AndSM_DestFilePathInformation(productNumberAndRevision, loadModuleProxyInterface);
                }
                lM_AndSM_DestFilePathInformation.addLM_DestFilePath(installLM.getDestFilePathName());
            }
            Iterator iterator2 = loadModuleProxyInterface.getInstallSMs().iterator();
            InstallSM installSM = null;
            String string = null;
            String string2 = null;
            while (iterator2.hasNext()) {
                installSM = (InstallSM)iterator2.next();
                if (!installSM.getChecksum().equals(InstallSM_ChecksumValue.getDefaultValue())) continue;
                if (lM_AndSM_DestFilePathInformation == null) {
                    lM_AndSM_DestFilePathInformation = new LM_AndSM_DestFilePathInformation(productNumberAndRevision, loadModuleProxyInterface);
                }
                string = installSM.getDestFilePathNameRef();
                string2 = installSM.getExtension();
                lM_AndSM_DestFilePathInformation.setSM_Extension(string2);
                if (string != null) {
                    lM_AndSM_DestFilePathInformation.addSM_DestFilePath(string + "." + string2);
                    continue;
                }
                lM_AndSM_DestFilePathInformation.addSM_DestFilePath(null);
            }
            return lM_AndSM_DestFilePathInformation;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(ProductNumberAndRevision aProductNumberAndRevision)", (String)("aProductNumberAndRevision: " + productNumberAndRevision + "\n\tThrowable caught."), (Throwable)throwable);
            throw new LoadModulesProxyException("Class name: " + this.getClass().getName() + "\n\tgetDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(ProductNumberAndRevision aProductNumberAndRevision)" + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }
}

