/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.repertoire;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleProgramInformationInterface;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleRefInformation;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;

public class ExtendedLoadModuleRefInformation
extends LoadModuleRefInformation
implements LoadModuleProgramInformationInterface {
    private LoadModuleProxyInterface myOptimizedLoadModuleProxyInterface = null;
    private OptimizedDocumentObjectProxyInterface myOptimizedDocumentObjectProxyInterface = null;

    public ExtendedLoadModuleRefInformation(LoadModuleRefInformation loadModuleRefInformation, LoadModuleProxyInterface loadModuleProxyInterface, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface) {
        super(loadModuleRefInformation.getTag(), loadModuleRefInformation.getProductNumber(), loadModuleRefInformation.getRevision(), loadModuleRefInformation.getProgramMemoryPoolSize(), loadModuleRefInformation.getProgramMemoryHeapSize(), loadModuleRefInformation.getProgramInstances(), loadModuleRefInformation.getLoaderName(), loadModuleRefInformation.getDeviceLoaderName(), loadModuleRefInformation.getDeviceLoaderInformation(), loadModuleRefInformation.getRestartCounterLimit(), loadModuleRefInformation.getRestartTimer());
        this.myOptimizedLoadModuleProxyInterface = loadModuleProxyInterface;
        this.myOptimizedDocumentObjectProxyInterface = optimizedDocumentObjectProxyInterface;
    }

    public Integer getExtendedProgramMemoryPoolSize() {
        Integer n = super.getProgramMemoryPoolSize();
        if (n == null) {
            n = this.myOptimizedLoadModuleProxyInterface.getProgramMemoryPoolSize();
        }
        return n;
    }

    public Integer getExtendedRestartCounterLimit() {
        Integer n = super.getRestartCounterLimit();
        if (n == null) {
            n = this.myOptimizedLoadModuleProxyInterface.getRestartCounterLimit();
        }
        return n;
    }

    public Integer getExtendedRestartTimer() {
        Integer n = super.getRestartTimer();
        if (n == null) {
            n = this.myOptimizedLoadModuleProxyInterface.getRestartTimer();
        }
        return n;
    }

    public String getExtendedProgramMemoryPoolSizeForToString() {
        Integer n = this.getExtendedProgramMemoryPoolSize();
        if (n == null) {
            return "";
        }
        return n.toString();
    }

    public Integer getExtendedProgramMemoryHeapSize() {
        Integer n = super.getProgramMemoryPoolSize();
        if (n == null) {
            n = this.myOptimizedLoadModuleProxyInterface.getProgramMemoryPoolSize();
        }
        return n;
    }

    public String getExtendedProgramMemoryHeapSizeForToString() {
        Integer n = this.getExtendedProgramMemoryHeapSize();
        if (n == null) {
            return "";
        }
        return n.toString();
    }

    public String getExtendedLoaderName() {
        String string = super.getLoaderName();
        if (string.equals("") && this.myOptimizedLoadModuleProxyInterface.getLoaderName() != null) {
            string = this.myOptimizedLoadModuleProxyInterface.getLoaderName();
        }
        return string;
    }

    public String getExtendedDeviceLoaderName() {
        String string = super.getDeviceLoaderName();
        if (string.equals("") && this.myOptimizedLoadModuleProxyInterface.getDeviceLoaderName() != null) {
            string = this.myOptimizedLoadModuleProxyInterface.getDeviceLoaderName();
        }
        return string;
    }

    public String getExtendedDeviceLoaderInformation() {
        String string = super.getDeviceLoaderInformation();
        if (string.equals("") && this.myOptimizedLoadModuleProxyInterface.getDeviceLoaderInformation() != null) {
            string = this.myOptimizedLoadModuleProxyInterface.getDeviceLoaderInformation();
        }
        return string;
    }

    public String getLoadClass() {
        return this.myOptimizedLoadModuleProxyInterface.getOseProgramLoadClass();
    }

    public Collection getDestinationFilePaths() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDestinationFilePaths()", (String)("LM product number in UCF: " + this.myOptimizedLoadModuleProxyInterface.getProductNumberRaw() + "\n\tLM product revision in UCF: " + this.myOptimizedLoadModuleProxyInterface.getProductRevisionRaw()));
        }
        Vector vector = this.myOptimizedLoadModuleProxyInterface.getInstallDatas();
        InstallLM_Container installLM_Container = null;
        Iterator iterator = vector.iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            installLM_Container = (InstallLM_Container)iterator.next();
            if (installLM_Container.isDirectory()) continue;
            String string = this.myOptimizedDocumentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), this.myOptimizedLoadModuleProxyInterface.getProductNumberRaw(), this.myOptimizedLoadModuleProxyInterface.getProductRevisionRaw());
            linkedList.add(string);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getDestinationFilePaths()", (String)("RETURNS - theDestFilePaths: " + linkedList));
        }
        return linkedList;
    }

    public String getLoaderNameSum() {
        return this.getExtendedLoaderName();
    }

    public String getDeviceLoaderNameSum() {
        return this.getExtendedDeviceLoaderName();
    }

    public String getDeviceLoaderInformationSum() {
        return this.getExtendedDeviceLoaderInformation();
    }

    public String toString() {
        return super.toString() + "\n\tELMRI - start" + "\n\tExtendedLoadModuleRefInformation (original no data specified in LmRef element)" + "\n\t\tLM ProgramMemoryPoolSize: " + this.myOptimizedLoadModuleProxyInterface.getProgramMemoryPoolSize() + "\n\t\tLM ProgramMemoryHeapSize: " + this.myOptimizedLoadModuleProxyInterface.getProgramMemoryHeapSize() + "\n\t\tLM LoaderName: " + this.myOptimizedLoadModuleProxyInterface.getLoaderName() + "\n\t\tLM DeviceLoaderName: " + this.myOptimizedLoadModuleProxyInterface.getDeviceLoaderName() + "\n\t\tLM DeviceLoaderInformation: " + this.myOptimizedLoadModuleProxyInterface.getDeviceLoaderInformation() + "\n\t\tLM Destination file paths: " + this.getDestinationFilePaths() + "\n\t\tmyOptimizedLoadModuleProxyInterface: " + this.myOptimizedLoadModuleProxyInterface + "\n\t\tmyOptimizedDocumentObjectProxyInterface: " + this.myOptimizedDocumentObjectProxyInterface + "\n\t\tELMRI - stop";
    }
}

