/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.create;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.create.BaseUP_Data;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreateAttributeData;
import se.ericsson.cello.upgradepackage.create.UpgradePackageShadowData;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UpgradePackageShadowCreator {
    private static UpgradePackageShadowCreator myInstance = null;
    public static final String USER_LABEL = "userLabel";
    public static final String FTP_SERVER_IP_ADDRESS = "FTP_ServerIP_Address";
    public static final String UP_FILE_PATH_ON_FTP_SERVER = "upgradePackageXML_FilePathOnFTP_Server";
    public static final String ANONYMOUS = "anonymous";

    public static synchronized UpgradePackageShadowCreator instance() {
        if (myInstance == null) {
            myInstance = new UpgradePackageShadowCreator();
        }
        return myInstance;
    }

    public static void createNeededShadowUpgradePackages(Coordinator coordinator, Collection collection) {
        if (Trace.valid(UpgradePackageShadowCreator.class, 20)) {
            Trace.debug(UpgradePackageShadowCreator.class, 20, "createNeededShadowUpgradePackages(Coordinator aContext, Collection anUpgradePackagesShadowData)", "\n\tanUpgradePackagesShadowDatas: " + collection);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                UpgradePackageMoImpl upgradePackageMoImpl = null;
                while (moIterator.hasMoreElements()) {
                    upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                    if (upgradePackageMoImpl == null) continue;
                    String string = upgradePackageMoImpl.getDocumentNumber(coordinator);
                    String string2 = upgradePackageMoImpl.getDocumentRevision(coordinator);
                    UpgradePackageShadowCreator.removeVisibleUP_FromList(string, string2, collection, upgradePackageMoImpl, coordinator);
                }
            }
            UpgradePackageShadowCreator.removeObsoleteLmUP_FromList(collection);
            UpgradePackageShadowCreator.createShadowUpgradePackages(coordinator, collection);
        }
        catch (Exception exception) {
            Trace.error(UpgradePackageShadowCreator.class, "createNeededShadowUpgradePackages(Coordinator aContext, Collection anUpgradePackagesShadowDatas)", "Exception caught when trying to create any Upgrade Packages that are not visible but do exist on disk i.e. shadow UP's.\n\tanUpgradePackagesShadowDatas: " + collection, exception);
        }
    }

    public static void createShadowUpgradePackages(Coordinator coordinator, Collection collection) throws MoAccessException {
        if (Trace.valid(UpgradePackageShadowCreator.class, 20)) {
            Trace.debug(UpgradePackageShadowCreator.class, 20, "createShadowUpgradePackages ( Coordinator aContext, Collection anUpgradePackagesShadowData )", "\n\tanUpgradePackagesShadowData: " + collection);
        }
        Iterator iterator = collection.iterator();
        UpgradePackageShadowData upgradePackageShadowData = null;
        ProductDataContainer productDataContainer = null;
        int n = 0;
        while (iterator.hasNext()) {
            upgradePackageShadowData = (UpgradePackageShadowData)iterator.next();
            productDataContainer = upgradePackageShadowData.getProductData();
            UpgradePackageCreateAttributeData upgradePackageCreateAttributeData = new UpgradePackageCreateAttributeData(USER_LABEL, FTP_SERVER_IP_ADDRESS, UP_FILE_PATH_ON_FTP_SERVER, ANONYMOUS, ANONYMOUS, 0, 1, false);
            BaseUP_Data baseUP_Data = new BaseUP_Data("BaseProductNumber", "BaseProductRevision", "BaseProductName", "BaseUpgradeControlFilePath");
            if (Trace.valid(class$se$ericsson$cello$upgradepackage$create$UpgradePackageShadowCreator == null ? UpgradePackageShadowCreator.class$("se.ericsson.cello.upgradepackage.create.UpgradePackageShadowCreator") : class$se$ericsson$cello$upgradepackage$create$UpgradePackageShadowCreator, 20)) {
                Trace.debug(class$se$ericsson$cello$upgradepackage$create$UpgradePackageShadowCreator == null ? UpgradePackageShadowCreator.class$("se.ericsson.cello.upgradepackage.create.UpgradePackageShadowCreator") : class$se$ericsson$cello$upgradepackage$create$UpgradePackageShadowCreator, 20, "createShadowUpgradePackages ( Coordinator aContext, Collection anUpgradePackagesShadowData )", "\n\t create Shadow for::::::::: '" + productDataContainer.toString());
            }
            SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
            if (productDataContainer.getName().equals("InitialUP")) {
                UpgradePackageMoImpl.create(singletonMoFactory.getMo(), "InitialUP", upgradePackageShadowData, upgradePackageCreateAttributeData, baseUP_Data, coordinator);
            } else {
                UpgradePackageMoImpl.create(singletonMoFactory.getMo(), "Virtual_" + n + "_of_" + productDataContainer.getNumber() + "_" + productDataContainer.getRevision(), upgradePackageShadowData, upgradePackageCreateAttributeData, baseUP_Data, coordinator);
            }
            ++n;
        }
    }

    private static void removeVisibleUP_FromList(String string, String string2, Collection collection, UpgradePackageMoImpl upgradePackageMoImpl, Coordinator coordinator) {
        Object object;
        Object object2;
        if (Trace.valid(UpgradePackageShadowCreator.class, 20)) {
            Trace.debug(UpgradePackageShadowCreator.class, 20, "removeVisibleUP_FromList ( String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, Collection anUpgradePackagesOnDiskDataList, UpgradePackageMoImpl aVisibleUpgradePackageMO )", "anUpgradePackageProductNumber: " + string + "\tanUpgradePackageProductRevision: " + string2 + "\tanUpgradePackagesOnDiskDataList: " + collection + "\taVisibleUpgradePackageMO: " + upgradePackageMoImpl);
        }
        Iterator iterator = collection.iterator();
        UpgradePackageShadowData upgradePackageShadowData = null;
        ProductDataContainer productDataContainer = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            upgradePackageShadowData = (UpgradePackageShadowData)iterator.next();
            productDataContainer = upgradePackageShadowData.getProductData();
            if (!(string + "_" + string2).equals(productDataContainer.getNumber() + "_" + productDataContainer.getRevision())) continue;
            object2 = "";
            try {
                object2 = object = upgradePackageMoImpl.getTypeOfUpgradePackage(null);
                if (Trace.valid(UpgradePackageShadowCreator.class, 20)) {
                    Trace.debug(UpgradePackageShadowCreator.class, 20, "removeVisibleUP_FromList ( String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, Collection anUpgradePackagesOnDiskDataList, UpgradePackageMoImpl aVisibleUpgradePackageMO )", "typeOfUPMoData " + (String)object);
                }
            }
            catch (MoAccessException moAccessException) {
                Trace.warning(UpgradePackageShadowCreator.class, "removeVisibleUP_FromList ( String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, Collection anUpgradePackagesOnDiskDataList, UpgradePackageMoImpl aVisibleUpgradePackageMO )", "MoAccessException caught while trying to get typeOFUP. ");
            }
            try {
                if (((String)object2).equals("Delta")) {
                    upgradePackageMoImpl.setBasedOnUpgradePackages(upgradePackageShadowData.getBasedOns(), coordinator);
                }
            }
            catch (Throwable throwable) {
                Trace.warning(UpgradePackageShadowCreator.class, "removeVisibleUP_FromList ( String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, Collection anUpgradePackagesOnDiskDataList, UpgradePackageMoImpl aVisibleUpgradePackageMO )", "Throwable caught while trying to update attribute basedOnUpgradePackages in UP MO: " + upgradePackageMoImpl + "\n\tThrowable data: " + throwable);
            }
            collection.remove(upgradePackageShadowData);
            bl = true;
            break;
        }
        if (!bl) {
            try {
                object2 = upgradePackageMoImpl.getUpgradeControlFilePath(null);
                object = new File((String)object2);
                if (((File)object).exists()) {
                    Trace.warning(UpgradePackageShadowCreator.class, "removeVisibleUP_FromList ( String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, Collection anUpgradePackagesOnDiskDataList, UpgradePackageMoImpl aVisibleUpgradePackageMO )", "The Upgrade Package '" + string + "_" + string2 + "' with the distinguished name '" + upgradePackageMoImpl.getLocalDistinguishedName() + " points to the same physical upgrade control (XML) file as another upgrade package MO. ");
                } else {
                    Trace.warning(UpgradePackageShadowCreator.class, "removeVisibleUP_FromList ( String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, Collection anUpgradePackagesOnDiskDataList, UpgradePackageMoImpl aVisibleUpgradePackageMO )", "The Upgrade Package '" + string + "_" + string2 + "' with the distinguished name '" + upgradePackageMoImpl.getLocalDistinguishedName() + "' do not have upgrade package control file on disk. ");
                }
            }
            catch (Exception exception) {
                Trace.warning(UpgradePackageShadowCreator.class, "removeVisibleUP_FromList ( String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, Collection anUpgradePackagesOnDiskDataList, UpgradePackageMoImpl aVisibleUpgradePackageMO )", "Either the upgrade package MO '" + string + "_" + string2 + "' with the distinguished name '" + upgradePackageMoImpl.getLocalDistinguishedName() + "do not exist on disk or that several Upgrade Package MO's points to same physical upgrade control (XML) file.");
            }
        }
    }

    private static void removeObsoleteLmUP_FromList(Collection collection) {
        if (Trace.valid(UpgradePackageShadowCreator.class, 20)) {
            Trace.debug(UpgradePackageShadowCreator.class, 20, "removeObsoleteLmUP_FromList( Collection anUpgradePackagesShadowDatas)", "\n\tanUpgradePackagesShadowDatas: " + collection);
        }
        Iterator iterator = collection.iterator();
        UpgradePackageShadowData upgradePackageShadowData = null;
        while (iterator.hasNext() && !(upgradePackageShadowData = (UpgradePackageShadowData)iterator.next()).isObsoleteLmUP()) {
            upgradePackageShadowData = null;
        }
        if (upgradePackageShadowData != null) {
            if (Trace.valid(UpgradePackageShadowCreator.class, 22)) {
                Trace.debug(UpgradePackageShadowCreator.class, 22, "removeObsoleteLmUP_FromList( Collection anUpgradePackagesShadowDatas)", "Found ObsoleteLmUP shadow data. Removing it from the list.theObsoleteUpgradePackageShadowData: " + upgradePackageShadowData);
            }
            collection.remove(upgradePackageShadowData);
        }
    }
}

