/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main.handler.actionhandler;

import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.convert.UpgradeMoDataConverter;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.main.event.state.SU_DowngradeExecutingEvent;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.exception.BusyMarkException;
import se.ericsson.cello.upgradepackage.main.handler.actionhandler.ActionHandler;
import se.ericsson.cello.upgradepackage.main.handler.actionhandler.ControllerClientInterface;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.main.util.ActionResultHandler;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_ConfirmedEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_Controller;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_Exception;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_RejectedInformationEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_RequestEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_ResponseEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.IdleProgressInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.OngoingActionID_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.PreUpgradeStateInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressHeaderInformationInterface;
import se.ericsson.cello.upgradepackage.util.enumer.ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ActionRestoreSU_Handler
extends ActionHandler
implements ControllerClientInterface,
Runnable,
PropertyChangeListener {
    private BlockingQueue myRestoreQueue = new BlockingQueue();
    private UpgradePackageMoExtended myRestoreClientInterface = null;

    public ActionRestoreSU_Handler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ActionRestoreSU_Handler");
        }
    }

    public ActionRestoreSU_Handler(UpgradePackageMoExtended upgradePackageMoExtended) {
        this.myRestoreClientInterface = upgradePackageMoExtended;
    }

    public String getDocumentNumberOpt() {
        return this.myRestoreClientInterface.getDocumentNumberOpt();
    }

    public String getDocumentRevisionOpt() {
        return this.myRestoreClientInterface.getDocumentRevisionOpt();
    }

    public void restoreSU(RestoreSU_RequestEvent restoreSU_RequestEvent) throws NoPermissionException, ActionNotAllowedException, RestoreSU_Exception {
        block16: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "aRestoreSU_Event: " + restoreSU_RequestEvent);
            }
            Trace.log1(this.getClass(), "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "Start Action - restoreSU initiated (Action ID: " + restoreSU_RequestEvent.getActionId() + ")" + "\n\tProduct number: " + restoreSU_RequestEvent.getUpgradePackageDocumentNumber() + "\n\tProduct revision: " + restoreSU_RequestEvent.getUpgradePackageDocumentRevision());
            Trace.flushToTraceFile();
            try {
                AccessControlHelper.performAccessControl();
                this.verifyActionNotInvokedOnTheInitUP(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision());
                if (restoreSU_RequestEvent.getPreUpgradeState() == 2) {
                    UpgradeCoordinator.instance().busyMark((ControllerClientInterface)restoreSU_RequestEvent.getSource(), ServiceSubType.restoreSU);
                    int n = restoreSU_RequestEvent.getUpgradePackageMO().createActionId(ActionResultDataTypeOfInvokedActionValue.Install);
                    restoreSU_RequestEvent.setActionId(n);
                    restoreSU_RequestEvent.getUpgradePackageMO().saveActionId(ActionResultDataTypeOfInvokedActionValue.RestoreSU, new Integer(n));
                    this.initiateThread();
                    this.myRestoreQueue.enqueue((Object)restoreSU_RequestEvent);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "End Action - restoreSU initiated (Action ID: " + n + ")\n");
                    }
                    break block16;
                }
                String string = "Not allowed to execute function RestoreSU when not pre upgraded";
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restoreSU (RestoreSU_RequestEvent aRestoreSU_Event)", string + "\n\tPreUpgradeState: " + restoreSU_RequestEvent.getPreUpgradeState());
                }
                throw new RestoreSU_Exception(string);
            }
            catch (NoPermissionException noPermissionException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "NoPermissionException caught when performing access control,\n\tNoPermissionException info: " + (Object)((Object)noPermissionException));
                }
                throw noPermissionException;
            }
            catch (BusyMarkException busyMarkException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "BusyMarkException caught,\n\tBusyMarkException info: " + (Object)((Object)busyMarkException));
                }
                throw busyMarkException;
            }
            catch (ActionNotAllowedException actionNotAllowedException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "ActionNotAllowedException caught,\n\tActionNotAllowedException info: " + (Object)((Object)actionNotAllowedException));
                }
                throw actionNotAllowedException;
            }
            catch (RestoreSU_Exception restoreSU_Exception) {
                throw restoreSU_Exception;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "Throwable caught when trying to execute action restoreSU.\n\taRestoreSU_Event: " + restoreSU_RequestEvent, throwable);
                UpgradeCoordinator.instance().freeMark(this, ServiceSubType.restoreSU);
                throw new RestoreSU_Exception(throwable.toString());
            }
            finally {
                Trace.flushToTraceFile();
            }
        }
    }

    public void restoreSU_Cont(RestoreSU_RequestEvent restoreSU_RequestEvent) throws NoPermissionException, ActionNotAllowedException, RestoreSU_Exception {
        block15: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "restoreSU_Cont(RestoreSU_RequestEvent aRestoreSU_Event)", "aRestoreSU_Event: " + restoreSU_RequestEvent);
            }
            Trace.log1(this.getClass(), "restoreSU(RestoreSU_RequestEvent aRestoreSU_Event)", "RestoreSU initiated (Action ID: " + restoreSU_RequestEvent.getActionId() + ")" + "\n\tProduct number: " + restoreSU_RequestEvent.getUpgradePackageDocumentNumber() + "\n\tProduct revision: " + restoreSU_RequestEvent.getUpgradePackageDocumentRevision());
            Trace.flushToTraceFile();
            try {
                AccessControlHelper.performAccessControl();
                this.verifyActionNotInvokedOnTheInitUP(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision());
                if (restoreSU_RequestEvent.getPreUpgradeState() == 3) {
                    this.initiateThread();
                    this.myRestoreQueue.enqueue((Object)restoreSU_RequestEvent);
                    break block15;
                }
                String string = "Not allowed to execute function RestoreSU when not pre upgraded";
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restoreSU (RestoreSU_RequestEvent aRestoreSU_Event)", string + "\n\tPreUpgradeState: " + restoreSU_RequestEvent.getPreUpgradeState());
                }
                throw new RestoreSU_Exception(string);
            }
            catch (NoPermissionException noPermissionException) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "restoreSU_Cont(RestoreSU_RequestEvent aRestoreSU_Event)", "NoPermissionException caught when performing access control,\n\tNoPermissionException info: " + (Object)((Object)noPermissionException));
                }
                throw noPermissionException;
            }
            catch (BusyMarkException busyMarkException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restoreSU_Cont(RestoreSU_RequestEvent aRestoreSU_Event)", "BusyMarkException caught,\n\tBusyMarkException info: " + (Object)((Object)busyMarkException));
                }
                throw busyMarkException;
            }
            catch (ActionNotAllowedException actionNotAllowedException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restoreSU_Cont(RestoreSU_RequestEvent aRestoreSU_Event)", "ActionNotAllowedException caught,\n\tActionNotAllowedException info: " + (Object)((Object)actionNotAllowedException));
                }
                throw actionNotAllowedException;
            }
            catch (RestoreSU_Exception restoreSU_Exception) {
                throw restoreSU_Exception;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "restoreSU_Cont(RestoreSU_RequestEvent aRestoreSU_Event)", "Throwable caught when trying to execute action restoreSU.\n\taRestoreSU_Event: " + restoreSU_RequestEvent, throwable);
                throw new RestoreSU_Exception(throwable.toString());
            }
            finally {
                Trace.flushToTraceFile();
            }
        }
    }

    public void finished() {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "finished()", "Unexpected call to this method received and ignored.");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent (new value): " + propertyChangeEvent.getNewValue() + "\n\tthis: " + this, false);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof ProgressHeaderInformationInterface) {
                this.myRestoreClientInterface.setProgressHeader((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof PreUpgradeStateInformation) {
                this.myRestoreClientInterface.setPreUpgradeState((PreUpgradeStateInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof SU_DowngradeExecutingEvent) {
                this.myRestoreClientInterface.setPreviousState(this.myRestoreClientInterface.getStateValue());
                this.myRestoreClientInterface.setState((SU_DowngradeExecutingEvent)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof OngoingActionID_Information) {
                OngoingActionID_Information ongoingActionID_Information = (OngoingActionID_Information)propertyChangeEvent.getNewValue();
                this.myRestoreClientInterface.setOngoingActionID(ongoingActionID_Information.getValue());
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent, false);
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught (IGNORED), message: " + throwable, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        RestoreSU_RequestEvent restoreSU_RequestEvent = null;
        RestoreSU_ResponseEvent restoreSU_ResponseEvent = null;
        try {
            try {
                restoreSU_RequestEvent = (RestoreSU_RequestEvent)this.myRestoreQueue.dequeue();
                this.myRestoreClientInterface = restoreSU_RequestEvent.getUpgradePackageMO();
                this.addAsListenerToStatusInformation();
                RestoreSU_Controller restoreSU_Controller = new RestoreSU_Controller();
                restoreSU_ResponseEvent = restoreSU_Controller.restoreSU(restoreSU_RequestEvent);
                if (restoreSU_ResponseEvent instanceof RestoreSU_ConfirmedEvent) {
                    ActionResultHandler.setActionResult((RestoreSU_ConfirmedEvent)restoreSU_ResponseEvent, this.myRestoreClientInterface, ActionResultDataTypeOfInvokedActionValue.RestoreSU);
                } else {
                    ActionResultHandler.setActionResult((RestoreSU_RejectedInformationEvent)restoreSU_ResponseEvent, this.myRestoreClientInterface, ActionResultDataTypeOfInvokedActionValue.RestoreSU);
                }
                if (restoreSU_RequestEvent.getPreviousState() != -1) {
                    this.myRestoreClientInterface.setStateValueNoNotification(restoreSU_RequestEvent.getPreviousState());
                }
                this.myRestoreClientInterface.setProgressHeaderValueNoNotification(new IdleProgressInformation(this).getProgressHeader());
                if (restoreSU_ResponseEvent instanceof RestoreSU_ConfirmedEvent) {
                    ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                    this.deleteSuConvertTables();
                    this.resetWorkingAttributes();
                    String string = configurationVersionMO_HandlerInterface.createDowngradeFinalCV_AndSetStartable(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision());
                    configurationVersionMO_HandlerInterface.deleteDowngradeRollbackCVs(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision(), string);
                }
                this.myRestoreClientInterface.setStateValueOnlyNotification(restoreSU_RequestEvent.getPreviousState());
                this.myRestoreClientInterface.setProgressHeaderValueNotificationOnly(new IdleProgressInformation(this));
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run()", "Throwable caught when trying to execute action restoreSU.\n\ttheRestoreSU_RequestEvent: " + restoreSU_RequestEvent, throwable);
                restoreSU_ResponseEvent = new RestoreSU_RejectedInformationEvent(this, this.myRestoreClientInterface.getOngoingActionID_NoException(), throwable.toString());
                ActionResultHandler.setActionResult(restoreSU_ResponseEvent, this.myRestoreClientInterface, ActionResultDataTypeOfInvokedActionValue.RestoreSU);
                Object var7_8 = null;
                this.removeAsListenerToStatusInformation();
                if (restoreSU_RequestEvent.getPreviousState() != -1) {
                    this.myRestoreClientInterface.setStateValue(restoreSU_RequestEvent.getPreviousState());
                }
                this.myRestoreClientInterface.setProgressHeaderValue(new IdleProgressInformation(this));
                this.resetWorkingAttributes();
                UpgradeCoordinator.instance().freeMark((ControllerClientInterface)((Object)this.myRestoreClientInterface), ServiceSubType.restoreSU);
            }
            Object var7_7 = null;
            this.removeAsListenerToStatusInformation();
            if (restoreSU_RequestEvent.getPreviousState() != -1) {
                this.myRestoreClientInterface.setStateValue(restoreSU_RequestEvent.getPreviousState());
            }
            this.myRestoreClientInterface.setProgressHeaderValue(new IdleProgressInformation(this));
            this.resetWorkingAttributes();
            UpgradeCoordinator.instance().freeMark((ControllerClientInterface)((Object)this.myRestoreClientInterface), ServiceSubType.restoreSU);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.removeAsListenerToStatusInformation();
            if (restoreSU_RequestEvent.getPreviousState() != -1) {
                this.myRestoreClientInterface.setStateValue(restoreSU_RequestEvent.getPreviousState());
            }
            this.myRestoreClientInterface.setProgressHeaderValue(new IdleProgressInformation(this));
            this.resetWorkingAttributes();
            UpgradeCoordinator.instance().freeMark((ControllerClientInterface)((Object)this.myRestoreClientInterface), ServiceSubType.restoreSU);
            throw throwable;
        }
    }

    private void addAsListenerToStatusInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListenerToStatusInformation()");
        }
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.PreUpgradeState, this);
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.State, this);
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.OngoingActionID, this);
    }

    private void initiateThread() {
        new Thread((Runnable)this, "RestoreSU_Handler").start();
    }

    private void removeAsListenerToStatusInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListenerToStatusInformation()");
        }
        ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
        ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.PreUpgradeState, this);
        ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.State, this);
        ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.OngoingActionID, this);
    }

    private void resetWorkingAttributes() {
        try {
            this.myRestoreClientInterface.setOngoingActionID(-1);
            this.myRestoreClientInterface.setPreviousState(-1);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "resetWorkingAttributes()", "Throwable caught", throwable);
        }
    }

    private void deleteSuConvertTables() throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteSuConvertTables()");
        }
        try {
            UpgradeMoDataConverter.deleteSuConvertInfoInTables();
        }
        catch (SuConverterException suConverterException) {
            throw new RestoreSU_Exception("Exception caught when creating SU Convert table.\n\tThrowable: " + suConverterException);
        }
    }
}

