/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.proxy;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.SubrackProdTypeProxyInformation;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.LoadModuleSU_DOM_MoMapInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.PiuTypeProxyInformation;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.PiuTypeSU_DOM_MoMapInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.ProxySelectorException;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.RepertoireProxyInformation;
import se.ericsson.cello.sudom.extsuif.proxy.interfaces.SU_DOM_ListenerInterface;
import se.ericsson.cello.sudom.parser.UpgradeControlFileParserFactory;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.proxy.ProxySelectorInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModulesMoMap;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMosMap;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ProxySelector
implements ProxySelectorInterface,
SU_DOM_ListenerInterface {
    private UpgradePackageMoExtended myUpMo = null;
    private String[] myNeededMainElements = new String[]{"PiuType", "ProductData", "Repertoire", "SubrackProdType", "LoadModule"};
    private DocumentObjectProxyInterface myDocumentObjectProxyInterface = null;
    private int myGenerationCount = 0;
    private PiuTypeMosMap myPiuTypeSU_DOM_MoMap = new PiuTypeMosMap();
    private boolean myIsPiuTypeMapSuccessfullyBuilt = false;
    private LoadModulesMoMap myLoadModuleSU_DOM_MoMap = new LoadModulesMoMap();
    private boolean myIsLoadModuleMapSuccessfullyBuilt = false;

    public ProxySelector(UpgradePackageMoExtended upgradePackageMoExtended) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ProxySelector(UpgradePackageMoExtended anUpMo)", "anUpMo: " + upgradePackageMoExtended);
        }
        this.myUpMo = upgradePackageMoExtended;
        this.prepareSU_DOM_AndMoMaps();
        UpgradeControlFileParserFactory.instance().addAsListener(this);
    }

    public boolean isMAOsDependentOnSU_DOM() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isMAOsDependentOnSU_DOM()");
        }
        try {
            boolean bl = ServiceFinder.getPiuTypeMO_HandlerInterface().isPiuTypeMOsDependentOnSU_DOM();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isMAOsDependentOnSU_DOM()", "Is PiuType MOs dependent on SU DOM: " + bl);
            }
            if (!bl) {
                bl = ServiceFinder.getSubrackProdTypeMO_HandlerInterface().isSubrackProdTypeMOsDependentOnSU_DOM();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isMAOsDependentOnSU_DOM()", "Is SubrackProdType MOs dependent on SU DOM: " + bl);
                }
            }
            if (!bl) {
                bl = ServiceFinder.getRepertoireMO_HandlerInterface().isRepertoireMOsDependentOnSU_DOM();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isMAOsDependentOnSU_DOM()", "Is Repertoire MOs dependent on SU DOM: " + bl);
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isMAOsDependentOnSU_DOM()", "RETURNS - theIsXXX_MOsDependentOnSU_DOM: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isMAOsDependentOnSU_DOM()", "Throwable caught (assuming the SU DOM is needed)", throwable);
            return true;
        }
    }

    public boolean isAllowedToRelease(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isAllowedToRelease(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getUpgradePackageMO_HandlerInterface().getUpgradePackageMo(string, string2);
            if (upgradePackageMoExtended == null || !upgradePackageMoExtended.equals(this.myUpMo)) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "isAllowedToRelease(String aProductNumber, String aProductRevision)", "Allowed to release the SU DOM\n\tmyUpMo: " + this.myUpMo + "\n\ttheUP_SU_DOM_ToBeReleased: " + upgradePackageMoExtended + "\n\tRETURNS - true");
                }
                return true;
            }
            UpgradePackageMoExtended upgradePackageMoExtended2 = ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCurrentUpgradePackage(null);
            if (this.isMAOsDependentOnSU_DOM()) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "isAllowedToRelease(String aProductNumber, String aProductRevision)", "Not allowed to release the SU DOM since MAOS are dependent on SU DOM and it is associated to the current active UP.\n\tmyUpMo: " + this.myUpMo + "\n\ttheActiveUP: " + upgradePackageMoExtended2 + "\n\ttheUP_SU_DOM_ToBeReleased: " + upgradePackageMoExtended + "\n\tRETURNS - false");
                }
                return false;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 21, "isAllowedToRelease(String aProductNumber, String aProductRevision)", "Allowed to release the SU DOM since MAOs are NOT dependent on SU DOM (associated to the current active UP).\n\tmyUpMo: " + this.myUpMo + "\n\ttheActiveUP: " + upgradePackageMoExtended2 + "\n\ttheUP_SU_DOM_ToBeReleased: " + upgradePackageMoExtended + "\n\tRETURNS - true");
            }
            return true;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isAllowedToRelease(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tThrowable caught (returning true)", throwable);
            return true;
        }
    }

    public String[] getMainElementNamesNotAllowedToRelease(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMainElementNamesNotAllowedToRelease(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        String[] stringArray = new String[]{"PiuType", "SubrackProdType", "Repertoire", "ProductData"};
        return stringArray;
    }

    public void reopenSUDOM() throws ProxySelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reopenSUDOM()");
        }
        if (this.myUpMo != null && this.isMAOsDependentOnSU_DOM()) {
            for (int i = 0; i < 1; ++i) {
                try {
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(this.myUpMo.getDocumentNumber(null), this.myUpMo.getDocumentRevision(null), true);
                    DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(this.myUpMo.getDocumentNumber(null), this.myUpMo.getDocumentRevision(null), this.myUpMo.getUpgradeControlFilePath(null), this.myNeededMainElements);
                    documentObjectProxyInterface.getLoadModulesProxyInterface();
                    documentObjectProxyInterface.getPiuTypesProxyInterface();
                    documentObjectProxyInterface.getRepertoiresProxyInterface();
                    documentObjectProxyInterface.getSubrackProdTypesProxyInterface();
                    this.myDocumentObjectProxyInterface = documentObjectProxyInterface;
                    documentObjectProxyInterface = null;
                    this.buildLoadModuleMap();
                    this.buildPiuTypeMap();
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(this.myUpMo.getDocumentNumber(null), this.myUpMo.getDocumentRevision(null));
                    ++this.myGenerationCount;
                    break;
                }
                catch (UpgradeControlFileParserException upgradeControlFileParserException) {
                    Trace.info(this.getClass(), "reopenSUDOM()", "UpgradeControlFileParserException caught: Failed to get a handle to the SU DOM - retrying within 3 seconds (will retry total 3 times)\n\tUpgradeControlFileParserException: " + upgradeControlFileParserException + "\n\tmyUpMo: " + this.myUpMo);
                    Timer.sleep(3000);
                    continue;
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "reopenSUDOM()", "Throwable caught: Failed to get a handle to the SU DOM - retrying within 3 seconds (will retry total 1 times)\n\tmyUpMo: " + this.myUpMo);
                    Timer.sleep(3000);
                }
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "reopenSUDOM()", "No current active UP exists i.e. no SU DOM will be prepared");
        }
    }

    private void prepareSU_DOM_AndMoMaps() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareSU_DOM_AndMoMaps()");
        }
        if (this.myUpMo != null && this.isMAOsDependentOnSU_DOM()) {
            this.defineSU_DOM_AndMoMaps();
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "prepareSU_DOM_AndMoMaps(boolean anOverrideMAOsDependentOnSU_DOM)", "No current active UP exists i.e. no SU DOM will be prepared");
        }
    }

    private synchronized void defineSU_DOM_AndMoMaps() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "defineSU_DOM_AndMoMaps()");
        }
        for (int i = 0; i < 2; ++i) {
            try {
                this.myDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElements(this.myUpMo.getDocumentNumber(null), this.myUpMo.getDocumentRevision(null), this.myUpMo.getUpgradeControlFilePath(null), this.myNeededMainElements);
                this.myDocumentObjectProxyInterface.getLoadModulesProxyInterface();
                this.myDocumentObjectProxyInterface.getPiuTypesProxyInterface();
                this.myDocumentObjectProxyInterface.getRepertoiresProxyInterface();
                this.myDocumentObjectProxyInterface.getSubrackProdTypesProxyInterface();
                this.buildLoadModuleMap();
                this.buildPiuTypeMap();
                ++this.myGenerationCount;
                break;
            }
            catch (UpgradeControlFileParserException upgradeControlFileParserException) {
                Trace.info(this.getClass(), "defineSU_DOM_AndMoMaps()", "UpgradeControlFileParserException caught: Failed to get a handle to the SU DOM - retrying within 3 seconds (will retry total 2 times)\n\tUpgradeControlFileParserException: " + upgradeControlFileParserException);
                Timer.sleep(3000);
                continue;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "defineSU_DOM_AndMoMaps()", "Throwable caught: Failed to get a handle to the SU DOM - retrying within 3 seconds (will retry total 2 times)");
                Timer.sleep(3000);
            }
        }
    }

    private boolean buildPiuTypeMap() {
        block14: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "buildPiuTypeMap()");
            }
            try {
                if (this.myDocumentObjectProxyInterface != null) {
                    Set set = this.myDocumentObjectProxyInterface.getPiuTypesProxyInterface().getPiuTypeKeys();
                    Collection collection = ServiceFinder.getPiuTypeMO_HandlerInterface().getAllPiuTypeMOs();
                    Iterator iterator = collection.iterator();
                    PiuTypeMoSU_Access piuTypeMoSU_Access = null;
                    if (this.myPiuTypeSU_DOM_MoMap != null) {
                        this.myPiuTypeSU_DOM_MoMap.clear();
                    }
                    this.myPiuTypeSU_DOM_MoMap = new PiuTypeMosMap();
                    if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                        while (iterator.hasNext()) {
                            piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                            if (set.contains(piuTypeMoSU_Access.getProductNumberOpt(null) + "_" + piuTypeMoSU_Access.getProductRevisionOpt(null))) {
                                this.myPiuTypeSU_DOM_MoMap.put(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null), piuTypeMoSU_Access);
                                continue;
                            }
                            if (!Trace.valid(this.getClass(), 20)) continue;
                            Trace.debug(this.getClass(), 20, "buildPiuTypeMap()", "Not added to the piuType Map\n\tthePiuTypeMo.getProductNumber(null): " + piuTypeMoSU_Access.getProductNumberOpt(null) + "\n\tthePiuTypeMo.getProductRevision(null): " + piuTypeMoSU_Access.getProductRevisionOpt(null));
                        }
                    } else {
                        String string = null;
                        String string2 = null;
                        while (iterator.hasNext()) {
                            piuTypeMoSU_Access = (PiuTypeMoSU_Access)iterator.next();
                            string = StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null));
                            string2 = StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null));
                            if (set.contains(string + "_" + string2)) {
                                this.myPiuTypeSU_DOM_MoMap.put(string, string2, piuTypeMoSU_Access);
                                continue;
                            }
                            if (!Trace.valid(this.getClass(), 20)) continue;
                            Trace.debug(this.getClass(), 20, "buildPiuTypeMap()", "Not added to the piuType Map (old PiuType Mo)\n\ttheOptProdNo: " + string + "\n\ttheOptProdRev: " + string2);
                        }
                    }
                    this.myIsPiuTypeMapSuccessfullyBuilt = true;
                    break block14;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "buildPiuTypeMap()", "No MoMaps is built since no SU DOM exists");
                }
                this.myIsPiuTypeMapSuccessfullyBuilt = false;
            }
            catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
                Trace.info(this.getClass(), "buildPiuTypeMap()", "Failed to build up the Map for the Mo type PiuType");
                this.myIsPiuTypeMapSuccessfullyBuilt = false;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "buildPiuTypeMap()", "Failed to build up the Map for the Mo types PiuType", throwable);
                this.myIsPiuTypeMapSuccessfullyBuilt = false;
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "buildPiuTypeMap()", "RETURNS - myIsPiuTypeMapSuccessfullyBuilt" + this.myIsPiuTypeMapSuccessfullyBuilt + "\n\tmyPiuTypeSU_DOM_MoMap: " + this.myPiuTypeSU_DOM_MoMap);
        }
        return this.myIsPiuTypeMapSuccessfullyBuilt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildLoadModuleMap() {
        block16: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "buildLoadModuleMap()");
            }
            try {
                if (this.myDocumentObjectProxyInterface != null) {
                    Set set = this.myDocumentObjectProxyInterface.getLoadModulesProxyInterface().getLoadModuleKeys();
                    Collection collection = ServiceFinder.getLoadModuleMO_HandlerInterface().getAllLoadModuleMOs();
                    Iterator iterator = collection.iterator();
                    LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                    if (this.myLoadModuleSU_DOM_MoMap != null) {
                        this.myLoadModuleSU_DOM_MoMap.clear();
                    }
                    this.myLoadModuleSU_DOM_MoMap = new LoadModulesMoMap();
                    if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                        while (iterator.hasNext()) {
                            loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                            if (!set.contains(loadModuleMoSU_Access.getProductNumberOpt(null) + "_" + loadModuleMoSU_Access.getProductRevisionOpt(null))) continue;
                            this.myLoadModuleSU_DOM_MoMap.put(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null), loadModuleMoSU_Access);
                        }
                    } else {
                        String string = null;
                        String string2 = null;
                        while (iterator.hasNext()) {
                            loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                            string = StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null));
                            string2 = StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null));
                            if (!set.contains(string + "_" + string2)) continue;
                            this.myLoadModuleSU_DOM_MoMap.put(string, string2, loadModuleMoSU_Access);
                        }
                    }
                    this.myIsLoadModuleMapSuccessfullyBuilt = true;
                    break block16;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "buildLoadModuleMap()", "No MoMaps is built since no SU DOM exists");
                }
                this.myIsLoadModuleMapSuccessfullyBuilt = false;
            }
            catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
                Trace.info(this.getClass(), "buildLoadModuleMap()", "Failed to build up the Map for the Mo type LoadModule");
                this.myIsLoadModuleMapSuccessfullyBuilt = false;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "buildLoadModuleMap()", "Failed to build up the Map for the Mo type LoadModule", throwable);
                this.myIsLoadModuleMapSuccessfullyBuilt = false;
            }
            finally {
                this.myDocumentObjectProxyInterface.clearLoadModulesProxyInterface();
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "buildLoadModuleMap()", "RETURNS - myIsLoadModuleMapSuccessfullyBuilt" + this.myIsLoadModuleMapSuccessfullyBuilt + "\n\tmyLoadModuleSU_DOM_MoMap: " + this.myLoadModuleSU_DOM_MoMap);
        }
        return this.myIsLoadModuleMapSuccessfullyBuilt;
    }

    public synchronized PiuTypeSU_DOM_MoMapInterface getPiuTypeSU_DOM_MoMapInterface() throws ProxySelectorException {
        if (this.myIsPiuTypeMapSuccessfullyBuilt) {
            return this.myPiuTypeSU_DOM_MoMap;
        }
        if (this.buildPiuTypeMap()) {
            return this.myPiuTypeSU_DOM_MoMap;
        }
        throw new ProxySelectorException("Failed to build the PiuTypeSU_DOM_MoMapInterface");
    }

    public synchronized LoadModuleSU_DOM_MoMapInterface getLoadModuleSU_DOM_MoMapInterface() throws ProxySelectorException {
        if (this.myIsLoadModuleMapSuccessfullyBuilt) {
            return this.myLoadModuleSU_DOM_MoMap;
        }
        if (this.buildLoadModuleMap()) {
            return this.myLoadModuleSU_DOM_MoMap;
        }
        throw new ProxySelectorException("Failed to build the LoadModuleSU_DOM_MoMapInterface");
    }

    public UpgradePackageMoExtended getUpgradePackageMo() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageMo()");
        }
        return this.myUpMo;
    }

    public void setUpgradePackageMo(UpgradePackageMoExtended upgradePackageMoExtended) throws ProxySelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setUpgradePackageMo(UpgradePackageMoExtended anUP_Mo)", "anUP_Mo: " + upgradePackageMoExtended);
        }
        try {
            UpgradePackageMoExtended upgradePackageMoExtended2 = this.myUpMo;
            this.myUpMo = upgradePackageMoExtended;
            UpgradeDB_StorageUtil.saveNewActiveUP_ProductNumber(this.myUpMo.getDocumentNumber(null));
            UpgradeDB_StorageUtil.saveNewActiveUP_ProductRevision(this.myUpMo.getDocumentRevision(null));
            this.prepareSU_DOM_AndMoMaps();
            if (upgradePackageMoExtended2 != null) {
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(upgradePackageMoExtended2.getDocumentNumber(null), upgradePackageMoExtended2.getDocumentRevision(null));
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setUpgradePackageMo(UpgradePackageMoExtended anUP_Mo)", "Throwable caught", throwable);
            throw new ProxySelectorException(throwable.toString());
        }
    }

    public void prepareFirstTime(UpgradePackageMoExtended upgradePackageMoExtended) throws ProxySelectorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareFirstTime(UpgradePackageMoExtended anUP_Mo)", "anUP_Mo: " + upgradePackageMoExtended);
        }
        try {
            boolean bl = this.isMAOsDependentOnSU_DOM();
            if (upgradePackageMoExtended != null && !bl) {
                this.myUpMo = upgradePackageMoExtended;
                this.defineSU_DOM_AndMoMaps();
                Trace.log1(this.getClass(), "prepareFirstTime(UpgradePackageMoExtended anUP_Mo)", "Proxy selector up and running where SU DOM has been prepared for UP: " + this.myUpMo);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "prepareFirstTime(UpgradePackageMoExtended anUP_Mo)", "No preparation needed since UDT configured in FROM state\n\tmyUpMo: " + this.myUpMo + "\n\ttheIsMAOsDependentOnSU_DOM: " + bl);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "prepareFirstTime(UpgradePackageMoExtended anUP_Mo)", "Throwable caught", throwable);
            throw new ProxySelectorException(throwable.toString());
        }
    }

    public PiuTypeProxyInformation getPiuTypeReadProxyInterface(String string, String string2, PiuTypeProxyInformation piuTypeProxyInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeReadProxyInterface(String aProductNumber, String aRevision, PiuTypeProxyInformation aPiuTypeProxyInformation)", "aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\taPiuTypeProxyInformation: " + piuTypeProxyInformation);
        }
        if (this.myDocumentObjectProxyInterface != null && piuTypeProxyInformation != null && piuTypeProxyInformation.getGenerationCount() == this.myGenerationCount && piuTypeProxyInformation.getPiuTypeReadProxyInterface() != null) {
            return piuTypeProxyInformation;
        }
        return this.getPiuTypeReadProxyInterface(string, string2);
    }

    private PiuTypeProxyInformation getPiuTypeReadProxyInterface(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeReadProxyInterface(String aProductNumber, String aRevision)", "aProductNumber: " + string + "\n\taRevision: " + string2);
        }
        if (this.myDocumentObjectProxyInterface == null) {
            Trace.log1(this.getClass(), "getPiuTypeReadProxyInterface(String aProductNumber, String aRevision)", "No handle to SU DOM (this is not a normal case i.e. trying to get a handle)");
            this.prepareSU_DOM_AndMoMaps();
        }
        return new PiuTypeProxyInformation(this.myDocumentObjectProxyInterface.getPiuTypesProxyInterface().getPiuTypeProxyInterface(string, string2), this.myGenerationCount);
    }

    private SubrackProdTypeProxyInformation getSubrackProdTypeReadProxyInterface(String string, String string2) {
        if (this.myDocumentObjectProxyInterface == null) {
            Trace.log1(this.getClass(), "getSubrackProdTypeTypeReadProxyInterface(String aProductNumber, String aRevision)", "No handle to SU DOM (this is not a normal case i.e. trying to get a handle)");
            this.prepareSU_DOM_AndMoMaps();
        }
        return new SubrackProdTypeProxyInformation(this.myDocumentObjectProxyInterface.getSubrackProdTypesProxyInterface().getSubrackProdTypeProxyInterface(string, string2), this.myGenerationCount);
    }

    public SubrackProdTypeProxyInformation getSubrackProdTypeReadProxyInterface(String string, String string2, SubrackProdTypeProxyInformation subrackProdTypeProxyInformation) {
        if (this.myDocumentObjectProxyInterface != null && subrackProdTypeProxyInformation != null && subrackProdTypeProxyInformation.getGenerationCount() == this.myGenerationCount && subrackProdTypeProxyInformation.getSubrackProdTypeReadProxyInterface() != null) {
            return subrackProdTypeProxyInformation;
        }
        return this.getSubrackProdTypeReadProxyInterface(string, string2);
    }

    public RepertoireProxyInformation getRepertoireReadProxyInterface(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireReadProxyInterface(String aRepertoireName)", "aRepertoireName: " + string);
        }
        if (this.myDocumentObjectProxyInterface == null) {
            Trace.log1(this.getClass(), "getRepertoireReadProxyInterface(String aRepertoireName)", "No handle to SU DOM (this is not a normal case i.e. trying to get a handle)");
            this.prepareSU_DOM_AndMoMaps();
        }
        return new RepertoireProxyInformation(this.myDocumentObjectProxyInterface.getRepertoiresProxyInterface().getRepertoireProxyInterface(string), this.myGenerationCount);
    }

    public RepertoireProxyInformation getRepertoireReadProxyInterface(String string, RepertoireProxyInformation repertoireProxyInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireReadProxyInterface(String aRepertoireName, RepertoireProxyInformation aRepertoireProxyInformation)", "aRepertoireName: " + string + "\n\taRepertoireProxyInformation: " + repertoireProxyInformation);
        }
        if (this.myDocumentObjectProxyInterface != null && repertoireProxyInformation != null && repertoireProxyInformation.getGenerationCount() == this.myGenerationCount && repertoireProxyInformation.getRepertoireReadProxyInterface() != null) {
            return repertoireProxyInformation;
        }
        return this.getRepertoireReadProxyInterface(string);
    }

    public String toString() {
        return "\n\tClass Name: " + this.getClass().getName() + "\n\tmyUpMo: " + this.myUpMo + "\n\tmyDocumentObjectProxyInterface: " + this.myDocumentObjectProxyInterface + "\n\tmyGenerationCount: " + this.myGenerationCount;
    }
}

