/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade;

import se.ericsson.cello.configurationversion.service.ConfigurationServiceFacade;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.ConfigurationServiceClientInterface;

public class ConfigurationServiceHandler
implements Runnable {
    private ConfigurationServiceClientInterface myConfigurationServiceClientInterface = null;
    public static final int INSTALL = 1;
    public static final int UPGRADE = 2;
    public static final int RESTORESU = 3;
    public static final int DELETE_RESTORESU = 4;
    public static final int VERIFY = 5;
    private int myService = -1;

    public ConfigurationServiceHandler(ConfigurationServiceClientInterface configurationServiceClientInterface, int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ConfigurationServiceHandler(ConfigurationServiceClientInterface aConfigurationServiceClientInterface, int aService)", "aConfigurationServiceClientInterface: " + configurationServiceClientInterface + "\n\taService: " + n);
        }
        this.myConfigurationServiceClientInterface = configurationServiceClientInterface;
        this.myService = n;
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run ( )");
        }
        String string = "Upgrade";
        ServiceSubType serviceSubType = ServiceSubType.upgrade;
        if (this.myService == 1) {
            string = "Install";
            serviceSubType = ServiceSubType.install;
        } else if (this.myService == 3) {
            string = "RestoreSU";
            serviceSubType = ServiceSubType.restoreSU;
        } else if (this.myService == 4) {
            string = "Delete UP with RestoreSU";
            serviceSubType = ServiceSubType.deleteUP;
        } else if (this.myService == 5) {
            string = "Verify UP";
            serviceSubType = ServiceSubType.verifyUpgrade;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run()", "The execution of the ongoing " + string + " proceeds when the Configuration Service has been started (registered).");
        }
        try {
            ConfigurationServiceFacade.getConfigurationServiceInterface().waitForCS();
            if (this.myService == 2) {
                this.myConfigurationServiceClientInterface.proceedWithUpgrade();
            } else if (this.myService == 1) {
                this.myConfigurationServiceClientInterface.proceedWithInstall();
            } else if (this.myService == 3) {
                this.myConfigurationServiceClientInterface.proceedWithRestoreSU();
            } else if (this.myService == 4) {
                this.myConfigurationServiceClientInterface.proceedWithDeleteRestoreSU();
            } else if (this.myService == 5) {
                this.myConfigurationServiceClientInterface.proceedWithVerify();
            } else {
                Trace.error(this.getClass(), "run()", "Unexpected service: " + this.myService);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "start ( )", "Throwable caught when trying to lock up the Configuration Service from the name server.\n\tThe upgrade execution will be rollbacked to the created rollback CV.", throwable);
            UpgradeCoordinator.instance().unlock(serviceSubType);
        }
        Trace.flushToTraceFile();
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "New THREAD handling the configuration service is going to be STOPPED.");
        }
        Trace.flushToTraceFile();
    }
}

