/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.parser.initialize;

import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageAttributeName;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageAttributeValue;
import se.ericsson.cello.sudom.parser.dom.upcompatibilityindex.UP_CompatibilityIndexAttributeName;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.parser.UpgradePackageSAXdh;
import se.ericsson.cello.upgradepackage.upgrade.parser.initialize.VerifyParserListenerInterface;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeVerifyData;

public class InitializeSAXdh
extends UpgradePackageSAXdh {
    private static final String FAKE_LEGAL_UP_SRC_PATH = "/home/user/sax/upCtrl.xml";
    private String currentUpProdNo;
    private String currentUpProdRev;
    private String currentUpCompatibilityIndex;
    private String oldUpProdNo;
    private String oldUpProdRev;
    private String oldUpCompatibilityIndex;
    private Vector caseList = new Vector(2);
    private Vector seqCaseList = new Vector(2);
    private Vector allSeqCases = new Vector(1);
    private Vector softReboot = new Vector(2);
    private Vector softHard = new Vector(4);
    private String seqLabel;
    private String seqInfo;
    private String confDline;
    private String errorEsc;
    private Vector seqLabelList = new Vector(4);
    private Vector confirmTimer = new Vector(4);
    private Vector seqInfoList = new Vector(4);
    private Vector instantRollbackErrorEsc = new Vector(4);
    private boolean finishMarkerFound = false;
    private boolean seqStored = false;
    private UpgradePackageAttributeValue myUP_Type = null;
    private VerifyParserListenerInterface myVerifyParserListenerInterface;
    private AttributeListImpl prodDataUp = new AttributeListImpl();
    private AttributeListImpl installUp = new AttributeListImpl();

    public InitializeSAXdh(String string, VerifyParserListenerInterface verifyParserListenerInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "InitializeSAXdh( String aCurrentUpCompatibilityIndex, VerifyParserListenerInterface aVerifyParserListenerInterface )", "aCurrentUpCompatibilityIndex: " + string + "\n\taVerifyParserListenerInterface: " + verifyParserListenerInterface);
        }
        this.currentUpProdNo = null;
        this.currentUpProdRev = null;
        this.currentUpCompatibilityIndex = string;
        this.myVerifyParserListenerInterface = verifyParserListenerInterface;
    }

    public InitializeSAXdh(String string, String string2, VerifyParserListenerInterface verifyParserListenerInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "InitializeSAXdh( String aCurrentUpProdNo, String aCurrentUpProdRev, VerifyParserListenerInterface aVerifyParserListenerInterface )", "aCurrentUpProdNo: " + string + "\n\taCurrentUpProdRev: " + string2 + "\n\taVerifyParserListenerInterface: " + verifyParserListenerInterface);
        }
        this.currentUpProdNo = string;
        this.currentUpProdRev = string2;
        this.currentUpCompatibilityIndex = null;
        this.myVerifyParserListenerInterface = verifyParserListenerInterface;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startElement ( String elementname, AttributeList atts )", "elementname: " + string + "\n\tatts: " + attributeList);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "startElement ( String elementname, AttributeList atts )", "Start element.\n\tParse state: " + this.parseState);
        }
        if (this.parseState == 0) {
            if (string.equalsIgnoreCase("UpgradePackage")) {
                object = new AttributeListImpl(attributeList);
                String string2 = ((AttributeListImpl)object).getValue(UpgradePackageAttributeName.Type.getValue());
                if (string2 != null && string2.equals(UpgradePackageAttributeValue.Delta.getValue())) {
                    this.myUP_Type = UpgradePackageAttributeValue.Delta;
                }
                this.parseState = 20;
            }
            if (string.equalsIgnoreCase("UpgradeWindow")) {
                this.parseState = 70;
            }
            if (string.equalsIgnoreCase("UpgradeSequence")) {
                this.parseState = 100;
            }
        }
        if (this.parseState == 20 && string.equalsIgnoreCase("ProductData")) {
            this.prodDataUp = new AttributeListImpl(attributeList);
            this.parseState = 30;
        }
        if (this.parseState == 30 && string.equalsIgnoreCase("InstallUP")) {
            this.installUp = new AttributeListImpl(attributeList);
            this.installUp = this.calcAbsoluteUpPaths(this.installUp, this.prodDataUp, FAKE_LEGAL_UP_SRC_PATH);
            this.parseState = 0;
        }
        if (this.parseState == 70 && string.equalsIgnoreCase("OldUpgradePackage")) {
            this.parseState = 80;
        }
        if (this.parseState == 80) {
            if (string.equalsIgnoreCase("ProductData") && this.currentUpProdNo != null) {
                this.oldUpProdNo = attributeList.getValue("number");
                this.oldUpProdRev = attributeList.getValue("revision");
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "startElement ( String elementname, AttributeList atts )", "Product No (old parsed): " + this.oldUpProdNo + "\n\tProduct Rev (old parsed): " + this.oldUpProdRev + "\nProduct No (current UP): " + this.currentUpProdNo + "\n\tProduct Rev (current UP): " + this.currentUpProdRev);
                }
                this.parseState = StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(this.oldUpProdNo + this.oldUpProdRev, this.currentUpProdNo + this.currentUpProdRev) ? 90 : 70;
            } else if (string.equalsIgnoreCase("UpCompatibilityIndex") && this.currentUpCompatibilityIndex != null) {
                this.oldUpCompatibilityIndex = attributeList.getValue(UP_CompatibilityIndexAttributeName.Index.getValue());
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "startElement ( String elementname, AttributeList atts )", "Compatibility Level (old parsed): " + this.oldUpCompatibilityIndex + "\nCompatibility Level (current UP): " + this.currentUpCompatibilityIndex);
                }
                this.parseState = this.currentUpCompatibilityIndex.equals(this.oldUpCompatibilityIndex) ? 90 : 70;
            }
        }
        if (this.parseState == 90 && string.equalsIgnoreCase("UpgradeCase")) {
            this.caseList.addElement(attributeList.getValue("case"));
            object = attributeList.getValue("type");
            if (object != null) {
                if (!((String)object).equalsIgnoreCase("soft") && !((String)object).equalsIgnoreCase("rebootNode")) {
                    Trace.error(this.getClass(), "startElement ( String elementname, AttributeList atts )", "Error in parsing type inside 'UpgradeCase'. Wrong value: " + (String)object);
                    throw new SAXException("Error in parsing type inside UpgradeCase. Wrong value: " + (String)object);
                }
                this.softReboot.addElement(object);
            } else {
                this.softReboot.addElement("");
            }
        }
        if (this.parseState != 100) return;
        if (string.equalsIgnoreCase("UpgradeSequence")) {
            this.seqLabel = attributeList.getValue("label");
            this.seqInfo = attributeList.getValue("information");
            this.confDline = attributeList.getValue("confirmWatchdogTimeOut");
            this.errorEsc = attributeList.getValue("errorEscalation");
            this.seqStored = false;
        }
        if (!string.equalsIgnoreCase("UpgradeCaseRef")) return;
        int n = InitializeSAXdh.findElementInVector(attributeList.getValue("case"), this.caseList);
        if (n == -1) return;
        if (this.seqStored) {
            this.softHard.setElementAt("", this.softHard.size() - 1);
            if (!Trace.valid(this.getClass(), 22)) return;
            Trace.debug(this.getClass(), 22, "startElement ( String elementname, AttributeList atts )", "elementname: " + string + "\nIgnoring this matching case since this sequence already has been selected," + "\nUpgradeSequence label: " + this.seqLabel + "\nmatching case when selected: " + (String)this.seqCaseList.lastElement() + "\nthis matching case: " + attributeList.getValue("case"));
            return;
        }
        if (InitializeSAXdh.findInList(this.seqLabel, this.seqLabelList)) {
            Trace.error(this.getClass(), "startElement ( String elementname, AttributeList atts )", "Error due to label is not unique: " + this.seqLabel);
            throw new SAXException("Label is not unique" + this.seqLabel);
        }
        this.seqLabelList.addElement(this.seqLabel);
        this.seqInfoList.addElement(this.seqInfo);
        this.confirmTimer.addElement(this.confDline);
        this.instantRollbackErrorEsc.addElement(this.errorEsc);
        this.softHard.addElement(this.softReboot.elementAt(n));
        this.seqCaseList.addElement(this.caseList.elementAt(n));
        this.seqStored = true;
    }

    public void endElement(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "endElement ( String elementname )", "elementname: " + string);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "endElement ( String elementname )", "End element.\n\tParse state: " + this.parseState);
        }
        if (this.parseState == 90 | this.parseState == 80 && string.equalsIgnoreCase("OldUpgradePackage")) {
            this.parseState = 70;
        }
        if (this.parseState == 70 && string.equalsIgnoreCase("UpgradeWindow")) {
            if (this.caseList.size() == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "endElement ( String elementname )", "CaseList Empty");
                }
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "endElement ( String elementname )", "Upgrade Cases caseList:");
                }
                for (int i = 0; i < this.caseList.size(); ++i) {
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "endElement ( String elementname )", "\n\t" + (String)this.caseList.elementAt(i));
                }
            }
            this.parseState = 0;
        }
        if (this.parseState == 100 && string.equalsIgnoreCase("UpgradeSequence")) {
            if (!this.seqCaseList.isEmpty()) {
                this.allSeqCases.addElement(this.seqCaseList.clone());
            }
            this.seqCaseList = new Vector(2);
            this.parseState = 0;
        }
        if (string.equalsIgnoreCase("UpgradePackage")) {
            this.finishMarkerFound = true;
        }
    }

    public void endDocument() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "endDocument()");
        }
        this.doBeforeExit();
        if (!this.finishMarkerFound) {
            this.parseState = 200;
        }
        super.endDocument();
    }

    private void doBeforeExit() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doBeforeExit()");
        }
        if (this.myUP_Type != null && this.myUP_Type.getValue().equals(UpgradePackageAttributeValue.Delta.getValue()) || this.seqLabelList.isEmpty()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doBeforeExit()", "No valid Upgrade Window found.\n\tmyUP_Type: " + this.myUP_Type + "\n\tseqLabelList: " + this.seqLabelList);
            }
            this.myVerifyParserListenerInterface.verifyUpgradeWindowResponse(null);
            return;
        }
        int n = this.seqLabelList.size();
        UpgradeVerifyData[] upgradeVerifyDataArray = new UpgradeVerifyData[n];
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "doBeforeExit()", "Sequences found:");
        }
        for (int i = 0; i < n; ++i) {
            upgradeVerifyDataArray[i] = new UpgradeVerifyData();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doBeforeExit()", "Label: " + this.seqLabelList.elementAt(i) + "Info: " + this.seqInfoList.elementAt(i) + "Confiorm timer: " + this.confirmTimer.elementAt(i));
            }
            upgradeVerifyDataArray[i].instantRollbackErrorEscalation = !"tolerateErrors".equalsIgnoreCase((String)this.instantRollbackErrorEsc.elementAt(i));
            upgradeVerifyDataArray[i].sequenceLabel = (String)this.seqLabelList.elementAt(i);
            upgradeVerifyDataArray[i].sequenceInfo = (String)this.seqInfoList.elementAt(i);
            upgradeVerifyDataArray[i].confirmTimer = (String)this.confirmTimer.elementAt(i);
            upgradeVerifyDataArray[i].isSoftSequence = ((String)this.softHard.elementAt(i)).equalsIgnoreCase("soft");
            upgradeVerifyDataArray[i].seqCaseLabel = (Vector)this.allSeqCases.elementAt(i);
        }
        this.myVerifyParserListenerInterface.verifyUpgradeWindowResponse(upgradeVerifyDataArray);
    }
}

