/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.classloader.DynClassPathException;
import se.ericsson.cello.su.classloader.DynamicClassLoaderCentral;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.util.javaheap.JavaHeapHelper;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequencesProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.UpgradeClientInterface;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.JvmUpdateHandlerException;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.MoppletDynamicInformation;
import se.ericsson.cello.upgradepackage.upgrade.step.softjvmupgrade.DynamicClassLoaderHelper;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public final class JvmUpdateHandler {
    public JvmUpdateHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "JvmUpdateHandler()");
        }
    }

    public ManagedObject[] generateJvmClasspath(String string, Vector vector, Vector vector2, boolean bl, UpgradePackageMoImpl upgradePackageMoImpl) throws MoAccessException, Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "generateJvmClasspath(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, UpgradePackageMoImpl anUpgradePackageMO)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\tanIsForcedMoppletUsage: " + bl + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl);
        }
        if (string == null) {
            string = "Old";
        }
        ManagedObject[] managedObjectArray = this.createAdmClasspath(string, upgradePackageMoImpl);
        ManagedObject[] managedObjectArray2 = this.doAddAndRemoveLm(managedObjectArray, vector, vector2, string, bl, upgradePackageMoImpl);
        return managedObjectArray2;
    }

    public void loadUnloadAUEsInDynamicClassPath(String string, Vector vector, Vector vector2, UpgradePackageMoImpl upgradePackageMoImpl, boolean bl) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadUnloadAUEsInDynamicClassPath(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanIsForcedMoppletUsage: " + bl);
        }
        try {
            Object object;
            LinkedList linkedList = this.getLMsToBeRemovedFromDynamicClassPath(vector2, upgradePackageMoImpl);
            boolean bl2 = false;
            if (string != null && string.equalsIgnoreCase("New")) {
                bl2 = true;
                DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(upgradePackageMoImpl);
                linkedList = new LinkedList();
            }
            Vector vector3 = new Vector(0);
            if (!bl) {
                object = this.getLMsToBeLoadedAsDynamicAndMopplets(upgradePackageMoImpl, vector, bl2);
                vector3 = ((MoppletDynamicInformation)object).getDynamicClasses();
            }
            if (!vector3.isEmpty() || !linkedList.isEmpty()) {
                object = ServiceFinder.getLoadModuleMO_HandlerInterface();
                this.loadUnloadAUEsInDynamicClassPath(linkedList, upgradePackageMoImpl, vector3, (LoadModuleMO_HandlerInterface)object);
            }
        }
        catch (DynClassPathException dynClassPathException) {
            throw new SAXException(dynClassPathException.toString());
        }
        catch (SAXException sAXException) {
            Trace.error(this.getClass(), "loadUnloadAUEsInDynamicClassPath(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanIsForcedMoppletUsage: " + bl + "\n\tSAXException caught", sAXException);
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "loadUnloadAUEsInDynamicClassPath(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanIsForcedMoppletUsage: " + bl + "\n\tThrowable caught", throwable);
            throw new SAXException(throwable.toString());
        }
    }

    public boolean updateJvmDynamicClassPathAndJavaHeap(String string, Vector vector, Vector vector2, Integer n, UpgradePackageMoImpl upgradePackageMoImpl, boolean bl, boolean bl2) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\taNewJavaHeapSize: " + n + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanIsForcedMoppletUsage: " + bl + "\n\tanIsNodeOrPiuRestartRequested: " + bl2);
        }
        try {
            Collection collection = this.getLMsToBeRemovedFromDynamicClassPath(vector2, upgradePackageMoImpl);
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            boolean bl3 = false;
            if (!bl) {
                if (string != null && string.equalsIgnoreCase("New")) {
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "Attribute baseClassPath has been set to 'new'.");
                    }
                    MoppletDynamicInformation moppletDynamicInformation = this.getLMsToBeLoadedAsDynamicAndMopplets(upgradePackageMoImpl, vector, true);
                    DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(upgradePackageMoImpl);
                    this.addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(collection, upgradePackageMoImpl, moppletDynamicInformation.getDynamicClasses(), loadModuleMO_HandlerInterface);
                    this.updateClassPathAndJavaHeap(string, moppletDynamicInformation.getAddJavaLM_List(), vector2, n, upgradePackageMoImpl);
                    bl3 = true;
                } else if (this.isJavaHeapToBeChanged(n)) {
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "Java heap size is to be changed.");
                    }
                    MoppletDynamicInformation moppletDynamicInformation = this.getLMsToBeLoadedAsDynamicAndMopplets(upgradePackageMoImpl, vector, false);
                    this.addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(collection, upgradePackageMoImpl, moppletDynamicInformation.getDynamicClasses(), loadModuleMO_HandlerInterface);
                    this.updateClassPathAndJavaHeap(string, moppletDynamicInformation.getAddJavaLM_List(), vector2, n, upgradePackageMoImpl);
                    bl3 = true;
                } else if (this.isLMs_ToBeRemovedFromClassPath(vector2, string, upgradePackageMoImpl)) {
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "LM(s) needs to be removed from the class path.");
                    }
                    MoppletDynamicInformation moppletDynamicInformation = this.getLMsToBeLoadedAsDynamicAndMopplets(upgradePackageMoImpl, vector, false);
                    this.addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(collection, upgradePackageMoImpl, moppletDynamicInformation.getDynamicClasses(), loadModuleMO_HandlerInterface);
                    this.updateClassPathAndJavaHeap(string, moppletDynamicInformation.getAddJavaLM_List(), vector2, n, upgradePackageMoImpl);
                    bl3 = true;
                } else {
                    MoppletDynamicInformation moppletDynamicInformation = this.getLMsToBeLoadedAsDynamicAndMopplets(upgradePackageMoImpl, vector, false);
                    if (!moppletDynamicInformation.getAddJavaLM_List().isEmpty()) {
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "LM(s) needs to be added to the class path.");
                        }
                        this.addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(collection, upgradePackageMoImpl, moppletDynamicInformation.getDynamicClasses(), loadModuleMO_HandlerInterface);
                        this.updateClassPathAndJavaHeap(string, moppletDynamicInformation.getAddJavaLM_List(), vector2, n, upgradePackageMoImpl);
                        bl3 = true;
                    } else if (!moppletDynamicInformation.getDynamicClasses().isEmpty() || !collection.isEmpty()) {
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "LM(s) needs to be added and/or removed from dynamic class path.");
                        }
                        if (!bl2) {
                            this.loadUnloadAUEsInDynamicClassPath(collection, upgradePackageMoImpl, moppletDynamicInformation.getDynamicClasses(), loadModuleMO_HandlerInterface);
                        } else {
                            this.addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(collection, upgradePackageMoImpl, moppletDynamicInformation.getDynamicClasses(), loadModuleMO_HandlerInterface);
                        }
                    } else if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "No change in class path, dynamic class or java heap.");
                    }
                }
            } else {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "Forced JVM restart requested in the UCF.");
                }
                if (string != null && string.equalsIgnoreCase("New")) {
                    DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(upgradePackageMoImpl);
                } else {
                    DynamicClassLoaderCentral.getInstance().unloadLoadModules(collection, upgradePackageMoImpl);
                }
                this.updateClassPathAndJavaHeap(string, vector, vector2, n, upgradePackageMoImpl);
                bl3 = true;
            }
            return bl3;
        }
        catch (DynClassPathException dynClassPathException) {
            throw new SAXException(dynClassPathException.toString());
        }
        catch (SAXException sAXException) {
            Trace.error(this.getClass(), "updateJvmDynamicClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\taNewJavaHeapSize: " + n + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanIsForcedMoppletUsage: " + bl + "\n\tanIsNodeOrPiuRestartRequested: " + bl2 + "\n\tSAXException caught", sAXException);
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateJvmClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aNewJavaHeapSize, UpgradePackageMoImpl anUpgradePackageMO, boolean anIsForcedMoppletUsage, boolean anIsNodeOrPiuRestartRequested)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\taNewJavaHeapSize: " + n + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanIsForcedMoppletUsage: " + bl + "\n\tanIsNodeOrPiuRestartRequested: " + bl2 + "\n\tThrowable caught", throwable);
            throw new SAXException(throwable.toString());
        }
    }

    private void loadUnloadAUEsInDynamicClassPath(Collection collection, UpgradePackageMoImpl upgradePackageMoImpl, Collection collection2, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadUnloadAUEsInDynamicClassPath(Collection aLMsToBeRemovedFromDynClassPath, UpgradePackageMoImpl anUP_Mo, Collection aDynamicClassesToBeLoaded, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "aLMsToBeRemovedFromDynClassPath: " + collection + "\n\tanUP_Mo: " + upgradePackageMoImpl + "\n\taDynamicClassesToBeLoaded: " + collection2 + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface);
        }
        try {
            DynamicClassLoaderCentral.getInstance().unloadLoadModules(collection, upgradePackageMoImpl);
            DynamicClassLoaderHelper dynamicClassLoaderHelper = new DynamicClassLoaderHelper();
            dynamicClassLoaderHelper.loadRequiredLMs(upgradePackageMoImpl, collection2, loadModuleMO_HandlerInterface);
        }
        catch (DynClassPathException dynClassPathException) {
            throw new SAXException(dynClassPathException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "loadUnloadAUEsInDynamicClassPath(Collection aLMsToBeRemovedFromDynClassPath, UpgradePackageMoImpl anUP_Mo, Collection aDynamicClassesToBeLoaded, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "Throwable caught\n\taLMsToBeRemovedFromDynClassPath: " + collection + "\n\taDynamicClassesToBeLoaded: " + collection2 + "\n\tanUP_Mo: " + upgradePackageMoImpl + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface, throwable);
            throw new SAXException(throwable.toString());
        }
    }

    private void updateClassPathAndJavaHeap(String string, Vector vector, Vector vector2, Integer n, UpgradeClientInterface upgradeClientInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aJavaHeapSize, UpgradeClientInterface anUpgradePackageMO)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\taJavaHeapSize: " + n + "\n\tanUpgradePackageMO: " + upgradeClientInterface);
        }
        try {
            this.generateAndSetJvmClasspath(string, vector, vector2, upgradeClientInterface);
            this.setJavaHeapSize(n);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateClassPathAndJavaHeap(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, Integer aJavaHeapSize, UpgradeClientInterface anUpgradePackageMO)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\taJavaHeapSize: " + n + "\n\tanUpgradePackageMO: " + upgradeClientInterface + "\n\tThrowable caught", throwable);
            throw new SAXException("Throwable caught when trying to set JVM classpath and java heapsize.Throwable: " + throwable);
        }
    }

    public Collection calculateAndSetExistingJvmAdmClassPath(Collection collection, Collection collection2, Collection collection3, UpgradeClientInterface upgradeClientInterface) throws JvmUpdateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateAndSetExistingJvmAdmClassPath(Collection aSU_LogicLMs, Collection anAddJavaLMs, Collection aRemoveJavaLMs, UpgradeClientInterface anUpgradePackageMO)", "aSU_LogicLMs: " + collection + "\n\tanAddJavaLMs: " + collection2 + "\n\taRemoveJavaLMs: " + collection3 + "\n\tanUpgradePackageMO: " + upgradeClientInterface);
        }
        try {
            ManagedObject[] managedObjectArray = this.createAdmClasspath("Old", upgradeClientInterface);
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            LinkedList<ManagedObject> linkedList2 = new LinkedList<ManagedObject>();
            LinkedList<ManagedObject> linkedList3 = new LinkedList<ManagedObject>();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                linkedList.add(this.lookupLM_Mo(productNumberAndRevisionInterface));
            }
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator2.next();
                linkedList2.add(this.lookupLM_Mo(productNumberAndRevisionInterface));
            }
            Iterator iterator3 = collection3.iterator();
            ManagedObject managedObject = null;
            while (iterator3.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator3.next();
                managedObject = this.lookupLM_MoVer2(productNumberAndRevisionInterface);
                if (managedObject != null) {
                    linkedList3.add(this.lookupLM_Mo(productNumberAndRevisionInterface));
                    continue;
                }
                Trace.log1(this.getClass(), "calculateAndSetExistingJvmAdmClassPath(Collection aSU_LogicLMs, Collection anAddJavaLMs, Collection aRemoveJavaLMs, UpgradeClientInterface anUpgradePackageMO)", "Couldn't lookup the LM MO that is to be removed from the class path (ignored)\n\ttheLM_ProdData: " + productNumberAndRevisionInterface);
            }
            LinkedList<ManagedObject> linkedList4 = new LinkedList<ManagedObject>();
            linkedList4.addAll(linkedList);
            linkedList4.addAll(linkedList2);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "calculateAndSetExistingJvmAdmClassPath(Collection aSU_LogicLMs, Collection anAddJavaLMs, Collection aRemoveJavaLMs, UpgradeClientInterface anUpgradePackageMO)", "theSU_LogicLMs: " + linkedList + "\n\ttheAddJavaLMs: " + linkedList2 + "\n\ttheRemoveJavaLMs: " + linkedList3);
            }
            LinkedList<ManagedObject> linkedList5 = new LinkedList<ManagedObject>();
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!this.isContaining((LoadModuleMoSU_Access)managedObjectArray[i], linkedList3)) {
                    linkedList4.add(managedObjectArray[i]);
                    continue;
                }
                linkedList5.add(managedObjectArray[i]);
            }
            ManagedObject[] managedObjectArray2 = new ManagedObject[linkedList4.size()];
            managedObjectArray2 = linkedList4.toArray(managedObjectArray2);
            Trace.log1(this.getClass(), "calculateAndSetExistingJvmAdmClassPath(Collection aSU_LogicLMs, Collection anAddJavaLMs, Collection aRemoveJavaLMs, UpgradeClientInterface anUpgradePackageMO)", "theNewAdmClassPathArray: " + SuLib.toString(managedObjectArray2));
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            jvmMO_HandlerInterface.setClassPath(managedObjectArray2);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "calculateAndSetExistingJvmAdmClassPath(Collection aSU_LogicLMs, Collection anAddJavaLMs, Collection aRemoveJavaLMs, UpgradeClientInterface anUpgradePackageMO)", "RETURNS - theRemovedJavaLMs: " + linkedList5);
            }
            return linkedList5;
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new JvmUpdateHandlerException(jvmMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "calculateAndSetExistingJvmAdmClassPath(Collection aSU_LogicLMs, Collection anAddJavaLMs, Collection aRemoveJavaLMs, UpgradeClientInterface anUpgradePackageMO)", "aSU_LogicLMs: " + collection + "\n\tanAddJavaLMs: " + collection2 + "\n\taRemoveJavaLMs: " + collection3 + "\n\tanUpgradePackageMO: " + upgradeClientInterface, throwable);
            throw new JvmUpdateHandlerException(throwable.toString());
        }
    }

    public Collection getLMsToBeRemovedFromDynamicClassPath(Collection collection, UpgradePackageMoImpl upgradePackageMoImpl) throws SAXException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getLMsToBeRemovedFromDynamicClassPath(Collection aRemoveJavaLMs, UpgradePackageMoImpl anUpgradePackageMO)", "aRemoveJavaLMs: " + collection + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl);
        }
        try {
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            if (!collection.isEmpty()) {
                LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                Iterator iterator = collection.iterator();
                ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                Collection collection2 = DynamicClassLoaderCentral.getInstance().getDynClasspath(upgradePackageMoImpl);
                while (iterator.hasNext()) {
                    productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                    loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModule(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
                    if (loadModuleMoSU_Access == null || !collection2.contains(loadModuleMoSU_Access)) continue;
                    linkedList.add(loadModuleMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLMsToBeRemovedFromDynamicClassPath(Collection aRemoveJavaLMs, UpgradePackageMoImpl anUpgradePackageMO)", "RETURNS - theLM_MOsThatExistInClassPathAndThatShallBeRemovedFromIt: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLMsToBeRemovedFromDynamicClassPath(Collection aRemoveJavaLMs, String aBaseClassPath, UpgradePackageMoImpl anUP_Mo)", "aRemoveJavaLMs: " + collection + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl, throwable);
            throw new SAXException(throwable.toString());
        }
    }

    public void addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(Collection collection, UpgradePackageMoImpl upgradePackageMoImpl, Collection collection2, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(Collection aLMsToBeRemovedFromDynClassPath, UpgradePackageMoImpl anUP_Mo, Collection aDynamicClassesToBeLoaded, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "aLMsToBeRemovedFromDynClassPath: " + collection + "\n\tanUP_Mo: " + upgradePackageMoImpl + "\n\taDynamicClassesToBeLoaded: " + collection2 + "\n\tanUP_Mo: " + upgradePackageMoImpl + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface);
        }
        try {
            DynamicClassLoaderCentral.getInstance().unloadLoadModules(collection, upgradePackageMoImpl);
            Collection collection3 = loadModuleMO_HandlerInterface.getLoadModuleMos(collection2);
            DynamicClassLoaderCentral.getInstance().addToDynamicClassPath(upgradePackageMoImpl, collection3);
        }
        catch (DynClassPathException dynClassPathException) {
            throw new SAXException(dynClassPathException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addAUEsToDynClassPathAndUnloadAUEsInDynamicClassPath(Collection aLMsToBeRemovedFromDynClassPath, UpgradePackageMoImpl anUP_Mo, Collection aDynamicClassesToBeLoaded, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface)", "aLMsToBeRemovedFromDynClassPath: " + collection + "\n\tanUP_Mo: " + upgradePackageMoImpl + "\n\taDynamicClassesToBeLoaded: " + collection2 + "\n\tanUP_Mo: " + upgradePackageMoImpl + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\tThrowable caught", throwable);
            throw new SAXException(throwable.toString());
        }
    }

    public MoppletDynamicInformation getLMsToBeLoadedAsDynamicAndMopplets(UpgradePackageMoImpl upgradePackageMoImpl, Collection collection, boolean bl) throws SAXException {
        Object object;
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getLMsToBeLoadedAsDynamicAndMopplets(UpgradePackageMoImpl anUpgradePackageMo, Collection anAddLmList, boolean anIsSwap)", "UpgradePackageMoImpl anUpgradePackageMo: " + upgradePackageMoImpl + "\n\tanAddLmList: " + collection + "\n\tanIsSwap: " + bl);
        }
        Vector<ProductNumberAndRevisionInterface> vector = new Vector<ProductNumberAndRevisionInterface>();
        Vector<ProductNumberAndRevisionInterface> vector2 = new Vector<ProductNumberAndRevisionInterface>();
        Vector<ProductNumberAndRevisionInterface> vector3 = new Vector<ProductNumberAndRevisionInterface>();
        if (!collection.isEmpty()) {
            object = this.getDocumentObjectProxyInterface(upgradePackageMoImpl);
            LoadModulesProxyInterface loadModulesProxyInterface = object.getLoadModulesProxyInterface();
            Iterator iterator = collection.iterator();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            while (iterator.hasNext()) {
                productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
                if (loadModuleProxyInterface.getDynamicClassName() != null) {
                    if (bl) {
                        if (loadModuleProxyInterface.isUseMoppletAtSwap()) {
                            vector.add(loadModuleProxyInterface.getProductNumberAndRevisionInterface());
                            vector3.add(productNumberAndRevisionInterface);
                            continue;
                        }
                        vector2.add(loadModuleProxyInterface.getProductNumberAndRevisionInterface());
                        continue;
                    }
                    vector2.add(loadModuleProxyInterface.getProductNumberAndRevisionInterface());
                    continue;
                }
                vector.add(loadModuleProxyInterface.getProductNumberAndRevisionInterface());
                vector3.add(productNumberAndRevisionInterface);
            }
        }
        object = new MoppletDynamicInformation(vector, vector2, vector3);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getLMsToBeLoadedAsDynamicAndMopplets(Collection anAddLmList, boolean anIsSwap)", "RETURNS - theMoppletDynamicInformation: " + object);
        }
        return object;
    }

    private boolean isContaining(LoadModuleMoSU_Access loadModuleMoSU_Access, Collection collection) throws JvmUpdateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isContaining(LoadModuleMoSU_Access aLM_MOInAdmClassPath, Collection aRemoveJavaLMs)", "aLM_MOInAdmClassPath: " + loadModuleMoSU_Access + "\n\taRemoveJavaLMs: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access2 = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access2 = (LoadModuleMoSU_Access)iterator.next();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isContaining(LoadModuleMoSU_Access aLM_MOInAdmClassPath, Collection aRemoveJavaLMs)", "theRemoveLM_Mo: " + loadModuleMoSU_Access2 + "\n\taLM_MOInAdmClassPath: " + loadModuleMoSU_Access);
                }
                if (!loadModuleMoSU_Access2.equals(loadModuleMoSU_Access)) continue;
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isContaining(LoadModuleMoSU_Access aLM_MOInAdmClassPath, Collection aRemoveJavaLMs)", "RETURNS - true");
                }
                return true;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isContaining(LoadModuleMoSU_Access aLM_MOInAdmClassPath, Collection aRemoveJavaLMs)", "RETURNS - false");
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isContaining(Collection aRemoveJavaLMs, ManagedObject[] aLM_MOsInAdmClassPath)", "aRemoveJavaLMs: " + collection + "\n\taRemoveJavaLMs: " + collection, throwable);
            throw new JvmUpdateHandlerException(throwable.toString());
        }
    }

    private ManagedObject lookupLM_Mo(ProductNumberAndRevisionInterface productNumberAndRevisionInterface) throws JvmUpdateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "aLM_ProductNumberAndRevision: " + productNumberAndRevisionInterface);
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access = ServiceFinder.getLoadModuleMO_HandlerInterface().getLoadModule(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
            if (loadModuleMoSU_Access != null) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "RETURNS theLM_Mo: " + loadModuleMoSU_Access);
                }
                return loadModuleMoSU_Access;
            }
            Trace.error(this.getClass(), "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "No Load Module Mo found for product data: " + productNumberAndRevisionInterface);
            throw new JvmUpdateHandlerException("No Load Module Mo found for product data: " + productNumberAndRevisionInterface);
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new JvmUpdateHandlerException(loadModuleMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "Throwable caught", throwable);
            throw new JvmUpdateHandlerException(throwable.toString());
        }
    }

    private ManagedObject lookupLM_MoVer2(ProductNumberAndRevisionInterface productNumberAndRevisionInterface) throws JvmUpdateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "lookupLM_MoVer2(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "aLM_ProductNumberAndRevision: " + productNumberAndRevisionInterface);
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access = ServiceFinder.getLoadModuleMO_HandlerInterface().getLoadModule(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "RETURNS theLM_Mo: " + loadModuleMoSU_Access);
            }
            return loadModuleMoSU_Access;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new JvmUpdateHandlerException(loadModuleMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "Throwable caught", throwable);
            throw new JvmUpdateHandlerException(throwable.toString());
        }
    }

    public void generateAndSetNewJvmClasspath(String string, UpgradeClientInterface upgradeClientInterface) throws MoAccessException, Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "generateJvmClasspath(String aBaseClassPath, UpgradeClientInterface anUpgradePackageMO)", "aBaseClassPath: " + string + "\n\tanUpgradePackageMO: " + upgradeClientInterface);
        }
        this.generateAndSetJvmClasspath("New", new Vector(), new Vector(), upgradeClientInterface);
    }

    public void generateAndSetJvmClasspath(String string, Vector vector, Vector vector2, UpgradeClientInterface upgradeClientInterface) throws MoAccessException, Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "generateAndSetJvmClasspath(String aBaseClassPath, Vector anAddLmList, Vector anRemoveLmList, UpgradeClientInterface anUpgradePackageMO)", "aBaseClassPath: " + string + "\n\tanAddLmList: " + vector + "\n\tanRemoveLmList: " + vector2 + "\n\tanUpgradePackageMO: " + upgradeClientInterface);
        }
        if (string == null) {
            string = "Old";
        }
        if (!string.equalsIgnoreCase("New") && vector.size() == 0 && vector2.size() == 0) {
            return;
        }
        ManagedObject[] managedObjectArray = this.createAdmClasspath(string, upgradeClientInterface);
        ManagedObject[] managedObjectArray2 = this.doAddAndRemoveLm(managedObjectArray, vector, vector2);
        JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
        jvmMO_HandlerInterface.setClassPath(managedObjectArray2);
    }

    public ManagedObject[] createAdmClasspath(String string, UpgradeClientInterface upgradeClientInterface) throws MoAccessException {
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAdmClasspath (String aBaseClassPath, UpgradeClientInterface anUpgradePackageMO)", "aBaseClassPath: " + string + "\n\tanUpgradePackageMO: " + upgradeClientInterface);
        }
        MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
        ManagedObject[] managedObjectArray = null;
        if (string != null && string.equalsIgnoreCase("New")) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createAdmClasspath(String aBaseClassPath)", "New base Class Path is to be set.");
            }
            managedObjectArray = this.getJvmLMs(upgradeClientInterface);
        } else {
            object = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            managedObjectArray = object.getAdmClasspath(null);
        }
        object = null;
        if (managedObjectArray.length == 0) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createAdmClasspath (String aBaseClassPath, UpgradeClientInterface anUpgradePackageMO)", "AdmClasspath = 0");
            }
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            object = jvmMoSU_Access.getClasspath(null);
            managedObjectArray = this.createAdmClasspathFromClasspath((String)object);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createAdmClasspath (String aBaseClassPath, UpgradeClientInterface anUpgradePackageMO)", "RETURNS - " + SuLib.toString(managedObjectArray));
        }
        return managedObjectArray;
    }

    private ManagedObject[] doAddAndRemoveLm(ManagedObject[] managedObjectArray, Vector vector, Vector vector2) throws MoAccessException, Exception {
        int n;
        int n2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)");
        }
        if (vector.size() == 0 && vector2.size() == 0) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "Classpath will NOT be changed.");
            }
            return managedObjectArray;
        }
        this.traceLoadModuleInfo("Existing", managedObjectArray);
        ManagedObject[] managedObjectArray2 = new ManagedObject[vector.size()];
        ManagedObject[] managedObjectArray3 = new ManagedObject[vector2.size()];
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "Add following Load Modules to the class path: ");
        }
        int n3 = 0;
        LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
        Map map = this.buildSetOfLM_MOsMap();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            managedObjectArray2[n3] = this.findLoadModuleRef(vector.elementAt(n2), loadModuleMO_HandlerInterface, map);
            if (managedObjectArray2[n3] == null) continue;
            ++n3;
        }
        this.traceLoadModuleInfo("Adding", managedObjectArray2);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "Remove following Load Modules from the class path:");
        }
        n3 = 0;
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            managedObjectArray3[n3] = this.findLoadModuleRef(vector2.elementAt(n2), loadModuleMO_HandlerInterface, map);
            if (managedObjectArray3[n3] != null) {
                ++n3;
                continue;
            }
            Trace.log1(this.getClass(), "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "The reference for the Load module to be removed from the class path was not found. It is ignored.\n\tLM Product number and revision: " + (ProductNumberAndRevisionInterface)vector2.elementAt(n2));
        }
        this.traceLoadModuleInfo("Removing", managedObjectArray3);
        Vector<ManagedObject> vector3 = new Vector<ManagedObject>();
        for (n = 0; n < managedObjectArray2.length; ++n) {
            if (managedObjectArray2[n] != null) {
                vector3.addElement(managedObjectArray2[n]);
                continue;
            }
            Trace.warning(this.getClass(), "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "The reference for the Load module to be added to the class path was set to null. It is ignored. addMo[" + n + "] = null");
        }
        n = 0;
        for (n3 = 0; n3 < managedObjectArray.length; ++n3) {
            n = 0;
            for (int i = 0; i < managedObjectArray3.length; ++i) {
                if (!managedObjectArray[n3].equals(managedObjectArray3[i])) continue;
                n = 1;
                i = managedObjectArray3.length;
            }
            if (n != 0) continue;
            vector3.addElement(managedObjectArray[n3]);
            n = 0;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "New class path to be set via JVM MO");
        }
        Enumeration enumeration = vector3.elements();
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        while (enumeration.hasMoreElements()) {
            loadModuleMoSU_Access = (LoadModuleMoSU_Access)enumeration.nextElement();
            if (loadModuleMoSU_Access == null || !Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "LoadModule Product No: " + loadModuleMoSU_Access.getProductNumber(null) + ", Revision: " + loadModuleMoSU_Access.getProductRevision(null));
        }
        Object[] objectArray = new ManagedObject[vector3.size()];
        vector3.copyInto(objectArray);
        return objectArray;
    }

    private ManagedObject[] doAddAndRemoveLm(ManagedObject[] managedObjectArray, Vector vector, Vector vector2, String string, boolean bl, UpgradePackageMoImpl upgradePackageMoImpl) throws MoAccessException, Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList, String aBaseClassPath, boolean anIsForcedMoppletUsage, UpgradePackageMoImpl anUpgradePackageMo)");
        }
        Vector vector3 = vector;
        if (vector.size() != 0 && !bl) {
            boolean bl2 = true;
            if (string.equalsIgnoreCase("Old")) {
                bl2 = false;
            }
            MoppletDynamicInformation moppletDynamicInformation = this.getLMsToBeLoadedAsDynamicAndMopplets(upgradePackageMoImpl, vector, bl2);
            vector3 = moppletDynamicInformation.getAddJavaLM_List();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList, String aBaseClassPath, boolean anIsForcedMoppletUsage, UpgradePackageMoImpl anUpgradePackageMo)", "theMoppletDynamicInformation: " + moppletDynamicInformation);
            }
        }
        return this.doAddAndRemoveLm(managedObjectArray, vector3, vector2);
    }

    private ManagedObject findLoadModuleRef(Object object, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Map map) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "findLoadModuleRef ( AttributeList aProdDataLm, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface )", "aLmList: " + object + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface);
        }
        String string = null;
        String string2 = null;
        if (object instanceof AttributeList) {
            string = ((AttributeList)object).getValue("productNumber");
            string2 = ((AttributeList)object).getValue("revision");
        } else if (object instanceof ProductNumberAndRevisionInterface) {
            string = ((ProductNumberAndRevisionInterface)object).getProductNumber();
            string2 = ((ProductNumberAndRevisionInterface)object).getRevision();
        } else {
            Trace.error(this.getClass(), "doAddAndRemoveLm(ManagedObject[] aLoadModules, Vector anAddLmList, Vector anRemoveLmList)", "Identifying the loadModule to be removed failed as they are not of type AttributeList or ProductNumberAndRevisionInterface  ");
        }
        ManagedObject managedObject = (ManagedObject)map.get(string + "_" + string2);
        if (managedObject != null) {
            return managedObject;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "findLoadModuleRef ( AttributeList aProdDataLm, LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface )", "No Load Module MO with product number and revision = " + string + " " + string2);
        }
        return null;
    }

    public long getCurrentJavaheapSize() throws JvmMO_HandlerException {
        return ServiceFinder.getJvmMO_HandlerInterface().getJavaHeapSizeInBytes();
    }

    private DocumentObjectProxyInterface getDocumentObjectProxyInterface(UpgradePackageMoImpl upgradePackageMoImpl) throws SAXException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getDocumentObjectProxyInterface(UpgradePackageMoImpl anUpgradePackageMo)", "anUpgradePackageMo: " + upgradePackageMoImpl);
        }
        try {
            String[] stringArray = new String[]{"UpgradeSequence", "LoadModule"};
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(upgradePackageMoImpl.getUpgradePackageProductNumber(), upgradePackageMoImpl.getUpgradePackageProductRevision(), upgradePackageMoImpl.getUpgradeControlFilePath(null), stringArray);
            return documentObjectProxyInterface;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDocumentObjectProxyInterface(UpgradePackageMoImpl anUpgradePackageMo)", "anUpgradePackageMo: " + upgradePackageMoImpl + "\n\tThrowable caught", throwable);
            throw new SAXException(throwable.toString());
        }
    }

    public void setJavaHeapSize(Integer n) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setJavaHeapSize( )");
        }
        if (n != null) {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            jvmMO_HandlerInterface.setJavaHeapSize(n);
        }
    }

    public void doRestartJvm() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doRestartJvm ( )");
        }
        Trace.log1(this.getClass(), "doRestartJvm ()", "Requesting the JVM to be restarted within 5000 milliseconds.");
        try {
            Trace.flushToTraceFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TimeHandler.sleep(500L);
        MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
        JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
        jvmMoSU_Access.actionForcedRestart(null);
    }

    public boolean isLMs_ToBeRemovedFromClassPath(Collection collection, String string, UpgradePackageMoImpl upgradePackageMoImpl) throws SAXException {
        Collection collection2;
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "isLMs_ToBeRemovedFromClassPath(Collection aRemoveJavaLMs, String aBaseClassPath, UpgradePackageMoImpl anUP_Mo)", "aRemoveJavaLMs: " + collection + "\n\taBaseClassPath: " + string + "\n\tanUP_Mo: " + upgradePackageMoImpl);
        }
        return !(collection2 = this.getLMs_ToBeRemovedFromClassPath(collection, string, upgradePackageMoImpl)).isEmpty();
    }

    private Collection getLMs_ToBeRemovedFromClassPath(Collection collection, String string, UpgradePackageMoImpl upgradePackageMoImpl) throws SAXException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getLMs_ToBeRemovedFromClassPath(Collection aRemoveJavaLMs, String aBaseClassPath, UpgradePackageMoImpl anUP_Mo)", "aRemoveJavaLMs: " + collection + "\n\taBaseClassPath: " + string + "\n\tanUP_Mo: " + upgradePackageMoImpl);
        }
        try {
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            if (!collection.isEmpty()) {
                ManagedObject[] managedObjectArray = this.createAdmClasspath(string, upgradePackageMoImpl);
                LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                Iterator iterator = collection.iterator();
                ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                while (iterator.hasNext()) {
                    productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
                    loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModule(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
                    if (loadModuleMoSU_Access == null || !loadModuleMO_HandlerInterface.contains(loadModuleMoSU_Access, managedObjectArray)) continue;
                    linkedList.add(loadModuleMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getLMs_ToBeRemovedFromClassPath(Collection aRemoveJavaLMs, String aBaseClassPath, UpgradePackageMoImpl anUP_Mo)", "RETURNS - theLM_MOsThatExistInClassPathAndThatShallBeRemovedFromIt: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLMs_ToBeRemovedFromClassPath(Collection aRemoveJavaLMs, String aBaseClassPath, UpgradePackageMoImpl anUP_Mo)", "aRemoveJavaLMs: " + collection + "\n\taBaseClassPath: " + string + "\n\tanUP_Mo: " + upgradePackageMoImpl, throwable);
            throw new SAXException(throwable.toString());
        }
    }

    public boolean isJavaHeapToBeChanged(Integer n) throws SAXException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "isJavaHeapToBeChanged(Integer aJavaHeap)", "aJavaHeap: " + n);
        }
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface;
            long l;
            long l2;
            boolean bl = false;
            if (n != null && (l2 = (long)(n * 1024)) != (l = (jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface()).getJavaHeapSizeInBytes())) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "isJavaHeapToBeChanged(Integer aJavaHeap)", "Java heap size needs to be changed according to UCF. \n\ttheNewJavaHeapSizeInBytes: " + l2 + "\n\ttheCurrentJavaHeapSizeInBytes: " + l);
                }
                bl = true;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isJavaHeapToBeChanged(Integer aJavaHeap)", "RETURNS - theIsJavaHeapToBeChanged: " + bl);
            }
            return bl;
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new SAXException(jvmMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isJavaHeapToBeChanged(Integer aJavaHeap)", "Throwable caught", throwable);
            throw new SAXException(throwable.toString());
        }
    }

    public boolean isJvmConnected() throws JvmUpdateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isJvmConnected()");
        }
        try {
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface;
            boolean bl = false;
            SwAllocationMoSU_Access swAllocationMoSU_Access = ServiceFinder.getJvmMO_HandlerInterface().getReferencedSwAllocationMo();
            if (swAllocationMoSU_Access != null && !(swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface()).getRepertoiresReferencedBySwAllocation(swAllocationMoSU_Access).isEmpty()) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isJvmConnected()", "RETURNS - " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isJvmConnected()", "Throwable caught.", throwable);
            throw new JvmUpdateHandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: isJvmConnected()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public ManagedObject[] getJvmLMs(UpgradeClientInterface upgradeClientInterface) throws JvmUpdateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJvmLMs(UpgradeClientInterface anUpgradePackageMo)", "anUpgradePackageMo: " + upgradeClientInterface);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            Object object;
            ManagedObject[] managedObjectArray;
            Collection<Object> collection = new LinkedList<ManagedObject>();
            if (this.isJvmConnected()) {
                Trace.suTestLog(this.getClass(), "getJvmLMs(UpgradeClientInterface anUpgradePackageMo)", "The Jvm Mo is connected i.e. only connected load modules are of interest.");
                managedObjectArray = ServiceFinder.getJvmMO_HandlerInterface().getReferencedSwAllocationMo();
                if (managedObjectArray != null) {
                    object = ServiceFinder.getSwAllocationMO_HandlerInterface();
                    Collection collection2 = object.getRepertoiresReferencedBySwAllocation((SwAllocationMoSU_Access)managedObjectArray);
                    RepertoireMoSU_Access repertoireMoSU_Access = null;
                    LinkedList<String> linkedList = new LinkedList<String>();
                    RepertoireMoData repertoireMoData = null;
                    Iterator iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        repertoireMoData = (RepertoireMoData)iterator.next();
                        repertoireMoSU_Access = repertoireMoData.repertoireMo;
                        linkedList.add(repertoireMoSU_Access.getName(null));
                    }
                    documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(upgradeClientInterface.getUpgradePackageProductNumber(), upgradeClientInterface.getUpgradePackageProductRevision(), upgradeClientInterface.getUpgradeControlFilePath(null), "Repertoire");
                    RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
                    Collection collection3 = repertoiresProxyInterface.getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(linkedList);
                    LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                    Collection collection4 = this.sortJVM_LMsAccordingToOrderInUCF(loadModuleMO_HandlerInterface, collection3, upgradeClientInterface);
                    collection = loadModuleMO_HandlerInterface.getLoadModules(collection4);
                }
            } else {
                Trace.suTestLog(this.getClass(), "getOtherLMs(UpgradeClientInterface anUpgradePackageMo)", "The Jvm Mo is not connected i.e. all load modules of type JVM are of interest.");
                managedObjectArray = ServiceFinder.getLoadModuleMO_HandlerInterface();
                object = upgradeClientInterface.getLoadModuleList(null);
                ManagedObject[] managedObjectArray2 = managedObjectArray.getLoadModulesOfType((ManagedObject[])object, 2);
                for (int i = 0; i < managedObjectArray2.length; ++i) {
                    collection.add(managedObjectArray2[i]);
                }
            }
            managedObjectArray = new ManagedObject[collection.size()];
            managedObjectArray = collection.toArray(managedObjectArray);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getJvmLMs()", "RETURNS - " + SuLib.toString(managedObjectArray));
            }
            object = managedObjectArray;
            return object;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJvmLMs()", "Throwable caught.", throwable);
            throw new JvmUpdateHandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getJvmLMs()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
        finally {
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
        }
    }

    private Collection sortJVM_LMsAccordingToOrderInUCF(LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, Collection collection, UpgradeClientInterface upgradeClientInterface) throws JvmUpdateHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sortJVM_LMsAccordingToOrderInUCF (LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Collection aProductNumberAndRevisionsOfAllLMsInRepertoires, UpgradeClientInterface anUpgradePackageMo )", "aLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taProductNumberAndRevisionsOfAllLMsInRepertoires: " + collection + "\n\tanUpgradePackageMo: " + upgradeClientInterface);
        }
        try {
            ManagedObject[] managedObjectArray = upgradeClientInterface.getLoadModuleList(null);
            ManagedObject[] managedObjectArray2 = loadModuleMO_HandlerInterface.getLoadModulesOfType(managedObjectArray, 2);
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            for (int i = 0; i < managedObjectArray2.length; ++i) {
                linkedList.add(managedObjectArray2[i]);
            }
            Collection collection2 = loadModuleMO_HandlerInterface.getProductNumberAndRevisionsForLoadModules(linkedList);
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions(new Vector(collection));
            LinkedList<ProductNumberAndRevision> linkedList2 = new LinkedList<ProductNumberAndRevision>();
            Iterator iterator = collection2.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                if (!productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                linkedList2.add(productNumberAndRevision);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "sortJVM_LMsAccordingToOrderInUCF (LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Collection aProductNumberAndRevisionsOfAllLMsInRepertoires, UpgradeClientInterface anUpgradePackageMo )", "RETURNS - " + linkedList2);
            }
            return linkedList2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sortJVM_LMsAccordingToOrderInUCF (LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, Collection aProductNumberAndRevisionsOfAllLMsInRepertoires, UpgradeClientInterface anUpgradePackageMo )", "aLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taProductNumberAndRevisionsOfAllLMsInRepertoires: " + collection + "\n\tanUpgradePackageMo: " + upgradeClientInterface + "\n\tThrowable caught.", throwable);
            throw new JvmUpdateHandlerException("Class name: " + this.getClass().getName() + "\n\taLoadModuleMO_HandlerInterface: " + loadModuleMO_HandlerInterface + "\n\taProductNumberAndRevisionsOfAllLMsInRepertoires: " + collection + "\n\tanUpgradePackageMo: " + upgradeClientInterface + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private ManagedObject[] createAdmClasspathFromClasspath(String string) throws MoAccessException {
        int n;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAdmClasspathFromClasspath ( String aClassPath )", "aClassPath: " + string);
        }
        if (string == null) {
            return new ManagedObject[0];
        }
        if (string.length() == 0) {
            return new ManagedObject[0];
        }
        Vector<String> vector = new Vector<String>(8);
        int n2 = string.indexOf(":");
        if (n2 != -1) {
            vector.addElement(string.substring(0, n2));
            int n3 = 0;
            n = string.length();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createAdmClasspathFromClasspath(String aClassPath)", "length " + n + string.substring(0, n2));
            }
            while ((n3 = string.indexOf(":", n2 + 1)) != -1 && n3 < n) {
                vector.addElement(string.substring(n2 + 1, n3));
                n2 = n3;
            }
        }
        vector.addElement(string.substring(n2 + 1));
        Vector<LoadModuleMoSU_Access> vector2 = new Vector<LoadModuleMoSU_Access>(vector.size());
        for (n = 0; n < vector.size(); ++n) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createAdmClasspathFromClasspath ( String aClassPath )", "filepath " + vector.elementAt(n));
            }
            String string2 = (String)vector.elementAt(n);
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator == null) continue;
            while (moIterator.hasMoreElements()) {
                LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                if (!loadModuleMoSU_Access.getLoadModuleFilePath(null).equals(string2)) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "createAdmClasspathFromClasspath ( String aClassPath )", "Found a matching load module.");
                }
                vector2.addElement(loadModuleMoSU_Access);
            }
        }
        Object[] objectArray = new ManagedObject[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    private void traceLoadModuleInfo(String string, ManagedObject[] managedObjectArray) throws MoAccessException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "traceLoadModuleInfo(String aType, ManagedObject[] aLoadModules)", "Class Path: " + string);
        }
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i] != null) {
                String string2 = ((LoadModuleMoSU_Access)managedObjectArray[i]).getProductNumber(null);
                String string3 = ((LoadModuleMoSU_Access)managedObjectArray[i]).getProductRevision(null);
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "traceLoadModuleInfo(String aType, ManagedObject[] aLoadModules)", "LoadModule Product No: " + string2 + ", Revision: " + string3);
                continue;
            }
            if (!Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "traceLoadModuleInfo(String aType, ManagedObject[] aLoadModules)", "loadModule[" + i + "]= null");
        }
    }

    private Map buildSetOfLM_MOsMap() throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "buildSetOfLM_MOsMap()");
        }
        try {
            HashMap<String, LoadModuleMoSU_Access> hashMap = new HashMap<String, LoadModuleMoSU_Access>();
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator == null) {
                return hashMap;
            }
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            String string = null;
            while (moIterator.hasMoreElements()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                string = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? loadModuleMoSU_Access.getProductNumberOpt(null) + "_" + loadModuleMoSU_Access.getProductRevisionOpt(null) : StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)) + "_" + StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, loadModuleMoSU_Access);
                    continue;
                }
                Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "More than one LM MO has been configured with the same product number and revision. This may result in an inconsistent configuration of the node\n\ttheProdNoRevKey: " + string + "\n\tWill use the LM MO instance: " + hashMap.get(string) + "\n\tIgnoring the LM MO instance: " + loadModuleMoSU_Access);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "Throwable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }

    public void generateAndSetJvmToStateClassPathAndHeapSize(String string, String string2, UpgradePackageMoImpl upgradePackageMoImpl) throws MoAccessException, Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "generateAndSetJvmToStateClassPathAndHeapSize(String aSequenceLabel, String aStepLabel, UpgradePackageMoImpl anUpgradePackageMO)");
        }
        String[] stringArray = new String[]{"UpgradeSequence"};
        OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = null;
        optimizedDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElementsOptimizedInterface(upgradePackageMoImpl.getDocumentNumber(null), upgradePackageMoImpl.getDocumentRevision(null), upgradePackageMoImpl.getUpgradeControlFilePath(null), stringArray, false);
        UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = optimizedDocumentObjectProxyInterface.getUpgradeSequencesProxyInterface();
        UpgradeSequenceProxyInterface upgradeSequenceProxyInterface = upgradeSequencesProxyInterface.getUpgradeSequenceProxyInterface(string);
        if (upgradeSequenceProxyInterface != null) {
            JavaHeapHelper javaHeapHelper;
            Integer n;
            Vector vector = upgradeSequenceProxyInterface.getAddJavaAuesToState(string2);
            Vector vector2 = upgradeSequenceProxyInterface.getRemoveJavaAuesToState(string2);
            Integer n2 = upgradeSequenceProxyInterface.getJavaHeapSizeForToState();
            if (n2 == null && (n = (javaHeapHelper = new JavaHeapHelper()).selectJavaHeap(upgradePackageMoImpl.getUpgradeControlFilePath(null), upgradePackageMoImpl.getDocumentNumber(null), upgradePackageMoImpl.getDocumentRevision(null))) != null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "generateAndSetJvmToStateClassPathAndHeapSize(String aSequenceLabel, String aStepLabel, UpgradePackageMoImpl anUpgradePackageMO)", "The Java heap defined in Repertoires is used: " + n);
                }
                n2 = n;
            }
            this.updateJvmDynamicClassPathAndJavaHeap("New", vector, vector2, n2, upgradePackageMoImpl, upgradeSequenceProxyInterface.getForcedMoppletUsageForToState(), true);
        } else {
            Trace.error(this.getClass(), "generateAndSetJvmToStateClassPathAndHeapSize(String aSequenceLabel, String aStepLabel, UpgradePackageMoImpl anUpgradePackageMO)", "upgradeSequence with sequence label " + string + "is not found and the to state class path and heapsize cannot be set");
        }
    }
}

