/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade;

import org.xml.sax.SAXException;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.UpgradePackageConst;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandler;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandlerFactory;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public final class LockRestartOp
implements ExecutableOp,
UpgradePackageConst {
    private boolean noRpMove;
    private int shutdownTime;
    private GenericUpgradeablePlugInUnit piuMo;
    private String myStepLabel = null;

    public LockRestartOp(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, boolean bl, int n, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "LockRestartOp ( UpgradeablePlugInUnit piuMo, boolean noRpMove, int shutdownTime )", "piuMo: " + genericUpgradeablePlugInUnit + "\n\tnoRpMove: " + bl + "\n\tshutdownTime: " + n);
        }
        this.piuMo = genericUpgradeablePlugInUnit;
        this.noRpMove = bl;
        this.shutdownTime = n;
        this.myStepLabel = string;
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        block17: {
            Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Execute operation 'LockRestartOp'." + this.myStepLabel + "\n\tUpgradeable PIU: " + this.piuMo);
            Control control = null;
            try {
                Object object;
                if (this.myStepLabel != null) {
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
                }
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                Coordinator coordinator = control.getCoordinator();
                int n = 0;
                if (this.shutdownTime > 0) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp ( ActionListener observer )", "set shutdowntimer to: " + this.shutdownTime);
                    }
                    object = ServiceFinder.getPIU_MO_HandlerInterface();
                    n = object.getShutdownTimer(this.piuMo, coordinator);
                    object.setShutdownTimer(this.piuMo, this.shutdownTime, coordinator);
                    PIU_AdmStateHandlerFactory pIU_AdmStateHandlerFactory = PIU_AdmStateHandlerFactory.instance();
                    PIU_AdmStateHandler pIU_AdmStateHandler = pIU_AdmStateHandlerFactory.createPIU_AdmStateHandler();
                    pIU_AdmStateHandler.setAdministrativeStateReq(this.piuMo, 2, coordinator);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp ( ActionListener observer )", "The setting of the administrative state to 'SHUTTINGDOWN' for\n\tPIU '" + this.piuMo + "' has been requested." + "\n\tnoRpMove: " + this.noRpMove);
                    }
                } else if (this.noRpMove) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp ( ActionListener observer )", "NO RPU move");
                    }
                    object = PIU_AdmStateHandlerFactory.instance();
                    PIU_AdmStateHandler pIU_AdmStateHandler = ((PIU_AdmStateHandlerFactory)object).createPIU_AdmStateHandler();
                    pIU_AdmStateHandler.setAdministrativeStateSwitchReq(this.piuMo, 0, 2, coordinator);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp ( ActionListener observer )", "The setting of the administrative state (no switch at lock) to 'SHUTTINGDOWN' for\n\tPIU '" + this.piuMo + "' has been requested." + "\n\tnoRpMove: " + this.noRpMove);
                    }
                } else {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp ( ActionListener observer )", "RPU move");
                    }
                    object = PIU_AdmStateHandlerFactory.instance();
                    PIU_AdmStateHandler pIU_AdmStateHandler = ((PIU_AdmStateHandlerFactory)object).createPIU_AdmStateHandler();
                    pIU_AdmStateHandler.setAdministrativeStateReq(this.piuMo, 0, coordinator);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp ( ActionListener observer )", "The setting of the administrative state to 'LOCKED' for\n\tPIU '" + this.piuMo + "' has been requested." + "\n\tnoRpMove: " + this.noRpMove);
                    }
                }
                control.getTerminator().commit();
                if (n == 0) break block17;
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Interrupted Exception caught when trying to execute 'Thread.sleep ( 2*1000 )'.", interruptedException);
                    throw new SAXException(interruptedException.toString());
                }
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                coordinator = control.getCoordinator();
                object = ServiceFinder.getPIU_MO_HandlerInterface();
                object.setShutdownTimer(this.piuMo, n, coordinator);
                control.getTerminator().commit();
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Trace.error(this.getClass(), "executeOp( ActionListener observer )", "TransactionRolledBack Exception caught.", transactionRolledBackException);
                throw new SAXException(transactionRolledBackException.toString());
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Trace.error(this.getClass(), "executeOp( ActionListener observer )", "InactiveTransaction Exception caught.", inactiveTransactionException);
                throw new SAXException(inactiveTransactionException.toString());
            }
            catch (MoAccessException moAccessException) {
                Trace.error(this.getClass(), "executeOp( ActionListener observer )", "MoAccess Exception caught, \n\tpiuMo: " + this.piuMo + "\n\tnoRpMove: " + this.noRpMove + "\n\tshutdownTime: " + this.shutdownTime, moAccessException);
                Transaction.rollback(control);
                throw new SAXException(moAccessException.toString());
            }
        }
    }

    public String toString() {
        return "\n\n\tClass: " + this.getClass().getName() + "\n\tnoRpMove: " + this.noRpMove + "\n\tshutdownTime: " + this.shutdownTime + "\n\tPlugInUnit Mo: " + this.piuMo;
    }
}

