/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.datacontainer;

import java.util.Collection;
import java.util.HashSet;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class UpgradePackageRelatedCVsDataContainer {
    private HashSet myDeleteableCVsList = new HashSet();
    private HashSet myNotDeleteableCVsList = new HashSet();
    private HashSet myPreUpgradeDeleteableCVsList = new HashSet();
    private HashSet myPreUpgradeNotDeleteableCVsList = new HashSet();

    public UpgradePackageRelatedCVsDataContainer(String[] stringArray, String[] stringArray2) {
        int n;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradePackageRelatedCVsDataContainer(String[ ] aDeleteableCVs, String[ ] aNotDeleteableCVs)", "aDeleteableCVs: " + SuLib.toString(stringArray) + "\n\taNotDeleteableCVs: " + SuLib.toString(stringArray2));
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.myDeleteableCVsList.add(stringArray[n]);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.myNotDeleteableCVsList.add(stringArray2[n]);
            }
        }
    }

    public boolean contains(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "contains(String aCV_Name)", "aCV_Name: " + string);
        }
        boolean bl = false;
        if (this.myDeleteableCVsList.contains(string)) {
            bl = true;
        } else if (this.myNotDeleteableCVsList.contains(string)) {
            bl = true;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "contains(String aCV_Name)", "RETURNS - theIsContains: " + bl);
        }
        return bl;
    }

    public void addDeletePreventingCVs(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addDeletePreventingCVs(Collection aDeletePreventingCVs)", "aDeletePreventingCVs: " + collection);
        }
        this.myNotDeleteableCVsList.addAll(collection);
    }

    public void addPreUpgradeDeletePreventingCVs(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPreUpgradeDeletePreventingCVs(Collection aDeletePreventingCVs)", "aDeletePreventingCVs: " + collection);
        }
        this.myNotDeleteableCVsList.addAll(collection);
        this.myPreUpgradeNotDeleteableCVsList.addAll(collection);
    }

    public void addNotDeletePreventingCVs(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addNotDeletePreventingCVs(Collection aNotDeletePreventingCVs)", "aNotDeletePreventingCVs: " + collection);
        }
        this.myDeleteableCVsList.addAll(collection);
    }

    public void addPreUpgradeNotDeletePreventingCVs(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPreUpgradeNotDeletePreventingCVs(Collection aNotDeletePreventingCVs)", "aNotDeletePreventingCVs: " + collection);
        }
        this.myDeleteableCVsList.addAll(collection);
        this.myPreUpgradeDeleteableCVsList.addAll(collection);
    }

    public boolean allCVsAreDeleteable() {
        return this.myNotDeleteableCVsList.isEmpty();
    }

    public String[] getDeleteableCVs() {
        String[] stringArray = new String[this.myDeleteableCVsList.size()];
        stringArray = this.myDeleteableCVsList.toArray(stringArray);
        return stringArray;
    }

    public String[] getPreUpgradeDeleteableCVs() {
        String[] stringArray = new String[this.myPreUpgradeDeleteableCVsList.size()];
        stringArray = this.myPreUpgradeDeleteableCVsList.toArray(stringArray);
        return stringArray;
    }

    public String[] getNotDeleteableCVs() {
        String[] stringArray = new String[this.myNotDeleteableCVsList.size()];
        stringArray = this.myNotDeleteableCVsList.toArray(stringArray);
        return stringArray;
    }

    public String[] getPreUpgradeNotDeleteableCVs() {
        String[] stringArray = new String[this.myPreUpgradeNotDeleteableCVsList.size()];
        stringArray = this.myPreUpgradeNotDeleteableCVsList.toArray(stringArray);
        return stringArray;
    }

    public boolean isDeletePreventingCVsOnlyPreUpgradeCVs() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 22, "isDeletePreventingCVsOnlyPreUpgradeCVs()", "myNotDeleteableCVsList: " + this.myNotDeleteableCVsList + "\n\tmyPreUpgradeNotDeleteableCVsList: " + this.myPreUpgradeNotDeleteableCVsList);
        }
        boolean bl = true;
        if (this.myNotDeleteableCVsList.size() != this.myPreUpgradeNotDeleteableCVsList.size()) {
            bl = false;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 22, "isDeletePreventingCVsOnlyPreUpgradeCVs()", "RETURNS - theIsOnlyPreUpgradeCVs: " + bl);
        }
        return bl;
    }

    public String toString() {
        return "\n\tdeleteableCVs: " + this.myDeleteableCVsList + "\n\tnotDeleteableCVs: " + this.myNotDeleteableCVsList + "\n\tpreUpgradeDeleteableCVs: " + this.myPreUpgradeDeleteableCVsList + "\n\tpreUpgradeNotDeleteableCVs: " + this.myPreUpgradeNotDeleteableCVsList;
    }
}

