/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.repertoire;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstance;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstanceException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstances;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationsContainer;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RestartCounterLimitInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RestartTimerInformation;

public class LoadModuleInformationData {
    private HashMap myLoadModuleInformationData = new HashMap();

    public void addLoadModuleInformation(LoadModuleInformation loadModuleInformation) throws ProgramInstanceException {
        LoadModuleInformationsContainer loadModuleInformationsContainer;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addLoadModuleInformation(LoadModuleInformation aLoadModuleInformation)", "aLoadModuleInformation");
        }
        if ((loadModuleInformationsContainer = (LoadModuleInformationsContainer)this.myLoadModuleInformationData.get(loadModuleInformation.getLDN())) == null) {
            this.myLoadModuleInformationData.put(loadModuleInformation.getLDN(), new LoadModuleInformationsContainer(loadModuleInformation));
        } else {
            int n = loadModuleInformationsContainer.getLoadModuleInformationIndex(loadModuleInformation.getLoaderType());
            if (n == -1) {
                loadModuleInformationsContainer.addLoadModuleInformation(loadModuleInformation);
                this.myLoadModuleInformationData.put(loadModuleInformation.getLDN(), loadModuleInformationsContainer);
            } else {
                LoadModuleInformation loadModuleInformation2 = loadModuleInformationsContainer.getLoadModuleInformation(n);
                if (!loadModuleInformation2.getHeapSize().equals(loadModuleInformation.getHeapSize())) {
                    loadModuleInformation2.setHeapSize(this.selectHeapSize(loadModuleInformation2.getHeapSize(), loadModuleInformation.getHeapSize()));
                }
                if (!loadModuleInformation2.getPoolSize().equals(loadModuleInformation.getPoolSize())) {
                    loadModuleInformation2.setPoolSize(this.selectPoolSize(loadModuleInformation2.getPoolSize(), loadModuleInformation.getPoolSize()));
                }
                loadModuleInformation2 = this.addProgramInstances(loadModuleInformation2, loadModuleInformation.getProgramInstances());
                loadModuleInformationsContainer.setLoadModuleInformation(n, loadModuleInformation2);
                this.myLoadModuleInformationData.put(loadModuleInformation.getLDN(), loadModuleInformationsContainer);
                if (!loadModuleInformation2.getRestartCounterLimit().equals(loadModuleInformation.getRestartCounterLimit())) {
                    loadModuleInformation2.setRestartCounterLimit(this.selectRestartCounterLimitValue(loadModuleInformation2.getRestartCounterLimit(), loadModuleInformation.getRestartCounterLimit()));
                }
                if (!loadModuleInformation2.getRestartTimer().equals(loadModuleInformation.getRestartTimer())) {
                    loadModuleInformation2.setRestartTimer(this.selectRestartTimerValue(loadModuleInformation2.getRestartTimer(), loadModuleInformation.getRestartTimer()));
                }
            }
        }
    }

    private LoadModuleInformation addProgramInstances(LoadModuleInformation loadModuleInformation, String string) throws ProgramInstanceException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addProgramInstances (LoadModuleInformation aStoredLoadModuleInformation, String aNewProgramInstances)", "aStoredLoadModuleInformation: " + loadModuleInformation + "\n\taNewProgramInstances: " + string);
        }
        ProgramInstances programInstances = new ProgramInstances(loadModuleInformation.getProgramInstances());
        ProgramInstances programInstances2 = new ProgramInstances(string);
        Collection collection = programInstances2.getProgramInstances();
        Iterator iterator = collection.iterator();
        ProgramInstance programInstance = null;
        while (iterator.hasNext()) {
            programInstance = (ProgramInstance)iterator.next();
            programInstances.add(programInstance);
        }
        loadModuleInformation.setProgramInstances(programInstances.toStringPure());
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addProgramInstances (LoadModuleInformation aStoredLoadModuleInformation, String aNewProgramInstances)", "aRETURN - theStoredProgramInstances: " + programInstances);
        }
        return loadModuleInformation;
    }

    public Iterator getLoadModuleLDNs() {
        return this.myLoadModuleInformationData.keySet().iterator();
    }

    public LoadModuleInformationsContainer getLoadModuleInformationsContainer(String string) {
        return (LoadModuleInformationsContainer)this.myLoadModuleInformationData.get(string);
    }

    public Collection getLoadModuleInformationsContainers() {
        return this.myLoadModuleInformationData.values();
    }

    public String selectHeapSize(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectHeapSize(String aStoredHeapSize, String aNewHeapSize)", "aStoredHeapSize: " + string + "\n\taNewHeapSize: " + string2);
        }
        String string3 = null;
        if (string.length() > 0 && string2.length() > 0) {
            Integer n = new Integer(string);
            Integer n2 = new Integer(string2);
            string3 = n.intValue() == n2.intValue() ? string : (n < n2 ? string2 : string);
        } else {
            string3 = string.length() > 0 ? string : string2;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "selectHeapSize(String aStoredHeapSize, String aNewHeapSize)", "RETURNS - theSelectedHeapSize: " + string3);
        }
        return string3;
    }

    public String selectPoolSize(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectPoolSize(String aStoredPoolSize, String aNewPoolSize)", "aStoredPoolSize: " + string + "\n\taNewPoolSize: " + string2);
        }
        String string3 = null;
        if (string.length() > 0 && string2.length() > 0) {
            Integer n = new Integer(string);
            Integer n2 = new Integer(string2);
            string3 = n.intValue() == n2.intValue() ? string : (n < n2 ? string2 : string);
        } else {
            string3 = string.length() > 0 ? string : string2;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "selectPoolSize(String aStoredPoolSize, String aNewPoolSize)", "RETURNS - theSelectedPoolSize: " + string3);
        }
        return string3;
    }

    private RestartCounterLimitInformation selectRestartCounterLimitValue(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectRestartCounterLimitValue(String aStoredRestartCounterLimitValue, String aNewRestartCounterLimitValue)", "aStoredRestartCounterLimitValue: " + string + "\n\taNewRestartCounterLimitValue: " + string2);
        }
        String string3 = null;
        RestartCounterLimitInformation restartCounterLimitInformation = null;
        if (string.length() > 0 && string2.length() > 0) {
            Integer n = new Integer(string);
            Integer n2 = new Integer(string2);
            string3 = n.intValue() == n2.intValue() ? string : (n > n2 ? string2 : string);
            restartCounterLimitInformation = new RestartCounterLimitInformation(string3, false);
        } else if (string.length() > 0) {
            string3 = string;
            restartCounterLimitInformation = new RestartCounterLimitInformation(string3, true);
        } else {
            string3 = string2;
            restartCounterLimitInformation = new RestartCounterLimitInformation(string3, true);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "selectRestartCounterLimitValue(String aStoredRestartCounterLimitValue, String aNewRestartCounterLimitValue)", "RETURNS - theSelectedRestartCounterLimitValue: " + string3);
        }
        return restartCounterLimitInformation;
    }

    public RestartTimerInformation selectRestartTimerValue(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectRestartTimerValue(String aStoredRestartTimerValue, String aNewRestartTimerValue)", "aStoredRestartTimerValue: " + string + "\n\taNewRestartTimerValue: " + string2);
        }
        String string3 = null;
        RestartTimerInformation restartTimerInformation = null;
        if (string.length() > 0 && string2.length() > 0) {
            Integer n = new Integer(string);
            Integer n2 = new Integer(string2);
            string3 = n.intValue() == n2.intValue() ? string : (n > n2 ? string2 : string);
            restartTimerInformation = new RestartTimerInformation(string3, false);
        } else if (string.length() > 0) {
            string3 = string;
            restartTimerInformation = new RestartTimerInformation(string3, true);
        } else {
            string3 = string2;
            restartTimerInformation = new RestartTimerInformation(string3, true);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "selectRestartTimerValue(String aStoredRestartTimerValue, String aNewRestartTimerValue)", "RETURNS - theRestartTimerInformation: " + restartTimerInformation);
        }
        return restartTimerInformation;
    }

    public String toString() {
        return "\n\tmyLoadModuleInformationData: " + this.myLoadModuleInformationData;
    }

    public String toNiceString() {
        String string = "";
        String string2 = null;
        LoadModuleInformationsContainer loadModuleInformationsContainer = null;
        Iterator iterator = this.myLoadModuleInformationData.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            loadModuleInformationsContainer = (LoadModuleInformationsContainer)this.myLoadModuleInformationData.get(string2);
            string = string + "\n\t\tLDN: " + string2 + loadModuleInformationsContainer.toNiceString();
        }
        return string;
    }
}

