/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.signedsw.SignedSoftwareUtils;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.CAuesInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRef;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadList;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeRef;
import se.ericsson.cello.sudom.parser.dom.repertoire.Repertoire;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoireProxy;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.handler.LoadModuleProgramInformation;
import se.ericsson.cello.upgradepackage.util.handler.SignedSoftwareInformationForPIUs;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.CalculateC_AUEsForUpgradeSequences;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;

public class CalculateCAUEs {
    private String myLogInfoFromState = "C Aues-FromState";
    private String myLogInfoToState = "C Aues-ToState";

    private Collection calculateCAuesByCase(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateCAuesByCase(  OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase, Collection aSSW_PIUs)", "anOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCase: " + string + "\n\taSSW_PIUs: " + collection);
        }
        Collection collection2 = CalculateC_AUEsForUpgradeSequences.getCAUEsFromState(optimizedDocumentObjectProxyInterface.getUpgradeSequencesProxyInterface(), optimizedDocumentObjectProxyInterface.getExplicitReplacementsProxyInterface(), string, collection);
        Collection collection3 = new Vector();
        try {
            if (!collection2.isEmpty()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "calculateCAuesByCase(  OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase, Collection aSSW_PIUs)", "theCAUEsFromStateCollection: " + collection2);
                }
                Iterator iterator = collection2.iterator();
                PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
                RepertoiresProxyInterface repertoiresProxyInterface = optimizedDocumentObjectProxyInterface.getRepertoiresProxyInterface();
                Iterator iterator2 = null;
                Iterator iterator3 = null;
                PiuTypeRef piuTypeRef = null;
                Collection collection4 = null;
                PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
                SlotMoSU_Access slotMoSU_Access = null;
                while (iterator.hasNext()) {
                    CAuesInformation cAuesInformation = (CAuesInformation)iterator.next();
                    iterator2 = repertoiresProxyInterface.getRepertoires().iterator();
                    while (iterator2.hasNext()) {
                        Repertoire repertoire = ((RepertoireProxy)iterator2.next()).getRepertoire();
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "calculateCAuesByCase(  OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase, Collection aSSW_PIUs)", "theRepertoire.getName(): " + repertoire.getName() + "\n\ttheCAuesInformation: " + cAuesInformation);
                        }
                        if (!cAuesInformation.getMyRunProgramsRepertoireName().contains(repertoire.getName()) || !(iterator3 = repertoire.getPiuTypeLoadLists().iterator()).hasNext()) continue;
                        slotMoSU_Access = (SlotMoSU_Access)cAuesInformation.getMySlot();
                        plugInUnitMoSU_Access = pIU_MO_HandlerInterface.getPIU_MO(slotMoSU_Access);
                        collection4 = SignedSoftwareUtils.getCRL_AndCertificateLoadModuleProgramInformations(plugInUnitMoSU_Access);
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "calculateCAuesByCase(  OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase, Collection aSSW_PIUs)", "thePlugInUnitMoSU_Access: " + plugInUnitMoSU_Access + "\n\ttheCRL_AndCertificateLoadModuleProgramInformations: " + collection4);
                        }
                        piuTypeRef = this.setPiuTypeUsingAnyTypeOfRevision(plugInUnitMoSU_Access, slotMoSU_Access);
                        collection3 = this.calculateCAuesByPiuTypeLoadLists(optimizedDocumentObjectProxyInterface, iterator3, piuTypeRef, slotMoSU_Access, collection4, collection3);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "calculateCAuesByCase(  OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase, Collection aSSW_PIUs)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCurrentCase: " + string, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateCAuesByCase(  OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase, Collection aSSW_PIUs)", "RETURN - theCAUEsToStateResultCollection: " + collection3);
        }
        return collection3;
    }

    public Collection collectFromState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectFromState(  OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface , String aCase)", "aCase: " + string + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface);
        }
        Collection collection2 = null;
        try {
            collection2 = this.calculateCAuesByCase(optimizedDocumentObjectProxyInterface, string, collection);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCurrentCase: " + string, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
        SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoFromState, optimizedDocumentObjectProxyInterface, collection2);
        return collection2;
    }

    public Collection collectToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectToState(  OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface , String aCase)", "aCase: " + string + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taSSW_PIUs: " + collection);
        }
        Collection collection2 = CalculateC_AUEsForUpgradeSequences.getCAUEsToState(optimizedDocumentObjectProxyInterface.getUpgradeSequencesProxyInterface(), optimizedDocumentObjectProxyInterface.getExplicitReplacementsProxyInterface(), string, collection);
        Collection collection3 = new Vector();
        try {
            if (!collection2.isEmpty()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "collectToState(  OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface , String aCase)", "theCAUEsToStateCollection: " + collection2);
                }
                Iterator iterator = collection2.iterator();
                PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
                RepertoiresProxyInterface repertoiresProxyInterface = optimizedDocumentObjectProxyInterface.getRepertoiresProxyInterface();
                Iterator iterator2 = null;
                Iterator iterator3 = null;
                PiuTypeRef piuTypeRef = null;
                PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
                SlotMoSU_Access slotMoSU_Access = null;
                while (iterator.hasNext()) {
                    CAuesInformation cAuesInformation = (CAuesInformation)iterator.next();
                    iterator2 = repertoiresProxyInterface.getRepertoires().iterator();
                    while (iterator2.hasNext()) {
                        Repertoire repertoire = ((RepertoireProxy)iterator2.next()).getRepertoire();
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "collectToState(  OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface , String aCase)", "theRepertoire.getName(): " + repertoire.getName() + "\n\ttheCAuesInformation: " + cAuesInformation);
                        }
                        if (!cAuesInformation.getMyRunProgramsRepertoireName().contains(repertoire.getName()) || !(iterator3 = repertoire.getPiuTypeLoadLists().iterator()).hasNext()) continue;
                        slotMoSU_Access = (SlotMoSU_Access)cAuesInformation.getMySlot();
                        plugInUnitMoSU_Access = pIU_MO_HandlerInterface.getPIU_MO(slotMoSU_Access);
                        piuTypeRef = this.setPiuTypeUsingAnyTypeOfRevision(plugInUnitMoSU_Access, slotMoSU_Access);
                        collection3 = this.calculateCAuesByPiuTypeLoadLists(optimizedDocumentObjectProxyInterface, iterator3, piuTypeRef, slotMoSU_Access, null, collection3);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCurrentCase: " + string, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
        SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoToState, optimizedDocumentObjectProxyInterface, collection3);
        return collection3;
    }

    public Collection collectFromState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "--collectFromState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            Collection collection2 = new Vector(1);
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                collection2 = this.calculateCAuesByCase(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase, collection);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                collection2 = SignedSoftwareUtils.add(collection2, this.calculateCAuesByCase(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase, collection));
            }
            if (collection2 == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectFromState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor not possible to collect the programs that are valid in TO state (returns an empty list).\n\taValidSequencesInformation: " + validSequencesInformation);
                }
                return new HashSet();
            }
            SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoFromState, optimizedDocumentObjectProxyInterface, collection2);
            return collection2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collectToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectToState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection);
        }
        try {
            Collection collection2 = new Vector(1);
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                collection2 = this.collectToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase, collection);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                collection2 = SignedSoftwareUtils.add(collection2, this.collectToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase, collection));
            }
            if (!validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade) && !validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade) && Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectToState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor not possible to collect the programs that are valid in TO state (returns an empty list).\n\taValidSequencesInformation: " + validSequencesInformation);
            }
            if (collection2 == null) {
                return new HashSet();
            }
            SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoToState, optimizedDocumentObjectProxyInterface, collection2);
            return collection2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private Collection getLoadModuleProgramInformations(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, Collection collection) {
        LoadModulesProxyInterface loadModulesProxyInterface = optimizedDocumentObjectProxyInterface.getLoadModulesProxyInterface();
        LinkedList<LoadModuleProgramInformation> linkedList = new LinkedList<LoadModuleProgramInformation>();
        Iterator iterator = collection.iterator();
        LoadModuleRef loadModuleRef = null;
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        while (iterator.hasNext()) {
            loadModuleRef = (LoadModuleRef)iterator.next();
            loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(loadModuleRef.getProductNumber(), loadModuleRef.getRevision());
            linkedList.add(new LoadModuleProgramInformation(loadModuleProxyInterface.getDeviceLoaderInformation(), loadModuleProxyInterface.getDeviceLoaderName(), loadModuleProxyInterface.getLoaderName(), loadModuleProxyInterface.getProductNumber(), loadModuleProxyInterface.getProductRevision(), SignedSoftwareUtils.theTag0, loadModuleProxyInterface.getOseProgramLoadClass(), SignedSoftwareUtils.getDestinationFilePaths(optimizedDocumentObjectProxyInterface, loadModuleProxyInterface, loadModuleProxyInterface.getProductNumber(), loadModuleProxyInterface.getProductRevision())));
        }
        return linkedList;
    }

    private PiuTypeRef setPiuTypeUsingAnyTypeOfRevision(PlugInUnitMoSU_Access plugInUnitMoSU_Access, SlotMoSU_Access slotMoSU_Access) {
        String string = "setPiuTypeUsingAnyTypeOfRevision(PlugInUnitMoSU_Access aPlugInUnitMoSU_Access, SlotMoSU_Access aSlotMo)";
        PiuTypeRef piuTypeRef = null;
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, string, "aPlugInUnitMoSU_Access: " + plugInUnitMoSU_Access + "\n\taSlotMo: " + slotMoSU_Access);
        }
        try {
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)plugInUnitMoSU_Access.getPiuType(null);
            ProductNumberAndRevision productNumberAndRevision = null;
            productNumberAndRevision = ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3") ? new ProductNumberAndRevision(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null)) : new ProductNumberAndRevision(StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
            piuTypeRef = new PiuTypeRef(productNumberAndRevision);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "thePiuTypeRef: " + piuTypeRef);
            }
            if (piuTypeRef.getRevision().equals("*") || piuTypeRef.getRevision().equals(ProductNumberAndRevision.getShortProductRevision(piuTypeRef.getRevision()))) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Wildcard revision found in piuType. Using the product revision of the slot to find load modules to install.");
                }
                SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
                String string2 = slotMO_HandlerInterface.getSlotRState(slotMoSU_Access);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Product revision of the slot that holds the PlugInUnit: " + slotMO_HandlerInterface.getSlotProductNumber(slotMoSU_Access) + "\n\ttheSlotRevision: " + string2);
                }
                if (string2 != null && !string2.equals("")) {
                    String string3 = slotMO_HandlerInterface.getSlotProductNumber(slotMoSU_Access);
                    if (string3.equals(piuTypeRef.getProductNumber())) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, string, "The product number registered in slot matches the configured PiuType.\n\ttheSlotRevision: " + string2);
                        }
                        piuTypeRef.setRevision(string2);
                    } else if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, string, "The slot product number holding the piu is not the same as configured piu type product number. The configured not supported wildcard revision can't be looked up to a specific or short revision in UCF.\n\taPiuTypeMoData: " + piuTypeRef + "\n\ttheSlotRevision: " + string2);
                    }
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "The slot revision is null or an empty string. The configured not supported wildcard revision can't be looked up to a specific or short revision in UCF.\n\taPiuTypeMoData: " + piuTypeRef + "\n\ttheSlotRevision: " + string2);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taPiuTypeRef: " + piuTypeRef + "\n\taSlotMo: " + slotMoSU_Access, throwable);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, string, "RETURN - The product number registered in slot matches the configured PiuType.\n\tthePiuTypeRef: " + piuTypeRef);
        }
        return piuTypeRef;
    }

    private Collection calculateCAuesByPiuTypeLoadLists(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, Iterator iterator, PiuTypeRef piuTypeRef, SlotMoSU_Access slotMoSU_Access, Collection collection, Collection collection2) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateCAuesByPiuTypeLoadLists(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, Iterator aPiuTypeLoadLists, PiuTypeRef aPiuTypeRef, SlotMoSU_Access aSlotMo,Collection aCRL_AndCertificateLoadModuleProgramInformations, Collection aCAUEsToStateResultCollection)", "anOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taPiuTypeLoadLists: " + iterator + "\n\taPiuTypeRef: " + piuTypeRef + "\n\taSlotMo: " + slotMoSU_Access + "\n\taCRL_AndCertificateLoadModuleProgramInformations: " + collection + "\n\taCAUEsToStateResultCollection: " + collection2);
        }
        PiuTypeLoadList piuTypeLoadList = null;
        SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
        while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            if (!piuTypeLoadList.getPiuTypeRefs().contains(piuTypeRef)) continue;
            signedSoftwareInformationForPIUs = new SignedSoftwareInformationForPIUs(((SubrackMoSU_Access)slotMoSU_Access.getParent()).getSwitchModuleNumber(null), slotMoSU_Access.getAsciPortNumber(null), this.getLoadModuleProgramInformations(optimizedDocumentObjectProxyInterface, piuTypeLoadList.getLoadModuleRefs()));
            if (collection != null && !collection.isEmpty()) {
                signedSoftwareInformationForPIUs.getSignedProgramInformationsForPIU().addAll(collection);
            }
            collection2 = SignedSoftwareUtils.add(signedSoftwareInformationForPIUs, collection2);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateCAuesByPiuTypeLoadLists(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, Iterator aPiuTypeLoadLists, PiuTypeRef aPiuTypeRef, SlotMoSU_Access aSlotMo,Collection aCRL_AndCertificateLoadModuleProgramInformations, Collection aCAUEsToStateResultCollection)", "RETURN - aCAUEsToStateResultCollection: " + collection2);
        }
        return collection2;
    }
}

