/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.piutype.DefaultPiuRoleValue;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypesProxyInterface;
import se.ericsson.cello.sudom.proxy.subrackprodtype.FanConfigurationValue;
import se.ericsson.cello.sudom.proxy.subrackprodtype.SubrackProdTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.subrackprodtype.SubrackProdTypesProxyInterface;
import se.ericsson.cello.sudom.proxy.subrackprodtype.TransmissionTypeValue;
import se.ericsson.cello.sudom.proxy.transform.TransformProxyInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.MAO_LayerNotSupporting;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.event.VerifyRequestEvent;

public class MAO_LayerConsistencyVerifier {
    public Collection verify(VerifyRequestEvent verifyRequestEvent) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "Collection verify(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        try {
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = this.getDocumentObjectProxyInterface(verifyRequestEvent);
            SubrackProdTypesProxyInterface subrackProdTypesProxyInterface = optimizedDocumentObjectProxyInterface.getSubrackProdTypesProxyInterface();
            Collection collection = subrackProdTypesProxyInterface.getSubrackProdTypeProxyInterfaces();
            Iterator iterator = collection.iterator();
            SubrackProdTypeProxyInterface subrackProdTypeProxyInterface = null;
            FanConfigurationValue fanConfigurationValue = null;
            TransmissionTypeValue transmissionTypeValue = null;
            SubrackProdTypeMO_HandlerInterface subrackProdTypeMO_HandlerInterface = ServiceFinder.getSubrackProdTypeMO_HandlerInterface();
            LinkedList<MAO_LayerNotSupporting> linkedList = new LinkedList<MAO_LayerNotSupporting>();
            TransformProxyInterface transformProxyInterface = optimizedDocumentObjectProxyInterface.getTransformProxyInterface();
            while (iterator.hasNext()) {
                subrackProdTypeProxyInterface = (SubrackProdTypeProxyInterface)iterator.next();
                fanConfigurationValue = subrackProdTypeProxyInterface.getFanConfiguration();
                if (fanConfigurationValue.getValue() == FanConfigurationValue.CAX_TWO.getValue() && !subrackProdTypeMO_HandlerInterface.isSU_VersionSupported("SU_3") && !transformProxyInterface.existsTransformForAttribute(SubrackProdTypeProxyInterface.FAN_CONFIGURATION_ATTRIBUTE, fanConfigurationValue.getDescription())) {
                    linkedList.add(new MAO_LayerNotSupporting("SubrackProdType", subrackProdTypeProxyInterface.getFanConfigurationAttributeName(), fanConfigurationValue.getValue() + " (" + fanConfigurationValue.getDescription() + ") "));
                }
                if ((transmissionTypeValue = subrackProdTypeProxyInterface.getTransmissionType()).getValue() != TransmissionTypeValue.ETHERNET_1G_10G_40G.getValue() || subrackProdTypeMO_HandlerInterface.isSU_VersionSupported("SU_3") || transformProxyInterface.existsTransformForAttribute(SubrackProdTypeProxyInterface.TRANSMISSION_TYPE_ATTRIBUTE, transmissionTypeValue.getDescription())) continue;
                linkedList.add(new MAO_LayerNotSupporting("SubrackProdType", subrackProdTypeProxyInterface.getTranssmissionTypeAttributeName(), transmissionTypeValue.getValue() + " (" + transmissionTypeValue.getDescription() + ") "));
            }
            PiuTypesProxyInterface piuTypesProxyInterface = optimizedDocumentObjectProxyInterface.getPiuTypesProxyInterface();
            Collection collection2 = piuTypesProxyInterface.getPiuTypeProxyInterfaces();
            Iterator iterator2 = collection2.iterator();
            PiuTypeProxyInterface piuTypeProxyInterface = null;
            DefaultPiuRoleValue defaultPiuRoleValue = null;
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            while (iterator2.hasNext()) {
                piuTypeProxyInterface = (PiuTypeProxyInterface)iterator2.next();
                defaultPiuRoleValue = piuTypeProxyInterface.getDefaultPiuRoleValue();
                if (defaultPiuRoleValue.getValue() != DefaultPiuRoleValue.GP.getValue() || piuTypeMO_HandlerInterface.isSU_VersionSupported("SU_2") || transformProxyInterface.existsTransformForAttribute(PiuTypeProxyInterface.DEFAULT_PIU_ROLE_ATTRIBUTE, defaultPiuRoleValue.getDescription())) continue;
                linkedList.add(new MAO_LayerNotSupporting("PiuType", piuTypeProxyInterface.getDefaultPiuRoleAttributeName(), defaultPiuRoleValue.getValue() + " (" + defaultPiuRoleValue.getDescription() + ") "));
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "Collection verify(VerifyRequestEvent aVerifyRequestEvent)", "RETURNS - theMAO_LayerNotSupportingUCF_Datas: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verify(VerifyRequestEvent aVerifyRequestEvent)", "Throwable caught");
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private OptimizedDocumentObjectProxyInterface getDocumentObjectProxyInterface(VerifyRequestEvent verifyRequestEvent) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDocumentObjectProxyInterface(VerifyRequestEvent aVerifyRequestEvent)", "aVerifyRequestEvent: " + verifyRequestEvent);
        }
        try {
            String[] stringArray = new String[]{"Repertoire", "ExplicitReplacement", "LoadModule", "PiuType", "Transform"};
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElementsOptimizedInterface(verifyRequestEvent.upgradePackageDocumentNumber, verifyRequestEvent.upgradePackageDocumentRevision, verifyRequestEvent.upgradePackageUCF_Path, stringArray, false);
            return optimizedDocumentObjectProxyInterface;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw new VerifyRequestException(upgradeControlFileParserException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDocumentObjectProxyInterface(VerifyRequestEvent aVerifyRequestEvent)", "Throwable caught.aVerifyRequestEvent: " + verifyRequestEvent, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }
}

