/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.managedelement.meaccess.UpgradeOngoingException;
import se.ericsson.cello.managedelement.meaccess.UpgradePackageChecksumVerifier;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.verify.UpgradePackageActiveException;

public class UpgradePackageChecksumVerifierImpl
implements UpgradePackageChecksumVerifier {
    private static final long UPGRADE_LOCK_TIMEOUT = 10000L;
    private static final long RETRY_INTERVAL = 200L;
    private boolean healthCheckStarted;

    public boolean isHealthCheckOngoing() {
        return this.healthCheckStarted;
    }

    public void setHealthCheckStatus(boolean bl) {
        this.healthCheckStarted = bl;
    }

    public boolean isUpgradeOngoing(String string) throws MoAccessException {
        ServiceSubType serviceSubType = this.checkAndGetServiceSubType(string);
        boolean bl = false;
        if (this.isUpgradeLocked(serviceSubType)) {
            bl = true;
        } else {
            Collection collection = this.findAllUpgradePackages();
            try {
                this.checkStatus(collection);
            }
            catch (UpgradeOngoingException upgradeOngoingException) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyAllLoadModuleChecksums(String string) throws UpgradeOngoingException, MoAccessException {
        ServiceSubType serviceSubType = this.checkAndGetServiceSubType(string);
        this.lockUpgrade(10000L, string);
        boolean bl = true;
        try {
            Collection collection = this.findAllUpgradePackages();
            this.checkStatus(collection);
            bl = this.verifyChecksums(collection);
        }
        finally {
            UpgradeCoordinator.instance().unlock(serviceSubType);
        }
        return bl;
    }

    private ServiceSubType checkAndGetServiceSubType(String string) throws ActionNotAllowedException {
        if (string.equals(ServiceSubType.healthCheck.getValue())) {
            return ServiceSubType.healthCheck;
        }
        throw new ActionNotAllowedException("Failed to lock the upgrade logic, unknown serviceSubType received: " + string);
    }

    private Collection findAllUpgradePackages() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                arrayList.add(moIterator.nextElement());
            }
        }
        return arrayList;
    }

    private void checkStatus(Collection collection) throws UpgradeOngoingException, MoAccessException {
        UpgradePackageMo upgradePackageMo = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            upgradePackageMo = (UpgradePackageMo)iterator.next();
            if (!this.isActive(upgradePackageMo)) continue;
            throw new UpgradePackageActiveException(upgradePackageMo.getUpgradePackageDocumentId(null));
        }
    }

    private boolean isActive(UpgradePackageMo upgradePackageMo) throws MoAccessException {
        int n = upgradePackageMo.getProgressHeader(null);
        int n2 = upgradePackageMo.getState(null);
        if (n == 0) {
            return n2 == 3 || n2 == 10 || n2 == 5 || n2 == 9 || n2 == 2;
        }
        return true;
    }

    private boolean verifyChecksums(Collection collection) throws MoAccessException {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = ((UpgradePackageMoExtended)iterator.next()).verifyLMChecksums();
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    private boolean isUpgradeLocked(ServiceSubType serviceSubType) throws MoAccessException {
        UpgradeCoordinator upgradeCoordinator = UpgradeCoordinator.instance();
        if (upgradeCoordinator.lock(serviceSubType)) {
            upgradeCoordinator.unlock(serviceSubType);
            return false;
        }
        return true;
    }

    private void lockUpgrade(long l, String string) throws UpgradeOngoingException, MoAccessException {
        UpgradeCoordinator upgradeCoordinator = UpgradeCoordinator.instance();
        StopWatch stopWatch = new StopWatch();
        while (!upgradeCoordinator.lock(string)) {
            if (stopWatch.getTime() > l) {
                throw new UpgradeOngoingException("Timed out waiting for system upgrade lock");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static class StopWatch {
        private long startTime = System.currentTimeMillis();

        public long getTime() {
            return System.currentTimeMillis() - this.startTime;
        }
    }
}

