/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradetrace.main;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import se.ericsson.cello.managedelement.suaccess.MoDataRecoveryHelperProxy;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.UpgradeTraceMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceHandler;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceHandlerInterface;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceData;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceDebug;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceError;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfo;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfoDataContainer;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceLog;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceWarning;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNameInUseException;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNotFoundException;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNotInUseException;
import se.ericsson.cello.upgradepackage.trace.validate.TraceAttributeValidator;
import se.ericsson.cello.upgradepackage.trace.validate.TraceAttributeValidatorException;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class UpgradeTraceMoImpl
extends ManagedObjectBase
implements UpgradeTraceMo,
PropertyChangeListener {
    private static UpgradeTraceMoImpl myInstance = null;
    private MoData myMoData;
    private UpgradeTraceHandlerInterface myUpgradeTraceHandler = UpgradeTraceHandler.instance();
    private NotificationSender myNotificationSender = NotificationSender.instance();
    private static final String traceId = "1";
    private static String[] traceInfoNames = new String[]{"type", "className", "methodName", "additionalInformation", "timeStamp", "version"};
    private static Object[] traceInfoValues = new Object[]{new Integer(0), "", "", "", "", ""};
    private Struct myTraceInformation = new StructImpl(traceInfoNames, traceInfoValues);
    private static final int MO_DATA_REVISION_60 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$I;

    public static synchronized UpgradeTraceMoImpl instance() {
        try {
            if (myInstance == null) {
                myInstance = new UpgradeTraceMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            MessageLog.traceError((Class)UpgradeTraceMoImpl.class, (String)"Create instance of Trace MO failed", (Throwable)moNameAlreadyTakenException);
        }
        return myInstance;
    }

    private UpgradeTraceMoImpl() throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement")).getMo(), "UpgradeTrace", traceId, null);
    }

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        throw new MoCanNotBeCreatedException("UpgradeTrace");
    }

    public void actionClearLogFile(Coordinator coordinator) throws MoAccessException {
        try {
            this.myUpgradeTraceHandler.clearTraceFile();
        }
        catch (LogFileNotInUseException logFileNotInUseException) {
            throw new OperationNotAllowedException("Cannot clear trace file when it is not in use.", "UpgradeTrace");
        }
        catch (Throwable throwable) {
            throw new OperationNotAllowedException("Throwable caught when trying to clear log file. Throwable: " + throwable, "UpgradeTrace");
        }
        this.changeTypeOfStorageAtModification(coordinator);
    }

    public void actionSetDefaultProperties(Coordinator coordinator) throws MoAccessException {
        TraceInfoDataContainer traceInfoDataContainer = new TraceInfoDataContainer();
        this.myUpgradeTraceHandler.getTraceInfoData().updateAllAttributes(traceInfoDataContainer);
        this.addRemovePropertyChangeListener();
    }

    public void actionAddClasses(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i].trim());
        }
        this.myUpgradeTraceHandler.getTraceInfoData().addActiveClasses(hashSet);
        if (this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage() == 1) {
            this.setActiveClassesInDatabase(this.myUpgradeTraceHandler.getTraceInfoData().getActiveClassesStringArray(), coordinator);
        } else {
            this.changeTypeOfStorageAtModification(coordinator);
        }
    }

    public void actionRemoveClasses(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i].trim());
        }
        this.myUpgradeTraceHandler.getTraceInfoData().removeActiveClasses(hashSet);
        if (this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage() == 1) {
            this.setActiveClassesInDatabase(this.myUpgradeTraceHandler.getTraceInfoData().getActiveClassesStringArray(), coordinator);
        } else {
            this.changeTypeOfStorageAtModification(coordinator);
        }
    }

    public void actionAddFunctions(int[] nArray, Coordinator coordinator) throws MoAccessException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            hashSet.add(new Integer(nArray[i]));
        }
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        hashSet2.addAll(hashSet);
        hashSet2.addAll(this.myUpgradeTraceHandler.getTraceInfoData().getActiveFunctions());
        try {
            TraceAttributeValidator.checkActiveFunctions(hashSet2);
        }
        catch (TraceAttributeValidatorException traceAttributeValidatorException) {
            throw new OperationNotAllowedException(traceAttributeValidatorException.getReasonTag(), "UpgradeTrace");
        }
        this.myUpgradeTraceHandler.getTraceInfoData().addActiveFunctions(hashSet);
        if (this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage() == 1) {
            this.setActiveFunctionsInDatabase(this.myUpgradeTraceHandler.getTraceInfoData().getActiveFunctionsIntArray(), coordinator);
        } else {
            this.changeTypeOfStorageAtModification(coordinator);
        }
    }

    public void actionRemoveFunctions(int[] nArray, Coordinator coordinator) throws MoAccessException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            hashSet.add(new Integer(nArray[i]));
        }
        this.myUpgradeTraceHandler.getTraceInfoData().removeActiveFunctions(hashSet);
        if (this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage() == 1) {
            this.setActiveFunctionsInDatabase(this.myUpgradeTraceHandler.getTraceInfoData().getActiveFunctionsIntArray(), coordinator);
        } else {
            this.changeTypeOfStorageAtModification(coordinator);
        }
    }

    public String[] actionListNotActiveLogFiles(Coordinator coordinator) throws MoAccessException {
        Collection collection = this.myUpgradeTraceHandler.getNotActiveLogFiles();
        return collection.toArray(new String[0]);
    }

    public void actionDeleteLogFile(String string, Coordinator coordinator) throws MoAccessException {
        try {
            this.myUpgradeTraceHandler.deleteLogFile(string);
        }
        catch (LogFileNotFoundException logFileNotFoundException) {
            throw new OperationNotAllowedException(logFileNotFoundException.getReasonTag(), "UpgradeTrace");
        }
        catch (LogFileNameInUseException logFileNameInUseException) {
            throw new OperationNotAllowedException(logFileNameInUseException.getReasonTag(), "UpgradeTrace");
        }
    }

    public void actionFlushTracesToFile(Coordinator coordinator) throws MoAccessException {
        if (this.myUpgradeTraceHandler.getTraceInfoData().getOutputMode() != 0) {
            throw new OperationNotAllowedException("The upgrade trace output is currently not directed to a file.", "UpgradeTrace");
        }
        this.myUpgradeTraceHandler.flushToTraceFile();
        this.changeTypeOfStorageAtModification(coordinator);
    }

    public void actionClearTraceLevelSU(Coordinator coordinator) throws MoAccessException {
        this.myUpgradeTraceHandler.getTraceInfoData().setLevelsSU(new HashSet());
    }

    public void reloadTraceProperties() {
        this.actionReloadTraceProperties(null);
    }

    public void actionReloadTraceProperties(Coordinator coordinator) {
        int n = ((IntegerAttribute)this.myMoData.getAttribute("typeOfStorage")).getValue(null);
        if (n == 1) {
            this.reloadTraceInfoFromDatabase(coordinator);
        } else {
            this.myUpgradeTraceHandler.reloadTraceInfoFromPropFile();
        }
        this.addRemovePropertyChangeListener();
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.myMoData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.myMoData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Cloneable cloneable;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("outputMode")) {
                objectArray[i] = new Integer(this.myUpgradeTraceHandler.getTraceInfoData().getOutputMode());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("level")) {
                objectArray[i] = new Integer(this.myUpgradeTraceHandler.getTraceInfoData().getLevel());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fileName")) {
                objectArray[i] = this.myUpgradeTraceHandler.getTraceInfoData().getFileName(true);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fileSize")) {
                objectArray[i] = new Integer(this.myUpgradeTraceHandler.getTraceInfoData().getFileSize());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("flushInterval")) {
                objectArray[i] = new Integer(this.myUpgradeTraceHandler.getTraceInfoData().getFlushInterval());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeClasses")) {
                objectArray[i] = this.myUpgradeTraceHandler.getTraceInfoData().getActiveClassesStringArray();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeFunctions")) {
                objectArray[i] = this.myUpgradeTraceHandler.getTraceInfoData().getActiveFunctionsIntArray();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sendLogsAsNotifications")) {
                objectArray[i] = new Integer(this.myUpgradeTraceHandler.getTraceInfoData().getSendLogsAsNotifications());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("traceInformation")) {
                objectArray[i] = this.myTraceInformation;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("typeOfStorage")) {
                objectArray[i] = new Integer(this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("traceDirectoryPath")) {
                objectArray[i] = this.myUpgradeTraceHandler.getTraceInfoData().getTraceDirectoryPath();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("levelsSU")) {
                cloneable = this.myUpgradeTraceHandler.getTraceInfoData().getLevelsSU();
                objectArray[i] = TraceAttributeValidator.convertLevelsSU_Collection(cloneable);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeMethodsSU")) {
                cloneable = this.myUpgradeTraceHandler.getTraceInfoData().getActiveMethodsSU();
                objectArray[i] = TraceAttributeValidator.convertActiveMethodsSU_Map((TreeMap)cloneable);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "UpgradeTrace");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.myMoData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Cloneable cloneable;
            String string;
            int n2;
            if (stringArray[i].equalsIgnoreCase("outputMode")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? UpgradeTraceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("outputMode", "UpgradeTrace");
                }
                n2 = (Integer)objectArray[i];
                try {
                    TraceAttributeValidator.checkOutputMode(n2);
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("outputMode", "UpgradeTrace");
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setOutputMode(n2);
                this.changeTypeOfStorageAtModification(coordinator);
                this.sendNotification("outputMode", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("level")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? UpgradeTraceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("level", "UpgradeTrace");
                }
                n2 = (Integer)objectArray[i];
                try {
                    TraceAttributeValidator.checkLevel(n2);
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("level", "UpgradeTrace");
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setLevel(n2);
                this.changeTypeOfStorageAtModification(coordinator);
                this.sendNotification("level", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fileName")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? UpgradeTraceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("fileName", "UpgradeTrace");
                }
                string = (String)objectArray[i];
                try {
                    TraceAttributeValidator.checkFileName(string);
                    this.myUpgradeTraceHandler.getTraceInfoData().setFileName(string);
                    this.changeTypeOfStorageAtModification(coordinator);
                    this.sendNotification("fileName", string, coordinator);
                    continue;
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("fileName", "UpgradeTrace", traceAttributeValidatorException.getReasonTag());
                }
            }
            if (stringArray[i].equalsIgnoreCase("fileSize")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? UpgradeTraceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("fileSize", "UpgradeTrace");
                }
                n2 = (Integer)objectArray[i];
                try {
                    TraceAttributeValidator.checkFileSize(n2);
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("fileSize", "UpgradeTrace");
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setFileSize(n2);
                this.changeTypeOfStorageAtModification(coordinator);
                this.sendNotification("fileSize", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("flushInterval")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? UpgradeTraceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("flushInterval", "UpgradeTrace");
                }
                n2 = (Integer)objectArray[i];
                try {
                    TraceAttributeValidator.checkFlushInterval(n2);
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("flushInterval", "UpgradeTrace");
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setFlushInterval(n2);
                this.changeTypeOfStorageAtModification(coordinator);
                this.sendNotification("flushInterval", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeClasses")) {
                if (!objectArray[i].getClass().equals(array$Ljava$lang$String == null ? UpgradeTraceMoImpl.class$("[Ljava.lang.String;") : array$Ljava$lang$String)) {
                    throw new WrongAttributeTypeException("activeClasses", "UpgradeTrace");
                }
                String[] stringArray2 = (String[])objectArray[i];
                cloneable = new HashSet();
                for (n = 0; n < stringArray2.length; ++n) {
                    cloneable.add(stringArray2[n].trim());
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setActiveClasses((HashSet)cloneable);
                this.changeTypeOfStorageAtModification(coordinator);
                this.sendNotification("activeClasses", stringArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("activeFunctions")) {
                if (!objectArray[i].getClass().equals(array$I == null ? UpgradeTraceMoImpl.class$("[I") : array$I)) {
                    throw new WrongAttributeTypeException("activeFunctions", "UpgradeTrace");
                }
                int[] nArray = (int[])objectArray[i];
                cloneable = new HashSet();
                for (n = 0; n < nArray.length; ++n) {
                    cloneable.add(new Integer(nArray[n]));
                }
                try {
                    TraceAttributeValidator.checkActiveFunctions(cloneable);
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("activeFunctions", "UpgradeTrace", traceAttributeValidatorException.getReasonTag());
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setActiveFunctions((HashSet)cloneable);
                this.changeTypeOfStorageAtModification(coordinator);
                this.sendNotification("activeFunctions", nArray, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sendLogsAsNotifications")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? UpgradeTraceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("sendLogsAsNotifications", "UpgradeTrace");
                }
                n2 = (Integer)objectArray[i];
                try {
                    TraceAttributeValidator.checkSendLogsAsNotification(n2);
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("sendLogsAsNotifications", "UpgradeTrace");
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setSendLogsAsNotifications(n2);
                this.changeTypeOfStorageAtModification(coordinator);
                this.addRemovePropertyChangeListener();
                this.sendNotification("sendLogsAsNotifications", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("typeOfStorage")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? UpgradeTraceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("typeOfStorage", "UpgradeTrace");
                }
                n2 = (Integer)objectArray[i];
                try {
                    TraceAttributeValidator.checkTypeOfStorage(n2);
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("typeOfStorage", "UpgradeTrace");
                }
                this.myUpgradeTraceHandler.getTraceInfoData().setTypeOfStorage(n2);
                this.sendNotification("typeOfStorage", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("levelsSU")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? UpgradeTraceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("levelsSU", "UpgradeTrace");
                }
                string = (String)objectArray[i];
                try {
                    cloneable = TraceAttributeValidator.convertLevelsSU_String(string);
                    Iterator iterator = cloneable.iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        TraceAttributeValidator.checkLevel(n);
                    }
                    this.myUpgradeTraceHandler.getTraceInfoData().setLevelsSU((HashSet)cloneable);
                    this.changeTypeOfStorageAtModification(coordinator);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ValueOutOfRangeException("levelsSU", "UpgradeTrace", "String contains a non parsable integer.");
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("levelsSU", "UpgradeTrace", traceAttributeValidatorException.getReasonTag());
                }
            }
            if (stringArray[i].equalsIgnoreCase("activeMethodsSU")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? UpgradeTraceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("activeMethodsSU", "UpgradeTrace");
                }
                string = (String)objectArray[i];
                try {
                    cloneable = TraceAttributeValidator.convertActiveMethodsSU_String(string);
                    this.myUpgradeTraceHandler.getTraceInfoData().setActiveMethodsSU((TreeMap)cloneable);
                    continue;
                }
                catch (TraceAttributeValidatorException traceAttributeValidatorException) {
                    throw new ValueOutOfRangeException("activeMethodsSU", "UpgradeTrace", traceAttributeValidatorException.getReasonTag());
                }
            }
            throw new NoSuchAttributeException(stringArray[i], "UpgradeTrace");
        }
        if (this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage() == 1) {
            this.storeTraceInfoAttrIntoDataBase(coordinator);
        }
    }

    public String[] getActiveClasses(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("activeClasses", coordinator);
    }

    public void setActiveClasses(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("activeClasses", stringArray, coordinator);
    }

    public int[] getActiveFunctions(Coordinator coordinator) throws MoAccessException {
        return (int[])this.getAttribute("activeFunctions", coordinator);
    }

    public void setActiveFunctions(int[] nArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("activeFunctions", nArray, coordinator);
    }

    public String getFileName(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("fileName", coordinator);
    }

    public void setFileName(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("fileName", string, coordinator);
    }

    public int getFileSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("fileSize", coordinator);
    }

    public void setFileSize(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("fileSize", new Integer(n), coordinator);
    }

    public int getFlushInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("flushInterval", coordinator);
    }

    public void setFlushInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("flushInterval", new Integer(n), coordinator);
    }

    public int getLevel(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("level", coordinator);
    }

    public void setLevel(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("level", new Integer(n), coordinator);
    }

    public int getOutputMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("outputMode", coordinator);
    }

    public void setOutputMode(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("outputMode", new Integer(n), coordinator);
    }

    public int getSendLogsAsNotifications(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("sendLogsAsNotifications", coordinator);
    }

    public void setSendLogsAsNotifications(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("sendLogsAsNotifications", new Integer(n), coordinator);
    }

    public String getTraceDirectoryPath(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("traceDirectoryPath", coordinator);
    }

    public Struct getTraceInformation(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("traceInformation", coordinator);
    }

    public int getTypeOfStorage(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("typeOfStorage", coordinator);
    }

    public void setTypeOfStorage(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("typeOfStorage", new Integer(n), coordinator);
    }

    public void recover(MoData moData, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        this.myMoData = moData;
        MoDataRecoveryHelperProxy moDataRecoveryHelperProxy = new MoDataRecoveryHelperProxy(this.myMoData, (ManagedObject)this);
        moDataRecoveryHelperProxy.assertMoDataRevision(6000);
        moDataRecoveryHelperProxy.assertAttribute("activeClasses");
        moDataRecoveryHelperProxy.assertAttribute("activeFunctions");
        moDataRecoveryHelperProxy.assertAttribute("fileName");
        moDataRecoveryHelperProxy.assertAttribute("fileSize");
        moDataRecoveryHelperProxy.assertAttribute("flushInterval");
        moDataRecoveryHelperProxy.assertAttribute("level");
        moDataRecoveryHelperProxy.assertAttribute("outputMode");
        moDataRecoveryHelperProxy.assertAttribute("sendLogsAsNotifications");
        moDataRecoveryHelperProxy.assertAttribute("typeOfStorage");
        int n = ((IntegerAttribute)this.myMoData.getAttribute("typeOfStorage")).getValue(null);
        if (n == 1) {
            this.reloadTraceInfoFromDatabase(null);
            Trace.log1(this.getClass(), "recover(MoData recoveredData, InitialMaoContext maoContext)", this.myUpgradeTraceHandler.getTraceInfoData().getLogString());
        }
        this.addRemovePropertyChangeListener();
        this.myUpgradeTraceHandler.getTraceInfoData().setUpgradeTraceMoLoaded(Boolean.TRUE);
    }

    public synchronized void registerData() {
        if (this.myMoData == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.myMoData = new MoData(this.getLocalDistinguishedName(), "UpgradeTrace", true, coordinator);
                this.myMoData.registerPersistentAttr((Attribute)new SequenceAttribute("activeClasses", false));
                this.myMoData.registerPersistentAttr((Attribute)new SequenceAttribute("activeFunctions", false));
                this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("fileName", false));
                this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("fileSize", false));
                this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("flushInterval", false));
                this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("level", false));
                this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("outputMode", false));
                this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("sendLogsAsNotifications", false));
                this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("typeOfStorage", true, 0));
                this.myMoData.setRevision(6000);
                this.myMoData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), (String)"Failed to register data, throwable caught.", (Throwable)throwable);
            }
            this.myUpgradeTraceHandler.getTraceInfoData().setUpgradeTraceMoLoaded(Boolean.TRUE);
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public String getType() {
        return "UpgradeTrace";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof TraceData) {
            TraceData traceData = (TraceData)propertyChangeEvent.getNewValue();
            if (traceData instanceof TraceDebug) {
                TraceDebug traceDebug = (TraceDebug)traceData;
                UpgradeTraceMoImpl.traceInfoValues[0] = new Integer(0);
                UpgradeTraceMoImpl.traceInfoValues[1] = traceDebug.getClassName();
                UpgradeTraceMoImpl.traceInfoValues[2] = traceDebug.getMethod();
                UpgradeTraceMoImpl.traceInfoValues[3] = traceDebug.getSlogan();
                UpgradeTraceMoImpl.traceInfoValues[4] = traceDebug.getTimeStamp();
                UpgradeTraceMoImpl.traceInfoValues[5] = traceDebug.getVersion();
            } else if (traceData instanceof TraceError) {
                TraceError traceError = (TraceError)traceData;
                Throwable throwable = traceError.getException();
                String string = null;
                if (throwable != null) {
                    string = " Exception: " + throwable.toString();
                }
                if (string == null) {
                    string = "";
                }
                UpgradeTraceMoImpl.traceInfoValues[0] = new Integer(1);
                UpgradeTraceMoImpl.traceInfoValues[1] = traceError.getClassName();
                UpgradeTraceMoImpl.traceInfoValues[2] = traceError.getMethod();
                UpgradeTraceMoImpl.traceInfoValues[3] = traceError.getSlogan() + string;
                UpgradeTraceMoImpl.traceInfoValues[4] = traceError.getTimeStamp();
                UpgradeTraceMoImpl.traceInfoValues[5] = traceError.getVersion();
            } else if (traceData instanceof TraceInfo) {
                TraceInfo traceInfo = (TraceInfo)traceData;
                UpgradeTraceMoImpl.traceInfoValues[0] = new Integer(2);
                UpgradeTraceMoImpl.traceInfoValues[1] = traceInfo.getClassName();
                UpgradeTraceMoImpl.traceInfoValues[2] = traceInfo.getMethod();
                UpgradeTraceMoImpl.traceInfoValues[3] = traceInfo.getSlogan();
                UpgradeTraceMoImpl.traceInfoValues[4] = traceInfo.getTimeStamp();
                UpgradeTraceMoImpl.traceInfoValues[5] = traceInfo.getVersion();
            } else if (traceData instanceof TraceLog) {
                TraceLog traceLog = (TraceLog)traceData;
                UpgradeTraceMoImpl.traceInfoValues[0] = new Integer(3);
                UpgradeTraceMoImpl.traceInfoValues[1] = traceLog.getClassName();
                UpgradeTraceMoImpl.traceInfoValues[2] = traceLog.getMethod();
                UpgradeTraceMoImpl.traceInfoValues[3] = traceLog.getSlogan();
                UpgradeTraceMoImpl.traceInfoValues[4] = traceLog.getTimeStamp();
                UpgradeTraceMoImpl.traceInfoValues[5] = traceLog.getVersion();
            } else if (traceData instanceof TraceWarning) {
                TraceWarning traceWarning = (TraceWarning)traceData;
                UpgradeTraceMoImpl.traceInfoValues[0] = new Integer(4);
                UpgradeTraceMoImpl.traceInfoValues[1] = traceWarning.getClassName();
                UpgradeTraceMoImpl.traceInfoValues[2] = traceWarning.getMethod();
                UpgradeTraceMoImpl.traceInfoValues[3] = traceWarning.getSlogan();
                UpgradeTraceMoImpl.traceInfoValues[4] = traceWarning.getTimeStamp();
                UpgradeTraceMoImpl.traceInfoValues[5] = traceWarning.getVersion();
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent, false);
                return;
            }
            this.myTraceInformation = new StructImpl(traceInfoNames, traceInfoValues);
            this.sendNotification("traceInformation", this.myTraceInformation, null);
        }
    }

    public String getUpgradeTraceId(Coordinator coordinator) {
        return this.getNamingAttributeValue();
    }

    public static Integer getMoDataRevision() {
        return new Integer(6000);
    }

    private void changeTypeOfStorageAtModification(Coordinator coordinator) {
        try {
            if (this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage() == 0) {
                this.myUpgradeTraceHandler.getTraceInfoData().setTypeOfStorage(2);
                this.storeTypeOfStorageInDataBase(2, coordinator);
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "changeTypeOfStorageAtActionInvoke()", "Failed to change the typeOfStorage to FILE when modifying trace properties, throwable caught.\n\tThrowable: " + throwable);
        }
    }

    private void reloadTraceInfoFromDatabase(Coordinator coordinator) {
        try {
            this.myMoData.handleTransaction(coordinator, MoData.READ_ACCESS);
            TraceInfoDataContainer traceInfoDataContainer = this.myUpgradeTraceHandler.getTraceInfoData();
            traceInfoDataContainer.setTypeOfStorage(1);
            traceInfoDataContainer.setOutputMode(((IntegerAttribute)this.myMoData.getAttribute("outputMode")).getValue(coordinator));
            traceInfoDataContainer.setActiveClasses(this.getActiveClassesFromDataBase(coordinator));
            traceInfoDataContainer.setActiveFunctions(this.getActiveFunctionsFromDataBase(coordinator));
            traceInfoDataContainer.setFileName(((StringAttribute)this.myMoData.getAttribute("fileName")).getValue(coordinator));
            traceInfoDataContainer.setFileSize(((IntegerAttribute)this.myMoData.getAttribute("fileSize")).getValue(coordinator));
            traceInfoDataContainer.setFlushInterval(((IntegerAttribute)this.myMoData.getAttribute("flushInterval")).getValue(coordinator));
            traceInfoDataContainer.setLevel(((IntegerAttribute)this.myMoData.getAttribute("level")).getValue(coordinator));
            traceInfoDataContainer.setSendLogsAsNotifications(((IntegerAttribute)this.myMoData.getAttribute("sendLogsAsNotifications")).getValue(coordinator));
            this.myUpgradeTraceHandler.getTraceInfoData().updateAllAttributes(traceInfoDataContainer);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "reloadTraceInfoFromDatabase(Coordinator aContext)", "aContext: " + SuLib.toString(coordinator) + "\n\tFailed to load the trace properties from the database, exception thrown.", throwable);
        }
    }

    private void storeTypeOfStorageInDataBase(int n, Coordinator coordinator) throws OperationNotAllowedException {
        IntegerAttribute integerAttribute = (IntegerAttribute)this.myMoData.getAttribute("typeOfStorage");
        try {
            if (coordinator == null) {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator2 = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator2.getTransactionID() + ", timeout = 3600 sec"));
                this.myMoData.handleTransaction(coordinator2, MoData.WRITE_ACCESS);
                integerAttribute.setValue(n);
                control.getTerminator().commit();
            } else {
                this.myMoData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                integerAttribute.setValue(n);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "storeTypeOfStorageInDataBase(int aTypeOfStorage, Coordinator aContext)", "Failed to update persistent data for typeOfStorage, throwable caught.", throwable);
            throw new OperationNotAllowedException("Failed to update persistent data for activeClasses. Throwable caught: " + throwable, "UpgradeTrace");
        }
    }

    private void setActiveClassesInDatabase(String[] stringArray, Coordinator coordinator) throws OperationNotAllowedException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)this.myMoData.getAttribute("activeClasses");
        sequenceAttribute = this.clearSequenceAttribute(sequenceAttribute);
        StringAttribute[] stringAttributeArray = new StringAttribute[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringAttributeArray[i] = new StringAttribute("", false, stringArray[i]);
        }
        try {
            if (coordinator == null) {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator2 = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator2.getTransactionID() + ", timeout = 3600 sec"));
                this.myMoData.handleTransaction(coordinator2, MoData.WRITE_ACCESS);
                sequenceAttribute.setValue((Attribute[])stringAttributeArray);
                control.getTerminator().commit();
            } else {
                this.myMoData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                sequenceAttribute.setValue((Attribute[])stringAttributeArray);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActiveClassesInDatabase(String[] anActiveClasses, Coordinator aContext)", "Failed to update persistent data for activeClasses, throwable caught.", throwable);
            throw new OperationNotAllowedException("Failed to update persistent data for activeClasses. Throwable caught: " + throwable, "UpgradeTrace");
        }
    }

    private void setActiveFunctionsInDatabase(int[] nArray, Coordinator coordinator) throws OperationNotAllowedException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)this.myMoData.getAttribute("activeFunctions");
        sequenceAttribute = this.clearSequenceAttribute(sequenceAttribute);
        IntegerAttribute[] integerAttributeArray = new IntegerAttribute[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerAttributeArray[i] = new IntegerAttribute("", false, nArray[i]);
        }
        try {
            if (coordinator == null) {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator2 = control.getCoordinator();
                this.myMoData.handleTransaction(coordinator2, MoData.WRITE_ACCESS);
                sequenceAttribute.setValue((Attribute[])integerAttributeArray);
                control.getTerminator().commit();
            } else {
                this.myMoData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                sequenceAttribute.setValue((Attribute[])integerAttributeArray);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActiveFunctionsInDatabase(int[] anActiveFunctions, Coordinator aContext)", "Failed to update persistent data for activeFunctions, throwable caught.", throwable);
            throw new OperationNotAllowedException("Failed to update persistent data for activeFunctions. Throwable caught: " + throwable, "UpgradeTrace");
        }
    }

    private SequenceAttribute clearSequenceAttribute(SequenceAttribute sequenceAttribute) {
        Attribute[] attributeArray = sequenceAttribute.getValue(null);
        for (int i = 0; i < attributeArray.length; ++i) {
            sequenceAttribute.removeElement(attributeArray[i]);
        }
        return sequenceAttribute;
    }

    private HashSet getActiveClassesFromDataBase(Coordinator coordinator) {
        Attribute[] attributeArray = ((SequenceAttribute)this.myMoData.getAttribute("activeClasses")).getValue(coordinator);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < attributeArray.length; ++i) {
            hashSet.add(((StringAttribute)attributeArray[i]).getValue(coordinator).trim());
        }
        return hashSet;
    }

    private HashSet getActiveFunctionsFromDataBase(Coordinator coordinator) {
        Attribute[] attributeArray = ((SequenceAttribute)this.myMoData.getAttribute("activeFunctions")).getValue(coordinator);
        Integer n = null;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < attributeArray.length; ++i) {
            n = new Integer(((IntegerAttribute)attributeArray[i]).getValue(coordinator));
            hashSet.add(n);
        }
        return hashSet;
    }

    private void storeTraceInfoAttrIntoDataBase(Coordinator coordinator) throws MoAccessException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)this.myMoData.getAttribute("activeClasses");
        this.clearSequenceAttribute(sequenceAttribute);
        Iterator iterator = this.myUpgradeTraceHandler.getTraceInfoData().getActiveClasses().iterator();
        StringAttribute stringAttribute = null;
        while (iterator.hasNext()) {
            stringAttribute = new StringAttribute("", false, (String)iterator.next());
            sequenceAttribute.addElement((Attribute)stringAttribute);
        }
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)this.myMoData.getAttribute("activeFunctions");
        this.clearSequenceAttribute(sequenceAttribute2);
        Iterator iterator2 = this.myUpgradeTraceHandler.getTraceInfoData().getActiveFunctions().iterator();
        IntegerAttribute integerAttribute = null;
        while (iterator2.hasNext()) {
            integerAttribute = new IntegerAttribute("", false, ((Integer)iterator2.next()).intValue());
            sequenceAttribute2.addElement((Attribute)integerAttribute);
        }
        ((StringAttribute)this.myMoData.getAttribute("fileName")).setValue(this.myUpgradeTraceHandler.getTraceInfoData().getFileName());
        ((IntegerAttribute)this.myMoData.getAttribute("fileSize")).setValue(this.myUpgradeTraceHandler.getTraceInfoData().getFileSize());
        ((IntegerAttribute)this.myMoData.getAttribute("flushInterval")).setValue(this.myUpgradeTraceHandler.getTraceInfoData().getFlushInterval());
        ((IntegerAttribute)this.myMoData.getAttribute("level")).setValue(this.myUpgradeTraceHandler.getTraceInfoData().getLevel());
        ((IntegerAttribute)this.myMoData.getAttribute("outputMode")).setValue(this.myUpgradeTraceHandler.getTraceInfoData().getOutputMode());
        ((IntegerAttribute)this.myMoData.getAttribute("sendLogsAsNotifications")).setValue(this.myUpgradeTraceHandler.getTraceInfoData().getSendLogsAsNotifications());
        ((IntegerAttribute)this.myMoData.getAttribute("typeOfStorage")).setValue(this.myUpgradeTraceHandler.getTraceInfoData().getTypeOfStorage());
    }

    private void addRemovePropertyChangeListener() {
        Trace.removePropertyChangeListener(NotifyingTracePropertyName.Debug, this);
        Trace.removePropertyChangeListener(NotifyingTracePropertyName.Error, this);
        Trace.removePropertyChangeListener(NotifyingTracePropertyName.Info, this);
        Trace.removePropertyChangeListener(NotifyingTracePropertyName.Log, this);
        Trace.removePropertyChangeListener(NotifyingTracePropertyName.Warning, this);
        if (this.myUpgradeTraceHandler.getTraceInfoData().getSendLogsAsNotifications() == 2) {
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Debug, this);
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Error, this);
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Info, this);
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Log, this);
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Warning, this);
        } else if (this.myUpgradeTraceHandler.getTraceInfoData().getSendLogsAsNotifications() == 1) {
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Error, this);
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Info, this);
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Log, this);
            Trace.addPropertyChangeListener(NotifyingTracePropertyName.Warning, this);
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator != null) {
            this.myNotificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        } else {
            this.myNotificationSender.pushAVC((ManagedObject)this, stringArray, objectArray);
        }
    }
}

