/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionListener;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.mgr.AbstractConfirmApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class ConfigurationVersionDeleteController
extends AbstractConfirmApplicationController
implements ActionListener {
    private static final int TRANSACTION_TIMEOUT_120_SECONDS = 120;
    String configurationVersionName;
    String message = null;
    boolean inRBList;
    boolean isStartable;
    String[] rollbacklist;
    String setstartable;
    String currentLoadedCV;
    String ldn;
    MOProxy configurationVersionMOProxy;

    public void init() {
        super.init();
        this.configurationVersionName = (String)this.getParameter("CV_NAME");
        try {
            this.ldn = (String)this.getParameter("LDNLIST");
            this.configurationVersionMOProxy = new MOProxy(this.ldn);
            this.rollbacklist = (String[])this.configurationVersionMOProxy.getAttribute("rollbackList");
            this.setstartable = (String)this.configurationVersionMOProxy.getAttribute("startableConfigurationVersion");
            this.currentLoadedCV = (String)this.configurationVersionMOProxy.getAttribute("currentLoadedConfigurationVersion");
        }
        catch (CSException e) {
            System.out.println("----- CSException in class ConfigurationVersionDeleteController.java");
            System.out.println("----- Thread.dumpStack():");
            Thread.dumpStack();
        }
        this.selectMessage();
        this.setConfirmationMessage(this.message, new Object[]{this.configurationVersionName});
    }

    public String selectMessage() {
        for (int i = 0; i < this.rollbacklist.length && !this.inRBList; ++i) {
            if (!this.rollbacklist[i].equals(this.configurationVersionName)) continue;
            this.inRBList = true;
        }
        if (this.setstartable.equals(this.configurationVersionName)) {
            this.isStartable = true;
        }
        this.message = this.inRBList && this.isStartable ? "CONFIRM_DELETE_IN_RBLIST_AND_STARTABLE_MSG" : (!this.inRBList && this.isStartable ? "CONFIRM_DELETE_STARTABLE_CV_MSG" : (this.inRBList && !this.isStartable ? "CONFIRM_DELETE_CV_IN_RBLIST_MSG" : "CONFIRM_DELETE_STANDARD_MSG"));
        return this.message;
    }

    public void performAction() {
        Transaction myTransaction = null;
        try {
            myTransaction = new Transaction(120);
            NameValue[] startArgs = new NameValue[1];
            if (this.inRBList) {
                startArgs[0] = new NameValue("configurationVersionName", (Object)this.configurationVersionName);
                this.configurationVersionMOProxy.action("removeFromRollbackList", startArgs, myTransaction.session);
            }
            if (this.isStartable) {
                startArgs[0] = new NameValue("configurationVersionName", (Object)this.currentLoadedCV);
                this.configurationVersionMOProxy.action("setStartable", startArgs, myTransaction.session);
            }
            startArgs[0] = new NameValue("configurationVersionName", (Object)this.configurationVersionName);
            this.configurationVersionMOProxy.action("delete", startArgs, myTransaction.session);
            myTransaction.commit();
            myTransaction.end();
            Log.logNotify((String)("Performing sendEmNotification('Delete CV')" + this.configurationVersionName));
            String notificationType = "se.ericsson.cello.emas.sm.CV_DELETED";
            this.sendNotification(notificationType, this.configurationVersionName);
        }
        catch (CSException e) {
            try {
                myTransaction.rollback();
                myTransaction.end();
            }
            catch (CSException be) {
                Log.logError((String)"Unable to rollback transaction", (Throwable)be);
            }
            this.reportException((Exception)((Object)e), "ERROR_REMOVE_CV", new Object[]{this.configurationVersionName});
        }
    }

    private void sendNotification(String notificationType, Object cvName) {
        AbstractApplication abstractApplication = this.view.getApplication();
        ApplicationManager applicationManager = abstractApplication.getApplicationManager();
        ConfigurationVersionDeleteController source = this;
        applicationManager.sendNotification(notificationType, (Object)source, cvName);
    }
}

