/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emas.sm.applications.RepertoireSelectController;
import se.ericsson.cello.emas.sm.applications.RepertoireSelectView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class EditRepertoiresActionController
extends AbstractApplicationController
implements ActionListener {
    private static final int TIME_OUT_PERIOD = 600;
    RepertoireSelectController controller = null;

    protected void init() {
        MOProxy[] repertoires = null;
        MOProxy swa = new MOProxy((String)this.getParameter("LDNLIST"));
        TreeMap<String, MOProxy> selectedRepertoires = new TreeMap<String, MOProxy>();
        String repName = null;
        try {
            repertoires = (MOProxy[])swa.getAttribute("repertoireList", null);
            for (int count = 0; count < repertoires.length; ++count) {
                repName = (String)repertoires[count].getAttribute("name", null);
                selectedRepertoires.put(repName, repertoires[count]);
            }
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_EDIT_REPERTOIRES", null);
            this.stopApp();
            return;
        }
        Object[][] params = new Object[][]{{"LDNLIST", swa.getParent().getDN()}, {"REPERTOIRE_LIST", selectedRepertoires}};
        this.controller = (RepertoireSelectController)this.startDialog(false, "EDIT_REPERTOIRES_TITLE", null, RepertoireSelectView.class, RepertoireSelectController.class, params);
        this.controller.addActionListener(this);
    }

    public void setSelectedRepertoires(TreeMap selectedRepertoires) {
        NameValue[] nameValues = new NameValue[1];
        Object repName = null;
        String ldn = (String)this.getParameter("LDNLIST");
        MOProxy swAllocationMo = new MOProxy(ldn);
        Transaction transaction = null;
        try {
            transaction = new Transaction(600);
            swAllocationMo.action("deleteAllRepertoires", new NameValue[0], transaction.session);
            MOProxy[] reps = selectedRepertoires.values().toArray(new MOProxy[0]);
            nameValues[0] = new NameValue("param", (Object)reps);
            swAllocationMo.action("addRepertoires", nameValues, transaction.session);
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException cs) {
                Log.logError((String)"Rollback of the transaction failed", (Throwable)cs);
            }
            this.reportException((Exception)((Object)e), "ERROR_EDIT_REPERTOIRES", null);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if ("OK".equals(event.getActionCommand())) {
            this.setSelectedRepertoires(this.controller.getSelectedRepertoires());
            this.controller.stopDialog();
            this.getApplication().stopApplicationNoCheck();
        }
        if ("APPLY".equals(event.getActionCommand())) {
            this.setSelectedRepertoires(this.controller.getSelectedRepertoires());
        }
        if ("CANCEL".equals(event.getActionCommand())) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    private void stopApp() {
        final AbstractApplication application = this.getApplication();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                application.stopApplicationNoCheck();
            }
        });
    }
}

