/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.cello.emas.sm.applications.RestoreSlide3VerificationResultsWizardController;
import se.ericsson.cello.emas.sm.applications.RestoreSlide3VerificationResultsWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlide4RestoreWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlide5ConfirmWizardController;
import se.ericsson.cello.emas.sm.applications.RestoreSlide5ConfirmWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlidesController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.mgr.RestoreConfirm;
import se.ericsson.cello.support.mgr.cellomom.CVActionResultInformation;
import se.ericsson.cello.support.mgr.cellomom.CVAutoConfigurationInformation;
import se.ericsson.cello.support.mgr.cellomom.CVCurrentDetailedActivity;
import se.ericsson.cello.support.mgr.cellomom.CVCurrentMainActivity;
import se.ericsson.cello.support.mgr.cellomom.CVInvokedAction;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class RestoreSlide4RestoreWizardController
extends RestoreSlidesController
implements ActionListener,
MOProxy.MOListener {
    private static final String MESSAGE_STRING = "The Restore Wizard has encountered a problem. The node could probably not\nstart on the CV that was being restored.\nThe executing CV is now: %s\nThe currentMainActivity of the ConfigurationVersion MO has changed unexpectedly\nduring restore. currentMainActivity is now %s\nit should have been CVCURRENTMAINACTIVITY.RESTORING_DOWNLOADED_BACKUP_CV.\nThe Restore Wizard will now close down!\nPlease, start it again if you still need to restore a CV.";
    private RestoreSlide4RestoreWizardView view;
    private boolean restoreIsOngoing = false;
    private boolean cancelRestoreIsOngoing = false;
    private boolean theWizardHasBeenClosed = false;
    private NameValue[] restoreParameters = new NameValue[2];
    private int WAIT_TIME = 5000;
    private int number = 0;
    private Timer clockTimerNodeTime;

    protected void init() {
        this.view = (RestoreSlide4RestoreWizardView)this.getView();
        this.view.setInfoJTextArea(this.getString("RESTORE_INFO_TEXT_WIZARD_SLIDE4", null));
        if (configurationVersionMo == null) {
            this.ldn = (String)this.getParameter("LDNLIST");
            configurationVersionMo = new MOProxy(this.ldn);
        }
    }

    private void startTimer() {
        final TimerTask task = new TimerTask(){

            public void run() {
                RestoreSlide4RestoreWizardController.this.checkCVVersion();
            }
        };
        this.number = 1;
        Runnable starter = new Runnable(){

            public void run() {
                RestoreSlide4RestoreWizardController.this.clockTimerNodeTime = new Timer();
                RestoreSlide4RestoreWizardController.this.clockTimerNodeTime.schedule(task, 20000L, 20000L);
            }
        };
        new Thread(starter, "clockTimerNodeTime").start();
    }

    protected boolean next() {
        if (!this.restoreIsOngoing) {
            if (this.getUserChoice() == 0) {
                this.startTimer();
                this.setNextEnabled(false);
                this.setCancelActionEnabled(true);
                this.setCancelActionAsDefaultButton();
                this.requestFocusCancelActionButton();
                this.setPreviousEnabled(false);
                this.view.setRestoreRadioButtonEnabled(false);
                this.view.setAutoconfigurationRadioButtonEnabled(false);
                configurationVersionMo.addMOListener((MOProxy.MOListener)this);
                try {
                    if (configurationVersionMo != null && configurationVersionMo.isExisting()) {
                        this.restoreParameters[0] = new NameValue("cvName", downloadedCv);
                        this.restoreParameters[1] = new NameValue("autoConfigurationInformation", (Object)this.getAutoConfigurationInformation());
                        if (this.forcedRestoreSelected()) {
                            configurationVersionMo.action("forcedRestore", this.restoreParameters);
                        } else {
                            configurationVersionMo.action("restore", this.restoreParameters);
                        }
                        restore_forcedRestore_failed = false;
                        this.restoreIsOngoing = true;
                        this.view.startIndeterminateProgressBar();
                        RestoreConfirm.createRestoreMemoryFile();
                        return false;
                    }
                }
                catch (CSException e) {
                    this.reportException((Exception)((Object)e), "", null);
                    this.letTheUserTryAgain();
                    return false;
                }
                configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
            } else {
                return false;
            }
        }
        return true;
    }

    public void checkCVVersion() {
        try {
            if (!this.restoreIsOngoing || configurationVersionMo == null || !configurationVersionMo.isExisting()) {
                if (this.restoreIsOngoing) {
                    ++this.number;
                }
                return;
            }
            Integer currentMainActivity = (Integer)configurationVersionMo.getAttribute("currentMainActivity");
            if (currentMainActivity.equals(CVCurrentMainActivity.RESTORING_DOWNLOADED_BACKUP_CV.toInteger())) {
                return;
            }
            String currentExecutingCv = (String)configurationVersionMo.getAttribute("executingCv");
            String cMainAct = CVCurrentMainActivity.get((Object)currentMainActivity).toString();
            String message = String.format(MESSAGE_STRING, currentExecutingCv, cMainAct);
            this.reportException(new Exception(), message, null);
            this.clockTimerNodeTime.cancel();
            restore_forcedRestore_failed = true;
            this.viewClosing();
        }
        catch (CSException e) {
            Log.trace((String)("Can't read ConfigurationVersion MP, the node is probably down, number of timeouts(20s): " + this.number));
        }
        ++this.number;
    }

    protected boolean cancelAction() {
        this.setCancelActionEnabled(false);
        this.view.setTextInProgressBar(this.getString("CVCURRENTMAINACTIVITY.CANCELLING_RESTORE_OF_DOWNLOADED_BACKUP_CV", null));
        try {
            Runnable executeCancelRestore = new Runnable(){

                public void run() {
                    try {
                        if (RestoreSlidesController.configurationVersionMo != null && RestoreSlidesController.configurationVersionMo.isExisting()) {
                            NameValue[] NO_ARGUMENTS = new NameValue[]{};
                            RestoreSlide4RestoreWizardController.this.cancelRestoreIsOngoing = true;
                            RestoreSlidesController.configurationVersionMo.action("cancelRestore", NO_ARGUMENTS);
                            RestoreSlide4RestoreWizardController.this.cancelRestoreIsOngoing = false;
                            RestoreSlide4RestoreWizardController.this.restoreIsOngoing = false;
                            RestoreSlide4RestoreWizardController.this.letTheUserTryAgain();
                        }
                    }
                    catch (CSException e) {
                        RestoreSlide4RestoreWizardController.this.cancelRestoreIsOngoing = false;
                        RestoreSlide4RestoreWizardController.this.letTheUserTryAgain();
                        RestoreSlide4RestoreWizardController.this.reportException((Exception)((Object)e), "", null);
                    }
                }
            };
            new Thread(executeCancelRestore).start();
        }
        catch (Exception e) {
            this.reportException(e, "", null);
        }
        return false;
    }

    public void attributesChanged(MOProxy anMO, NameValue[] someAttributes) {
        Log.trace((String)"------  method attributesChanged in class RestoreSlide4RestoreWizardController");
        if (!this.restoreIsOngoing && !this.cancelRestoreIsOngoing) {
            return;
        }
        try {
            for (int i = 0; i < someAttributes.length; ++i) {
                CVCurrentDetailedActivity activity;
                if (!someAttributes[i].name.equals("currentDetailedActivity") || (activity = CVCurrentDetailedActivity.get((Object)someAttributes[i].value)) == null) continue;
                this.view.setTextInProgressBar(this.getString(activity.toString(), null));
                if (activity != CVCurrentDetailedActivity.EXECUTION_FAILED && activity != CVCurrentDetailedActivity.AWAITING_RESTORE_CONFIRMATION) continue;
                restore_forcedRestore_failed = activity == CVCurrentDetailedActivity.EXECUTION_FAILED;
                this.goToVerificationResultsOrConfirmSlide();
            }
        }
        catch (Exception e) {
            this.restoreIsOngoing = false;
            this.letTheUserTryAgain();
            this.reportException(e, "ERROR_GET", null);
        }
    }

    private void goToVerificationResultsOrConfirmSlide() {
        this.clockTimerNodeTime.cancel();
        this.waitForAttributes();
        this.view.stopIndeterminateProgressBar();
        this.view.setTextInProgressBar("");
        RestoreConfirm.deleteMemoryfile();
        configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        this.getWizardPresenter().showNext();
        this.restoreIsOngoing = false;
    }

    protected Class getNextViewClass() {
        if (restore_forcedRestore_failed) {
            return RestoreSlide3VerificationResultsWizardView.class;
        }
        return RestoreSlide5ConfirmWizardView.class;
    }

    protected Class getNextControllerClass() {
        if (restore_forcedRestore_failed) {
            return RestoreSlide3VerificationResultsWizardController.class;
        }
        return RestoreSlide5ConfirmWizardController.class;
    }

    protected void beforeVisible() {
        this.setWizardTitle("CV_RESTORE_WIZARD_SLIDE_4", new Object[]{downloadedCv});
        this.setCancelVisible(false);
        this.setCancelActionVisible(true);
        this.setCancelActionEnabled(false);
        this.setPreferredSizeCancelActionButton(120);
        this.setNextEnabled(!this.restoreIsOngoing && !this.cancelRestoreIsOngoing);
        this.setPreviousEnabled(!this.restoreIsOngoing && !this.cancelRestoreIsOngoing);
        this.setCloseVisible(true);
        this.requestFocusNextButton();
        this.setNextAsDefaultButton();
        this.view.setTextInProgressBar("");
        this.view.setRestoreRadioButtonEnabled(true);
        this.view.setAutoconfigurationRadioButtonEnabled(true);
        this.view.setToolTips();
        this.view.stopIndeterminateProgressBar();
    }

    private Integer getAutoConfigurationInformation() {
        Integer autoConfigurationInformation = null;
        String autoconfigurationInformationRadioButton = this.view.getAutoconfigurationRadioButtonValue();
        if (autoconfigurationInformationRadioButton.equals(this.view.ON_SELECTED)) {
            autoConfigurationInformation = CVAutoConfigurationInformation.ON.toInteger();
        } else if (autoconfigurationInformationRadioButton.equals(this.view.OFF_SELECTED)) {
            autoConfigurationInformation = CVAutoConfigurationInformation.OFF.toInteger();
        } else if (autoconfigurationInformationRadioButton.equals(this.view.AS_CONFIGURED_IN_DOWNLOADED_CV_SELECTED)) {
            autoConfigurationInformation = CVAutoConfigurationInformation.AS_CONFIGURED.toInteger();
        }
        return autoConfigurationInformation;
    }

    private boolean forcedRestoreSelected() {
        return this.view.getRestoreRadioButtonValue().equals(this.view.FORCED_RESTORE_ACTION_SELECTED);
    }

    private void letTheUserTryAgain() {
        if (!this.theWizardHasBeenClosed) {
            this.beforeVisible();
        }
    }

    private int getUserChoice() {
        int userChoice = 0;
        Object[] buttons = new String[]{this.getString("GSL_PROCEED", null), this.getString("GSL_CANCEL", null)};
        Object[] NO_ARGS = null;
        String stringQuestionMessage = this.getString("RESTORE_RESTORE_QUESTION_MESSAGE", NO_ARGS);
        try {
            this.actionResult = (Struct)configurationVersionMo.getAttribute("actionResult");
            Object structMemberInvokedAction = this.actionResult.getElementValue("invokedAction");
            Integer invokedAction = CVInvokedAction.get((Object)structMemberInvokedAction).toInteger();
            Integer expectedInvokedAction = CVInvokedAction.VERIFY_RESTORE.toInteger();
            String lastActionCv = this.actionResult.getElementValue("configurationVersionName").toString();
            String selectedRestoreCv = EmasSystemProperties.getProperty((String)"CV_NAME");
            if (invokedAction.equals(expectedInvokedAction) && lastActionCv.equals(selectedRestoreCv)) {
                HashMap additionalActionResultDataMap = new HashMap();
                this.getAdditionalActionResultData(additionalActionResultDataMap);
                if (additionalActionResultDataMap.containsKey(CVActionResultInformation.ACTION_FORCED_RESTORE_IS_NOT_ALLOWED.toInteger()) && additionalActionResultDataMap.containsKey(CVActionResultInformation.ACTION_RESTORE_IS_NOT_ALLOWED.toInteger())) {
                    stringQuestionMessage = this.getString("RESTORE_RESTORE_QUESTION_MESSAGE_FAILED", NO_ARGS);
                } else if (additionalActionResultDataMap.containsKey(CVActionResultInformation.ACTION_RESTORE_IS_NOT_ALLOWED.toInteger()) && additionalActionResultDataMap.containsKey(CVActionResultInformation.ACTION_FORCED_RESTORE_IS_ALLOWED.toInteger())) {
                    stringQuestionMessage = this.getString("RESTORE_RESTORE_QUESTION_MESSAGE_FORCED", NO_ARGS);
                }
            }
            userChoice = JOptionPane.showOptionDialog((Component)((Object)this.view), new JScrollPane(this.getQuestion(stringQuestionMessage)), this.getString("RESTORE_RESTORE_QUESTION", null), 0, -1, null, buttons, buttons[0]);
            configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        }
        catch (Exception e) {
            Log.logError((String)"Exception getting parameters.", (Throwable)e);
            this.reportException(e, "ERROR_GET", null);
        }
        return userChoice;
    }

    protected void getAdditionalActionResultData(HashMap additionalActionResultDataMap) {
        try {
            MOProxy cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
            Struct[] additionalActionResultData = (Struct[])cvMO.getAttribute("additionalActionResultData");
            if (additionalActionResultData != null) {
                for (int i = 0; i < additionalActionResultData.length; ++i) {
                    Object memberInformationName = additionalActionResultData[i].getElementValue("information");
                    Integer memberInformationNameInteger = CVActionResultInformation.get((Object)memberInformationName).toInteger();
                    String memberInformationNameString = CVActionResultInformation.get((Object)memberInformationName).toString();
                    additionalActionResultDataMap.put(memberInformationNameInteger, memberInformationNameString);
                }
            }
        }
        catch (NoSuchFieldException e) {
            Log.logError((String)"Error building fault information", (Throwable)e);
        }
        catch (CSException e) {
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
    }

    private JTextArea getQuestion(String stringQuestionMessage) {
        JTextArea jTextAreaWarningMessage = new JTextArea(stringQuestionMessage);
        jTextAreaWarningMessage.setEditable(false);
        jTextAreaWarningMessage.setSize(new Dimension(300, 80));
        jTextAreaWarningMessage.setLineWrap(true);
        jTextAreaWarningMessage.setWrapStyleWord(true);
        jTextAreaWarningMessage.setBackground(this.view.basePanel.getBackground());
        return jTextAreaWarningMessage;
    }

    private void waitForAttributes() {
        if (configurationVersionMo == null) {
            configurationVersionMo = RestoreConfirm.getConfigurationVersionMo();
        }
        while (!this.theWizardHasBeenClosed) {
            try {
                if (configurationVersionMo == null || !configurationVersionMo.isExisting()) continue;
                configurationVersionMo.getAttribute("restoreConfirmationDeadline");
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(this.WAIT_TIME);
                }
                catch (Exception ex) {}
            }
        }
    }

    protected boolean close() {
        configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        this.theWizardHasBeenClosed = true;
        return true;
    }

    protected void viewClosing() {
        configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        this.theWizardHasBeenClosed = true;
        this.getApplicationManager().exitApplicationEMTApp();
    }

    public void childCreated(MOProxy childMO) {
    }

    public void childDeleted(MOProxy childMO) {
    }

    public void actionPerformed(ActionEvent event) {
    }
}

